/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.systemcall;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import java.net.URL;
import java.util.ArrayList;
import org.slf4j.LoggerFactory;
import sanproject.sn2.base.property.SJbaseSystemPropertiesManager;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.SJcUserGroupInfoUty;
import sanproject.sn2.com.utility.SJcUserInfoUty;
import sanproject.sn2.com.utility.account.SJcRoleResourceContainer;
import sanproject.sn2.com.utility.account.SJcUserInfoContainer;
import sanproject.sn2.com.utility.account.exception.SJcNotFoundUserException;
import sanproject.sn2.com.utility.account.exception.SJcParamErrorException;
import sanproject.sn2.com.utility.fileuty.SJcFileUtyManager;

public class SJcmdGetAuthBitmap {
    private static final String LOG_FUNCTION = "SJcmdGetAuthBitmap";
    private static final String LOG_TITLE = "SJcmdGetAuthBitmap";
    private static String encode = "UTF-8";
    private static String szMsg;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        String LOG_SUBTITLE = "main";
        SJbaseSystemPropertiesManager clsEnv = null;
        SJcFileUtyManager fcls = null;
        try {
            LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)lc);
            lc.reset();
            URL logurl = SJcmdGetAuthBitmap.class.getResource("logback.xml");
            configurator.doConfigure(logurl);
            System.setProperty("SN_DataPath", SJcEnvUty.getSnBasePath() + "san\\SN2\\SN2Files");
            System.setProperty("SN_EnvFile", SJcEnvUty.getSnBasePath() + "san\\SN2\\SN2Files\\data\\base\\setting\\system\\properties\\SN2_Startup.properties");
            System.setProperty("SN_EnvFileV", SJcEnvUty.getSnBasePath() + "san\\SN2\\SN2Files\\data\\base\\setting\\system\\properties\\SN2_StartupV.properties");
            System.setProperty("SN_LogPath", "GetBitmapCredential");
            szMsg = "Start.";
            SJcLogUty.getLogger().info("SJcmdGetAuthBitmap", "SJcmdGetAuthBitmap", "main", szMsg);
            clsEnv = new SJbaseSystemPropertiesManager();
            clsEnv.initialize(0);
            if (argv.length != 1 || argv[0] == "") {
                throw new SJcParamErrorException();
            }
            fcls = new SJcFileUtyManager();
            String[] szAlyUser = new String[]{SJcmdGetAuthBitmap.asByteArray(argv[0])};
            SJcUserInfoContainer[] clsUserInfo = SJcUserInfoUty.getUserInfo(szAlyUser);
            if (clsUserInfo[0] == null) {
                throw new SJcNotFoundUserException();
            }
            SJcRoleResourceContainer clsAuth = SJcUserGroupInfoUty.getUserGroupObject(clsUserInfo[0].getGrpName());
            String szAuth = clsAuth.getAllAuthBit();
            System.out.println(szAuth);
        }
        catch (Exception e) {
            szMsg = "Exception.";
            SJcLogUty.getLogger().error("SJcmdGetAuthBitmap", "SJcmdGetAuthBitmap", "main", szMsg, e);
            System.out.println("");
        }
        finally {
            try {
                if (fcls != null) {
                    fcls.finish();
                }
                if (clsEnv != null) {
                    clsEnv.finish();
                }
            }
            catch (Exception e) {
                szMsg = "Exception.";
                SJcLogUty.getLogger().error("SJcmdGetAuthBitmap", "SJcmdGetAuthBitmap", "main", szMsg, e);
            }
            szMsg = "End.";
            SJcLogUty.getLogger().info("SJcmdGetAuthBitmap", "SJcmdGetAuthBitmap", "main", szMsg);
        }
    }

    private static String asByteArray(String ascii) {
        String result = new String();
        try {
            ArrayList<String> buf = new ArrayList<String>();
            for (int sub = 0; sub < ascii.length(); sub += 2) {
                String byteString = ascii.substring(sub, sub + 2);
                buf.add(byteString);
            }
            byte[] byteArray = new byte[buf.size()];
            for (int i = 0; i < byteArray.length; ++i) {
                String byteString = (String)buf.get(i);
                byteArray[i] = Byte.parseByte(byteString, 16);
            }
            result = new String(byteArray, encode);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }
}

