/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.client.adapter.cimxml;

import com.sun.net.httpserver.HttpHandler;
import com.ws.wbem.client.adapter.cimxml.CIMXMLListenerHandler;
import com.ws.wbem.client.adapter.common.HTTPServer;
import com.ws.wbem.client.adapter.common.TLSInfo;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import javax.wbem.listener.IndicationListener;
import javax.wbem.listener.WBEMListener;

public class CIMXMLListener
implements WBEMListener {
    private final Hashtable<Integer, Listener> mListenerTable = new Hashtable();
    private final Properties mProperties = new Properties();

    public int addListener(IndicationListener pListener, int pPort, String pProtocol) {
        return this.addListener(pListener, pPort, pProtocol, null);
    }

    public int addListener(IndicationListener pListener, int pPort, String pProtocol, String localAddr) {
        try {
            Listener listener = new Listener(pListener, pPort, pProtocol);
            this.mListenerTable.put(new Integer(listener.getPort()), listener);
            return listener.getPort();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public String getProperty(String name) {
        return this.mProperties.getProperty(name);
    }

    public void removeListener(int pPort) {
        Listener listener = this.mListenerTable.get(new Integer(pPort));
        if (listener != null) {
            listener.stop();
        }
    }

    public void setProperty(String name, String value) {
        if (null == value) {
            this.mProperties.remove(name);
        } else {
            this.mProperties.put(name, value);
        }
    }

    class Listener {
        private int mPort;
        private HTTPServer mServerListener;
        private final IndicationListener mIndicationListener;

        public Listener(IndicationListener clientListener, int port, String protocol) throws Exception {
            if (null == protocol) {
                throw new IllegalArgumentException("Protocol shall not be null.");
            }
            this.mIndicationListener = clientListener;
            this.start(port);
        }

        int getPort() {
            return this.mPort;
        }

        private synchronized void start(int port) throws Exception {
            try {
                new CIMXMLListenerHandler(this.mIndicationListener);
                String keystore = CIMXMLListener.this.mProperties.getProperty("javax.wbem.listener.keyStore", null);
                TLSInfo tlsInfo = null;
                if (null != keystore) {
                    String truststore = CIMXMLListener.this.mProperties.getProperty("javax.wbem.listener.trustStore", null);
                    String keystorePassword = CIMXMLListener.this.mProperties.getProperty("javax.wbem.listener.keyStorePassword", null);
                    String ciphers = CIMXMLListener.this.mProperties.getProperty("javax.wbem.listener.ciphers", null);
                    String[] cipherList = new String[]{};
                    if (null != ciphers) {
                        cipherList = ciphers.split("\\s*,\\s*");
                    }
                    tlsInfo = new TLSInfo(null != truststore, keystore, keystorePassword, truststore, cipherList);
                }
                this.mServerListener = new HTTPServer(tlsInfo);
                this.mServerListener.setURLHandler("/", (HttpHandler)new CIMXMLListenerHandler(this.mIndicationListener), null);
                this.mServerListener.start(null, port);
                this.mPort = this.mServerListener.getPort();
            }
            catch (IOException e) {
                this.mServerListener = null;
                throw e;
            }
        }

        void stop() {
            if (null != this.mServerListener) {
                this.mServerListener.stop();
            }
        }
    }
}

