/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.client.adapter.cimxml;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.ws.cim.xmlcim.CIMXMLElementsParser;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cim.CIMInstance;
import javax.wbem.listener.IndicationListener;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.xml.sax.SAXParseException;

public class CIMXMLListenerHandler
implements HttpHandler {
    private final IndicationListener mListener;
    private String mIndicationURL;
    private final XMLInputFactory mFactory;

    public CIMXMLListenerHandler(IndicationListener clientListener) {
        this.mListener = clientListener;
        this.mFactory = XMLInputFactory.newInstance();
        this.mFactory.setProperty("javax.xml.stream.isCoalescing", true);
    }

    public void addResponseHeaderFields(Headers outHeaders) {
        outHeaders.add("CIMOperation", "ExportMethodResponse");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpExchange conn) throws IOException {
        try {
            if (!conn.getRequestMethod().equals("POST")) {
                String errRsp = "Not Implemented.";
                conn.sendResponseHeaders(501, "Not Implemented.".getBytes().length);
                OutputStream os = conn.getResponseBody();
                os.write("Not Implemented.".getBytes());
                return;
            }
            Logger log = Logger.getLogger("com.ws.wbem.client");
            Headers hdrs = conn.getRequestHeaders();
            String str = hdrs.getFirst("CIMExportMethod");
            if (null == str || !str.equals("ExportIndication")) {
                String errRsp = "Missing header ExportIndication";
                conn.sendResponseHeaders(400, "Missing header ExportIndication".getBytes().length);
                OutputStream os = conn.getResponseBody();
                os.write("Missing header ExportIndication".getBytes());
                return;
            }
            this.mIndicationURL = conn.getRequestURI().getPath();
            this.addResponseHeaderFields(conn.getResponseHeaders());
            String[] messageID = new String[1];
            XMLStreamReader reader = this.mFactory.createXMLStreamReader(conn.getRequestBody());
            CIMInstance ci = this.parseInstance(reader, messageID);
            try {
                this.mListener.indicationOccured(this.mIndicationURL, ci);
            }
            catch (Throwable th) {
                log.log(Level.SEVERE, "Caught exception when processing indication for URL: " + this.mIndicationURL, th);
            }
            String resp = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><CIM DTDVERSION=\"2.0\" CIMVERSION=\"2.0\"><MESSAGE ID=\"%s\" PROTOCOLVERSION=\"1.0\"><SIMPLEEXPRSP><EXPMETHODRESPONSE NAME=\"ExportIndication\"></EXPMETHODRESPONSE></SIMPLEEXPRSP></MESSAGE></CIM>";
            resp = String.format(resp, messageID[0]);
            conn.sendResponseHeaders(200, resp.getBytes().length);
            OutputStream os = conn.getResponseBody();
            os.write(resp.getBytes());
        }
        catch (Exception e) {
            new DataOutputStream(conn.getResponseBody());
            StringBuilder message = new StringBuilder("XML Parsing error: <b>Parse Error with Request:\n");
            if (e instanceof SAXParseException) {
                SAXParseException spe = (SAXParseException)e;
                message = message.append("** URI: ");
                message = message.append(spe.getSystemId());
                message = message.append('\n');
                message = message.append("** Line: ");
                message = message.append(spe.getLineNumber());
                message = message.append('\n');
            }
            message = message.append("</b>");
            String errRsp = message.toString();
            conn.sendResponseHeaders(500, errRsp.getBytes().length);
            OutputStream os = conn.getResponseBody();
            os.write(errRsp.getBytes());
        }
        finally {
            conn.getRequestBody().close();
            conn.getResponseBody().close();
        }
    }

    private CIMInstance parseInstance(XMLStreamReader reader, String[] messageID) throws XMLStreamException {
        int eventType = reader.next();
        QName startTag = null;
        CIMInstance ci = null;
        while (eventType != 8) {
            switch (eventType) {
                case 15: {
                    break;
                }
                case 10: {
                    break;
                }
                case 1: {
                    startTag = reader.getName();
                    if (null == startTag) break;
                    if ("INSTANCE".equals(startTag.getLocalPart())) {
                        ci = CIMXMLElementsParser.parseInstance((XMLStreamReader)reader, null);
                        break;
                    }
                    if (!"MESSAGE".equals(startTag.getLocalPart())) break;
                    messageID[0] = reader.getAttributeValue(null, "ID");
                    break;
                }
                case 2: {
                    QName qName = reader.getName();
                    if (!qName.getLocalPart().equals("INSTANCE")) break;
                    break;
                }
                case 4: {
                    break;
                }
            }
            eventType = reader.next();
        }
        reader.close();
        return ci;
    }

    public void setIndicationURL(String pIndicationURL) {
        this.mIndicationURL = pIndicationURL;
    }
}

