/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.rptdt.csv.wrapper;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import sanproject.sn2.rptdt.csv.SJdtCSVWrapperManager;
import sanproject.sn2.rptdt.exception.SJdtRPTDTException;
import sanproject.sn2.rptdt.util.SJdtRPTDTDevice;
import sanproject.sn2.rptdt.util.SJdtRPTDTUtils;

public abstract class SJdtCSVWrapperBase {
    private static Logger logger = Logger.getLogger(SJdtCSVWrapperBase.class.getName());
    private String[] csvTitleRecord = null;
    private String[] csvColumnRecord = null;
    protected List<String[]> csvDataList = null;
    protected Map<String, String[]> keyRecordMap = null;
    protected boolean fileExist = true;
    private Map<String, Integer> csvColumnMap = null;
    protected static final String NUMBER_REGEX = "^[0-9]+$";
    protected static final String NUMBER_INCLUDED_DOT_REGEX = "^[0-9]+$|^[0-9]+[.]?[0-9]+$";
    private static final String CSV_FILE_FORMAT = "%-19s";
    private static final String CSV_ROWS_FORMAT = "%6s";
    protected static final String KEY_VALUE_SEPARATOR = ",";

    public boolean isFileExists() {
        return this.fileExist;
    }

    public void init(String csvFileName, boolean squeeze) throws SJdtRPTDTException {
        String csvFilePath = SJdtCSVWrapperManager.inputDir + csvFileName;
        File csvFile = new File(csvFilePath);
        if (csvFile.exists()) {
            String USE_LINE_DATA;
            List<String[]> csvAllDataList = null;
            csvAllDataList = !squeeze ? SJdtCSVWrapperManager.getCsvData(csvFilePath) : ((USE_LINE_DATA = SJdtCSVWrapperManager.getValidatorValue(this.getCsvName() + ".usedata")) == null ? SJdtCSVWrapperManager.getCsvData(csvFilePath) : SJdtCSVWrapperManager.getCsvData_onlyUseData(this.getCsvName(), csvFilePath));
            if (csvAllDataList.size() < 2) {
                logger.severe("csvFileName=[" + csvFileName + "], rowsLength=[" + csvAllDataList.size() + "]");
                throw new SJdtRPTDTException();
            }
            this.csvTitleRecord = csvAllDataList.get(0);
            this.csvColumnRecord = csvAllDataList.get(1);
            this.csvColumnMap = SJdtCSVWrapperManager.getCsvColumnMap(this.csvColumnRecord);
            this.csvDataList = csvAllDataList.subList(2, csvAllDataList.size());
            this.keyRecordMap = this.getKeyColumnArray().length > 0 ? this.getMatchedAllRecordMap(this.getKeyColumnArray()) : this.getDefaultMatchedRecordMap();
            this.fileExist = true;
        } else {
            this.csvTitleRecord = new String[]{""};
            this.csvColumnRecord = new String[]{""};
            this.csvColumnMap = new HashMap<String, Integer>();
            this.csvDataList = new ArrayList<String[]>();
            this.keyRecordMap = this.getDefaultMatchedRecordMap();
            this.fileExist = false;
        }
        this.init();
        logger.info("load=[" + String.format(CSV_FILE_FORMAT, csvFileName) + "], " + "rows=[" + String.format(CSV_ROWS_FORMAT, this.csvDataList.size()) + "], " + SJdtRPTDTUtils.getMemoryInfo());
    }

    public void validate() throws SJdtRPTDTException {
        String model = SJdtRPTDTDevice.getModel(SJdtRPTDTDevice.getModelInfo());
        this.validateTitle(this.getCsvName() + ".title");
        this.validateColumn(this.getCsvName() + ".column" + model);
    }

    private void validateTitle(String titleKey) throws SJdtRPTDTException {
        String title;
        String validatorStr = SJdtCSVWrapperManager.getValidatorValue(titleKey);
        if (!validatorStr.equals(title = this.csvTitleRecord[0])) {
            logger.severe("csvName=[" + this.getCsvName() + "], validatorStr=[" + validatorStr + "], title=[" + title + "]");
            throw new SJdtRPTDTException();
        }
    }

    private void validateColumn(String columnKey) throws SJdtRPTDTException {
        String[] validatorStrArray;
        String line = SJdtCSVWrapperManager.getValidatorValue(columnKey);
        block0: for (String validatorStr : validatorStrArray = line.split(KEY_VALUE_SEPARATOR, -1)) {
            for (String column : this.csvColumnRecord) {
                if (validatorStr.equals(column)) continue block0;
            }
            logger.severe("csvName=[" + this.getCsvName() + "], validatorStr=[" + validatorStr + "]");
            throw new SJdtRPTDTException();
        }
    }

    public String[] getKeyColumnArray() {
        return new String[0];
    }

    public void init() {
    }

    public String[] getDefaultRecordValue() {
        Object[] defaultValue = new String[this.csvColumnMap.size()];
        Arrays.fill(defaultValue, "");
        return defaultValue;
    }

    public Map<String, String[]> getDefaultMatchedRecordMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>(){
            private static final long serialVersionUID = 1L;

            @Override
            public String[] get(Object obj) {
                String[] oneRecord = (String[])super.get(obj);
                if (oneRecord == null) {
                    oneRecord = SJdtCSVWrapperBase.this.getDefaultRecordValue();
                }
                return oneRecord;
            }
        };
        return map;
    }

    public Map<String, List<String[]>> getDefaultMatchedExistsRecordMap() {
        HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>(){
            private static final long serialVersionUID = 1L;

            @Override
            public List<String[]> get(Object obj) {
                ArrayList recordList = (ArrayList)super.get(obj);
                if (recordList == null) {
                    recordList = new ArrayList();
                }
                return recordList;
            }
        };
        return map;
    }

    private String getValue(int rowIndex, int columnIndex) {
        return this.csvDataList.get(rowIndex)[columnIndex];
    }

    public String getValue(int rowIndex, String columnName) {
        int columnIndex = this.getColumnIndex(columnName);
        if (columnIndex == -1) {
            return "";
        }
        return this.getValue(rowIndex, columnIndex);
    }

    public String getValue(String[] record, String targetColumn) {
        int columnIndex = this.getColumnIndex(targetColumn);
        if (columnIndex == -1) {
            return "";
        }
        return record[columnIndex];
    }

    public String getKeyRecordColumnValue(String keyColumnValue, String getTargetColumn) {
        String[] keyRecord = this.getKeyRecord(keyColumnValue);
        return this.getValue(keyRecord, getTargetColumn);
    }

    public String[] getRecord(int rowIndex) {
        return this.csvDataList.get(rowIndex);
    }

    public String[] getKeyRecord(String keyColumnValue) {
        return this.keyRecordMap.get(keyColumnValue);
    }

    public int getColumnIndex(String columnName) {
        Integer integer = this.csvColumnMap.get(columnName);
        if (integer == null) {
            return -1;
        }
        return integer;
    }

    public List<String[]> getCsvDataList() {
        return this.csvDataList;
    }

    public int getCsvDataListSize() {
        return this.csvDataList.size();
    }

    public Map<String, String[]> getMatchedAllRecordMap(String targetColumn) {
        Map<String, String[]> map = this.getDefaultMatchedRecordMap();
        for (String[] record : this.csvDataList) {
            String value = this.getValue(record, targetColumn);
            if (!StringUtils.isNotEmpty((String)value) || map.containsKey(value)) continue;
            map.put(value, record);
        }
        return map;
    }

    public Map<String, String[]> getMatchedAllRecordMap(String[] targetColumnArray) {
        Map<String, String[]> map = this.getDefaultMatchedRecordMap();
        for (String[] record : this.csvDataList) {
            ArrayList<String> valueList = new ArrayList<String>();
            for (int i = 0; i < targetColumnArray.length; ++i) {
                String value = this.getValue(record, targetColumnArray[i]);
                valueList.add(value);
            }
            String keyColumnValue = SJdtRPTDTUtils.getAddSeparatorStr(valueList, KEY_VALUE_SEPARATOR);
            if (!StringUtils.isNotEmpty((String)keyColumnValue) || map.containsKey(keyColumnValue)) continue;
            map.put(keyColumnValue, record);
        }
        return map;
    }

    public Map<String, List<String[]>> getMatchedSameAllRecordMap(String targetColumn) {
        Map<String, List<String[]>> map = this.getDefaultMatchedExistsRecordMap();
        for (String[] record : this.csvDataList) {
            String value = this.getValue(record, targetColumn);
            if (StringUtils.isNotEmpty((String)value) && !map.containsKey(value)) {
                ArrayList<String[]> machedList = new ArrayList<String[]>();
                machedList.add(record);
                map.put(value, machedList);
                continue;
            }
            map.get(value).add(record);
        }
        return map;
    }

    public Map<String, String> getAllRecordColumnValueSetMap(String searchTargetColumn) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String[] record : this.csvDataList) {
            String value = this.getValue(record, searchTargetColumn);
            if (!StringUtils.isNotEmpty((String)value)) continue;
            map.put(value, null);
        }
        return map;
    }

    public List<String> getAllRecordColumnValueSet(String searchTargetColumn) {
        Map<String, String> map = this.getAllRecordColumnValueSetMap(searchTargetColumn);
        return new ArrayList<String>(map.keySet());
    }

    public List<String[]> getMatchedAllRecord(String searchStr, String targetColumn) {
        ArrayList<String[]> matchedRecordList = new ArrayList<String[]>();
        for (String[] record : this.csvDataList) {
            String value = this.getValue(record, targetColumn);
            if (!searchStr.equals(value)) continue;
            matchedRecordList.add(record);
        }
        return matchedRecordList;
    }

    public List<String[]> getMatchedAllRecord(String searchStr, String targetColumn, List<String[]> recordList) {
        ArrayList<String[]> matchedRecordList = new ArrayList<String[]>();
        if (recordList == null) {
            return matchedRecordList;
        }
        for (String[] record : recordList) {
            String value = this.getValue(record, targetColumn);
            if (!searchStr.equals(value)) continue;
            matchedRecordList.add(record);
        }
        return matchedRecordList;
    }

    public List<String[]> getPrefixMatchedAllRecord(String searchStr, String targetColumn) {
        ArrayList<String[]> matchedRecordList = new ArrayList<String[]>();
        for (String[] record : this.csvDataList) {
            String value = this.getValue(record, targetColumn);
            if (!value.startsWith(searchStr)) continue;
            matchedRecordList.add(record);
        }
        return matchedRecordList;
    }

    public List<String[]> getMatchedAllRecord(String[] searchStrList, String targetColumn) {
        ArrayList<String[]> matchedRecordList = new ArrayList<String[]>();
        block0: for (String[] record : this.csvDataList) {
            String value = this.getValue(record, targetColumn);
            for (String searchStr : searchStrList) {
                if (!searchStr.equals(value)) continue;
                matchedRecordList.add(record);
                continue block0;
            }
        }
        return matchedRecordList;
    }

    public String[] getMatchedOneRecord(String searchStr, String searchTargetColumn) {
        String[] result = this.getDefaultRecordValue();
        for (String[] record : this.csvDataList) {
            String value = this.getValue(record, searchTargetColumn);
            if (!searchStr.equals(value)) continue;
            result = record;
            break;
        }
        return result;
    }

    public String[] getMatchedExistsOneRecord(String searchStr, String searchTargetColumn) {
        String[] result = null;
        for (String[] record : this.csvDataList) {
            String value = this.getValue(record, searchTargetColumn);
            if (!searchStr.equals(value)) continue;
            result = record;
            break;
        }
        return result;
    }

    public List<String> getMatchedAllRecordColumnValue(String searchStr, String searchTargetColumn, String getTargetColumn) {
        ArrayList<String> result = new ArrayList<String>();
        for (String[] record : this.csvDataList) {
            String value = this.getValue(record, searchTargetColumn);
            if (!searchStr.equals(value)) continue;
            result.add(this.getValue(record, getTargetColumn));
        }
        return result;
    }

    public String getMatchedOneRecordColumnValue(String searchStr, String searchTargetColumn, String getTargetColumn) {
        String result = "";
        for (String[] record : this.csvDataList) {
            String value = this.getValue(record, searchTargetColumn);
            if (!searchStr.equals(value)) continue;
            result = this.getValue(record, getTargetColumn);
            break;
        }
        return result;
    }

    public List<String> getMatchedAllRecordColumnValueSet(List<String> set, String searchTargetColumn, String ... getTargetColumn) {
        LinkedHashMap map = new LinkedHashMap();
        for (String searchStr : set) {
            for (String[] record : this.csvDataList) {
                String value = this.getValue(record, searchTargetColumn);
                if (!searchStr.equals(value)) continue;
                for (String column : getTargetColumn) {
                    String key = this.getValue(record, column);
                    if (!StringUtils.isNotEmpty((String)key)) continue;
                    map.put(key, null);
                }
            }
        }
        return new ArrayList<String>(map.keySet());
    }

    public List<String> getMatchedAllKeyRecordColumnValueSet(List<String> set, String getTargetColumn) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String searchStr : set) {
            String value = this.getKeyRecordColumnValue(searchStr, getTargetColumn);
            if (!StringUtils.isNotEmpty((String)value) || result.contains(value)) continue;
            result.add(value);
        }
        return new ArrayList<String>(result);
    }

    public boolean isColumnExist(String getTargetColumn) {
        boolean result = false;
        int columnIndex = this.getColumnIndex(getTargetColumn);
        if (columnIndex != -1) {
            result = true;
        }
        return result;
    }

    public abstract String getCsvName();
}

