/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.rptdt.report.generator;

import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.VelocityContext;
import sanproject.sn2.rptdt.csv.SJdtCSVWrapperManager;
import sanproject.sn2.rptdt.csv.wrapper.SJdtCacheInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtMpPcbStatusCSVWrapper;
import sanproject.sn2.rptdt.exception.SJdtRPTDTException;
import sanproject.sn2.rptdt.report.SJdtReportGeneratorManager;
import sanproject.sn2.rptdt.report.generator.Pcb;
import sanproject.sn2.rptdt.report.generator.SJdtReportGeneratorBase;

public class SJdtCachedetailReportGenerator
extends SJdtReportGeneratorBase {
    private static Logger logger = Logger.getLogger(SJdtCachedetailReportGenerator.class.getName());
    private static final String REPORT_NAME = "Cachedetail";
    private static final boolean IS_GRAPHIC_REPORT = true;
    private static final boolean USE_TABLE_SORT = false;
    private static final boolean USE_CONTENTS_FOOTER = false;
    private static final String MENU_LINK_VIEW_KEY = "Common.menu.Cachedetail";
    private static final String EXPLANATION_KEY = "Common.explanation.Cachedetail";
    private static final String VM_LIBLARY_PATH = "/sanproject/sn2/rptdt/template/cachedetail/vm/VM_cachedetail_library.vm";
    private static final String CONTENTS_BODY_VM_FILE_PATH = "/sanproject/sn2/rptdt/template/cachedetail/vm/contentsBody_Cachedetail.vm";
    private static final String REPORT_FRAMESET_HTML_FILE_NAME = "Cachedetail.html";
    private static final String MENU_FRAMESET_HTML_FILE_NAME = "menuFrameset_Cachedetail.html";
    private static final String MENU_BODY_HTML_FILE_NAME = "menuBody_Cachedetail.html";
    private static final String CONTENTS_FRAMESET_HTML_FILE_NAME = "contentsFrameset_Cachedetail.html";
    private static final String CONTENTS_TITLE_HTML_FILE_NAME = "contentsTitle_Cachedetail.html";
    private static final String CONTENTS_BODY_HTML_FILE_NAME = "contentsBody_Cachedetail.html";

    @Override
    public String getReportName() {
        return REPORT_NAME;
    }

    @Override
    public boolean isGraphicReport() {
        return true;
    }

    @Override
    public boolean useTableSort() {
        return false;
    }

    @Override
    public boolean useContentsFooter() {
        return false;
    }

    @Override
    public String getMenuLinkViewKey() {
        return MENU_LINK_VIEW_KEY;
    }

    @Override
    public String getExplanationKey() {
        return EXPLANATION_KEY;
    }

    @Override
    public String getReportFramesetHtmlFileName() {
        return REPORT_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getMenuFramesetHtmlFileName() {
        return MENU_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getMenuBodyHtmlFileName() {
        return MENU_BODY_HTML_FILE_NAME;
    }

    @Override
    public String getContentsFramesetHtmlFileName() {
        return CONTENTS_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getContentsTitleHtmlFileName() {
        return CONTENTS_TITLE_HTML_FILE_NAME;
    }

    @Override
    public String getContentsBodyHtmlFileName() {
        return CONTENTS_BODY_HTML_FILE_NAME;
    }

    @Override
    public void generateReportDir() {
        super.generateReportDir();
        SJdtReportGeneratorManager.generateDir(this.OUTPUT_CSS_DIR);
        SJdtReportGeneratorManager.generateDir(this.OUTPUT_IMG_DIR);
    }

    @Override
    public void generateContentsBody() throws SJdtRPTDTException {
        VelocityContext context = SJdtReportGeneratorManager.getVelocityContext();
        context.put("libraryPath", (Object)VM_LIBLARY_PATH);
        this.setFixedStr(context);
        this.setVariableStr(context);
        String generateFilePath = this.OUTPUT_HTML_DIR + this.getContentsBodyHtmlFileName();
        SJdtReportGeneratorManager.generateFile(context, CONTENTS_BODY_VM_FILE_PATH, generateFilePath);
        String cssFileName = "contentsBody_Cachedetail.css";
        String originalFilePath = "/sanproject/sn2/rptdt/template/cachedetail/css/" + cssFileName;
        String destFilePath = this.OUTPUT_CSS_DIR + cssFileName;
        SJdtReportGeneratorManager.copyFile(originalFilePath, destFilePath);
        SJdtReportGeneratorManager.copyAllFile(this, "/cachedetail/img/", this.OUTPUT_IMG_DIR);
    }

    private void setFixedStr(VelocityContext context) {
        context.put("dkc", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cachedetail.dkc"));
        context.put("cacheSize", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cachedetail.cacheSize"));
        context.put("sharedMemorySize", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cachedetail.sharedMemorySize"));
        context.put("gb", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cachedetail.gb"));
        context.put("cache2cb", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cachedetail.cache2cb"));
        context.put("cache2ca", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cachedetail.cache2ca"));
        context.put("cache1ca", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cachedetail.cache1ca"));
        context.put("cache1cb", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cachedetail.cache1cb"));
        context.put("cache2cd", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cachedetail.cache2cd"));
        context.put("cache2cc", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cachedetail.cache2cc"));
        context.put("cache1cc", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cachedetail.cache1cc"));
        context.put("cache1cd", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cachedetail.cache1cd"));
        context.put("notInstalled", (Object)SJdtReportGeneratorManager.getGuidanceValue("Cachedetail.notInstalled"));
    }

    private void setVariableStr(VelocityContext context) {
        SJdtMpPcbStatusCSVWrapper mpPcbStatus = (SJdtMpPcbStatusCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("MpPcbStatus.csv");
        boolean useDkc1Flg = mpPcbStatus.existsModule1Data();
        context.put("useDkc1Flg", (Object)useDkc1Flg);
        this.setCacheInfo(context);
    }

    private void setCacheInfo(VelocityContext context) {
        SJdtCacheInfoCSVWrapper cacheInfo = (SJdtCacheInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("CacheInfo.csv");
        HashMap<String, Pcb> cacheMap = new HashMap<String, Pcb>();
        int dkc0CacheSize = 0;
        int dkc0SharedMemorySize = 0;
        int dkc1CacheSize = 0;
        int dkc1SharedMemorySize = 0;
        List<String[]> csvDataList = cacheInfo.getCsvDataList();
        for (String[] cacheInfoRecord : csvDataList) {
            String module = cacheInfo.getValue(cacheInfoRecord, "Module#");
            String cacheLocation = cacheInfo.getValue(cacheInfoRecord, "Cache Location");
            String cacheLocationAsLowerCase = cacheLocation.toLowerCase();
            Pcb pcb = new Pcb();
            String cmDimmSizeStr = StringUtils.defaultIfEmpty((String)cacheInfo.getValue(cacheInfoRecord, "CM DIMM Size(GB)"), (String)"0");
            String cacheSizeStr = StringUtils.defaultIfEmpty((String)cacheInfo.getValue(cacheInfoRecord, "Cache Size(GB)"), (String)"0");
            String smSizeStr = StringUtils.defaultIfEmpty((String)cacheInfo.getValue(cacheInfoRecord, "SM Size(GB)"), (String)"0");
            int cmDimmSize = Integer.parseInt(cmDimmSizeStr);
            int cacheSize = Integer.parseInt(cacheSizeStr);
            int smSize = Integer.parseInt(smSizeStr);
            pcb.setCmDimmSize(cmDimmSize);
            pcb.setCacheSize(cacheSize);
            cacheMap.put(cacheLocationAsLowerCase, pcb);
            if ("0".equals(module)) {
                dkc0CacheSize += cacheSize;
                dkc0SharedMemorySize += smSize;
                continue;
            }
            dkc1CacheSize += cacheSize;
            dkc1SharedMemorySize += smSize;
        }
        context.put("cacheMap", cacheMap);
        context.put("valueOfDkc0CacheSize", (Object)String.valueOf(dkc0CacheSize));
        context.put("valueOfDkc0SharedMemorySize", (Object)String.valueOf(dkc0SharedMemorySize));
        context.put("valueOfDkc1CacheSize", (Object)String.valueOf(dkc1CacheSize));
        context.put("valueOfDkc1SharedMemorySize", (Object)String.valueOf(dkc1SharedMemorySize));
    }
}

