/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.rptdt.report.generator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import sanproject.sn2.rptdt.csv.SJdtCSVWrapperManager;
import sanproject.sn2.rptdt.csv.wrapper.SJdtChapUserInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtIscsiHostInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtIscsiTargetInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtLdevInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtLunInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtLunPortInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtPdevInfoCSVWrapper;
import sanproject.sn2.rptdt.csv.wrapper.SJdtWwnInfoCSVWrapper;
import sanproject.sn2.rptdt.report.generator.SJdtTableReportGenerator;
import sanproject.sn2.rptdt.util.SJdtRPTDTDevice;

public class SJdtHostgroupReportGenerator
extends SJdtTableReportGenerator {
    private static final String REPORT_NAME = "Hostgroup";
    private static final boolean IS_GRAPHIC_REPORT = false;
    private static final boolean USE_TABLE_SORT = true;
    private static final boolean USE_CONTENTS_FOOTER = false;
    private static final String[] HEADER_KEY_ARRAY = new String[]{"portLocation", "hostGroup", "resourceGroupName", "resourceGroupId", "numberOfLuns", "numberOfLdevs", "numberOfPgs", "numberOfDkas", "totalLdevCapacity", "portSecurity", "hostMode", "hostModeOption", "numberOfHosts"};
    private static final String[] HM_HEADER_KEY_ARRAY = new String[]{"portLocation", "type", "hostGroupIscsiTargetAlias", "hostGroupIscsiTargetId", "iscsiTargetName", "resourceGroupName", "resourceGroupId", "numberOfLuns", "numberOfLdevs", "numberOfPgs", "numberOfDkbs", "totalLdevCapacity", "portSecurity", "chapAuthentication", "chapAuthenticationMode", "chapAuthenticationUserName", "chapAuthenticationNumberOfUsers", "hostMode", "hostModeOption", "numberOfHosts"};
    private static final int COLUMN_LENGTH = SJdtHostgroupReportGenerator.getColumnLengthForKeySort(HEADER_KEY_ARRAY.length);
    private static final int HM_COLUMN_LENGTH = SJdtHostgroupReportGenerator.getColumnLengthForKeySort(HM_HEADER_KEY_ARRAY.length);
    private static final String MENU_LINK_VIEW_KEY = "Common.menu.Hostgroup";
    private static final String EXPLANATION_KEY = "Common.explanation.Hostgroup";
    private static final String TABLE_HEADER_BASE_KEY = "Hostgroup.table.header";
    private static final String REPORT_FRAMESET_HTML_FILE_NAME = "Hostgroup.html";
    private static final String MENU_FRAMESET_HTML_FILE_NAME = "menuFrameset_Hostgroup.html";
    private static final String MENU_BODY_HTML_FILE_NAME = "menuBody_Hostgroup.html";
    private static final String CONTENTS_FRAMESET_HTML_FILE_NAME = "contentsFrameset_Hostgroup.html";
    private static final String CONTENTS_TITLE_HTML_FILE_NAME = "contentsTitle_Hostgroup.html";
    private static final String CONTENTS_BODY_HTML_FILE_NAME = "contentsBody_Hostgroup.html";

    @Override
    public String getReportName() {
        return REPORT_NAME;
    }

    @Override
    public boolean isGraphicReport() {
        return false;
    }

    @Override
    public boolean useTableSort() {
        return true;
    }

    @Override
    public boolean useContentsFooter() {
        return false;
    }

    @Override
    public String[] getTableHeaderKeyArray() {
        if (SJdtRPTDTDevice.isHmdev()) {
            return HM_HEADER_KEY_ARRAY;
        }
        return HEADER_KEY_ARRAY;
    }

    @Override
    public String getMenuLinkViewKey() {
        return MENU_LINK_VIEW_KEY;
    }

    @Override
    public String getExplanationKey() {
        return EXPLANATION_KEY;
    }

    @Override
    public String getTableHeaderBaseKey() {
        return TABLE_HEADER_BASE_KEY;
    }

    @Override
    public String getReportFramesetHtmlFileName() {
        return REPORT_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getMenuFramesetHtmlFileName() {
        return MENU_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getMenuBodyHtmlFileName() {
        return MENU_BODY_HTML_FILE_NAME;
    }

    @Override
    public String getContentsFramesetHtmlFileName() {
        return CONTENTS_FRAMESET_HTML_FILE_NAME;
    }

    @Override
    public String getContentsTitleHtmlFileName() {
        return CONTENTS_TITLE_HTML_FILE_NAME;
    }

    @Override
    public String getContentsBodyHtmlFileName() {
        return CONTENTS_BODY_HTML_FILE_NAME;
    }

    @Override
    public boolean isEnableSortKey() {
        return true;
    }

    @Override
    public List<String[]> getTableDataList() {
        ArrayList<String[]> tableDataList = new ArrayList<String[]>();
        SJdtLunInfoCSVWrapper lunInfo = (SJdtLunInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("LunInfo.csv");
        SJdtWwnInfoCSVWrapper wwnInfo = (SJdtWwnInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("WwnInfo.csv");
        SJdtLdevInfoCSVWrapper ldevInfo = (SJdtLdevInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("LdevInfo.csv");
        SJdtPdevInfoCSVWrapper pdevInfo = (SJdtPdevInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("PdevInfo.csv");
        SJdtLunPortInfoCSVWrapper lunPortInfo = (SJdtLunPortInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("LunPortInfo.csv");
        SJdtChapUserInfoCSVWrapper chapUserInfo = (SJdtChapUserInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("ChapUserInfo.csv");
        SJdtIscsiTargetInfoCSVWrapper iscsiTagetInfo = (SJdtIscsiTargetInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("IscsiTargetInfo.csv");
        SJdtIscsiHostInfoCSVWrapper iscsiHostInfo = (SJdtIscsiHostInfoCSVWrapper)SJdtCSVWrapperManager.getCsvWrapper("IscsiHostInfo.csv");
        HashSet<String> portAndHostGroupSet = new HashSet<String>();
        List<String[]> csvDataList = lunInfo.getCsvDataList();
        for (String[] lunInfoRecord : csvDataList) {
            String chapAuthenticationUserName;
            String chapAuthenticationMode;
            String chapAuthentication;
            String hostGroupIscsiTargetId;
            String port = lunInfo.getValue(lunInfoRecord, "Port");
            String hostGroup = lunInfo.getValue(lunInfoRecord, "Host Group");
            String portAndHostGroupStr = port + ";" + hostGroup;
            if (portAndHostGroupSet.contains(portAndHostGroupStr)) continue;
            portAndHostGroupSet.add(portAndHostGroupStr);
            String packageType = lunInfo.getValue(lunInfoRecord, "Package Type");
            String[] oneRecord = null;
            oneRecord = SJdtRPTDTDevice.isHmdev() ? new String[HM_COLUMN_LENGTH] : new String[COLUMN_LENGTH];
            oneRecord[((Integer)SJdtHostgroupReportGenerator.headerMap.get((Object)"portLocation")).intValue()] = port;
            oneRecord[((Integer)SJdtHostgroupReportGenerator.headerMap.get((Object)"type")).intValue()] = packageType;
            oneRecord[((Integer)SJdtHostgroupReportGenerator.headerMap.get((Object)"hostGroupIscsiTargetAlias")).intValue()] = hostGroup;
            oneRecord[((Integer)SJdtHostgroupReportGenerator.headerMap.get((Object)"hostGroupIscsiTargetId")).intValue()] = hostGroupIscsiTargetId = wwnInfo.getHostGroupNumber(port, hostGroup);
            List<String[]> lunsRecordList = lunInfo.getLunsRecordList(port, hostGroup);
            oneRecord[((Integer)SJdtHostgroupReportGenerator.headerMap.get((Object)"numberOfLuns")).intValue()] = String.valueOf(lunsRecordList.size());
            if (lunsRecordList.size() == 0) {
                oneRecord[((Integer)SJdtHostgroupReportGenerator.headerMap.get((Object)"numberOfLdevs")).intValue()] = "0";
                oneRecord[((Integer)SJdtHostgroupReportGenerator.headerMap.get((Object)"numberOfPgs")).intValue()] = "0";
                if (SJdtRPTDTDevice.isHmdev()) {
                    oneRecord[((Integer)SJdtHostgroupReportGenerator.headerMap.get((Object)"numberOfDkbs")).intValue()] = "0";
                } else {
                    oneRecord[((Integer)SJdtHostgroupReportGenerator.headerMap.get((Object)"numberOfDkas")).intValue()] = "0";
                }
                oneRecord[((Integer)SJdtHostgroupReportGenerator.headerMap.get((Object)"totalLdevCapacity")).intValue()] = "0";
            } else {
                List<Object> ldevSet = new ArrayList();
                ldevSet = lunInfo.getLdevSet(lunsRecordList);
                oneRecord[((Integer)SJdtHostgroupReportGenerator.headerMap.get((Object)"numberOfLdevs")).intValue()] = String.valueOf(ldevSet.size());
                List<String> eccGroupList = ldevInfo.getEccGroupValueSet(ldevSet);
                oneRecord[((Integer)SJdtHostgroupReportGenerator.headerMap.get((Object)"numberOfPgs")).intValue()] = String.valueOf(eccGroupList.size());
                List<String> dkaSet = pdevInfo.getDkaValueSet(eccGroupList);
                if (SJdtRPTDTDevice.isHmdev()) {
                    oneRecord[((Integer)SJdtHostgroupReportGenerator.headerMap.get((Object)"numberOfDkbs")).intValue()] = String.valueOf(dkaSet.size());
                } else {
                    oneRecord[((Integer)SJdtHostgroupReportGenerator.headerMap.get((Object)"numberOfDkas")).intValue()] = String.valueOf(dkaSet.size());
                }
                oneRecord[((Integer)SJdtHostgroupReportGenerator.headerMap.get((Object)"totalLdevCapacity")).intValue()] = ldevInfo.getSumSize(ldevSet);
            }
            if (!this.isIscsi(packageType)) {
                oneRecord[((Integer)SJdtHostgroupReportGenerator.headerMap.get((Object)"iscsiTargetName")).intValue()] = "-";
                oneRecord[((Integer)SJdtHostgroupReportGenerator.headerMap.get((Object)"resourceGroupName")).intValue()] = lunInfo.getValue(lunInfoRecord, "Resource Group Name (Host Group)");
                oneRecord[((Integer)SJdtHostgroupReportGenerator.headerMap.get((Object)"resourceGroupId")).intValue()] = lunInfo.getValue(lunInfoRecord, "Resource Group ID (Host Group)");
                String securitySwitch = lunPortInfo.getMatchedOneRecordColumnValue(port, "Port", "Security Switch");
                oneRecord[((Integer)SJdtHostgroupReportGenerator.headerMap.get((Object)"portSecurity")).intValue()] = this.getOnOffToDisplayStr(securitySwitch);
                oneRecord[((Integer)SJdtHostgroupReportGenerator.headerMap.get((Object)"chapAuthentication")).intValue()] = "-";
                oneRecord[((Integer)SJdtHostgroupReportGenerator.headerMap.get((Object)"chapAuthenticationMode")).intValue()] = "-";
                oneRecord[((Integer)SJdtHostgroupReportGenerator.headerMap.get((Object)"chapAuthenticationUserName")).intValue()] = "-";
                oneRecord[((Integer)SJdtHostgroupReportGenerator.headerMap.get((Object)"chapAuthenticationNumberOfUsers")).intValue()] = "-";
                String hostMode = lunInfo.getValue(lunInfoRecord, "Host Mode");
                oneRecord[((Integer)SJdtHostgroupReportGenerator.headerMap.get((Object)"hostMode")).intValue()] = hostMode.toUpperCase();
                oneRecord[((Integer)SJdtHostgroupReportGenerator.headerMap.get((Object)"hostModeOption")).intValue()] = lunInfo.getValue(lunInfoRecord, "Host Mode Option");
                int numberOfMatchedRecord = wwnInfo.getNumberOfHosts(port, hostGroup);
                oneRecord[((Integer)SJdtHostgroupReportGenerator.headerMap.get((Object)"numberOfHosts")).intValue()] = String.valueOf(numberOfMatchedRecord);
                tableDataList.add(oneRecord);
                continue;
            }
            List<String[]> iscsiTrgetListSpecifidPort = iscsiTagetInfo.getMatchedAllRecord(port, "Port");
            List<String[]> iscsiTrgetListSpecifidIscsiId = iscsiTagetInfo.getMatchedAllRecord(hostGroupIscsiTargetId, "iSCSI Target ID", iscsiTrgetListSpecifidPort);
            String[] iscsiTagetInfoRecord = iscsiTagetInfo.getDefaultRecordValue();
            if (iscsiTrgetListSpecifidIscsiId.size() != 0) {
                iscsiTagetInfoRecord = iscsiTrgetListSpecifidIscsiId.get(0);
            }
            oneRecord[((Integer)SJdtHostgroupReportGenerator.headerMap.get((Object)"iscsiTargetName")).intValue()] = iscsiTagetInfo.getValue(iscsiTagetInfoRecord, "iSCSI Target Name");
            oneRecord[((Integer)SJdtHostgroupReportGenerator.headerMap.get((Object)"resourceGroupName")).intValue()] = iscsiTagetInfo.getValue(iscsiTagetInfoRecord, "Resource Group Name (iSCSI Target)");
            oneRecord[((Integer)SJdtHostgroupReportGenerator.headerMap.get((Object)"resourceGroupId")).intValue()] = iscsiTagetInfo.getValue(iscsiTagetInfoRecord, "Resource Group ID (iSCSI Target)");
            String securitySwitch = iscsiTagetInfo.getValue(iscsiTagetInfoRecord, "Security Switch");
            oneRecord[((Integer)SJdtHostgroupReportGenerator.headerMap.get((Object)"portSecurity")).intValue()] = this.getOnOffToDisplayStr(securitySwitch);
            oneRecord[((Integer)SJdtHostgroupReportGenerator.headerMap.get((Object)"chapAuthentication")).intValue()] = chapAuthentication = iscsiTagetInfo.getValue(iscsiTagetInfoRecord, "Authentication | Method");
            oneRecord[((Integer)SJdtHostgroupReportGenerator.headerMap.get((Object)"chapAuthenticationMode")).intValue()] = chapAuthenticationMode = iscsiTagetInfo.getValue(iscsiTagetInfoRecord, "Authentication | Mutual CHAP");
            oneRecord[((Integer)SJdtHostgroupReportGenerator.headerMap.get((Object)"chapAuthenticationUserName")).intValue()] = chapAuthenticationUserName = iscsiTagetInfo.getValue(iscsiTagetInfoRecord, "Authentication | User Name");
            List<String[]> chapUsersList = chapUserInfo.getNumberofUsers(port, hostGroupIscsiTargetId);
            oneRecord[((Integer)SJdtHostgroupReportGenerator.headerMap.get((Object)"chapAuthenticationNumberOfUsers")).intValue()] = String.valueOf(chapUsersList.size());
            String hostMode = iscsiTagetInfo.getValue(iscsiTagetInfoRecord, "Host Mode");
            oneRecord[((Integer)SJdtHostgroupReportGenerator.headerMap.get((Object)"hostMode")).intValue()] = hostMode.toUpperCase();
            oneRecord[((Integer)SJdtHostgroupReportGenerator.headerMap.get((Object)"hostModeOption")).intValue()] = iscsiTagetInfo.getValue(iscsiTagetInfoRecord, "Host Mode Option");
            List<String[]> iscsiHostListSpecifidPort = iscsiHostInfo.getMatchedAllRecord(port, "Port");
            List<String[]> iscsiHostListSpecifidIscsiId = iscsiHostInfo.getMatchedAllRecord(hostGroupIscsiTargetId, "iSCSI Target ID", iscsiHostListSpecifidPort);
            int cnt = 0;
            for (String[] iscsiHostSpecifidIscsiId : iscsiHostListSpecifidIscsiId) {
                if (!StringUtils.isNotEmpty((String)iscsiHostInfo.getValue(iscsiHostSpecifidIscsiId, "iSCSI Name"))) continue;
                ++cnt;
            }
            oneRecord[((Integer)SJdtHostgroupReportGenerator.headerMap.get((Object)"numberOfHosts")).intValue()] = String.valueOf(cnt);
            tableDataList.add(oneRecord);
        }
        return tableDataList;
    }
}

