/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.profiles.dmtf.indications;

import com.ws.utilities.CipherUtilities;
import com.ws.wbem.CloseableAddableIterator;
import com.ws.wbem.jserver.JServerProperties;
import com.ws.wbem.jserver.profiles.common.GenericReadOnlyProvider;
import com.ws.wbem.jserver.profiles.common.WSBaseProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Level;
import javax.cim.CIMArgument;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger32;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.client.EnumerateResponse;

public abstract class TLSSettingDataProvider
extends GenericReadOnlyProvider {
    private static final String MN_SETENABLEDCIPHERSUITES = "SetEnabledCipherSuites";
    private static final String MN_STARTSERVICE = "StartService";
    private static final String MN_STOPSERVICE = "StopService";
    private static final String AN_CIPHERSUITES = "CipherSuites";
    private static final long ERR_UNSPECIFIED_ERROR = 1L;
    private static final long ERR_INVALID_PARAMETER = 2L;
    private static final long ERR_NO_CIPHERS = 3L;
    private static final long ERR_EMPTY_CIPHERS = 4L;
    private static final long ERR_INVALID_CIPHERS = 5L;
    private static final String CPN_ENABLEDCIPHERSUITES = "EnabledCipherSuites";
    private static final String CPN_SUPPORTEDCIPHERSUITES = "SupportedCipherSuites";
    private static final String CPN_DEFAULTCIPHERSUITES = "DefaultCipherSuites";
    private static final String CPN_NAME = "Name";
    private static final String CN_OBJECTMANAGERADAPTER = "CIM_ObjectManagerAdapter";
    private final String mObjectManagerAdapterName;

    public static CIMInstance fixSettingDataInstance(WSBaseProvider wSBaseProvider, CIMInstance cIMInstance, String[] stringArray) {
        CIMInstance cIMInstance2 = cIMInstance;
        if (null != cIMInstance2 && (null == stringArray || stringArray.length > 0)) {
            HashSet<String> hashSet = new HashSet<String>();
            if (null != stringArray) {
                for (String object : stringArray) {
                    hashSet.add(object.toLowerCase());
                }
            }
            String[] stringArray2 = null;
            String[] stringArray3 = null;
            try {
                stringArray2 = CipherUtilities.getSupportedJavaCiphers();
                stringArray3 = CipherUtilities.getDefaultJavaCiphers();
            }
            catch (WBEMException wBEMException) {
                Throwable throwable = wBEMException.getCause();
                mLogger.log(Level.SEVERE, "Could not get supported or default cipher suites", null == throwable ? wBEMException : throwable);
                return cIMInstance2;
            }
            ArrayList<CIMProperty> arrayList = new ArrayList<CIMProperty>();
            if (null == stringArray || hashSet.contains(CPN_SUPPORTEDCIPHERSUITES.toLowerCase())) {
                arrayList.add(new CIMProperty(CPN_SUPPORTEDCIPHERSUITES, CIMDataType.STRING_ARRAY_T, (Object)stringArray2, false));
            }
            if (null == stringArray || hashSet.contains(CPN_DEFAULTCIPHERSUITES.toLowerCase())) {
                arrayList.add(new CIMProperty(CPN_DEFAULTCIPHERSUITES, CIMDataType.STRING_ARRAY_T, (Object)stringArray3, false));
            }
            if ((null == stringArray || hashSet.contains(CPN_ENABLEDCIPHERSUITES.toLowerCase())) && null == cIMInstance2.getPropertyValue(CPN_ENABLEDCIPHERSUITES)) {
                arrayList.add(new CIMProperty(CPN_ENABLEDCIPHERSUITES, CIMDataType.STRING_ARRAY_T, (Object)stringArray3, false));
            }
            cIMInstance2 = wSBaseProvider.deriveInstance(cIMInstance, arrayList.toArray(new CIMProperty[arrayList.size()]));
        }
        return cIMInstance2;
    }

    public TLSSettingDataProvider(String string) {
        this.mObjectManagerAdapterName = string;
    }

    public CloseableIterator<CIMInstance> enumerateInstances(CIMObjectPath cIMObjectPath, String[] stringArray, String string, String string2, boolean bl) throws WBEMException {
        CloseableAddableIterator closeableAddableIterator = new CloseableAddableIterator();
        CloseableIterator closeableIterator = mInternalProvider.enumerateInstances(cIMObjectPath, stringArray, string, string2, bl);
        while (closeableIterator.hasNext()) {
            CIMInstance cIMInstance = (CIMInstance)closeableIterator.next();
            cIMInstance = TLSSettingDataProvider.fixSettingDataInstance((WSBaseProvider)this, cIMInstance, stringArray);
            closeableAddableIterator.add((Object)this.cleanInstance(cIMObjectPath, cIMInstance));
        }
        closeableAddableIterator.done();
        return closeableAddableIterator;
    }

    public synchronized CIMInstance getInstance(CIMObjectPath cIMObjectPath, String[] stringArray) throws WBEMException {
        cIMObjectPath = this.cleanPath(cIMObjectPath);
        CIMInstance cIMInstance = mInternalProvider.getInstance(cIMObjectPath, stringArray);
        cIMInstance = TLSSettingDataProvider.fixSettingDataInstance((WSBaseProvider)this, cIMInstance, stringArray);
        return this.cleanInstance(cIMObjectPath, cIMInstance);
    }

    private CIMObjectPath getObjectManagerAdapter() throws WBEMException {
        CIMObjectPath cIMObjectPath = null;
        CIMObjectPath cIMObjectPath2 = new CIMObjectPath(null, null, null, JServerProperties.getInteropNamespace(), CN_OBJECTMANAGERADAPTER, null);
        UnsignedInteger32 unsignedInteger32 = new UnsignedInteger32(10L);
        EnumerateResponse enumerateResponse = mHandle.enumerateInstances(cIMObjectPath2, null, null, null, unsignedInteger32, false, unsignedInteger32);
        boolean bl = false;
        block2: while (!bl || !enumerateResponse.isEnd()) {
            if (bl) {
                enumerateResponse = mHandle.getInstances(cIMObjectPath2, enumerateResponse.getContext(), unsignedInteger32);
            } else {
                bl = true;
            }
            CloseableIterator closeableIterator = enumerateResponse.getResponses();
            while (closeableIterator.hasNext()) {
                cIMObjectPath2 = ((CIMInstance)closeableIterator.next()).getObjectPath();
                String string = cIMObjectPath2.getKey(CPN_NAME) != null ? (String)cIMObjectPath2.getKey(CPN_NAME).getValue() : null;
                if (!this.mObjectManagerAdapterName.equals(string)) continue;
                cIMObjectPath = cIMObjectPath2;
                try {
                    mHandle.closeEnumeration(cIMObjectPath2, enumerateResponse.getContext());
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    while (null != throwable2.getCause()) {
                        throwable2 = throwable2.getCause();
                    }
                    mLogger.log(Level.WARNING, "Error closing enumeration context.", throwable2);
                }
                continue block2;
            }
        }
        return cIMObjectPath;
    }

    public Object invokeMethod(CIMObjectPath cIMObjectPath, String string, CIMArgument<?>[] closeableIterator, CIMArgument<?>[] cIMArgumentArray) throws WBEMException {
        long l = 0L;
        if (MN_SETENABLEDCIPHERSUITES.equals(string)) {
            String string2;
            String[] stringArray = null;
            boolean bl = false;
            for (CIMInstance cIMInstance : closeableIterator) {
                if (AN_CIPHERSUITES.equals(cIMInstance.getName())) {
                    bl = true;
                    stringArray = (String[])cIMInstance.getValue();
                    string2 = CipherUtilities.validateCiphers((String[])stringArray);
                    if (null == string2) continue;
                    mLogger.log(Level.SEVERE, "Invalid Cipher values passed to SetEnabledCipherSuites: {0}", string2);
                    l = 5L;
                    continue;
                }
                mLogger.log(Level.SEVERE, "There was an invalid parameter passed to SetEnabledCipherSuites: {0}", cIMInstance.getName());
                l = 2L;
            }
            if (l == 0L) {
                if (!bl) {
                    l = 3L;
                    mLogger.log(Level.SEVERE, "Method argument \"{0}\" was missing from call to SetEnabledCipherSuites", AN_CIPHERSUITES);
                } else if (l == 0L && null != stringArray && stringArray.length == 0) {
                    l = 4L;
                    mLogger.severe("Empty Cipher list passed to SetEnabledCipherSuites method");
                } else {
                    CloseableIterator closeableIterator2 = mInternalProvider.enumerateInstances(cIMObjectPath, null, null, null, false);
                    if (closeableIterator2.hasNext()) {
                        CIMInstance cIMInstance;
                        CIMInstance cIMInstance2 = (CIMInstance)closeableIterator2.next();
                        CIMProperty[] cIMPropertyArray = new CIMProperty[]{new CIMProperty(CPN_ENABLEDCIPHERSUITES, CIMDataType.STRING_ARRAY_T, (Object)stringArray, false)};
                        cIMInstance = this.deriveInstance(cIMInstance2, cIMPropertyArray);
                        mInternalProvider.modifyInstance(cIMInstance, new String[]{CPN_ENABLEDCIPHERSUITES});
                        string2 = this.getObjectManagerAdapter();
                        if (null == string2) {
                            mLogger.severe("Could not find instance of CIM_ObjectManagerAdapter.  Cannot restart it using new Cipher Suites");
                        } else {
                            this.restartObjectManagerAdapter((CIMObjectPath)string2);
                        }
                    } else {
                        l = 1L;
                        mLogger.log(Level.SEVERE, "Could not find instance of Settings Class: {0}", cIMObjectPath);
                    }
                }
            }
        } else {
            throw new WBEMException(17, string);
        }
        return new UnsignedInteger32(l);
    }

    private void restartObjectManagerAdapter(final CIMObjectPath cIMObjectPath) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                    mHandle.invokeMethod(cIMObjectPath, TLSSettingDataProvider.MN_STOPSERVICE, new CIMArgument[0], new CIMArgument[0]);
                    mHandle.invokeMethod(cIMObjectPath, TLSSettingDataProvider.MN_STARTSERVICE, new CIMArgument[0], new CIMArgument[0]);
                    mLogger.log(Level.FINE, "Enabled Cipher suites modified, Restarted ObjectManagerAdapter: {0}", cIMObjectPath);
                }
                catch (Throwable throwable) {
                    mLogger.log(Level.SEVERE, "Caught exception trying to restart ObjectManagerAdapter", throwable);
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.setDaemon(true);
        thread.setName("restartObjectManagerAdapter");
        thread.setDaemon(true);
        thread.start();
    }
}

