/*
 * Decompiled with CFR 0.152.
 */
package sanproject.serverux.data;

import java.lang.reflect.Array;
import sanproject.serverux.data.MonitorInfo;

public class MonitorInfoArray
extends MonitorInfo {
    private MonitorInfo[] data;

    public MonitorInfoArray() {
        this.data = new MonitorInfo[0];
    }

    public MonitorInfoArray(Class clazz) {
        this.data = (MonitorInfo[])Array.newInstance(clazz, 0);
    }

    public MonitorInfoArray(MonitorInfo[] monitorInfoArray) {
        this.data = monitorInfoArray;
    }

    public MonitorInfo get(int n) {
        this.rangeCheck(n);
        return this.data[n];
    }

    public MonitorInfo[] get() {
        return this.data;
    }

    public int size() {
        return this.data.length;
    }

    private void rangeCheck(int n) {
        int n2 = this.data.length;
        if (n < 0 || n >= n2) {
            throw new IndexOutOfBoundsException("Index: " + n + ",Size: " + n2);
        }
    }

    public void set(MonitorInfo[] monitorInfoArray) {
        this.data = monitorInfoArray;
    }

    public boolean contains(MonitorInfo monitorInfo) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!this.get(i).equals(monitorInfo)) continue;
            return true;
        }
        return false;
    }

    public int indexOf(MonitorInfo monitorInfo) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!this.get(i).equals(monitorInfo)) continue;
            return i;
        }
        return -1;
    }

    private void secureSize(Class clazz) {
        int n = this.data.length;
        int n2 = n + 1;
        MonitorInfo[] monitorInfoArray = this.data;
        this.data = (MonitorInfo[])Array.newInstance(clazz, n2);
        System.arraycopy(monitorInfoArray, 0, this.data, 0, n);
    }

    public void addElement(MonitorInfo monitorInfo) {
        this.secureSize(monitorInfo.getClass());
        this.setElement(this.size() - 1, monitorInfo);
    }

    void setElement(int n, MonitorInfo monitorInfo) {
        this.rangeCheck(n);
        this.data[n] = monitorInfo;
    }

    void setElements(MonitorInfo[] monitorInfoArray) {
        this.data = monitorInfoArray;
    }
}

