/*
 * Decompiled with CFR 0.152.
 */
package sanproject.serverux.data;

import java.lang.reflect.Array;
import java.util.NoSuchElementException;
import sanproject.serverux.data.MonitorElementInfo;
import sanproject.serverux.data.MonitorInfo;

public class MonitorInfoCollection
extends MonitorInfo {
    private int cursor = 0;
    private MonitorInfoCollection nextCollection = null;
    private MonitorElementInfo[] data;
    private int lastRet = -1;

    public MonitorInfoCollection() {
        this.data = new MonitorElementInfo[0];
    }

    public MonitorInfoCollection(Class clazz) {
        this.data = (MonitorElementInfo[])Array.newInstance(clazz, 0);
    }

    public MonitorInfoCollection(MonitorElementInfo[] monitorElementInfoArray) {
        this.setElements(monitorElementInfoArray);
    }

    public boolean contains(MonitorElementInfo monitorElementInfo) {
        for (int i = this.data.length - 1; i >= 0; --i) {
            if (!this.get(i).equals(monitorElementInfo)) continue;
            return true;
        }
        return false;
    }

    public int indexOf(MonitorElementInfo monitorElementInfo) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!this.get(i).equals(monitorElementInfo)) continue;
            return i;
        }
        return -1;
    }

    public MonitorElementInfo next() {
        try {
            MonitorElementInfo monitorElementInfo = null;
            if (this.hasNext()) {
                monitorElementInfo = this.get(this.cursor);
                this.lastRet = this.cursor++;
            }
            return monitorElementInfo;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoSuchElementException(indexOutOfBoundsException.getMessage());
        }
    }

    public MonitorElementInfo get(int n) {
        this.rangeCheck(n);
        return this.data[n];
    }

    public MonitorElementInfo[] get() {
        return this.data;
    }

    public boolean hasNext() {
        return this.cursor != this.size();
    }

    public int size() {
        return this.data.length;
    }

    private void rangeCheck(int n) {
        int n2 = this.data.length;
        if (n < 0 || n >= n2) {
            throw new IndexOutOfBoundsException("Index: " + n + ",Size: " + n2);
        }
    }

    public MonitorInfoCollection getNextCollection() {
        return this.nextCollection;
    }

    public void setNextCollection(MonitorInfoCollection monitorInfoCollection) {
        this.nextCollection = monitorInfoCollection;
    }

    public boolean hasNextCollection() {
        return this.getNextCollection() != null;
    }

    private void secureSize(Class clazz) {
        int n = this.data.length;
        int n2 = n + 1;
        MonitorElementInfo[] monitorElementInfoArray = this.data;
        this.data = (MonitorElementInfo[])Array.newInstance(clazz, n2);
        System.arraycopy(monitorElementInfoArray, 0, this.data, 0, n);
    }

    void addElement(MonitorElementInfo monitorElementInfo) {
        this.secureSize(monitorElementInfo.getClass());
        this.setElement(this.size() - 1, monitorElementInfo);
    }

    void setElement(int n, MonitorElementInfo monitorElementInfo) {
        this.rangeCheck(n);
        monitorElementInfo.setParent(this);
        this.data[n] = monitorElementInfo;
    }

    void setElements(MonitorElementInfo[] monitorElementInfoArray) {
        this.data = monitorElementInfoArray;
        for (int i = monitorElementInfoArray.length - 1; i >= 0; --i) {
            this.data[i].setParent(this);
        }
    }
}

