/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.account;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import sanproject.client.account.RJAccAddUsrDialog;
import sanproject.client.account.RJAccApplyData;
import sanproject.client.account.RJAccElement;
import sanproject.client.account.RJAccIconTable;
import sanproject.client.account.RJAccTreePanel;
import sanproject.client.account.RJAccUserElement;
import sanproject.client.com.RJComUty;
import sanproject.client.com.RJcGuide;
import sanproject.client.com.RJcTreePanel;
import sanproject.client.com.abs.RJaContainMenu;
import sanproject.client.com.abs.RJaMenuItemActionListener;
import sanproject.client.com.abs.RJaPopupMenuSTD;
import sanproject.client.com.abs.RJaTreeManager;
import sanproject.client.com.abs.RJaTreeNode;
import sanproject.client.data.RJDataMsg;
import sanproject.serverux.data.UserEntryInfoSx;

public class RJAccUserFolderElement
extends RJAccElement
implements RJaContainMenu,
RJaMenuItemActionListener {
    private String[] menuItems = new String[]{RJcGuide.text("Account/AddDlgTitle")};
    private Component parent = null;
    private JComponent invoker;
    private DefaultTreeModel treeModel = null;
    private RJaTreeNode node = null;
    private int slprID;
    String name;

    public RJAccUserFolderElement(int n, String string, RJcTreePanel rJcTreePanel) {
        super(null, rJcTreePanel);
        this.slprID = n;
        this.name = string;
        this.setName(this.toSlprName(n));
        this.parent = this.supplier.searchWindow(rJcTreePanel);
    }

    public void createChildren(RJaTreeManager rJaTreeManager, RJaTreeNode rJaTreeNode) {
        this.supplier.putLog("[Account]", "[Tree]", "CreateChildren");
        this.node = rJaTreeNode;
        ArrayList arrayList = this.supplier.getUserEntryInfo(this.slprID);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            UserEntryInfoSx userEntryInfoSx = (UserEntryInfoSx)iterator.next();
            RJAccUserElement rJAccUserElement = new RJAccUserElement(userEntryInfoSx.getStrUserID(), (RJcTreePanel)rJaTreeManager);
            rJAccUserElement.initDetail(userEntryInfoSx);
            rJAccUserElement.setSlprName(this.name);
            rJAccUserElement.setPassword(this.supplier.getUserPasswordStrFromUserID(rJAccUserElement.getName()));
            RJaTreeNode rJaTreeNode2 = rJaTreeManager.addObject(rJaTreeNode, rJAccUserElement);
            rJaTreeNode2.createChildren();
        }
        rJaTreeNode.setAllowsChildren(rJaTreeNode.getChildCount() != 0);
    }

    public Icon getIcon(boolean bl) {
        Icon icon = this.slprID == Short.MAX_VALUE ? RJAccIconTable.getIcon(bl ? 2 : 3) : RJAccIconTable.getIcon(bl ? 4 : 5);
        if (icon == null) {
            icon = super.getIcon(bl);
        }
        return icon;
    }

    public boolean getAllowsChildren() {
        return true;
    }

    private String toSlprName(int n) {
        String string = null;
        if (n == Short.MAX_VALUE) {
            string = "SA";
        } else if (n >= 0) {
            Object[] objectArray = new Object[]{new Integer(n)};
            string = MessageFormat.format("SLPR{0,number,00}", objectArray);
        }
        return string;
    }

    public void showMenu(JComponent jComponent, int n, int n2, DefaultTreeModel defaultTreeModel, RJaTreeNode rJaTreeNode) {
        this.supplier.putLog("[Account]", "[Tree]", "PopUp_F");
        this.treeModel = defaultTreeModel;
        this.node = rJaTreeNode;
        this.invoker = jComponent;
        RJaPopupMenuSTD rJaPopupMenuSTD = null;
        if (rJaPopupMenuSTD == null && this.supplier.getAccountPermissionFromRMI() == 2) {
            rJaPopupMenuSTD = new RJaPopupMenuSTD(this, this.menuItems);
        }
        if (rJaPopupMenuSTD != null) {
            rJaPopupMenuSTD.show(jComponent, n, n2);
        }
    }

    public void menuItemActionPerformed(ActionEvent actionEvent, int n) {
        this.actionAddAccount();
        this.invoker.revalidate();
        this.invoker.repaint(1L);
    }

    private void actionAddAccount() {
        this.supplier.putLog("[Account]", "[Tree]", "AddUser Dialog");
        boolean bl = false;
        ((RJAccTreePanel)this.getTreePanel()).collectUsrElement();
        RJAccApplyData rJAccApplyData = this.supplier.getApplyData();
        if (rJAccApplyData.usrElement_Number() >= 500) {
            Object[] objectArray = new Object[]{RJComUty.CAPTION_MSG_OK};
            RJDataMsg rJDataMsg = this.supplier.getMessage(21055612);
            int n = this.supplier.showMessage((RJAccTreePanel)this.getTreePanel(), rJDataMsg, 0, objectArray, objectArray[0]);
        } else {
            RJAccAddUsrDialog rJAccAddUsrDialog = new RJAccAddUsrDialog((Frame)this.parent, this.supplier);
            RJAccUserElement rJAccUserElement = new RJAccUserElement("", this.treePanel);
            rJAccAddUsrDialog.setElement(rJAccUserElement);
            rJAccAddUsrDialog.show("");
            if (rJAccAddUsrDialog.buttonflag && rJAccUserElement.getName().length() != 0) {
                int n = this.treePanel.lookup(this.node, rJAccUserElement);
                UserEntryInfoSx userEntryInfoSx = new UserEntryInfoSx();
                String[] stringArray = this.makeRWPermission();
                userEntryInfoSx.strPermission = stringArray[0];
                userEntryInfoSx.strWritePermission = stringArray[1];
                userEntryInfoSx.nSLPRno = this.slprID;
                userEntryInfoSx.nAccountFlg = 1;
                rJAccUserElement.initDetail(userEntryInfoSx);
                rJAccUserElement.setslprID(this.slprID);
                rJAccUserElement.setSlprName(this.name);
                RJaTreeNode rJaTreeNode = this.treePanel.insertObject(this.node, n, rJAccUserElement);
                this.treePanel.getTree().setSelectionPath(new TreePath(rJaTreeNode.getPath()));
            }
        }
    }

    private String[] makeRWPermission() {
        int n;
        byte[] byArray = new byte[64];
        byte[] byArray2 = new byte[64];
        for (n = 0; n < 64; ++n) {
            byArray[n] = (byte)Integer.parseInt("FF", 16);
            byArray2[n] = (byte)Integer.parseInt("FF", 16);
        }
        n = 64;
        byArray[0] = (byte)(byArray[0] - n);
        byArray2[0] = (byte)(byArray2[0] - n);
        n = 2;
        byArray[18] = (byte)(byArray[18] - n);
        byArray2[18] = (byte)(byArray2[18] - n);
        if (this.slprID != Short.MAX_VALUE) {
            n = -128;
            byArray[0] = (byte)(byArray[0] - n);
            byArray2[0] = (byte)(byArray2[0] - n);
        }
        return RJAccUserFolderElement.byte2String(byArray, byArray2);
    }

    static String[] byte2String(byte[] byArray, byte[] byArray2) {
        String[] stringArray = new String[]{new String(), new String()};
        for (int i = 0; i < 64; ++i) {
            String string = Integer.toHexString(new Byte(byArray[i]).intValue());
            String string2 = Integer.toHexString(new Byte(byArray2[i]).intValue());
            string = RJAccUserFolderElement.remodel_String(string);
            string2 = RJAccUserFolderElement.remodel_String(string2);
            stringArray[0] = string + stringArray[0];
            stringArray[1] = string2 + stringArray[1];
        }
        return stringArray;
    }

    static String remodel_String(String string) {
        if (string.length() < 2) {
            while (string.length() < 2) {
                string = "0" + string;
            }
        } else if (string.length() > 2) {
            string = string.substring(string.length() - 2);
        }
        return string;
    }

    public String toString() {
        return this.name;
    }
}

