/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.baseinfo.pg;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import sanproject.client.baseinfo.com.RJBaseInfoComboAdapter;
import sanproject.client.baseinfo.com.RJBaseInfoDataSupplier;
import sanproject.client.baseinfo.com.RJBaseInfoDef;
import sanproject.client.baseinfo.com.RJBaseInfoTabPanel;
import sanproject.client.baseinfo.pg.RJBaseInfoItemFolder;
import sanproject.client.baseinfo.pg.RJBaseInfoPGLDEVTablePanel;
import sanproject.client.baseinfo.pg.RJBaseInfoPGPGTablePanel;
import sanproject.client.com.RJcBaseComboBox;
import sanproject.client.com.RJcButton;
import sanproject.client.com.RJcComboBoxModel;
import sanproject.client.com.RJcGroupCushionPanel;
import sanproject.client.com.RJcHeaderPanel;
import sanproject.client.com.RJcMainTitlePanel;

public class RJBaseInfoPGPanel
extends RJBaseInfoTabPanel
implements RJBaseInfoDef {
    private RJBaseInfoPGPGTablePanel pgTablePanel;
    private RJBaseInfoPGLDEVTablePanel ldevTablePanel;
    private RJcButton detailButton;
    private JComboBox folderCombo;
    private JPanel comboPanel;
    private static final int TABLE_PANEL_WIDTH = 400;
    private static final int FORDER_COUNT = 4;

    public RJBaseInfoPGPanel(RJBaseInfoDataSupplier rJBaseInfoDataSupplier) {
        super(rJBaseInfoDataSupplier);
        this.initInstance();
        this.detailButton.addActionListener(this.pgTablePanel);
        this.pgTablePanel.setDetailButton(this.detailButton);
        this.pgTablePanel.setFolderComboBox(this.folderCombo);
    }

    public boolean showPanel(boolean bl) {
        boolean bl2 = true;
        this.supplier.putLog("[BaseInfo]", "[PG Status]", "showPanel ");
        this.supplier.clearAllCache();
        this.initFolderComboBox((RJBaseInfoItemFolder)this.folderCombo.getSelectedItem());
        return bl2;
    }

    private void initFolderComboBox(RJBaseInfoItemFolder rJBaseInfoItemFolder) {
        ArrayList<RJBaseInfoItemFolder> arrayList = new ArrayList<RJBaseInfoItemFolder>();
        RJBaseInfoItemFolder rJBaseInfoItemFolder2 = null;
        arrayList.add(0, new RJBaseInfoItemFolder(0));
        for (int i = 0; i < 4; ++i) {
            rJBaseInfoItemFolder2 = new RJBaseInfoItemFolder(i + 1);
            arrayList.add(rJBaseInfoItemFolder2);
        }
        RJcComboBoxModel rJcComboBoxModel = new RJcComboBoxModel(arrayList);
        rJcComboBoxModel.setSelectedItem(null);
        this.folderCombo.setModel(rJcComboBoxModel);
        if (rJBaseInfoItemFolder == null || !arrayList.contains(rJBaseInfoItemFolder)) {
            rJBaseInfoItemFolder = (RJBaseInfoItemFolder)this.folderCombo.getItemAt(0);
        }
        this.folderCombo.setSelectedItem(rJBaseInfoItemFolder);
    }

    private void folderComboItemSelected(ItemEvent itemEvent) {
        RJBaseInfoItemFolder rJBaseInfoItemFolder = (RJBaseInfoItemFolder)this.folderCombo.getSelectedItem();
        this.supplier.putLog("[BaseInfo]", "[PG Status]", "folderComboItemSelected [" + rJBaseInfoItemFolder + "] Start");
        this.pgTablePanel.showTable(rJBaseInfoItemFolder, -1);
        this.supplier.putLog("[BaseInfo]", "[PG Status]", "folderComboItemSelected [" + rJBaseInfoItemFolder + "] End");
        this.initFolderComboBox((RJBaseInfoItemFolder)this.folderCombo.getSelectedItem());
        this.ldevTablePanel.reset();
    }

    public boolean chgTab() {
        this.pgTablePanel.reset();
        this.ldevTablePanel.reset();
        this.folderCombo.removeAllItems();
        boolean bl = super.chgTab();
        return bl;
    }

    public void closePanel() {
    }

    public String collectExportData() {
        String string = this.getExportHeader();
        string = string + this.pgTablePanel.collectExportData();
        string = string + this.ldevTablePanel.collectExportData();
        return string;
    }

    protected JComponent createNorthComponent() {
        RJcMainTitlePanel rJcMainTitlePanel = (RJcMainTitlePanel)super.createNorthComponent();
        return rJcMainTitlePanel;
    }

    private JPanel createComboPanel() {
        this.folderCombo = this.createFolderComboBox();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        jPanel.add((Component)this.folderCombo, "Center");
        return jPanel;
    }

    private JComboBox createFolderComboBox() {
        RJcBaseComboBox rJcBaseComboBox = new RJcBaseComboBox();
        rJcBaseComboBox.addItemListener(new RJBaseInfoComboAdapter(this.supplier){

            public void itemStateSelected(ItemEvent itemEvent) {
                RJBaseInfoPGPanel.this.folderComboItemSelected(itemEvent);
            }
        });
        rJcBaseComboBox.setPreferredSize(new Dimension(200, 24));
        rJcBaseComboBox.setMinimumSize(new Dimension(200, 24));
        return rJcBaseComboBox;
    }

    private JPanel createDetailButtonPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        Border border = BorderFactory.createEmptyBorder(2, 0, 2, 0);
        this.detailButton = (RJcButton)this.newButton("BasicInfo/DetailBtn");
        this.detailButton.setEnabled(false);
        JLabel jLabel = new JLabel();
        jPanel.setBorder(border);
        jPanel.setOpaque(false);
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.detailButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 8, 0, 0), 0, 0));
        return jPanel;
    }

    protected JComponent createCenterComponent() {
        JSplitPane jSplitPane = new JSplitPane();
        Border border = BorderFactory.createEmptyBorder(0, 0, 0, 0);
        jSplitPane.setBorder(border);
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setOrientation(1);
        jSplitPane.setDividerSize(4);
        jSplitPane.setDividerLocation(400);
        jSplitPane.setOpaque(false);
        jSplitPane.add((Component)this.createLeftPanel(), "left");
        jSplitPane.add((Component)this.createRightPanel(), "right");
        return jSplitPane;
    }

    private JPanel createLeftPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(8, 4));
        Border border = BorderFactory.createEmptyBorder(4, 8, 4, 8);
        this.ldevTablePanel = new RJBaseInfoPGLDEVTablePanel(this.supplier);
        this.pgTablePanel = new RJBaseInfoPGPGTablePanel(this.ldevTablePanel, this.supplier);
        RJcGroupCushionPanel rJcGroupCushionPanel = new RJcGroupCushionPanel((JComponent)this.pgTablePanel, 1);
        RJcHeaderPanel rJcHeaderPanel = new RJcHeaderPanel("BasicInfo/PGTableTitle");
        rJcHeaderPanel.add(this.createComboPanel());
        rJcHeaderPanel.setAlignmentY(0.5f);
        jPanel.setBorder(border);
        jPanel.setOpaque(false);
        jPanel.add((Component)rJcHeaderPanel, "North");
        jPanel.add((Component)rJcGroupCushionPanel, "Center");
        jPanel.add((Component)this.createDetailButtonPanel(), "South");
        return jPanel;
    }

    private JPanel createRightPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(8, 4));
        RJcHeaderPanel rJcHeaderPanel = new RJcHeaderPanel("BasicInfo/LDEVTableTitle");
        Border border = BorderFactory.createEmptyBorder(4, 8, 4, 8);
        RJcGroupCushionPanel rJcGroupCushionPanel = new RJcGroupCushionPanel((JComponent)this.ldevTablePanel, 1);
        jPanel.setBorder(border);
        jPanel.setOpaque(false);
        jPanel.add((Component)rJcHeaderPanel, "North");
        jPanel.add((Component)rJcGroupCushionPanel, "Center");
        return jPanel;
    }

    public String getWindowName() {
        return "BasicInfo/PG";
    }
}

