/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.hur.dialog.pair;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import sanproject.client.com.RJComFont;
import sanproject.client.hur.RJHurGuide;
import sanproject.client.hur.RJHurMacro;
import sanproject.client.hur.dialog.com.RJHurBasePanel;

public class RJHurHeaderPanel
extends RJHurBasePanel
implements RJHurMacro {
    private GridBagLayout thisLayout = new GridBagLayout();
    private JComponent headerComponent = null;
    private String labelText = null;
    private Dimension thisSize = new Dimension(120, 24);
    private static final int HGAP = 8;
    private static final int VGAP = 4;
    private String key = null;

    public RJHurHeaderPanel() {
        this((String)null);
    }

    public RJHurHeaderPanel(String string) {
        this.setOpaque(true);
        this.setLayout(this.thisLayout);
        this.setHeader(string);
    }

    public void setHeader(JCheckBox jCheckBox) {
        this.headerComponent = jCheckBox;
        String string = this.guide(jCheckBox.getText());
        jCheckBox.setText(string);
        jCheckBox.setOpaque(false);
        this.layoutComponent(string);
    }

    public void setHeader(String string) {
        this.labelText = this.guide(string);
        JLabel jLabel = (JLabel)this.headerComponent;
        if (jLabel == null) {
            jLabel = new JLabel();
            this.headerComponent = jLabel;
        }
        jLabel.setText(this.labelText);
        jLabel.setHorizontalAlignment(2);
        jLabel.setHorizontalTextPosition(2);
        this.layoutComponent(this.labelText);
    }

    private String guide(String string) {
        String string2 = string;
        if (string != null) {
            this.key = string;
            string2 = RJHurGuide.text(string);
            if (this.key.equals(string2)) {
                this.key = null;
            }
        }
        return string2;
    }

    private void layoutComponent(String string) {
        if (string != null) {
            Color color = null;
            Color color2 = null;
            if (this.key != null) {
                color = RJHurGuide.color(this.key);
                color2 = RJHurGuide.color(this.key + "_BGClr");
            }
            if (color == null) {
                color = Color.white;
            }
            if (color2 == null) {
                color2 = RJHurMacro.ESPBGCLR1;
            }
            this.headerComponent.setForeground(color);
            this.setBackground(color2);
            this.headerComponent.setFont(RJComFont.labelFont);
            int n = 120;
            int n2 = this.stringWidth(this.headerComponent, string);
            n = Math.max(n, n2);
            this.add((Component)this.headerComponent, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 17, 2, new Insets(0, 8, 0, 8), 0, 0));
            this.thisSize.width = n + 16;
        }
        this.setPreferredSize(this.thisSize);
        this.setMinimumSize(this.thisSize);
    }

    private int stringWidth(Component component, String string) {
        int n = this.getFontMetrics(component.getFont()).stringWidth(string);
        n = (n + 3) / 4 * 4;
        return n;
    }

    public void setOpaque(boolean bl) {
        super.setOpaque(bl);
        if (this.headerComponent instanceof JLabel) {
            ((JLabel)this.headerComponent).setText(bl ? this.labelText : null);
        }
    }
}

