/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.hur.dialog.pair;

import java.util.ArrayList;
import sanproject.client.hur.RJHurDataControl;
import sanproject.client.hur.dialog.pair.RJHurAbstractInfo;
import sanproject.client.hur.dialog.pair.RJHurAbstractItem;
import sanproject.client.hur.dialog.pair.RJHurItemRCU;

public class RJHurItemVOL
extends RJHurAbstractItem {
    protected RJHurAbstractInfo info;
    protected RJHurDataControl controller;
    protected int modelID = -1;
    protected int ldkc = -1;
    protected int cu = -1;
    protected int ldev = -1;
    protected String portName = null;
    protected int port = -1;
    protected ArrayList portList = null;
    protected int hostGroup = -1;
    protected int lun = -1;
    protected int cuMax;
    protected int ldevMax = 256;
    protected int portMax;
    protected int hostGroupMax;
    protected int lunMax;
    protected int ldkcMax;

    public RJHurItemVOL(RJHurAbstractInfo rJHurAbstractInfo) {
        this.info = rJHurAbstractInfo;
        this.controller = rJHurAbstractInfo.getController();
    }

    public void setModelID(int n) {
        if (this.modelID != n) {
            this.modelID = n;
            this.cuMax = RJHurDataControl.getMaxCUNumber(n) + 1;
            String[] stringArray = RJHurDataControl.getPortList(n);
            this.portMax = stringArray.length;
            this.portList = new ArrayList();
            for (int i = 0; i < this.portMax; ++i) {
                this.portList.add(stringArray[i]);
            }
            this.hostGroupMax = RJHurDataControl.getMaxHOSTGNumber(n) + 1;
            this.lunMax = RJHurDataControl.getMaxLUNNumber(n) + 1;
            this.ldkcMax = RJHurDataControl.getMaxLDKCNumber(n) + 1;
        }
    }

    public int getVol() {
        return (this.ldkc << 16) + (this.cu << 8) + this.ldev;
    }

    public void setVol(int n) {
        this.ldkc = (n & 0xFF0000) >>> 16;
        this.cu = (n & 0xFF00) >>> 8;
        this.ldev = n % this.ldevMax;
    }

    public int getLdkc() {
        return this.ldkc;
    }

    public void setLdkc(int n) {
        this.ldkc = n;
    }

    public int getCu() {
        return this.cu;
    }

    public void setCu(int n) {
        this.cu = n;
    }

    public int getLdev() {
        return this.ldev;
    }

    public void setLdev(int n) {
        this.ldev = n;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
        if (n >= 0) {
            this.portName = (String)this.portList.get(n);
        }
    }

    public String getPortName() {
        return this.portName;
    }

    public void setPortName(String string) {
        this.portName = string;
        this.port = this.portList.indexOf(string);
    }

    public int getHostGroup() {
        return this.hostGroup;
    }

    public void setHostGroup(int n) {
        this.hostGroup = n;
    }

    public int getLun() {
        return this.lun;
    }

    public void setLun(int n) {
        this.lun = n;
    }

    public void add(int n, RJHurItemRCU rJHurItemRCU) {
        if (this.info.isOpen()) {
            int n2 = this.lun + n;
            this.lun = n2 % this.lunMax;
            int n3 = this.hostGroup + n2 / this.lunMax;
            this.hostGroup = n3 % this.hostGroupMax;
            int n4 = this.port + n3 / this.hostGroupMax;
            this.setPort(n4 % this.portMax);
        } else {
            int n5 = this.ldev + n;
            this.ldev = n5 % this.ldevMax;
            int n6 = this.cu + n5 / this.ldevMax;
            this.setCu(n6 % this.cuMax);
            this.ldkc = rJHurItemRCU.getPairLDKC();
        }
    }

    public int sub(RJHurItemVOL rJHurItemVOL) {
        int n = 0;
        if (this.info.isOpen()) {
            n = (this.port - rJHurItemVOL.getPort() + this.portMax) % this.portMax;
            n = n * this.hostGroupMax + (this.hostGroup - rJHurItemVOL.getHostGroup());
            if ((n = n * this.lunMax + (this.lun - rJHurItemVOL.getLun())) < 0) {
                n += this.portMax * this.hostGroupMax * this.lunMax;
            }
        } else {
            int n2;
            int n3 = (this.ldkc - rJHurItemVOL.getLdkc() + this.ldkcMax) % this.ldkcMax;
            n = n3 * this.cuMax * this.ldevMax + (n2 = (this.cu - rJHurItemVOL.getCu() + this.cuMax) % this.cuMax) * this.ldevMax + (this.ldev - rJHurItemVOL.getLdev());
            if (n < 0) {
                n += this.ldkcMax * this.cuMax * this.ldevMax;
            }
        }
        return n;
    }

    public String toString() {
        String string = null;
        string = this.info.isOpen() ? this.toPortString() : this.toLDEVString();
        return string;
    }

    public String toPortString() {
        String string = this.portName + " - " + this.toHexString(this.hostGroup, 2) + " - " + this.controller.getLUNDisplayString(this.lun);
        return string;
    }

    public String toLDEVString() {
        String string = this.toHexString(this.ldkc, 2) + ":" + this.toHexString(this.cu, 2) + ":" + this.toHexString(this.ldev, 2);
        return string;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof RJHurItemVOL) {
            RJHurItemVOL rJHurItemVOL = (RJHurItemVOL)object;
            bl = this.info.isOpen() ? this.port == rJHurItemVOL.getPort() && this.hostGroup == rJHurItemVOL.getHostGroup() && this.lun == rJHurItemVOL.getLun() : this.ldkc == rJHurItemVOL.getLdkc() && this.cu == rJHurItemVOL.getCu() && this.ldev == rJHurItemVOL.getLdev();
        }
        return bl;
    }

    public int compareTo(Object object) {
        int n = 1;
        if (object instanceof RJHurItemVOL) {
            RJHurItemVOL rJHurItemVOL = (RJHurItemVOL)object;
            if (this.info.isOpen()) {
                n = this.port - rJHurItemVOL.getPort();
                if (n == 0 && (n = this.hostGroup - rJHurItemVOL.getHostGroup()) == 0) {
                    n = this.lun - rJHurItemVOL.getLun();
                }
            } else {
                n = this.ldkc - rJHurItemVOL.getLdkc();
                if (n == 0 && (n = this.cu - rJHurItemVOL.getCu()) == 0) {
                    n = this.ldev - rJHurItemVOL.getLdev();
                }
            }
        }
        return n;
    }
}

