/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.ldevguard.dctl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import sanproject.client.com.RJComUty;
import sanproject.client.data.RJDataException;
import sanproject.client.data.RJDataLDEVPart;
import sanproject.client.ldevguard.dctl.RJDGDDataControl;
import sanproject.client.ldevguard.dctl.RJDGDException;
import sanproject.client.ldevguard.gui.logging.Logger;
import sanproject.client.openldevguard.dctl.com.ManageReadData;
import sanproject.common.Robj_interface_RJSetGettingParamLDEV;
import sanproject.common.Robj_interface_RJiLDEVIndex;
import sanproject.common.Robj_interface_RJiLDEVInfoDetail;
import sanproject.serversx.data.RJiCUIndex;
import sanproject.serverux.dataimpl.RJSetGettingParamLDEV;
import sanproject.serverux.dataimpl.RJiLDEVInfoDetail;

public class ManageLdevInfo
extends ManageReadData {
    private static final GetDataCuInfo NULL_DATA_CUINFO;
    private static final GetDataLdevInfo NULL_DATA_LDEVINFO;
    private final GetDataCuInfo originalCompareData;
    private final RJDGDDataControl vrmDataControl;

    public ManageLdevInfo(RJDGDDataControl rJDGDDataControl) {
        super(6, "LdevInfo", rJDGDDataControl, COMP_LDKC_CU, (Object)NULL_DATA_CUINFO);
        this.vrmDataControl = rJDGDDataControl;
        this.originalCompareData = new GetDataCuInfo(-1, -1, null);
    }

    private boolean checkVrmVolume(Robj_interface_RJiLDEVInfoDetail robj_interface_RJiLDEVInfoDetail) {
        boolean bl = false;
        if (!(robj_interface_RJiLDEVInfoDetail == null || robj_interface_RJiLDEVInfoDetail.isOpenVolume() || robj_interface_RJiLDEVInfoDetail.isBJNLVolume() || robj_interface_RJiLDEVInfoDetail.isBSystemDisk())) {
            int n = robj_interface_RJiLDEVInfoDetail.getIEmulationType();
            String string = this.getChangeTbl().getEmulationTypeName(n);
            if (!string.equals("3390-V") && !robj_interface_RJiLDEVInfoDetail.isBPoolVol()) {
                bl = true;
            }
        }
        return bl;
    }

    private Robj_interface_RJiLDEVInfoDetail[] getLdevInfoDetail() throws Exception {
        Robj_interface_RJiLDEVIndex[] robj_interface_RJiLDEVIndexArray = this.makeLDEVIndexArray();
        RJSetGettingParamLDEV rJSetGettingParamLDEV = this.makeParamData();
        RJDataLDEVPart rJDataLDEVPart = this.controller.getLDEVPart();
        StringBuffer stringBuffer = new StringBuffer("        The initialization of LDEV detail information begins. ");
        stringBuffer.append("<Num = ").append(robj_interface_RJiLDEVIndexArray.length).append(">");
        Logger.put(Level.FINE, this.logName, stringBuffer.toString());
        long l = 0L;
        long l2 = 0L;
        Object[] objectArray = null;
        try {
            l = System.currentTimeMillis();
            objectArray = robj_interface_RJiLDEVIndexArray.length > 0 ? rJDataLDEVPart.getLDEVInfoDetail(robj_interface_RJiLDEVIndexArray, (Robj_interface_RJSetGettingParamLDEV)rJSetGettingParamLDEV) : new Robj_interface_RJiLDEVInfoDetail[]{};
            l2 = System.currentTimeMillis();
        }
        catch (RJDataException rJDataException) {
            Logger.put(Level.WARNING, this.logName, "RJDataException : getLDEVInfoDetail()");
            throw this.makeException(rJDataException.getErrPart(), rJDataException.getErrCode());
        }
        Arrays.sort(objectArray);
        StringBuffer stringBuffer2 = new StringBuffer("        The initialization of LDEV detail information ends. ");
        stringBuffer2.append("<Time = ").append(l2 - l).append(" ms> ");
        stringBuffer2.append("<Num = ").append(objectArray.length).append(">");
        Logger.put(Level.FINE, this.logName, stringBuffer2.toString());
        return objectArray;
    }

    private GetDataLdevInfo makeGetDataLdevInfo(Robj_interface_RJiLDEVInfoDetail robj_interface_RJiLDEVInfoDetail) {
        GetDataLdevInfo getDataLdevInfo;
        if (this.checkVrmVolume(robj_interface_RJiLDEVInfoDetail)) {
            getDataLdevInfo = new GetDataLdevInfo();
            getDataLdevInfo.ldevInfoDetail = robj_interface_RJiLDEVInfoDetail;
            getDataLdevInfo.vrmVolume = true;
        } else {
            getDataLdevInfo = NULL_DATA_LDEVINFO;
        }
        return getDataLdevInfo;
    }

    private Robj_interface_RJiLDEVIndex[] makeLDEVIndexArray() {
        ArrayList arrayList = this.vrmDataControl.getEquipLDEVIndex();
        return arrayList.toArray(new Robj_interface_RJiLDEVIndex[0]);
    }

    private RJSetGettingParamLDEV makeParamData() {
        RJSetGettingParamLDEV rJSetGettingParamLDEV = new RJSetGettingParamLDEV();
        rJSetGettingParamLDEV.setBBasic(true);
        rJSetGettingParamLDEV.setBSize(true);
        return rJSetGettingParamLDEV;
    }

    protected Object[] getData() throws Exception {
        ArrayList<GetDataCuInfo> arrayList = new ArrayList<GetDataCuInfo>();
        GetDataCuInfo getDataCuInfo = NULL_DATA_CUINFO;
        Robj_interface_RJiLDEVInfoDetail[] robj_interface_RJiLDEVInfoDetailArray = this.getLdevInfoDetail();
        for (int i = 0; i < robj_interface_RJiLDEVInfoDetailArray.length; ++i) {
            Object object;
            short s = robj_interface_RJiLDEVInfoDetailArray[i].getSLDKC();
            short s2 = robj_interface_RJiLDEVInfoDetailArray[i].getSCU();
            short s3 = robj_interface_RJiLDEVInfoDetailArray[i].getSLDEV();
            if (getDataCuInfo.getSLDKC() != s || getDataCuInfo.getSCU() != s2) {
                object = new GetDataLdevInfo[256];
                Arrays.fill(object, NULL_DATA_LDEVINFO);
                getDataCuInfo = new GetDataCuInfo(s, s2, (GetDataLdevInfo[])object);
                arrayList.add(getDataCuInfo);
            }
            ((GetDataCuInfo)getDataCuInfo).ldevInfo[s3] = object = this.makeGetDataLdevInfo(robj_interface_RJiLDEVInfoDetailArray[i]);
        }
        return arrayList.toArray();
    }

    protected boolean isSupport() {
        return true;
    }

    protected Exception makeException(int n, int n2) {
        return new RJDGDException(n, n2);
    }

    protected Object makeOriginalCompareData(int n, int n2, int n3) {
        this.originalCompareData.setCUIndex((short)n, (short)n2);
        return this.originalCompareData;
    }

    protected Object makeOriginalData(Object object) {
        return object;
    }

    public Robj_interface_RJiLDEVInfoDetail getLdevInfoDetail(int n, int n2, int n3) {
        GetDataCuInfo getDataCuInfo = (GetDataCuInfo)((Object)this.getOriginalDataObject(n, n2, n3));
        return getDataCuInfo.ldevInfo[n3].ldevInfoDetail;
    }

    public String getLdevString(int n, int n2, int n3) {
        return RJComUty.getLDEVDisplayName(this.getLdevInfoDetail(n, n2, n3));
    }

    public long getCapacity(int n, int n2, int n3) {
        return this.getLdevInfoDetail(n, n2, n3).getLLDEVSize();
    }

    public String getEmulationType(int n, int n2, int n3) {
        int n4 = this.getLdevInfoDetail(n, n2, n3).getIEmulationType();
        return this.getChangeTbl().getEmulationTypeName(n4);
    }

    public boolean isExternal(int n, int n2, int n3) {
        return this.getLdevInfoDetail(n, n2, n3).isExternalVolume();
    }

    public boolean isVrmVolume(int n, int n2, int n3) {
        GetDataCuInfo getDataCuInfo = (GetDataCuInfo)((Object)this.getOriginalDataObject(n, n2, n3));
        return getDataCuInfo.ldevInfo[n3].vrmVolume;
    }

    static {
        NULL_DATA_LDEVINFO = new GetDataLdevInfo();
        NULL_DATA_LDEVINFO.ldevInfoDetail = (Robj_interface_RJiLDEVInfoDetail)new RJiLDEVInfoDetail();
        NULL_DATA_LDEVINFO.ldevInfoDetail.setLDEVIndex((short)-1, (short)-1, (short)-1);
        NULL_DATA_LDEVINFO.vrmVolume = false;
        Object[] objectArray = new GetDataLdevInfo[256];
        Arrays.fill(objectArray, NULL_DATA_LDEVINFO);
        NULL_DATA_CUINFO = new GetDataCuInfo(-1, -1, (GetDataLdevInfo[])objectArray);
    }

    private static class GetDataLdevInfo {
        private boolean vrmVolume;
        private Robj_interface_RJiLDEVInfoDetail ldevInfoDetail;

        private GetDataLdevInfo() {
        }
    }

    private static class GetDataCuInfo
    extends RJiCUIndex {
        private GetDataLdevInfo[] ldevInfo;

        public GetDataCuInfo(int n, int n2, GetDataLdevInfo[] getDataLdevInfoArray) {
            this.setCUIndex((short)n, (short)n2);
            this.ldevInfo = getDataLdevInfoArray;
        }
    }
}

