/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.monitor.performance.physical;

import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.event.ListSelectionEvent;
import sanproject.client.com.RJcElement;
import sanproject.client.com.RJcGuide;
import sanproject.client.com.abs.RJaDataModel;
import sanproject.client.com.abs.RJaDataModelEntry;
import sanproject.client.monitor.com.RJHihChartData;
import sanproject.client.monitor.com.RJHihChartDataCollection;
import sanproject.client.monitor.com.RJHihChartPanel;
import sanproject.client.monitor.com.RJHihDataSupplier;
import sanproject.client.monitor.com.RJHihElement;
import sanproject.client.monitor.com.RJHihMonitoringInfo;
import sanproject.client.monitor.com.RJHihTablePanel;
import sanproject.client.monitor.com.RJHihTimePair;
import sanproject.client.monitor.performance.RJHihPerfChartPanel;
import sanproject.client.monitor.performance.RJHihPerfTablePanel;
import sanproject.client.monitor.performance.physical.RJHihPhChartPanel;
import sanproject.client.monitor.performance.physical.RJHihPhClprElement;
import sanproject.client.monitor.performance.physical.RJHihPhysicalTableModel;
import sanproject.serverux.arg.monitor.HIHsmPhysicalCacheUseRateArgInfo;
import sanproject.serverux.arg.monitor.HIHsmWritePendingRateArgInfo;
import sanproject.serverux.arg.monitor.MonArg;
import sanproject.serverux.data.HIHsmPhysicalCacheUseRate;
import sanproject.serverux.data.HIHsmWritePendingRate;
import sanproject.serverux.data.MonitorInfoCollection;

public class RJHihPhClprTableModel
extends RJHihPhysicalTableModel {
    public RJHihPhClprTableModel(RJHihDataSupplier rJHihDataSupplier) {
        super(rJHihDataSupplier);
    }

    public void defineTable(int n) {
        this.modelId = n;
        this.setHeaderMode(2);
        this.addColumnInfo("ELM", RJcGuide.text("PerformanceManagement/CacheListClprNoLbl"), 80, new RJHihElement(), false, 0);
        this.setVisibleIcon("ELM", false);
        this.columnNames.setSearchKey("ELM");
        if (n == 0) {
            this.setAutoResizeMode(0);
            this.addColumnInfo("AVE", RJcGuide.text("PerformanceManagement/CacheListUsageAverageLbl"), 80, new String(""), false, 4);
            this.setSpecialHeader("AVE", RJcGuide.text("PerformanceManagement/CacheListUsageLbl"), 2);
            this.addColumnInfo("MAX", RJcGuide.text("PerformanceManagement/CacheListUsageMaxLbl"), 80, new String(""), false, 4);
        } else {
            this.setAutoResizeMode(2);
            this.columnNames.addKey("AVE");
            this.columnNames.addKey("MAX");
        }
        this.addColumnInfo("PAVE", RJcGuide.text("PerformanceManagement/CacheListPendingAverageLbl"), 80, new String(""), false, 4);
        this.setSpecialHeader("PAVE", RJcGuide.text("PerformanceManagement/CacheListPendingRateLbl"), 2);
        this.addColumnInfo("PMAX", RJcGuide.text("PerformanceManagement/CacheListPendingMaxLbl"), 80, new String(""), false, 4);
    }

    public void initModel(RJHihChartPanel rJHihChartPanel) {
        RJHihMonitoringInfo rJHihMonitoringInfo = this.supplier.getMonitoringInfo();
        int n = 4;
        if (rJHihMonitoringInfo.getRangeKind() == 0) {
            n = 2;
        }
        ((RJHihPhChartPanel)rJHihChartPanel).adjustComponent(n);
    }

    public void addRow(RJcElement rJcElement) {
        RJaDataModelEntry rJaDataModelEntry = super.setElement(rJcElement);
        rJaDataModelEntry = this.availEntry(rJaDataModelEntry);
        rJaDataModelEntry.put("SEL", ((RJHihPhClprElement)rJcElement).getSelection());
        rJaDataModelEntry.put("ELM", rJcElement);
        rJaDataModelEntry.put("NAME", ((RJHihPhClprElement)rJcElement).getClprName());
        rJaDataModelEntry.put("AVE", ((RJHihPhClprElement)rJcElement).getRateAverage());
        rJaDataModelEntry.put("MAX", ((RJHihPhClprElement)rJcElement).getRateMaximum());
        rJaDataModelEntry.put("PAVE", ((RJHihPhClprElement)rJcElement).getWritePendingAverage());
        rJaDataModelEntry.put("PMAX", ((RJHihPhClprElement)rJcElement).getWritePendingMaximum());
    }

    public Object getValueAt(int n, Object object) {
        Integer n2;
        Object object2 = super.getValueAt(n, object);
        if (object.equals("AVE")) {
            n2 = (Integer)((RJaDataModelEntry)this.rows.get(n)).get("MAX");
            if (object2 != null && (Integer)object2 == 0 && n2 != null && n2 > 0) {
                object2 = "+" + ((Integer)object2).toString();
            }
        }
        if (object.equals("PAVE")) {
            n2 = (Integer)((RJaDataModelEntry)this.rows.get(n)).get("PMAX");
            if (object2 != null && (Integer)object2 == 0 && n2 != null && n2 > 0) {
                object2 = "+" + ((Integer)object2).toString();
            }
        }
        return object2;
    }

    protected void setSortKey(Vector vector, Object object) {
        if (object.equals("AVE")) {
            vector.add(new RJaDataModel.SortKey("MAX"));
        }
        if (object.equals("PAVE")) {
            vector.add(new RJaDataModel.SortKey("PMAX"));
        }
        vector.add(new RJaDataModel.SortKey("ELM"));
    }

    public void collectChartData(RJHihChartDataCollection rJHihChartDataCollection) {
        RJHihMonitoringInfo rJHihMonitoringInfo = this.supplier.getMonitoringInfo();
        RJHihTimePair rJHihTimePair = rJHihMonitoringInfo.getMonitoringTime();
        int n = this.getChartCount();
        if (rJHihTimePair != null && n > 0) {
            Object object = null;
            object = rJHihMonitoringInfo.getRangeKind() == 0 ? new HIHsmPhysicalCacheUseRateArgInfo(1, rJHihTimePair.getFromTime(), rJHihTimePair.getToTime(), n) : new HIHsmWritePendingRateArgInfo(1, rJHihTimePair.getFromTime(), rJHihTimePair.getToTime(), n);
            RJHihChartData rJHihChartData = new RJHihChartData();
            this.setArgument((MonArg)object, rJHihChartData);
            MonitorInfoCollection monitorInfoCollection = (MonitorInfoCollection)this.supplier.getMonitorInfo((MonArg)object);
            RJHihChartData rJHihChartData2 = new RJHihChartData();
            rJHihChartData2.setDrawTerm(this.supplier.getMonitoringInfo().getMonitoringTime());
            rJHihChartData2.setLabels(rJHihChartData.getLabels());
            RJHihChartData rJHihChartData3 = new RJHihChartData();
            rJHihChartData3.setDrawTerm(this.supplier.getMonitoringInfo().getMonitoringTime());
            rJHihChartData3.setLabels(rJHihChartData.getLabels());
            for (int i = 0; i < monitorInfoCollection.size(); ++i) {
                HIHsmWritePendingRate hIHsmWritePendingRate = (HIHsmWritePendingRate)monitorInfoCollection.get(i);
                rJHihChartData2.addChartValues(hIHsmWritePendingRate.getUseRate());
                if (!(hIHsmWritePendingRate instanceof HIHsmPhysicalCacheUseRate)) continue;
                rJHihChartData3.addChartValues(((HIHsmPhysicalCacheUseRate)hIHsmWritePendingRate).getCacheUseRate());
            }
            rJHihChartData2.completeChartValues();
            rJHihChartData3.completeChartValues();
            rJHihChartDataCollection.put("PerformanceManagement/DetailComboItemWritePend", rJHihChartData2);
            rJHihChartDataCollection.put("PerformanceManagement/DetailComboItemCacheUse", rJHihChartData3);
        }
    }

    protected void addArgument(MonArg monArg, RJcElement rJcElement, int n) {
        RJHihPhClprElement rJHihPhClprElement = (RJHihPhClprElement)rJcElement;
        ((HIHsmWritePendingRateArgInfo)monArg).setCLPR(n, rJHihPhClprElement.getClprNo());
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.enableComponents();
    }

    public void completedTable() {
        super.completedTable();
        this.enableComponents();
    }

    private void enableComponents() {
        JComboBox jComboBox = (JComboBox)((RJHihTablePanel)this.manager).getComponent("PerformanceManagement/DetailComboBox");
        JComboBox jComboBox2 = (JComboBox)((RJHihTablePanel)this.manager).getComponent("PerformanceManagement/AxisYComboBox");
        jComboBox.setEnabled(false);
        jComboBox2.setEnabled(false);
        RJHihMonitoringInfo rJHihMonitoringInfo = this.supplier.getMonitoringInfo();
        RJHihTimePair rJHihTimePair = rJHihMonitoringInfo.getMonitoringTime();
        if (rJHihTimePair != null) {
            int n = this.getChartCount();
            int[] nArray = this.getSelectedRows();
            RJHihPerfChartPanel rJHihPerfChartPanel = (RJHihPerfChartPanel)((RJHihPerfTablePanel)this.manager).getChart();
            rJHihPerfChartPanel.setSelectedRowCount(nArray.length);
            if (nArray.length > 0 || n > 0) {
                jComboBox.setEnabled(true);
            }
        }
    }
}

