/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.pool;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import sanproject.client.com.RJCom;
import sanproject.client.com.RJcConst;
import sanproject.client.com.RJcElement;
import sanproject.client.com.RJcGuide;
import sanproject.client.com.RJcTablePanel;
import sanproject.client.com.abs.RJaDataModelEntry;
import sanproject.client.com.abs.RJaMenuItemActionListener;
import sanproject.client.com.abs.RJaPopupMenuSTD;
import sanproject.client.com.abs.RJaTableDataModel;
import sanproject.client.pool.RJPoolApplyData;
import sanproject.client.pool.RJPoolApplyItem;
import sanproject.client.pool.RJPoolDataSupplier;
import sanproject.client.pool.RJPoolFreeTablePanel;
import sanproject.client.pool.RJPoolGuideDef;
import sanproject.client.pool.RJPoolLdevElement;
import sanproject.client.pool.RJPoolLdevTableModel;
import sanproject.client.pool.RJPoolPoolElement;
import sanproject.client.pool.RJPoolPoolLdevTableModel;
import sanproject.client.pool.RJPoolTreePanel;

public class RJPoolPoolTablePanel
extends RJcTablePanel
implements RJPoolGuideDef,
RJaMenuItemActionListener {
    private static final int MAX_VOL = 1024;
    protected RJPoolDataSupplier supplier;
    private JLabel totalCapaField = new JLabel();
    private JLabel usedVolField = new JLabel();
    private JLabel remainVolField = new JLabel();
    private int remainVolCount = -1;
    private RJPoolTreePanel treePanel = null;
    private RJPoolFreeTablePanel freeTablePanel = null;
    private RJPoolPoolElement poolElement = null;
    private static final String[] menuItems = new String[]{RJcGuide.text("Pool/PopupDelVol")};
    private RJaPopupMenuSTD menu = null;

    public RJPoolPoolTablePanel() {
        this((RJPoolDataSupplier)null);
    }

    public RJPoolPoolTablePanel(RJPoolDataSupplier rJPoolDataSupplier) {
        this.supplier = rJPoolDataSupplier;
        this.createTable(null);
        this.add((Component)this.createSouthPanel(), "South");
    }

    public void createTable(RJaTableDataModel rJaTableDataModel) {
        this.createTable(null, rJaTableDataModel);
    }

    public void createTable(RJPoolPoolElement rJPoolPoolElement, RJaTableDataModel rJaTableDataModel) {
        this.poolElement = rJPoolPoolElement;
        if (rJaTableDataModel == null) {
            rJaTableDataModel = new RJPoolPoolLdevTableModel(this.supplier);
        }
        super.createTable(rJaTableDataModel);
        this.setCountLabel();
    }

    public void addPoolVolume(RJPoolApplyItem rJPoolApplyItem) {
        Object object;
        rJPoolApplyItem.setPoolId(this.poolElement.getPoolId());
        rJPoolApplyItem.setThreshold(this.poolElement.getThreshold());
        rJPoolApplyItem.setKind(this.poolElement.getPoolKind());
        rJPoolApplyItem.setGrainSize(this.poolElement.getGrainSize());
        ArrayList arrayList = rJPoolApplyItem.getPoolVolList();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object = (RJPoolLdevElement)iterator.next();
            ((RJPoolLdevElement)object).setPoolId(this.poolElement.getPoolId());
            this.poolElement.addCapacity(((RJPoolLdevElement)object).getCapacity());
            ((RJPoolLdevTableModel)this.model).addRow((RJcElement)object);
            this.poolElement.incrementPoolVolCount();
            this.poolElement.setClprNo(((RJPoolLdevElement)object).getClprNo());
            this.poolElement.setClprName(((RJPoolLdevElement)object).getClprName());
            if (((RJPoolLdevElement)object).isExternal()) {
                this.poolElement.incrementExtVOLCount();
            } else {
                this.poolElement.incrementIntVOLCount();
            }
            if (((RJPoolLdevElement)object).isCacheMode()) {
                this.poolElement.incrementCacheEnableCount();
            } else {
                this.poolElement.incrementCacheDisableCount();
            }
            switch (((RJPoolLdevElement)object).getHDDType()) {
                case 0: {
                    this.poolElement.incrementIntFCDriveCount();
                    break;
                }
                case 5: {
                    this.poolElement.incrementIntSSDDriveCount();
                    break;
                }
                default: {
                    this.poolElement.incrementIntSATADriveCount();
                }
            }
            if (((RJPoolLdevElement)object).isEncryption()) {
                this.poolElement.incrementEncEnableCount();
            } else {
                this.poolElement.incrementEncDisableCount();
            }
            this.poolElement.setRaidLevel(((RJPoolLdevElement)object).getRaidLevel());
        }
        ((RJPoolLdevTableModel)this.model).sortLdev();
        object = this.supplier.getApplyData();
        ((RJPoolApplyData)object).addPoolVol(rJPoolApplyItem);
        this.setCountLabel();
        this.treePanel.resetSelectionPath();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
    }

    public void completedTable() {
        super.completedTable();
        this.setCountLabel();
    }

    private void setCountLabel() {
        this.usedVolField.setText(null);
        this.remainVolField.setText(null);
        this.totalCapaField.setText(null);
        this.remainVolCount = -1;
        if (this.poolElement != null) {
            int n = this.model.getRowCount();
            this.totalCapaField.setText(this.poolElement.toCapacityString());
            this.usedVolField.setText(String.valueOf(n));
            this.remainVolCount = 1024 - n;
            this.remainVolField.setText(String.valueOf(this.remainVolCount));
        }
        if (this.freeTablePanel != null) {
            this.freeTablePanel.setAddButtonEnabled();
        }
    }

    public void showPopupMenu(MouseEvent mouseEvent, Object object) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (jPopupMenu.isPopupTrigger(mouseEvent) && this.isAddActionEnable()) {
            JTable jTable = (JTable)mouseEvent.getSource();
            int n = jTable.rowAtPoint(mouseEvent.getPoint());
            int[] nArray = jTable.getSelectedRows();
            Arrays.sort(nArray);
            int n2 = Arrays.binarySearch(nArray, n);
            if (n2 >= 0) {
                this.menu = new RJaPopupMenuSTD(this, menuItems);
                this.menu.show(jTable, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private boolean isAddActionEnable() {
        boolean bl = true;
        int[] nArray = this.model.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            RJaDataModelEntry rJaDataModelEntry = this.model.getRow(nArray[i]);
            RJPoolLdevElement rJPoolLdevElement = (RJPoolLdevElement)rJaDataModelEntry.get("LDEV");
            if (rJPoolLdevElement.getModify().isModify() && rJPoolLdevElement.getPoolId() >= 0) continue;
            bl = false;
            break;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void menuItemActionPerformed(ActionEvent actionEvent, int n) {
        try {
            RJCom.waitCursor(this);
            RJPoolApplyItem rJPoolApplyItem = new RJPoolApplyItem();
            rJPoolApplyItem.setPoolId(this.poolElement.getPoolId());
            int[] nArray = this.model.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                RJaDataModelEntry rJaDataModelEntry = this.model.getRow(nArray[i]);
                RJPoolLdevElement rJPoolLdevElement = (RJPoolLdevElement)rJaDataModelEntry.get("LDEV");
                rJPoolLdevElement.setPoolId(-1);
                this.poolElement.addCapacity(-rJPoolLdevElement.getCapacity().longValue());
                this.poolElement.decrementPoolVolCount();
                rJPoolApplyItem.addPoolVol(rJPoolLdevElement);
                if (rJPoolLdevElement.isExternal()) {
                    this.poolElement.decrementExtVOLCount();
                } else {
                    this.poolElement.decrementIntVOLCount();
                }
                if (rJPoolLdevElement.isCacheMode()) {
                    this.poolElement.decrementCacheEnableCount();
                } else {
                    this.poolElement.decrementCacheDisableCount();
                }
                switch (rJPoolLdevElement.getHDDType()) {
                    case 0: {
                        this.poolElement.decrementIntFCDriveCount();
                        break;
                    }
                    case 5: {
                        this.poolElement.decrementIntSSDDriveCount();
                        break;
                    }
                    default: {
                        this.poolElement.decrementIntSATADriveCount();
                    }
                }
                if (rJPoolLdevElement.isEncryption()) {
                    this.poolElement.decrementEncEnableCount();
                    continue;
                }
                this.poolElement.decrementEncDisableCount();
            }
            this.model.remove();
            ((RJPoolLdevTableModel)this.model).sortLdev();
            RJPoolApplyData rJPoolApplyData = this.supplier.getApplyData();
            rJPoolApplyData.deletePoolVol(rJPoolApplyItem);
            this.freeTablePanel.addFreeVolume();
            this.setCountLabel();
            this.treePanel.resetSelectionPath();
        }
        finally {
            RJCom.defCursor(this);
        }
    }

    public RJPoolPoolElement getPoolElement() {
        return this.poolElement;
    }

    public int getRremainVolCount() {
        return this.remainVolCount;
    }

    public void setTreePanel(RJPoolTreePanel rJPoolTreePanel) {
        this.treePanel = rJPoolTreePanel;
    }

    public void setFreeTablePanel(RJPoolFreeTablePanel rJPoolFreeTablePanel) {
        this.freeTablePanel = rJPoolFreeTablePanel;
    }

    private JPanel createSouthPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setPreferredSize(new Dimension(200, 16));
        jPanel.setMinimumSize(new Dimension(200, 16));
        jPanel.setBackground(RJcGuide.color("Pool/PoolTableMarginBgClr"));
        JLabel jLabel = new JLabel(RJcGuide.text("Pool/PoolTableTotalCapaLbl"));
        jLabel.setForeground(RJcGuide.color("Pool/PoolTableTotalCapaLbl"));
        jLabel.setHorizontalAlignment(4);
        jLabel.setFont(RJcConst.boldFont);
        this.totalCapaField.setForeground(RJcGuide.color("Pool/PoolTableTotalCapaField"));
        this.totalCapaField.setPreferredSize(new Dimension(80, 14));
        this.totalCapaField.setMinimumSize(new Dimension(80, 14));
        this.totalCapaField.setFont(RJcConst.boldFont);
        this.totalCapaField.setHorizontalAlignment(0);
        JLabel jLabel2 = new JLabel(RJcGuide.text("Pool/PoolTableUsedVolLbl"));
        jLabel2.setForeground(RJcGuide.color("Pool/PoolTableUsedVolLbl"));
        jLabel2.setHorizontalAlignment(4);
        jLabel2.setFont(RJcConst.boldFont);
        this.usedVolField.setForeground(RJcGuide.color("Pool/PoolTableUsedVolField"));
        this.usedVolField.setPreferredSize(new Dimension(32, 14));
        this.usedVolField.setMinimumSize(new Dimension(32, 14));
        this.usedVolField.setFont(RJcConst.boldFont);
        this.usedVolField.setHorizontalAlignment(0);
        JLabel jLabel3 = new JLabel(RJcGuide.text("Pool/PoolTableRemaningVolLbl"));
        jLabel3.setForeground(RJcGuide.color("Pool/PoolTableRemaningVolLbl"));
        jLabel3.setHorizontalAlignment(4);
        jLabel3.setFont(RJcConst.boldFont);
        this.remainVolField.setForeground(RJcGuide.color("Pool/PoolTableRemaningVolField"));
        this.remainVolField.setPreferredSize(new Dimension(32, 14));
        this.remainVolField.setMinimumSize(new Dimension(32, 14));
        this.remainVolField.setFont(RJcConst.boldFont);
        this.remainVolField.setHorizontalAlignment(0);
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 8, 0, 0), 0, 0));
        jPanel.add((Component)this.totalCapaField, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(0, 2, 0, 8), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.usedVolField, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 2, 0, 8), 0, 0));
        jPanel.add((Component)jLabel3, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.remainVolField, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 2, 0, 8), 0, 0));
        return jPanel;
    }
}

