/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.ppkey;

import java.util.ArrayList;
import sanproject.client.com.RJComUty;
import sanproject.client.ppkey.RJPPKeyMacro;
import sanproject.client.ppkey.RJPPKeyPanel;
import sanproject.serverux.dataimpl.PPKget1PPInfo;

class RJPPKeyInfoClass
implements RJPPKeyMacro {
    public String m_strPPName;
    public String m_strPPID;
    public String m_strKeyKind;
    public String m_strStatus;
    public int m_nInstallStatus;
    public int m_nAction;
    public String m_strPermitVolume;
    public String m_strTerm;
    public long m_lPermitVol;
    public String m_strRetPermVol = new String("");
    public String m_strRetUserVol = new String("");
    public int m_nUpdate;
    public long m_lSerialNumber;
    public int m_nAccountType;
    public long m_nUsedCapa;
    public ArrayList counterList;
    public ArrayList licenseList;
    public int keyKind;
    public long lMeterVol;

    RJPPKeyInfoClass(PPKget1PPInfo pPKget1PPInfo) {
        this.m_strPPName = pPKget1PPInfo.strPPName;
        this.m_strPPID = pPKget1PPInfo.strPPID;
        this.m_strKeyKind = pPKget1PPInfo.strLicenseType;
        this.m_nInstallStatus = pPKget1PPInfo.nStatus;
        this.m_nAction = pPKget1PPInfo.nInstall;
        this.m_strStatus = this.changeInstallStatus(pPKget1PPInfo.nStatus);
        this.m_strPermitVolume = this.makePermitVolume(pPKget1PPInfo);
        this.m_strTerm = this.makeTerm(pPKget1PPInfo);
        this.m_nUpdate = pPKget1PPInfo.nUpdate;
        this.m_lPermitVol = this.makeSortPermitVol(this.m_strRetPermVol, this.m_strRetUserVol);
        this.m_lSerialNumber = pPKget1PPInfo.nSN;
        this.m_nAccountType = pPKget1PPInfo.nAccountType;
        this.m_nUsedCapa = pPKget1PPInfo.lUsedCapa;
        this.counterList = pPKget1PPInfo.licenseCounter;
        this.licenseList = pPKget1PPInfo.portableLicenseList;
        this.keyKind = pPKget1PPInfo.nKeyKind;
    }

    public String changeInstallStatus(int n) {
        String string;
        switch (n) {
            case 2: {
                string = "Not Installed";
                break;
            }
            case 1: {
                string = "Installed";
                break;
            }
            case 4: {
                string = "Not Enough License";
                break;
            }
            case 3: {
                string = "Grace Period";
                break;
            }
            case 5: {
                string = "Expired";
                break;
            }
            case 6: {
                string = "Expired";
                break;
            }
            case 7: {
                string = "ReInstall Key";
                break;
            }
            case 8: {
                string = "Installed(Disabled)";
                break;
            }
            default: {
                string = new String("");
            }
        }
        return string;
    }

    public String makePermitVolume(PPKget1PPInfo pPKget1PPInfo) {
        String string = new String("");
        boolean bl = false;
        block0 : switch (pPKget1PPInfo.nStatus) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                switch (pPKget1PPInfo.nPermitVol) {
                    case 0: {
                        break block0;
                    }
                    case -1: {
                        this.m_strRetPermVol = string = string.concat("Unlimited");
                        bl = true;
                        break block0;
                    }
                }
                bl = true;
            }
        }
        if (bl) {
            if (pPKget1PPInfo.nPermitVol != -1) {
                string = string.concat(Integer.toString(pPKget1PPInfo.nPermitVol) + " TB");
                this.m_strRetPermVol = Integer.toString(pPKget1PPInfo.nPermitVol);
            }
            if (pPKget1PPInfo.nAccountType == 4) {
                if (pPKget1PPInfo.lUsedCapa != 0L) {
                    long l = pPKget1PPInfo.lUsedCapa * 100L;
                    int n = (int)(l % 1024L);
                    if (n != 0) {
                        l += 1024L;
                    }
                    l -= (long)n;
                    long l2 = (l /= 1024L) / 100L;
                    long l3 = l % 100L;
                    String string2 = new String("");
                    String string3 = Long.toString(l2);
                    String string4 = Long.toString(l3);
                    String string5 = "";
                    string5 = string4.length() == 1 ? "0" + string4 : string4;
                    string2 = string2.concat(string3);
                    string2 = string2.concat(".");
                    string2 = string2.concat(string5);
                    string = string.concat("(" + string2 + " TB)");
                    this.m_strRetUserVol = RJComUty.gtoTS1000((int)l, 2, 0);
                } else {
                    string = string.concat("(0.00 TB)");
                    this.m_strRetUserVol = this.m_strRetUserVol + "0.00";
                }
            }
            if (this.isMeterKey(pPKget1PPInfo.nKeyKind) || this.isMeterKey(pPKget1PPInfo.nKeyKind, pPKget1PPInfo.iBackKeyKind)) {
                if (pPKget1PPInfo.lPermDiffCapa >= 0L) {
                    this.lMeterVol = pPKget1PPInfo.lPermDiffCapa / 1024L;
                    string = string.concat(" + " + this.lMeterVol + " TB-Days");
                } else {
                    double d = Math.abs((double)pPKget1PPInfo.lPermDiffCapa / 1024.0);
                    this.lMeterVol = Long.valueOf(RJPPKeyPanel.LDEVtoLicense(String.valueOf(d)));
                    string = string.concat(" - " + this.lMeterVol + " TB-Days");
                }
            }
        }
        return string;
    }

    public String makeTerm(PPKget1PPInfo pPKget1PPInfo) {
        String string = new String("");
        if (pPKget1PPInfo.nExpireDays > 0) {
            string = string.concat(Integer.toString(pPKget1PPInfo.nExpireDays));
        } else if (pPKget1PPInfo.nStatus == 1) {
            string = new String("");
        } else if (pPKget1PPInfo.nDeterDays > 0) {
            string = string.concat(Integer.toString(pPKget1PPInfo.nDeterDays));
        }
        return string;
    }

    public long makeSortPermitVol(String string, String string2) {
        long l = 0L;
        if (!string.equals("Unlimited")) {
            if (string.length() != 0) {
                l = Long.parseLong(string) + this.lMeterVol << 24;
            }
            if (string2.length() != 0) {
                byte[] byArray = string2.getBytes();
                int n = string2.indexOf(".");
                String string3 = new String(byArray, 0, n);
                long l2 = Long.parseLong(string3);
                l += l2 << 8;
                l |= 0x8000L;
                string3 = new String(byArray, n + 1, 2);
                l += Long.parseLong(string3);
            }
        } else {
            l = 0xFFFFFFFFL;
        }
        return l;
    }

    public boolean isReduced() {
        boolean bl = this.m_nUpdate == 1 && this.m_nAction == 1 && this.licenseList.isEmpty();
        return bl;
    }

    public boolean isTemporaryKey() {
        boolean bl = this.keyKind == 1;
        return bl;
    }

    public boolean isEmergencyKey() {
        boolean bl = this.keyKind == 3;
        return bl;
    }

    public boolean isPortableInstalled() {
        boolean bl = !this.counterList.isEmpty();
        return bl;
    }

    public boolean isTremKey() {
        boolean bl = this.keyKind == 7;
        return bl;
    }

    public int getInstallStatus() {
        return this.m_nInstallStatus;
    }

    public boolean isPermanentKey() {
        boolean bl = this.keyKind == 2;
        return bl;
    }

    public boolean isMeterKey(int n) {
        boolean bl = n == 8;
        return bl;
    }

    public boolean isMeterKey(int n, int n2) {
        boolean bl = n == 3 && n2 == 8;
        return bl;
    }
}

