/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.sanproject.util;

import com.hitachi.sanproject.util.SanProperties;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class SanLogger {
    public static final String KEY_LIMIT = "com.hitachi.sanproject.util.logging.limit";
    public static final String KEY_COUNT = "com.hitachi.sanproject.util.logging.count";
    public static final String KEY_APPEND = "com.hitachi.sanproject.util.logging.append";
    public static final String KEY_LEVEL = "com.hitachi.sanproject.util.logging.level";
    protected static final int LIMIT = 0x100000;
    protected static final int COUNT = 10;
    protected static final boolean APPEND = true;
    protected static final Level LEVEL = Level.INFO;
    protected static final String FORMAT = "%1$tY/%1$tm/%1$td,%1$tH:%1$tM:%1$tS.%1$tL,[%2$-7s],%3$010d,%4$s.%5$s(){%6$s}%n";

    private SanLogger() {
    }

    public static Logger getLogger(SanProperties sanProperties, String string, String string2, String string3) throws SecurityException, IOException {
        Object object;
        String string4;
        Object object2;
        int n = 0x100000;
        int n2 = 10;
        boolean bl = true;
        Level level = LEVEL;
        if (sanProperties != null) {
            String string5;
            object2 = sanProperties.getProperty(KEY_LIMIT);
            if (object2 != null) {
                n = Integer.valueOf((String)object2);
            }
            if ((string4 = sanProperties.getProperty(KEY_COUNT)) != null) {
                n2 = Integer.valueOf(string4);
            }
            if ((object = sanProperties.getProperty(KEY_APPEND)) != null) {
                bl = Boolean.valueOf((String)object);
            }
            if ((string5 = sanProperties.getProperty(KEY_LEVEL)) != null) {
                level = Level.parse(string5);
            }
        }
        object2 = string == null ? Logger.getLogger(SanLogger.class.getCanonicalName()) : Logger.getLogger(string);
        ((Logger)object2).setLevel(level);
        ((Logger)object2).setFilter(null);
        string4 = null;
        string4 = string2 != null && string3 != null ? String.format("%s%s%s_%%g.log", string2, File.separator, string3) : "java_%u.log";
        object = new FileHandler(string4, n, n2, bl);
        ((Handler)object).setFilter(null);
        ((Handler)object).setLevel(level);
        ((Handler)object).setFormatter(SanLogger.newFormatter());
        ((Logger)object2).addHandler((Handler)object);
        return object2;
    }

    protected static Formatter newFormatter() {
        Formatter formatter = new Formatter(){

            @Override
            public synchronized String format(LogRecord logRecord) {
                Date date = new Date(logRecord.getMillis());
                String string = String.format(SanLogger.FORMAT, date, logRecord.getLevel().toString(), logRecord.getThreadID(), logRecord.getSourceClassName(), logRecord.getSourceMethodName(), logRecord.getMessage());
                return string;
            }
        };
        return formatter;
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println();
        throwable.printStackTrace(printWriter);
        printWriter.close();
        return stringWriter.toString();
    }

    public static void deleteLckFile(String string) throws SecurityException {
        if (string == null) {
            return;
        }
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        for (File file2 : file.listFiles()) {
            if (!file2.getPath().endsWith(".lck")) continue;
            file2.delete();
        }
    }
}

