/*
 * Decompiled with CFR 0.152.
 */
package com.ws.wbem.apps.mofcompiler;

import com.ws.cim.mof.compiler.MOFParser;
import com.ws.cim.mof.compiler.MOFParserHandler;
import com.ws.utilities.WSIStandardMessages;
import com.ws.utilities.cli.CLIOption;
import com.ws.wbem.apps.common.WSICommandLine;
import com.ws.wbem.apps.mofcompiler.MOFCompilerHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Hashtable;
import javax.wbem.WBEMException;
import javax.wbem.client.WBEMClient;

public class MOFCompiler {
    private static final String CMD_MOFFILE = "MOFFILE";
    private static final String CLI_NAMESPACE = "namespace";
    private static WSICommandLine mCLI;

    public static void parseMOF(String[] argv, boolean isInvoked, WBEMClient pCallBack) throws Exception {
        MOFCompiler.parseMOF(argv, isInvoked, pCallBack, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseMOF(String[] argv, boolean isInvoked, WBEMClient pCallBack, MOFParserHandler pParseCallBack) throws Exception {
        String fileName = null;
        Hashtable<String, String> clht = MOFCompiler.parseCLI(argv, isInvoked);
        if (argv[0].equals("-II")) {
            clht.put("-II", "true");
        }
        fileName = clht.get("filename");
        if ((fileName = new File(fileName).getAbsolutePath()) == null) {
            String errorMessage = WSIStandardMessages.getMessage((String)"ERROR_MOFCOMP_FILE_NOT_SPECIFIED", null);
            System.err.println(errorMessage);
            if (!isInvoked) {
                System.exit(1);
            } else {
                throw new WBEMException(6, errorMessage);
            }
        }
        boolean verbose = true;
        if (clht.get("-q") != null && !isInvoked) {
            verbose = false;
        }
        if (isInvoked) {
            verbose = false;
        }
        boolean syntaxOnly = false;
        if (clht.get("-c") != null) {
            syntaxOnly = true;
        }
        MOFCompilerHandler handler = null;
        try {
            handler = new MOFCompilerHandler(clht, pCallBack, verbose, isInvoked, pParseCallBack);
            new MOFParser(handler, fileName, isInvoked);
            if (syntaxOnly) {
                if (verbose) {
                    System.out.println(WSIStandardMessages.getMessage((String)"MESSAGE_SYN_SUCCESS", null));
                }
            } else if (verbose) {
                System.out.println(WSIStandardMessages.getMessage((String)"MESSAGE_SUCCESS", null));
                MOFCompiler.printStats(handler);
            }
        }
        catch (FileNotFoundException fne) {
            if (!isInvoked) {
                Object[] o = new Object[]{fne.getMessage()};
                System.err.println(WSIStandardMessages.getMessage((String)"ERROR_FILE_NOT_FOUND", (Object[])o));
                System.exit(1);
            }
            throw fne;
        }
        catch (Exception e) {
            if (isInvoked) {
                throw e;
            }
            System.err.println(e);
            System.exit(-1);
        }
        catch (Error e) {
            if (isInvoked) {
                throw e;
            }
            System.err.println(e.getLocalizedMessage());
            System.exit(-1);
        }
        finally {
            if (null != handler) {
                handler.close();
            }
        }
    }

    private static Hashtable<String, String> parseCLI(String[] argv, boolean isInvoked) throws WBEMException {
        mCLI = new WSICommandLine(WSIStandardMessages.getMessage((String)"MOFCOMP_NAME", null));
        String[] opts = new String[]{"d", "h", "i", "kf", "kp", "l", "n", "o", "p", "q", "s", "tf", "u", "v", "wp"};
        mCLI.setOptions(opts);
        CLIOption cOpt = new CLIOption("c", "\t\tSyntax Checking Only", false);
        mCLI.addOption(cOpt);
        cOpt = new CLIOption("m", "\t\tAllow modification of elements (Qualifier Type, Classes, Instances, ...) if they exist.", false);
        mCLI.addOption(cOpt);
        String[] cmds = new String[]{CMD_MOFFILE};
        mCLI.setCommands(cmds);
        mCLI.addExample(WSIStandardMessages.getMessage((String)"MOFCOMP_EXAMPLE1", null));
        mCLI.addExample(WSIStandardMessages.getMessage((String)"MOFCOMP_EXAMPLE2", null));
        mCLI.addExample(WSIStandardMessages.getMessage((String)"MOFCOMP_EXAMPLE3", null));
        mCLI.parse(argv);
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("protocol", "cim-xml");
        if (mCLI.isOptionSelected("c")) {
            ht.put("-c", "-c");
        }
        if (mCLI.isOptionSelected("d")) {
            ht.put("-d", mCLI.getOptionValue("d"));
        }
        if (mCLI.isOptionSelected("q")) {
            ht.put("-q", "-q");
        }
        if (mCLI.isOptionSelected("i")) {
            ht.put("-i", mCLI.getOptionValue("i"));
        }
        if (mCLI.isOptionSelected("l")) {
            ht.put("-l", mCLI.getOptionValue("l"));
        }
        if (mCLI.isOptionSelected("n")) {
            ht.put(CLI_NAMESPACE, mCLI.getOptionValue("n"));
        }
        if (mCLI.isOptionSelected("s")) {
            ht.put("cimhost", mCLI.getOptionValue("s"));
        }
        if (mCLI.isOptionSelected("u")) {
            String u = mCLI.getOptionValue("u");
            ht.put("username", u);
        }
        if (mCLI.isOptionSelected("p")) {
            String p = mCLI.getOptionValue("p");
            ht.put("password", p);
        }
        if (mCLI.isOptionSelected("o")) {
            ht.put("logdir", mCLI.getOptionValue("o"));
            ht.put("standalone", "true");
        }
        if (mCLI.isOptionSelected("wp")) {
            ht.put("protocol", mCLI.getOptionValue("wp"));
        }
        if (mCLI.isOptionSelected("m")) {
            ht.put("-C", "-C");
            ht.put("-I", "-I");
            ht.put("-Q", "-Q");
        }
        ht.put("filename", mCLI.getCommandValue(CMD_MOFFILE));
        ht.put("password", mCLI.getOptionValue("p") == null ? "guest" : mCLI.getOptionValue("p"));
        ht.put("username", mCLI.getOptionValue("u") == null ? "guest" : mCLI.getOptionValue("u"));
        return ht;
    }

    private static void printStats(MOFCompilerHandler handler) {
        if (handler.getQualifierTypeStats() > 0) {
            System.out.println(handler.getQualifierTypeStats() + " Qualifier Types.");
        }
        if (handler.getClassStats() > 0) {
            System.out.println(handler.getClassStats() + " Classes.");
        }
        if (handler.getInstanceStats() > 0) {
            System.out.println(handler.getInstanceStats() + " Instances.");
        }
    }

    public static void main(String[] argv) throws Exception {
        MOFCompiler.parseMOF(argv, false, null);
    }
}

