/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.slp.impl;

import ch.ethz.iks.slp.ServiceLocationException;
import ch.ethz.iks.slp.impl.SLPCore;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.util.ArrayList;

class AuthenticationBlock {
    public static final short BSD_DSA = 2;
    private int timestamp;
    private byte[] data = null;
    private byte[] sig = null;
    private String spi = null;

    AuthenticationBlock(short bsd, String spiStr, int timeStamp, byte[] byteData, byte[] signature) throws ServiceLocationException {
        this();
        if (bsd != 2) {
            throw new ServiceLocationException(16, "Only BSD 0x0002 (DSA) is supported.");
        }
        this.timestamp = timeStamp;
        this.data = byteData;
        this.spi = spiStr;
        if (signature == null) {
            this.sign();
        } else {
            this.sig = signature;
        }
    }

    AuthenticationBlock() {
    }

    private void sign() throws ServiceLocationException {
        try {
            PrivateKey privateKey = SLPCore.CONFIG.getPrivateKey(this.spi);
            SLPCore.platform.logDebug("Signing with SPI: " + this.spi);
            Signature signature = Signature.getInstance("SHA1withDSA");
            signature.initSign(privateKey);
            signature.update(this.data);
            this.sig = signature.sign();
        }
        catch (Exception e) {
            SLPCore.platform.logError(e.getMessage(), e.fillInStackTrace());
            throw new ServiceLocationException(7, "Could not sign data");
        }
    }

    String getSPI() {
        return this.spi;
    }

    int getTimestamp() {
        return this.timestamp;
    }

    boolean verify(byte[] verData) throws ServiceLocationException {
        try {
            PublicKey publicKey = SLPCore.CONFIG.getPublicKey(this.spi);
            Signature signature = Signature.getInstance("SHA1withDSA");
            signature.initVerify(publicKey);
            signature.update(verData);
            boolean success = signature.verify(this.sig);
            SLPCore.platform.logDebug((success ? "Verified with SPI: " : "Verification failed with SPI: ") + this.spi);
            return success;
        }
        catch (Exception e) {
            SLPCore.platform.logError(e.getMessage(), e.fillInStackTrace());
            throw new ServiceLocationException(7, "Could not verify data with SPI: " + this.spi);
        }
    }

    int getLength() {
        return 10 + this.spi.getBytes().length + this.sig.length;
    }

    void write(DataOutputStream out) throws IOException {
        out.writeShort(2);
        out.writeShort((short)this.getLength());
        out.writeInt(this.timestamp);
        byte[] temp = this.spi.getBytes();
        out.writeShort(temp.length);
        out.write(temp);
        out.write(this.sig);
    }

    static AuthenticationBlock[] parse(DataInputStream input) throws IOException, ServiceLocationException {
        ArrayList<AuthenticationBlock> blocks = new ArrayList<AuthenticationBlock>();
        int blockCount = input.readByte();
        for (int i = 0; i < blockCount; ++i) {
            AuthenticationBlock authBlock = new AuthenticationBlock();
            short bsd = input.readShort();
            if (bsd != 2) {
                throw new ServiceLocationException(7, "BSD " + bsd + " is not supported.");
            }
            short size = input.readShort();
            authBlock.timestamp = input.readInt();
            authBlock.spi = input.readUTF();
            authBlock.sig = new byte[size - 2 - 2 - 4 - 2 - authBlock.spi.getBytes().length];
            try {
                input.readFully(authBlock.sig);
            }
            catch (IOException ioe) {
                throw new ServiceLocationException(2, ioe.getMessage());
            }
            blocks.add(authBlock);
        }
        if (!SLPCore.CONFIG.getSecurityEnabled()) {
            return new AuthenticationBlock[0];
        }
        return blocks.toArray(new AuthenticationBlock[0]);
    }
}

