/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.sanproject.rmi.server;

import com.hitachi.sanproject.data.SanData;
import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanDataInternalUtility;
import com.hitachi.sanproject.data.SanDataUtility;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanInterface;
import com.hitachi.sanproject.rmi.SanRemote;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import com.hitachi.sanproject.rmi.SanRmiErrorCode;
import com.hitachi.sanproject.rmi.SanRmiException;
import com.hitachi.sanproject.rmi.server.SanRmiServer;
import com.hitachi.sanproject.rmi.server.functions.JNIFunctions;
import com.hitachi.sanproject.rmi.server.managers.SanAuditLogManager;
import com.hitachi.sanproject.rmi.server.managers.SanAuthenticationManager;
import com.hitachi.sanproject.rmi.server.managers.SanResourcelockManager;
import com.hitachi.sanproject.util.SanLogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import java.util.zip.ZipFile;

public class SanRemoteObject
extends UnicastRemoteObject
implements SanRemote {
    public static final String PACKAGE_FUNCTIONS = "com.hitachi.sanproject.rmi.server.functions";
    public static final String DIRECTORY_INTERFACE = "define_interface";
    public static final String DIRECTORY_DATA = "define_data";
    protected Logger logger;
    protected HashMap<String, SanData> datas = null;
    protected HashMap<String, SanInterface> interfaces = null;
    protected HashMap<String, SanData> auditLogs = null;
    protected SanData generalParameter = null;
    protected SanAuthenticationManager authenticationManager = null;
    protected SanResourcelockManager resourcelockManager = null;
    protected SanAuditLogManager auditLogManager = null;
    private static final int MAXNUM_INVOKE_THREAD = 4;
    private AtomicInteger invokeThreadCounter = new AtomicInteger(0);

    public SanData getGeneralParameter() {
        return this.generalParameter;
    }

    public SanRemoteObject() throws RemoteException {
        this.initialize();
    }

    public SanRemoteObject(int n) throws RemoteException {
        super(n);
        this.initialize();
    }

    public SanRemoteObject(int n, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) throws RemoteException {
        super(n, rMIClientSocketFactory, rMIServerSocketFactory);
        this.initialize();
    }

    protected void initialize() {
        this.logger = SanRmiServer.getLogger();
        this.authenticationManager = SanRmiServer.getAuthenticationManager();
        this.resourcelockManager = SanRmiServer.getResourcelockManager();
        this.auditLogManager = SanRmiServer.getAuditLogManager();
    }

    public SanResponse invoke(SanData sanData, SanRequest sanRequest) throws RemoteException, SanRmiException {
        Serializable serializable;
        SanInterface sanInterface;
        long l = System.currentTimeMillis();
        SanResponse sanResponse = null;
        String string = null;
        String string2 = null;
        int[] nArray = null;
        String string3 = null;
        SanData sanData2 = null;
        try {
            if (this.invokeThreadCounter.incrementAndGet() > 4) {
                throw SanRmiErrorCode.newException(SanRmiErrorCode.OVER_MAXNUM_INVOKE_THREAD);
            }
            this.checkRmiServerStatus();
            string = this.getClientHostInfo();
            string2 = this.getClientHostName(sanData);
            nArray = this.getStorageInfo(sanData);
            if (this.interfaces == null) {
                throw SanRmiErrorCode.newException(SanRmiErrorCode.SERVER_NOT_READY);
            }
            if (sanRequest == null) {
                throw SanRmiErrorCode.newException(SanRmiErrorCode.NULL_REQUEST);
            }
            string3 = sanRequest.id();
            this.logger.info(String.format("functionId=%s %s", string3, SanRmiServer.getMemoryInfo()));
            sanInterface = this.interfaces.get(string3);
            if (sanInterface == null) {
                throw SanRmiErrorCode.newException(SanRmiErrorCode.INVALID_FUNCTION_ID, String.format("FunctionId=%s", string3));
            }
            serializable = (Boolean)sanInterface.getAttr("authentication");
            Boolean bl = (Boolean)sanInterface.getAttr("resourcelock");
            if (bl.booleanValue()) {
                sanData2 = this.resourcelockManager.getLockStatus(sanData);
            } else if (((Boolean)serializable).booleanValue()) {
                sanData2 = this.authenticationManager.authenticateStorageUser(sanData);
                if (sanData2 == null) {
                    String[] stringArray = this.getAccountInfo(sanData);
                    if (stringArray == null) {
                        throw SanRmiErrorCode.newException(SanRmiErrorCode.INVALID_ACCOUNT_INFO, "AccountInfo=null");
                    }
                    throw SanRmiErrorCode.newException(SanRmiErrorCode.INVALID_ACCOUNT_INFO, String.format("UserName=%s", stringArray[0]));
                }
            } else {
                sanData2 = SanRemoteObject.newGeneralParameterInstance(this.generalParameter, sanData);
                SanRemoteObject.copyStorageInfoOfGeneralParameter(sanData2, sanData);
                sanData2 = SanDataInternalUtility.copyHiddenMembersOfGeneralParameter((SanData)sanData2, (SanData)sanData);
            }
            sanResponse = this.privateinvoke(sanInterface, sanData2, sanRequest);
        }
        catch (SanRmiException sanRmiException) {
            this.invokeThreadCounter.decrementAndGet();
            this.logger.warning(String.format("end : clientHostInfo=%s, clientHostName=%s, functionId=%s : %s", string, string2, string3, SanLogger.getStackTrace((Throwable)sanRmiException)));
            throw sanRmiException;
        }
        catch (Exception exception) {
            this.invokeThreadCounter.decrementAndGet();
            this.logger.severe(String.format("end : clientHostInfo=%s, clientHostName=%s, functionId=%s : %s", string, string2, string3, SanLogger.getStackTrace((Throwable)exception)));
            throw SanRmiErrorCode.newException(SanRmiErrorCode.UNKNOWN_ERROR);
        }
        this.invokeThreadCounter.decrementAndGet();
        sanInterface = this.interfaces.get(string3);
        serializable = this.auditLogManager.getAuditLogs();
        if (((HashMap)serializable).get(sanInterface.id()) != null) {
            try {
                this.auditLogManager.startThread(sanInterface, sanData2, sanRequest, sanResponse);
            }
            catch (Exception exception) {
                throw SanRmiErrorCode.newException(SanRmiErrorCode.UNKNOWN_ERROR);
            }
        }
        long l2 = System.currentTimeMillis();
        this.logger.info(String.format("end[ProcessingTime=%dmsec] : clientHostInfo=%s, clientHostName=%s, functionId=%s %s", l2 - l, string, string2, string3, SanRmiServer.getMemoryInfo()));
        return sanResponse;
    }

    public SanRequest newRequest(SanData sanData, String string) throws RemoteException, SanRmiException {
        long l = System.currentTimeMillis();
        SanRequest sanRequest = null;
        String string2 = null;
        String string3 = null;
        int[] nArray = null;
        try {
            this.checkRmiServerStatus();
            string2 = this.getClientHostInfo();
            string3 = this.getClientHostName(sanData);
            nArray = this.getStorageInfo(sanData);
            if (this.interfaces == null) {
                throw SanRmiErrorCode.newException(SanRmiErrorCode.SERVER_NOT_READY);
            }
            SanInterface sanInterface = this.interfaces.get(string);
            if (sanInterface == null) {
                throw SanRmiErrorCode.newException(SanRmiErrorCode.INVALID_FUNCTION_ID, String.format("FunctionId=%s", string));
            }
            sanRequest = sanInterface.getRequest().clone();
        }
        catch (SanRmiException sanRmiException) {
            this.logger.warning(String.format("Error : clientHostInfo=%s, clientHostName=%s : %s", string2, string3, SanLogger.getStackTrace((Throwable)sanRmiException)));
            throw sanRmiException;
        }
        long l2 = System.currentTimeMillis();
        if (nArray == null) {
            this.logger.info(String.format("[ProcessingTime=%dmsec] clientHostInfo=%s, clientHostName=%s, functionId=%s", l2 - l, string2, string3, string));
        } else {
            this.logger.info(String.format("[ProcessingTime=%dmsec] clientHostInfo=%s, clientHostName=%s, storageInfo{model=%s, serialnumber=%s}", l2 - l, string2, string3, nArray[0], nArray[1]));
        }
        return sanRequest;
    }

    public SanResponse newResponse(SanData sanData, String string) throws RemoteException, SanRmiException {
        long l = System.currentTimeMillis();
        SanResponse sanResponse = null;
        String string2 = null;
        String string3 = null;
        int[] nArray = null;
        try {
            this.checkRmiServerStatus();
            string2 = this.getClientHostInfo();
            string3 = this.getClientHostName(sanData);
            nArray = this.getStorageInfo(sanData);
            if (this.interfaces == null) {
                throw SanRmiErrorCode.newException(SanRmiErrorCode.SERVER_NOT_READY);
            }
            SanInterface sanInterface = this.interfaces.get(string);
            if (sanInterface == null) {
                throw SanRmiErrorCode.newException(SanRmiErrorCode.INVALID_FUNCTION_ID, String.format("FunctionId=%s", string));
            }
            sanResponse = sanInterface.getResponse().clone();
        }
        catch (SanRmiException sanRmiException) {
            this.logger.warning(String.format("Error : clientHostInfo=%s, clientHostName=%s : %s", string2, string3, SanLogger.getStackTrace((Throwable)sanRmiException)));
            throw sanRmiException;
        }
        long l2 = System.currentTimeMillis();
        if (nArray == null) {
            this.logger.info(String.format("[ProcessingTime=%dmsec] clientHostInfo=%s, clientHostName=%s, functionId=%s", l2 - l, string2, string3, string));
        } else {
            this.logger.info(String.format("[ProcessingTime=%dmsec] clientHostInfo=%s, clientHostName=%s, storageInfo{model=%s, serialnumber=%s}", l2 - l, string2, string3, nArray[0], nArray[1]));
        }
        return sanResponse;
    }

    public SanData newData(String string) throws RemoteException, SanRmiException {
        long l = System.currentTimeMillis();
        SanData sanData = null;
        try {
            this.checkRmiServerStatus();
            if (this.datas == null) {
                throw SanRmiErrorCode.newException(SanRmiErrorCode.SERVER_NOT_READY);
            }
            sanData = this.datas.get(string);
            if (sanData == null) {
                throw SanRmiErrorCode.newException(SanRmiErrorCode.INVALID_DATA_ID, String.format("DataId=%s", string));
            }
        }
        catch (SanRmiException sanRmiException) {
            this.logger.warning(String.format("Error :  %s", SanLogger.getStackTrace((Throwable)sanRmiException)));
            throw sanRmiException;
        }
        long l2 = System.currentTimeMillis();
        this.logger.info(String.format("[ProcessingTime=%dmsec] dataId=%s", l2 - l, string));
        return sanData.clone();
    }

    public List<String> functionList(SanData sanData) throws RemoteException, SanRmiException {
        long l = System.currentTimeMillis();
        ArrayList<String> arrayList = null;
        String string = null;
        String string2 = null;
        int[] nArray = null;
        try {
            this.checkRmiServerStatus();
            string = this.getClientHostInfo();
            string2 = this.getClientHostName(sanData);
            nArray = this.getStorageInfo(sanData);
            arrayList = new ArrayList<String>(this.interfaces.keySet());
            Collections.sort(arrayList);
        }
        catch (SanRmiException sanRmiException) {
            this.logger.warning(String.format("Error :  clientHostInfo=%s, clientHostName=%s : %s", string, string2, SanLogger.getStackTrace((Throwable)sanRmiException)));
            throw sanRmiException;
        }
        long l2 = System.currentTimeMillis();
        if (nArray == null) {
            this.logger.info(String.format("[ProcessingTime=%dmsec] clientHostInfo=%s, clientHostName=%s", l2 - l, string, string2));
        } else {
            this.logger.info(String.format("[ProcessingTime=%dmsec] clientHostInfo=%s, clientHostName=%s, storageInfo{model=%s, serialnumber=%s}", l2 - l, string, string2, nArray[0], nArray[1]));
        }
        return arrayList;
    }

    protected String getClientHostInfo() {
        try {
            return SanRemoteObject.getClientHost();
        }
        catch (ServerNotActiveException serverNotActiveException) {
            this.logger.warning(SanLogger.getStackTrace((Throwable)serverNotActiveException));
            return null;
        }
    }

    protected String getClientHostName(SanData sanData) throws SanRmiException {
        String string = null;
        try {
            if (sanData == null || !sanData.id().equals("GeneralParameter")) {
                throw SanRmiErrorCode.newException(SanRmiErrorCode.NULL_GENERAL_PARAMETER);
            }
            SanObject sanObject = sanData.getObj("ClientInfo");
            if (sanObject == null) {
                throw SanRmiErrorCode.newException(SanRmiErrorCode.INVALID_CLIENT_INFO, "GeneralParameter.ClientInfo=null");
            }
            string = (String)sanObject.getMember("HostName");
            if (string == null) {
                throw SanRmiErrorCode.newException(SanRmiErrorCode.INVALID_CLIENT_INFO, "GeneralParameter.ClientInfo.HostName=null");
            }
        }
        catch (SanDataException sanDataException) {
            this.logger.warning(SanLogger.getStackTrace((Throwable)sanDataException));
            throw SanRmiErrorCode.newException(SanRmiErrorCode.UNKNOWN_ERROR);
        }
        return string;
    }

    protected int[] getStorageInfo(SanData sanData) throws SanRmiException {
        int[] nArray = null;
        try {
            SanObject sanObject = sanData.getObj("StorageInfo");
            if (sanObject != null) {
                nArray = new int[]{sanObject.getInt("Model"), sanObject.getInt("SerialNumber")};
            }
        }
        catch (SanDataException sanDataException) {
            this.logger.warning(SanLogger.getStackTrace((Throwable)sanDataException));
            throw SanRmiErrorCode.newException(SanRmiErrorCode.UNKNOWN_ERROR);
        }
        return nArray;
    }

    protected String[] getAccountInfo(SanData sanData) throws SanRmiException {
        String[] stringArray = null;
        try {
            SanObject sanObject = sanData.getObj("AccountInfo");
            if (sanObject != null) {
                stringArray = new String[]{sanObject.getString("UserName"), sanObject.getString("Password")};
            }
        }
        catch (SanDataException sanDataException) {
            this.logger.warning(SanLogger.getStackTrace((Throwable)sanDataException));
            throw SanRmiErrorCode.newException(SanRmiErrorCode.UNKNOWN_ERROR);
        }
        return stringArray;
    }

    public SanInterface getInterface(String string) {
        return this.interfaces.get(string);
    }

    public SanResponse privateinvoke(SanInterface sanInterface, SanData sanData, SanRequest sanRequest) throws SanRmiException {
        SanResponse sanResponse = sanInterface.getResponse().clone();
        return this.privateinvoke(sanInterface, sanData, sanRequest, sanResponse);
    }

    public SanResponse privateinvoke(SanInterface sanInterface, SanData sanData, SanRequest sanRequest, SanResponse sanResponse) throws SanRmiException {
        this.logger.info("start");
        if (((Boolean)sanInterface.getAttr("native")).booleanValue()) {
            Integer n = (Integer)sanInterface.getAttr("function_index");
            this.logger.info(String.format("JNIFunctions.nativeinvoke : start : functionIndex=%d", n));
            short s = JNIFunctions.nativeinvoke(n, sanData, sanRequest, sanResponse);
            if (s != 0) {
                this.logger.severe(String.format("JNIFunctions.nativeinvoke : end : functionIndex=%d, result=%d", n, s));
                throw SanRmiErrorCode.newException(SanRmiErrorCode.UNKNOWN_ERROR);
            }
            this.logger.info(String.format("JNIFunctions.nativeinvoke : end : functionIndex=%d", n));
        } else {
            Method method = (Method)sanInterface.getAttr("method_obj");
            this.logger.info(String.format("method.invoke : start : method=%s", method.getName()));
            try {
                short s = (Short)method.invoke(null, sanData, sanRequest, sanResponse);
                if (s != 0) {
                    this.logger.severe(String.format("method.invoke : end : method=%s, result=%d", method.getName(), s));
                    throw SanRmiErrorCode.newException(SanRmiErrorCode.UNKNOWN_ERROR);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                this.logger.severe(String.format("method.invoke : end : method=%s : %s", method.getName(), SanLogger.getStackTrace((Throwable)exception)));
                throw SanRmiErrorCode.newException(SanRmiErrorCode.UNKNOWN_ERROR);
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getCause() != null && invocationTargetException.getCause() instanceof SanRmiException) {
                    throw (SanRmiException)invocationTargetException.getCause();
                }
                this.logger.severe(String.format("method.invoke : end : method=%s : %s", method.getName(), SanLogger.getStackTrace((Throwable)invocationTargetException)));
                throw SanRmiErrorCode.newException(SanRmiErrorCode.UNKNOWN_ERROR);
            }
            this.logger.info(String.format("method.invoke : end : method=%s", method.getName()));
        }
        this.logger.info("end");
        return sanResponse;
    }

    public void readDatas(File file) {
        if (file == null) {
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        HashMap<String, SanData> hashMap = new HashMap<String, SanData>();
        for (File file2 : fileArray) {
            String string = file2.getName();
            if (!file2.isFile() || !string.endsWith(".json")) continue;
            this.logger.info(String.format("data=%s", string));
            try {
                SanData sanData = SanDataUtility.readDataFromJSON((File)file2);
                hashMap.put(sanData.id(), sanData);
            }
            catch (SanDataException sanDataException) {
                this.logger.warning(SanLogger.getStackTrace((Throwable)sanDataException));
            }
        }
        this.generalParameter = (SanData)hashMap.get("GeneralParameter");
        this.datas = hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readDatas() {
        HashMap<String, SanData> hashMap = new HashMap<String, SanData>();
        JarEntry jarEntry = null;
        ZipFile zipFile = null;
        try {
            URL uRL = this.getClass().getClassLoader().getResource("define/define_data/");
            JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
            zipFile = jarURLConnection.getJarFile();
            Enumeration<JarEntry> enumeration = ((JarFile)zipFile).entries();
            while (enumeration.hasMoreElements()) {
                jarEntry = enumeration.nextElement();
                if (jarEntry.isDirectory() || !jarEntry.getName().contains(DIRECTORY_DATA) || !jarEntry.getName().endsWith(".json")) continue;
                InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(jarEntry.getName());
                this.logger.info(jarEntry.getName());
                SanData sanData = SanDataUtility.readDataFromJSON((InputStream)inputStream, (String)jarEntry.getName());
                hashMap.put(sanData.id(), sanData);
            }
        }
        catch (SanDataException sanDataException) {
            this.logger.warning(SanLogger.getStackTrace((Throwable)sanDataException));
        }
        catch (IOException iOException) {
            this.logger.warning(SanLogger.getStackTrace((Throwable)iOException));
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (IOException iOException) {
                this.logger.warning(SanLogger.getStackTrace((Throwable)iOException));
            }
        }
        this.generalParameter = (SanData)hashMap.get("GeneralParameter");
        this.datas = hashMap;
    }

    /*
     * WARNING - void declaration
     */
    public void readInterfaces(File file) {
        Object object;
        Object object2;
        Object object32;
        void sanInterface;
        if (file == null) {
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        HashMap<String, SanInterface> hashMap = new HashMap<String, SanInterface>();
        ArrayList<SanInterface> arrayList = new ArrayList<SanInterface>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        Object arrayList4 = fileArray;
        int n = ((File[])arrayList4).length;
        boolean bl = false;
        while (sanInterface < n) {
            File s2 = arrayList4[sanInterface];
            object32 = s2.getName();
            if (s2.isFile() && ((String)object32).endsWith(".json")) {
                this.logger.info(String.format("interface=%s", object32));
                try {
                    object2 = SanDataUtility.readInterfaceFromJSON((File)s2);
                    if (((SanInterface)object2).getAttr("class") != null) {
                        arrayList.add((SanInterface)object2);
                    } else if (((SanInterface)object2).getAttr("lib") != null) {
                        arrayList2.add(object2);
                        arrayList3.add((String)((SanInterface)object2).getAttr("lib"));
                    } else {
                        this.logger.warning(String.format("Invalid File : fileName=%s", object32));
                    }
                }
                catch (SanDataException sanDataException) {
                    this.logger.warning(SanLogger.getStackTrace((Throwable)sanDataException));
                }
            }
            ++sanInterface;
        }
        arrayList4 = (ArrayList)arrayList.clone();
        Iterator iterator = ((ArrayList)arrayList4).iterator();
        while (iterator.hasNext()) {
            SanInterface sanInterface2 = (SanInterface)iterator.next();
            String string = (String)sanInterface2.getAttr("class");
            object32 = (String)sanInterface2.getAttr("method");
            try {
                object2 = String.format("%s.%s", PACKAGE_FUNCTIONS, string);
                object = Class.forName((String)object2);
                Method method = ((Class)object).getMethod((String)object32, SanData.class, SanRequest.class, SanResponse.class);
                sanInterface2.putAttr("native", Boolean.FALSE);
                sanInterface2.putAttr("method_obj", method);
                this.logger.info(String.format("method=%s.%s()", object2, object32));
            }
            catch (ClassNotFoundException | NoSuchMethodException | SecurityException exception) {
                arrayList.remove(sanInterface2);
                this.logger.warning(SanLogger.getStackTrace((Throwable)exception));
            }
        }
        for (SanInterface arrayList5 : arrayList) {
            hashMap.put(arrayList5.id(), arrayList5);
        }
        if (arrayList2.size() > 0 && JNIFunctions.initialize()) {
            try {
                this.logger.info("JNIFunctions.startLoadingNativeFunction : start");
                short s = JNIFunctions.startLoadingNativeFunctions(arrayList2.size());
                this.logger.info(String.format("JNIFunctions.startLoadingNativeFunction : end, result=%d", s));
                ArrayList sanInterface3 = (ArrayList)arrayList2.clone();
                for (Object object32 : sanInterface3) {
                    object2 = (String)((SanInterface)object32).getAttr("lib");
                    object = (String)((SanInterface)object32).getAttr("function");
                    if (!JNIFunctions.loadLibrary((String)object2)) continue;
                    this.logger.info("JNIFunctions.loadNativeFunctions : start");
                    int n2 = JNIFunctions.loadNativeFunctions((String)object2, (String)object);
                    this.logger.info(String.format("JNIFunctions.loadNativeFunctions : end, functionIndex=%s", n2));
                    if (n2 >= 0) {
                        ((SanInterface)object32).putAttr("native", Boolean.TRUE);
                        ((SanInterface)object32).putAttr("function_index", n2);
                        this.logger.info(String.format("libName=%s, funcName=%s()", object2, object));
                        continue;
                    }
                    arrayList2.remove(object32);
                    this.logger.warning(String.format("can't load function : lib=%s, function=%s", object2, object));
                }
                this.logger.info("JNIFunctions.endLoadingNativeFunctions : start");
                short s2 = JNIFunctions.endLoadingNativeFunctions();
                this.logger.info(String.format("JNIFunctions.endLoadingNativeFunctions : end, result=%d", s2));
            }
            catch (Exception exception) {
                this.logger.warning(SanLogger.getStackTrace((Throwable)exception));
            }
            for (SanInterface sanInterface4 : arrayList2) {
                hashMap.put(sanInterface4.id(), sanInterface4);
            }
        }
        this.interfaces = hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readInterfaces() {
        Object object;
        String string;
        Object object2;
        Iterator iterator;
        Object object32;
        Iterator iterator2;
        Serializable serializable;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        JarEntry jarEntry = null;
        ZipFile zipFile = null;
        try {
            serializable = this.getClass().getClassLoader().getResource("define/define_interface/");
            iterator2 = (JarURLConnection)((URL)serializable).openConnection();
            zipFile = ((JarURLConnection)((Object)iterator2)).getJarFile();
            object32 = ((JarFile)zipFile).entries();
            while (object32.hasMoreElements()) {
                jarEntry = object32.nextElement();
                if (jarEntry.isDirectory() || !jarEntry.getName().contains(DIRECTORY_INTERFACE) || !jarEntry.getName().endsWith(".json")) continue;
                this.logger.info(jarEntry.getName());
                iterator = this.getClass().getClassLoader().getResourceAsStream(jarEntry.getName());
                object2 = SanDataUtility.readInterfaceFromJSON((InputStream)((Object)iterator), (String)jarEntry.getName());
                if (((SanInterface)object2).getAttr("class") != null) {
                    arrayList.add(object2);
                    continue;
                }
                if (((SanInterface)object2).getAttr("lib") != null) {
                    arrayList2.add(object2);
                    arrayList3.add((String)((SanInterface)object2).getAttr("lib"));
                    continue;
                }
                this.logger.warning(String.format("Invalid File : fileName=%s", jarEntry.getName()));
            }
        }
        catch (SanDataException sanDataException) {
            this.logger.warning(SanLogger.getStackTrace((Throwable)sanDataException));
        }
        catch (IOException iOException) {
            this.logger.warning(SanLogger.getStackTrace((Throwable)iOException));
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (IOException iOException) {
                this.logger.warning(SanLogger.getStackTrace((Throwable)iOException));
            }
        }
        serializable = (ArrayList)arrayList.clone();
        iterator2 = ((ArrayList)serializable).iterator();
        while (iterator2.hasNext()) {
            object32 = (SanInterface)iterator2.next();
            iterator = (String)((SanInterface)object32).getAttr("class");
            object2 = (String)((SanInterface)object32).getAttr("method");
            try {
                string = String.format("%s.%s", PACKAGE_FUNCTIONS, iterator);
                object = Class.forName(string);
                Method method = ((Class)object).getMethod((String)object2, SanData.class, SanRequest.class, SanResponse.class);
                ((SanInterface)object32).putAttr("native", Boolean.FALSE);
                ((SanInterface)object32).putAttr("method_obj", method);
                this.logger.info(String.format("method=%s.%s()", string, object2));
            }
            catch (ClassNotFoundException | NoSuchMethodException | SecurityException exception) {
                arrayList.remove(object32);
                this.logger.warning(SanLogger.getStackTrace((Throwable)exception));
            }
        }
        for (Object object32 : arrayList) {
            hashMap.put(((SanInterface)object32).id(), object32);
        }
        if (arrayList2.size() > 0 && JNIFunctions.initialize()) {
            try {
                this.logger.info("JNIFunctions.startLoadingNativeFunction : start");
                short s = JNIFunctions.startLoadingNativeFunctions(arrayList2.size());
                this.logger.info(String.format("JNIFunctions.startLoadingNativeFunction : end, result=%d", s));
                object32 = (ArrayList)arrayList2.clone();
                iterator = ((ArrayList)object32).iterator();
                while (iterator.hasNext()) {
                    object2 = (SanInterface)iterator.next();
                    string = (String)((SanInterface)object2).getAttr("lib");
                    object = (String)((SanInterface)object2).getAttr("function");
                    if (!JNIFunctions.loadLibrary(string)) continue;
                    this.logger.info("JNIFunctions.loadNativeFunctions : start");
                    int n = JNIFunctions.loadNativeFunctions(string, (String)object);
                    this.logger.info(String.format("JNIFunctions.loadNativeFunctions : end, functionIndex=%s", n));
                    if (n >= 0) {
                        ((SanInterface)object2).putAttr("native", Boolean.TRUE);
                        ((SanInterface)object2).putAttr("function_index", n);
                        this.logger.info(String.format("libName=%s, funcName=%s()", string, object));
                        continue;
                    }
                    arrayList2.remove(object2);
                    this.logger.warning(String.format("can't load function : lib=%s, function=%s", string, object));
                }
                this.logger.info("JNIFunctions.endLoadingNativeFunctions : start");
                short s2 = JNIFunctions.endLoadingNativeFunctions();
                this.logger.info(String.format("JNIFunctions.endLoadingNativeFunctions : end, result=%d", s2));
            }
            catch (Exception exception) {
                this.logger.warning(SanLogger.getStackTrace((Throwable)exception));
            }
            for (Object object32 : arrayList2) {
                hashMap.put(((SanInterface)object32).id(), object32);
            }
        }
        this.interfaces = hashMap;
    }

    protected void checkRmiServerStatus() throws SanRmiException {
        if (SanRmiServer.getStatus() != 1) {
            SanRmiException sanRmiException = SanRmiErrorCode.newException(SanRmiErrorCode.SERVER_NOT_READY);
            throw sanRmiException;
        }
    }

    public static SanData newGeneralParameterInstance(SanData sanData, SanData sanData2) throws SanDataException {
        SanData sanData3 = sanData.clone();
        SanObject sanObject = sanData3.newObj("ClientInfo");
        SanDataInternalUtility.clearHiddenMembersOfGeneralParameter((SanData)sanData3);
        SanObject sanObject2 = sanData2.getObj("ClientInfo");
        sanObject.putMember("HostName", sanObject2.getMember("HostName"));
        sanData3.putMember("RunOption", sanData2.getMember("RunOption"));
        return sanData3;
    }

    public static SanData copyStorageInfoOfGeneralParameter(SanData sanData, SanData sanData2) throws SanDataException {
        SanObject sanObject = sanData.newObj("StorageInfo");
        SanObject sanObject2 = sanData2.getObj("StorageInfo");
        sanObject.putMember("Model", sanObject2.getMember("Model"));
        sanObject.putMember("SerialNumber", sanObject2.getMember("SerialNumber"));
        return sanData;
    }
}

