/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.baseinfo.com;

import java.text.MessageFormat;
import javax.swing.Icon;
import sanproject.client.baseinfo.com.RJBaseInfoDataSupplier;
import sanproject.client.baseinfo.com.RJBaseInfoElement;
import sanproject.client.com.RJComDef;
import sanproject.client.com.RJComUty;
import sanproject.client.com.RJIconTBL;
import sanproject.client.com.RJcGuide;
import sanproject.client.data.RJDataLPRControler;
import sanproject.common.Robj_interface_RJiPGIndex;
import sanproject.common.Robj_interface_RJiVDEVIndex;
import sanproject.common.Robj_interface_RJiVDEVLDEVInfoDetail;
import sanproject.serversx.data.RJiVDEVIndex;
import sanproject.serverux.dataimpl.RJiLDEVInfoDetail3;

public class RJBaseInfoLDEVElement
extends RJBaseInfoElement {
    protected RJiLDEVInfoDetail3 ldevDetail = null;
    protected Robj_interface_RJiVDEVLDEVInfoDetail vdevLdevDetail = null;
    private String slprString = null;
    private String clprString = null;
    private String emulationType = null;
    private byte volumeFlag;
    private Long capacity = null;
    private Long capacityLUSE = null;
    private Long lbaCount = null;
    private Long lbaCountLUSE = null;
    private String raidString = null;
    private String protectionLevel = null;
    private String hddTypeString = null;
    private Integer luPath = null;
    private String vMAString = null;
    private String attributeString = null;
    private String extDevInfoString = null;
    private Integer extPaths = null;
    private String cacheModeString = null;
    private boolean mode = true;
    private String encryptionString = null;
    private String ldevRsgString = null;

    public RJBaseInfoLDEVElement(RJiLDEVInfoDetail3 rJiLDEVInfoDetail3, RJBaseInfoDataSupplier rJBaseInfoDataSupplier) {
        super(null, rJBaseInfoDataSupplier);
        this.initDetail(rJiLDEVInfoDetail3);
    }

    public RJBaseInfoLDEVElement(RJiLDEVInfoDetail3 rJiLDEVInfoDetail3, RJBaseInfoDataSupplier rJBaseInfoDataSupplier, boolean bl) {
        super(null, rJBaseInfoDataSupplier);
        this.setDspMode(bl);
        this.initDetail(rJiLDEVInfoDetail3);
    }

    public void initDetail(RJiLDEVInfoDetail3 rJiLDEVInfoDetail3) {
        this.ldevDetail = rJiLDEVInfoDetail3;
        this.vdevLdevDetail = this.supplier.getVDEVLDEVInfoDetail(rJiLDEVInfoDetail3);
        this.setName(RJBaseInfoLDEVElement.getLDEVDisplayName(rJiLDEVInfoDetail3));
        RJDataLPRControler rJDataLPRControler = this.supplier.getLPRControler();
        this.slprNo = new Integer(rJiLDEVInfoDetail3.getSSLPR());
        this.slprName = rJDataLPRControler.getSLPRNoToName(rJiLDEVInfoDetail3.getSSLPR());
        Integer n = new Integer(rJiLDEVInfoDetail3.getSCLPR());
        String string = rJDataLPRControler.getCLPRNoToName(rJiLDEVInfoDetail3.getSCLPR());
        this.slprString = RJBaseInfoLDEVElement.toClprString(this.slprNo, this.slprName);
        this.clprString = RJBaseInfoLDEVElement.toClprString(n, string);
        this.emulationType = this.toEmuString();
        this.volumeFlag = rJiLDEVInfoDetail3.getByVolumeFlag();
        this.capacityLUSE = this.capacity = new Long(rJiLDEVInfoDetail3.getLLDEVSize());
        this.lbaCountLUSE = this.lbaCount = new Long(rJiLDEVInfoDetail3.getLLDEVLBASize());
        this.raidString = rJiLDEVInfoDetail3.isExternalVolume() || rJiLDEVInfoDetail3.isExternalMFVolume() ? "-" : this.supplier.getRAIDLevelName(rJiLDEVInfoDetail3.getIRaidLevel());
        this.protectionLevel = RJComUty.getDisplayProtection(rJiLDEVInfoDetail3.getByProtectionLevel());
        this.hddTypeString = this.toIntVolInfoString();
        this.luPath = new Integer(rJiLDEVInfoDetail3.getILUPathNumber());
        this.vMAString = this.toVMAString();
        this.attributeString = this.toAttributeString();
        this.extDevInfoString = this.toExtDeviceInfoString();
        this.extPaths = new Integer(rJiLDEVInfoDetail3.getIExtAltPathNum());
        this.cacheModeString = this.toExtCacheModeString();
        this.encryptionString = this.toEncryptionString();
        this.ldevRsgString = this.supplier.getLdevRSG(rJiLDEVInfoDetail3.getObjLDEVIndex());
    }

    public void initCapacityLUSE(RJiLDEVInfoDetail3[] rJiLDEVInfoDetail3Array) {
        long l = 0L;
        long l2 = 0L;
        for (int i = 0; i < rJiLDEVInfoDetail3Array.length; ++i) {
            l += rJiLDEVInfoDetail3Array[i].getLLDEVSize();
            l2 += rJiLDEVInfoDetail3Array[i].getLLDEVLBASize();
        }
        this.capacityLUSE = new Long(l);
        this.lbaCountLUSE = new Long(l2);
    }

    public void setDspMode(boolean bl) {
        this.mode = bl;
    }

    private String toEmuString() {
        int n = this.ldevDetail.getIEmulationType();
        String string = this.supplier.getEmulationTypeName(n);
        if (!this.mode && this.ldevDetail.getSLUSEElmCount() > 1) {
            string = string + " * " + this.ldevDetail.getSLUSEElmCount();
        }
        if (this.mode && this.isCV()) {
            string = string + " " + RJcGuide.text("BasicInfo/LDEV_CVS");
        }
        return string;
    }

    public static String toMaxLBAString(Long l) {
        String string = l.toString() + " " + RJcGuide.text("BasicInfo/UNIT_Blocks");
        return string;
    }

    public static String toCapacityString(int n, Long l) {
        String string = null;
        switch (n) {
            case 1: 
            case 2: {
                string = l.toString() + " " + RJcGuide.text("BasicInfo/UNIT_Cyl");
                break;
            }
            case 3: {
                string = RJComUty.ktoGSlong(l) + " " + RJcGuide.text("BasicInfo/UNIT_GB");
                break;
            }
        }
        return string;
    }

    public static String toPGString(Robj_interface_RJiVDEVIndex robj_interface_RJiVDEVIndex) {
        String string = RJComUty.getPGDisplayName((Robj_interface_RJiPGIndex)robj_interface_RJiVDEVIndex);
        string = string + " - (" + robj_interface_RJiVDEVIndex.getIVDEV() + ")";
        return string;
    }

    private String toEncryptionString() {
        String string = "COMMON/Valid";
        if (this.ldevDetail.isInternalVolume()) {
            string = this.ldevDetail.isBEncrypt() ? "COMMON/Valid" : "COMMON/Unvalid";
            string = RJcGuide.text(string);
        } else {
            string = "-";
        }
        return string;
    }

    private String toVMAString() {
        String string = "BasicInfo/LDEVVMANone";
        if (this.ldevDetail.isBVMA()) {
            string = "BasicInfo/LDEVVMAVma";
            if (this.ldevDetail.isBExtent()) {
                string = "BasicInfo/LDEVVMAExt";
            }
        }
        return RJcGuide.text(string);
    }

    private String toAttributeString() {
        String string = RJcGuide.text("BasicInfo/LDEVNone");
        if (this.ldevDetail.isBHIHSMReserve()) {
            string = RJcGuide.text("BasicInfo/LDEVReserve");
        } else if (this.ldevDetail.isBPoolVol()) {
            string = RJcGuide.text("BasicInfo/LDEVPoolVol");
            Integer n = new Integer(this.ldevDetail.getSPoolID());
            MessageFormat messageFormat = new MessageFormat(string);
            Object[] objectArray = new Object[]{n};
            string = messageFormat.format(objectArray);
        } else if (this.ldevDetail.isQSVvol()) {
            string = RJcGuide.text("BasicInfo/LDEVVVol");
        } else if (this.ldevDetail.isAOUVvol()) {
            string = RJcGuide.text("BasicInfo/LDEVAOUVol");
        } else if (this.ldevDetail.isBJNLVolume()) {
            string = RJcGuide.text("BasicInfo/LDEVJournal");
        } else if (this.ldevDetail.isBSystemDisk()) {
            string = RJcGuide.text("BasicInfo/LDEVSystem");
        } else if (this.ldevDetail.isBLockVolume()) {
            string = RJcGuide.text("COMMON/QuorumDisk");
        } else if (this.ldevDetail.isBOdmVolume()) {
            string = RJcGuide.text("BasicInfo/LDEVODMVol");
        }
        return string;
    }

    private String toIntVolInfoString() {
        String string = RJcGuide.text("COMMON/DriveTypeNONE");
        if (!this.ldevDetail.isExternalVolume() && !this.ldevDetail.isExternalMFVolume()) {
            switch (this.ldevDetail.getByDriveType()) {
                case 0: {
                    string = RJcGuide.text("COMMON/FC");
                    break;
                }
                case 5: {
                    string = RJcGuide.text("COMMON/SSD");
                    break;
                }
                default: {
                    string = RJcGuide.text("COMMON/SATA");
                }
            }
        }
        return string;
    }

    private String toExtDeviceInfoString() {
        String string = "-/-/-/-";
        if (this.ldevDetail.isExternalVolume() || this.ldevDetail.isExternalMFVolume()) {
            String string2 = RJcGuide.text("BasicInfo/LDEVNone");
            String string3 = RJcGuide.text("BasicInfo/LDEVNone");
            String string4 = RJcGuide.text("BasicInfo/LDEVNone");
            String string5 = RJcGuide.text("COMMON/DriveTypeNONE");
            if (this.ldevDetail.getStrExtVenderName() != null && !this.ldevDetail.getStrExtVenderName().equals("")) {
                string2 = this.ldevDetail.getStrExtVenderName();
            }
            if (this.ldevDetail.getStrExtDeviceName() != null && !this.ldevDetail.getStrExtDeviceName().equals("")) {
                string3 = this.ldevDetail.getStrExtDeviceName();
            }
            if (this.ldevDetail.getStrExtSerial() != null && !this.ldevDetail.getStrExtSerial().equals("")) {
                string4 = this.ldevDetail.getStrExtSerial();
            }
            switch (this.ldevDetail.getByExtDriveType()) {
                case 0: {
                    string5 = RJcGuide.text("COMMON/FC");
                    break;
                }
                case 5: {
                    string5 = RJcGuide.text("COMMON/SSD");
                    break;
                }
                default: {
                    string5 = RJcGuide.text("COMMON/SATA");
                }
            }
            string = string2 + "/" + string3 + "/" + string4 + "/" + string5;
        }
        return string;
    }

    private String toExtCacheModeString() {
        String string = "BasicInfo/LDEVNone";
        if (this.ldevDetail.isExternalVolume()) {
            string = this.ldevDetail.isBCacheMode() ? "BasicInfo/CacheModeTrue" : "BasicInfo/CacheModeFalse";
        }
        string = RJcGuide.text(string);
        return string;
    }

    public Icon getIcon(boolean bl) {
        Icon icon = this.getLDEVIcon();
        return icon;
    }

    private Icon getLDEVIcon() {
        int n = 0;
        if (this.ldevDetail.isBRmtCmdDev()) {
            n = 23;
        } else if (this.ldevDetail.isBLUPathCmdDev()) {
            n = 85;
            if (this.ldevDetail.isBLUPathCmdDevSec()) {
                n = 86;
            }
        } else {
            n = this.ldevDetail.isBHIHSMReserve() ? 20 : (this.ldevDetail.getSLUSEElmCount() > 1 ? 22 : (this.ldevDetail.getSLUSEElmCount() == 0 ? 24 : (this.mode && this.isCV() ? 34 : 21)));
        }
        Icon icon = RJIconTBL.getIcon(n);
        return icon;
    }

    public boolean isCV() {
        boolean bl = false;
        if (this.vdevLdevDetail != null) {
            bl = this.vdevLdevDetail.getByLDEVStatus() == 2;
        }
        return bl;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof RJBaseInfoLDEVElement) {
            bl = this.ldevDetail.equals((Object)((RJBaseInfoLDEVElement)object).getLDEVDetail());
        }
        return bl;
    }

    public int hashCode() {
        int n = this.ldevDetail.hashCode();
        return n;
    }

    public int compareTo(Object object) {
        int n = 0;
        if (object instanceof RJBaseInfoLDEVElement) {
            n = this.ldevDetail.compareTo((Object)((RJBaseInfoLDEVElement)object).getLDEVDetail());
        }
        return n;
    }

    public RJiLDEVInfoDetail3 getLDEVDetail() {
        return this.ldevDetail;
    }

    public Robj_interface_RJiVDEVIndex getVDEVIndex() {
        RJiVDEVIndex rJiVDEVIndex = new RJiVDEVIndex();
        rJiVDEVIndex.setVDEVIndex(this.ldevDetail.getIFB4(), this.ldevDetail.getIPG(), this.ldevDetail.getIVDEV());
        return rJiVDEVIndex;
    }

    public boolean isLUSE() {
        boolean bl = false;
        if (this.ldevDetail.getSLUSEElmCount() != 1) {
            bl = true;
        }
        return bl;
    }

    public int getVolumeFlag() {
        return this.volumeFlag;
    }

    public String getSlprString() {
        return this.slprString;
    }

    public String getClprString() {
        return this.clprString;
    }

    public String getEmulationType() {
        return this.emulationType;
    }

    public Long getLBACount() {
        return this.lbaCount;
    }

    public Long getLBACountLUSE() {
        return this.lbaCountLUSE;
    }

    public Long getCapacity() {
        return this.capacity;
    }

    public Long getCapacityLUSE() {
        return this.capacityLUSE;
    }

    public String getRaidString() {
        return this.raidString;
    }

    public String getHddTypeString() {
        return this.hddTypeString;
    }

    public String getEncryptionString() {
        return this.encryptionString;
    }

    public Integer getLUPath() {
        return this.luPath;
    }

    public String getVMAString() {
        return this.vMAString;
    }

    public String getAttributeString() {
        return this.attributeString;
    }

    public String getExtDevInfoString() {
        return this.extDevInfoString;
    }

    public Integer getExtPaths() {
        return this.extPaths;
    }

    public String getCacheModeString() {
        return this.cacheModeString;
    }

    public String getProtectionLevel() {
        return this.protectionLevel;
    }

    public String getLdevResourceGroupstring() {
        return this.ldevRsgString;
    }

    public static String getLDEVDisplayName(RJiLDEVInfoDetail3 rJiLDEVInfoDetail3) {
        StringBuffer stringBuffer = new StringBuffer(RJComUty.getLDEVDisplayName(rJiLDEVInfoDetail3.getSLDKC(), rJiLDEVInfoDetail3.getSCU(), rJiLDEVInfoDetail3.getSLDEV()));
        if (rJiLDEVInfoDetail3.isExternalVolume()) {
            stringBuffer.append(RJComDef.LDEV_MARK_E);
        }
        if (rJiLDEVInfoDetail3.isExternalMFVolume()) {
            stringBuffer.append(RJComDef.LDEV_MARK_M);
        }
        if (rJiLDEVInfoDetail3.isQSVvol()) {
            stringBuffer.append(RJComDef.LDEV_MARK_V);
        }
        if (rJiLDEVInfoDetail3.isAOUVvol()) {
            stringBuffer.append(RJComDef.LDEV_MARK_U);
        }
        return stringBuffer.toString();
    }

    public Integer getRaidLevel() {
        return this.ldevDetail.getIRaidLevel();
    }
}

