/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.com;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import sanproject.client.com.RJCom;
import sanproject.client.com.RJComPanel;
import sanproject.client.com.RJcTabID;
import sanproject.client.data.RJDataControl;
import sanproject.client.exdevice.com.Guidance;
import sanproject.client.exdevice.com.Message;
import sanproject.client.exdevice.com.ModalDialog;
import sanproject.client.exdevice.data.EXDException;

public class DialogContentsPanel
extends JPanel {
    public static final DialogState APPLY_STATUS = new DialogState("applied.");
    public static final DialogState CANCEL_STATUS = new DialogState("canceled.");
    public static final DialogState ABORT_STATUS = new DialogState("aborted.");
    private DialogState dialogStatus;
    private String windowName;
    static /* synthetic */ Class class$javax$swing$RootPaneContainer;

    public DialogContentsPanel() {
        this(true);
    }

    public DialogContentsPanel(LayoutManager layoutManager) {
        this(layoutManager, true);
    }

    public DialogContentsPanel(boolean bl) {
        this(new BorderLayout(4, 4), bl);
    }

    public DialogContentsPanel(LayoutManager layoutManager, boolean bl) {
        super(layoutManager, bl);
        Object object = this.getClass();
        Object object2 = ((Class)object).getName();
        int n = ((String)object2).lastIndexOf(46);
        this.windowName = ((String)object2).substring(n + 1);
        this.dialogStatus = CANCEL_STATUS;
        object = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        object2 = Guidance.COLOR_PANELBACK.getColor();
        this.setOpaque(true);
        this.setBorder((Border)object);
        this.setBackground((Color)object2);
    }

    public void addNotify() {
        super.addNotify();
        this.installShortcutKey();
    }

    public String getWindowName() {
        String string = this.windowName;
        return string;
    }

    public void setWaitCursor() {
        RJCom.waitCursor(this);
    }

    public void setDefaultCursor() {
        RJCom.defCursor(this);
    }

    public JDialog createDialogWindow(JFrame jFrame, String string) {
        JDialog jDialog = this.createDialogWindow(jFrame, string, true);
        return jDialog;
    }

    public JDialog createDialogWindow(JFrame jFrame, String string, boolean bl) {
        ModalDialog modalDialog = new ModalDialog(jFrame, string, bl);
        Container container = modalDialog.getContentPane();
        container.add(this);
        modalDialog.setDefaultCloseOperation(2);
        modalDialog.pack();
        modalDialog.setLocationRelativeTo(jFrame);
        return modalDialog;
    }

    public JDialog createDialogWindow(JDialog jDialog, String string) {
        JDialog jDialog2 = this.createDialogWindow(jDialog, string, true);
        return jDialog2;
    }

    public JDialog createDialogWindow(JDialog jDialog, String string, boolean bl) {
        ModalDialog modalDialog = new ModalDialog(jDialog, string, bl);
        Container container = modalDialog.getContentPane();
        container.add(this);
        modalDialog.setDefaultCloseOperation(2);
        modalDialog.pack();
        modalDialog.setLocationRelativeTo(jDialog);
        return modalDialog;
    }

    public synchronized DialogState getDialogStatus() {
        DialogState dialogState = this.dialogStatus;
        return dialogState;
    }

    public synchronized void setDialogStatus(DialogState dialogState) {
        this.dialogStatus = dialogState;
    }

    public void putLog(String string, String string2) {
        String string3 = "[" + this.getWindowName() + "]";
        this.putLog(string3, string, string2, 0);
    }

    public void putLog(String string, String string2, String string3, int n) {
        RJDataControl rJDataControl = RJDataControl.getDataControl();
        RJCom.putLog(rJDataControl, string, string2, string3, n);
    }

    protected void installShortcutKey() {
        JRootPane jRootPane = this.getWindowRootPane();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                DialogContentsPanel.this.closeContentDialog();
            }
        };
        InputMap inputMap = jRootPane.getInputMap();
        inputMap.put(keyStroke, "close-dialog");
        ActionMap actionMap = jRootPane.getActionMap();
        actionMap.put("close-dialog", abstractAction);
    }

    protected void closeContentDialog() {
        JDialog jDialog = (JDialog)SwingUtilities.getWindowAncestor(this);
        jDialog.dispose();
    }

    protected void processEXDException(EXDException eXDException) {
        int n = eXDException.getPosition();
        int n2 = eXDException.getCode();
        Message message = Message.getMessage(n, n2);
        String string = message.getMessageText();
        this.putLog("DialogContentsPanel", string);
        message.showOKDialog(this);
        int n3 = message.getErrorLevel();
        this.endRequest(n3);
    }

    protected void endRequest(int n) {
        if (n != 0 && n != 4 && n != 5 && n != 7 && n != 8 && n != 9 && n != 10) {
            this.setDialogStatus(ABORT_STATUS);
            this.closeContentDialog();
            this.transferReqeustToOwner(n);
        }
    }

    protected Component getWindowGlassPane() {
        RootPaneContainer rootPaneContainer = (RootPaneContainer)((Object)SwingUtilities.getAncestorOfClass(class$javax$swing$RootPaneContainer == null ? (class$javax$swing$RootPaneContainer = DialogContentsPanel.class$("javax.swing.RootPaneContainer")) : class$javax$swing$RootPaneContainer, this));
        Component component = rootPaneContainer != null ? rootPaneContainer.getGlassPane() : null;
        return component;
    }

    protected JRootPane getWindowRootPane() {
        RootPaneContainer rootPaneContainer = (RootPaneContainer)((Object)SwingUtilities.getAncestorOfClass(class$javax$swing$RootPaneContainer == null ? (class$javax$swing$RootPaneContainer = DialogContentsPanel.class$("javax.swing.RootPaneContainer")) : class$javax$swing$RootPaneContainer, this));
        JRootPane jRootPane = rootPaneContainer != null ? rootPaneContainer.getRootPane() : null;
        return jRootPane;
    }

    protected StackTraceElement getCallerTraceElement() {
        Exception exception = new Exception();
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        StackTraceElement stackTraceElement = stackTraceElementArray[2];
        return stackTraceElement;
    }

    private void transferReqeustToOwner(final int n) {
        JDialog jDialog = (JDialog)SwingUtilities.getWindowAncestor(this);
        if (jDialog != null) {
            RJComPanel rJComPanel;
            Window window = jDialog.getOwner();
            if (window instanceof ModalDialog) {
                ModalDialog modalDialog = (ModalDialog)window;
                modalDialog.endRequest(n);
            } else if (window instanceof Frame && (rJComPanel = this.findComPanel(window)) != null) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        rJComPanel.endRequest(n);
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    private RJComPanel findComPanel(Container container) {
        Component[] componentArray;
        RJComPanel rJComPanel = null;
        if (container != null && (componentArray = container.getComponents()) != null) {
            for (int i = 0; i < componentArray.length; ++i) {
                Container container2;
                RJComPanel rJComPanel2;
                Component component = componentArray[i];
                if (component instanceof RJComPanel) {
                    rJComPanel = (RJComPanel)component;
                    break;
                }
                if (!(component instanceof Container) || (rJComPanel2 = this.findComPanel(container2 = (Container)component)) == null) continue;
                rJComPanel = rJComPanel2;
                break;
            }
        }
        return rJComPanel;
    }

    protected static boolean isEditable(int n, int n2) {
        boolean bl = RJcTabID.hasWritePermission(n, n2);
        RJDataControl rJDataControl = RJDataControl.getDataControl();
        boolean bl2 = RJCom.getEditMode(rJDataControl);
        boolean bl3 = bl && bl2;
        return bl3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class DialogState
    implements Serializable {
        private String name;

        protected DialogState(String string) {
            this.name = string;
        }

        public String getName() {
            String string = this.name;
            return string;
        }
    }
}

