/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.monitor.performance.physical;

import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Icon;
import sanproject.client.com.RJcGuide;
import sanproject.client.com.RJcTreePanel;
import sanproject.client.com.abs.RJaTreeNode;
import sanproject.client.monitor.com.RJHihDataSupplier;
import sanproject.client.monitor.com.RJHihElement;
import sanproject.client.monitor.com.RJHihIconTable;
import sanproject.client.monitor.com.RJHihTimePair;
import sanproject.client.monitor.performance.physical.RJHihPhDkpElement;
import sanproject.client.monitor.performance.physical.RJHihPhDkpTableModel;
import sanproject.serverux.arg.monitor.HIHsmDKADKPCompositionInfoArgInfo;
import sanproject.serverux.arg.monitor.HIHsmDKPUseRateArgInfo;
import sanproject.serverux.arg.monitor.HIHsmPhysicalDKPUseRateArgInfo;
import sanproject.serverux.arg.monitor.MonArg;
import sanproject.serverux.data.HIHsmDKACompositionInfo;
import sanproject.serverux.data.HIHsmDKADKPCompositionInfo;
import sanproject.serverux.data.HIHsmDKPCompositionInfo;
import sanproject.serverux.data.MonitorInfoCollection;

public class RJHihPhDkpFolderElement
extends RJHihElement {
    private int clusterNo;
    private int dkaNo;
    private HIHsmDKPCompositionInfo dkps = null;
    private HIHsmDKADKPCompositionInfo dkadkps = null;
    private HIHsmDKACompositionInfo dkas = null;

    public RJHihPhDkpFolderElement(int n, int n2, RJHihDataSupplier rJHihDataSupplier, RJcTreePanel rJcTreePanel) {
        super(RJcGuide.text("PerformanceManagement/PhysicalDkp"), rJHihDataSupplier, rJcTreePanel);
        this.clusterNo = n;
        this.dkaNo = n2;
    }

    public RJHihPhDkpFolderElement(RJHihDataSupplier rJHihDataSupplier, RJcTreePanel rJcTreePanel) {
        this(-1, -1, rJHihDataSupplier, rJcTreePanel);
    }

    public void selectNode(RJaTreeNode rJaTreeNode) {
        this.supplier.putLog("[Monitor]", "[Physical]", "RJHihPhDkpFolderElement.selectNode start");
        this.createChildren();
        this.model = this.saveModel;
        if (this.model == null) {
            this.model = new RJHihPhDkpTableModel(this.supplier);
        }
        this.model.beginSetting();
        MonitorInfoCollection monitorInfoCollection = this.getDKPUseRate();
        this.table.createTable(this.model);
        Iterator iterator = this.children.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            RJHihPhDkpElement rJHihPhDkpElement = (RJHihPhDkpElement)iterator.next();
            rJHihPhDkpElement.collectUseRate(monitorInfoCollection, n);
            this.model.addRow(rJHihPhDkpElement);
            ++n;
        }
        this.model.completeSetting();
        this.table.completedTable();
        this.supplier.putLog("[Monitor]", "[Physical]", "RJHihPhDkpFolderElement.selectNode end");
    }

    private void createChildren() {
        if (this.children == null) {
            this.dkadkps = this.getDkaDkps();
            this.children = new ArrayList();
            for (int i = 0; i < this.dkadkps.getSize(); ++i) {
                this.clusterNo = this.dkadkps.getCluster(i);
                this.dkas = (HIHsmDKACompositionInfo)this.dkadkps.getDka(i);
                for (int j = 0; j < this.dkas.getSize(); ++j) {
                    this.dkps = (HIHsmDKPCompositionInfo)this.dkas.getDkp(j);
                    this.dkaNo = this.dkas.getNumber(j);
                    for (int k = 0; k < this.dkps.getSize(); ++k) {
                        int n = this.dkps.getNumber(k);
                        String string = this.dkps.getName(k);
                        RJHihPhDkpElement rJHihPhDkpElement = new RJHihPhDkpElement(this.clusterNo, this.dkaNo, n, string, this.supplier, this.treePanel);
                        this.children.add(rJHihPhDkpElement);
                    }
                }
            }
        }
    }

    public HIHsmDKADKPCompositionInfo getDkaDkps() {
        if (this.dkadkps == null) {
            HIHsmDKADKPCompositionInfoArgInfo hIHsmDKADKPCompositionInfoArgInfo = new HIHsmDKADKPCompositionInfoArgInfo();
            this.dkadkps = (HIHsmDKADKPCompositionInfo)this.supplier.getMonitorInfo((MonArg)hIHsmDKADKPCompositionInfoArgInfo);
        }
        return this.dkadkps;
    }

    private MonitorInfoCollection getDKPUseRate() {
        MonitorInfoCollection monitorInfoCollection = null;
        RJHihTimePair rJHihTimePair = this.supplier.getMonitoringInfo().getMonitoringTime();
        int n = this.children.size();
        if (rJHihTimePair != null && n > 0) {
            Object object = null;
            object = this.getRangeKind() == 0 ? new HIHsmPhysicalDKPUseRateArgInfo(2, rJHihTimePair.getFromTime(), rJHihTimePair.getToTime(), n) : new HIHsmDKPUseRateArgInfo(2, rJHihTimePair.getFromTime(), rJHihTimePair.getToTime(), n);
            Iterator iterator = this.children.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                RJHihPhDkpElement rJHihPhDkpElement = (RJHihPhDkpElement)iterator.next();
                object.setAllParam(n2, rJHihPhDkpElement.getClusterNo(), rJHihPhDkpElement.getDkaNo(), rJHihPhDkpElement.getDkpNo());
                ++n2;
            }
            monitorInfoCollection = (MonitorInfoCollection)this.supplier.getMonitorInfo((MonArg)object);
        }
        return monitorInfoCollection;
    }

    public Icon getIcon(boolean bl) {
        Icon icon = RJHihIconTable.getIcon(17);
        return icon;
    }
}

