/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.openldevguard.gui.logging;

import java.io.OutputStream;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import sanproject.client.openldevguard.gui.logging.SingleLineFormatter;

public class ErrorConsoleHandler
extends StreamHandler {
    public ErrorConsoleHandler() {
        this(System.err, null);
    }

    private ErrorConsoleHandler(OutputStream outputStream, Formatter formatter) {
        Formatter formatter2 = formatter;
        if (formatter2 == null) {
            formatter2 = this.createDefaultFormatter();
        }
        Filter filter = this.createDefaultFilter();
        this.setOutputStream(outputStream);
        this.setFormatter(formatter2);
        this.setLevel(Level.ALL);
        this.setFilter(filter);
    }

    private Formatter createDefaultFormatter() {
        SingleLineFormatter singleLineFormatter = new SingleLineFormatter();
        return singleLineFormatter;
    }

    private Filter createDefaultFilter() {
        return new Filter(){

            public boolean isLoggable(LogRecord logRecord) {
                boolean bl = false;
                Level level = logRecord.getLevel();
                if (level.equals(Level.SEVERE) || level.equals(Level.WARNING)) {
                    bl = true;
                }
                return bl;
            }
        };
    }

    public final synchronized void publish(LogRecord logRecord) {
        super.publish(logRecord);
        this.flush();
    }
}

