/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.openldevguard.gui.main;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.event.TableModelEvent;
import sanproject.client.openldevguard.com.TableSortedEvent;
import sanproject.client.openldevguard.gui.OpenLDEVGuardException;
import sanproject.client.openldevguard.gui.OpenLDEVGuardProperties;
import sanproject.client.openldevguard.gui.main.AbstractPagingTableModel;
import sanproject.client.openldevguard.gui.main.LDEVWrapper;
import sanproject.client.openldevguard.gui.main.OpenLDEVGuardDataControlWrapper;
import sanproject.client.openldevguard.gui.main.TableDataItem;
import sanproject.client.openldevguard.gui.main.ViewDefine;
import sanproject.client.openldevguard.gui.main.VolumeDetailTableItem;
import sanproject.client.openldevguard.utility.ObjectUtilities;

class VolumeDetailTableModel
extends AbstractPagingTableModel {
    public static final int CULDEV = 0;
    public static final int SVOL = 1;
    public static final int MAX_LENGTH = 2;
    private OpenLDEVGuardDataControlWrapper mdcwWrapper;
    private List mlstLUSEVolumes;
    private int[] marrSorterType;
    private String[] marrColumnNames;
    private String[] marrColumnIDs;

    VolumeDetailTableModel(OpenLDEVGuardDataControlWrapper openLDEVGuardDataControlWrapper) {
        this.loadProperties();
        this.mdcwWrapper = openLDEVGuardDataControlWrapper;
        this.mlstLUSEVolumes = new ArrayList();
        this.marrSorterType = new int[2];
        this.marrColumnIDs = new String[2];
        this.marrColumnNames = new String[2];
        this.marrSorterType[0] = 2;
        this.marrColumnIDs[0] = "culdev";
        this.marrColumnNames[0] = openLDEVGuardDataControlWrapper.getGuidanceString("COMMON/LDKC_CU_LDEV");
        this.marrSorterType[1] = 1;
        this.marrColumnIDs[1] = "svol";
        this.marrColumnNames[1] = openLDEVGuardDataControlWrapper.getGuidanceString("COMMON/SVOL_Open");
    }

    public final int getMaxRowCountInPage() {
        int n = 0;
        return n;
    }

    protected final List getAllRowDataList() {
        return this.mlstLUSEVolumes;
    }

    protected final TableDataItem createCellObject(Object object, int n) {
        TableDataItem tableDataItem;
        LDEVWrapper lDEVWrapper = (LDEVWrapper)object;
        switch (n) {
            case 0: {
                tableDataItem = VolumeDetailTableItem.createCULDEVNumberCellItem(this.mdcwWrapper, lDEVWrapper);
                break;
            }
            case 1: {
                tableDataItem = VolumeDetailTableItem.createSVolCellItem(this.mdcwWrapper, lDEVWrapper);
                break;
            }
            default: {
                tableDataItem = null;
            }
        }
        return tableDataItem;
    }

    protected final TableDataItem[] getRowCellItems(Object object) {
        TableDataItem[] tableDataItemArray = new TableDataItem[2];
        for (int i = 0; i < 2; ++i) {
            tableDataItemArray[i] = this.createCellObject(object, i);
        }
        return tableDataItemArray;
    }

    protected final int getSorterType(int n) {
        int n2 = this.marrSorterType[n];
        return n2;
    }

    public final int getSortingIndex() {
        String string = ObjectUtilities.getClassName(this);
        String string2 = string + ".sortingindex";
        String string3 = OpenLDEVGuardProperties.getProperty(string2);
        int n = -1;
        try {
            n = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            String string4 = String.valueOf(n);
            OpenLDEVGuardProperties.setProperty(string2, string4);
        }
        return n;
    }

    public final int getSortKind(int n) {
        int n2 = this.getSortingIndex();
        int n3 = -1;
        if (n2 == n) {
            String string = ObjectUtilities.getClassName(this);
            String string2 = string + ".sortkind";
            String string3 = OpenLDEVGuardProperties.getProperty(string2);
            try {
                n3 = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                String string4 = String.valueOf(n3);
                OpenLDEVGuardProperties.setProperty(string2, string4);
            }
        }
        return n3;
    }

    protected final String[] getColumnNames() {
        String[] stringArray = this.marrColumnNames;
        return stringArray;
    }

    protected final String[] getColumnIDs() {
        String[] stringArray = this.marrColumnIDs;
        return stringArray;
    }

    private void loadProperties() {
        String string;
        String string2 = ObjectUtilities.getClassName(this);
        String string3 = string2 + ".sortingindex";
        int n = -1;
        if (ViewDefine.isSupportLoadViewProperties() && (string = OpenLDEVGuardProperties.getProperty(string3)) != null && !string.equals("")) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
        }
        string = String.valueOf(n);
        OpenLDEVGuardProperties.setProperty(string3, string);
        string3 = string2 + ".sortkind";
        n = 0;
        if (ViewDefine.isSupportLoadViewProperties() && (string = OpenLDEVGuardProperties.getProperty(string3)) != null && !string.equals("")) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
        }
        string = String.valueOf(n);
        OpenLDEVGuardProperties.setProperty(string3, string);
    }

    public final void initializeData(LDEVWrapper lDEVWrapper) throws OpenLDEVGuardException {
        Object object;
        if (lDEVWrapper != null) {
            object = lDEVWrapper.getLUSEVolumes();
            this.mlstLUSEVolumes = Arrays.asList(object);
        }
        this.updateCellData();
        object = new TableModelEvent(this, -1);
        this.fireTableChanged((TableModelEvent)object);
        int n = this.getSortingIndex();
        int n2 = this.getSortKind(n);
        TableSortedEvent tableSortedEvent = new TableSortedEvent(this, n, n2);
        this.fireTableSorted(tableSortedEvent);
    }

    public final void requestSort(int n) {
        int n2 = this.getSortKind(n);
        n2 = this.getNextSortKind(n, n2);
        this.updateSortingFlags(n, n2);
        this.updateSortCellData(n, n2);
        n2 = this.getRowCount();
        TableModelEvent tableModelEvent = new TableModelEvent(this, 0, n2);
        this.fireTableChanged(tableModelEvent);
        n2 = this.getSortingIndex();
        int n3 = this.getSortKind(n2);
        TableSortedEvent tableSortedEvent = new TableSortedEvent(this, n2, n3);
        this.fireTableSorted(tableSortedEvent);
    }

    private void updateSortingFlags(int n, int n2) {
        String string = ObjectUtilities.getClassName(this);
        String string2 = String.valueOf(n);
        String string3 = String.valueOf(n2);
        OpenLDEVGuardProperties.setProperty(string + ".sortingindex", string2);
        OpenLDEVGuardProperties.setProperty(string + ".sortkind", string3);
    }
}

