/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.spread;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.rmi.RemoteException;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import sanproject.client.com.RJCom;
import sanproject.client.com.RJComDialog;
import sanproject.client.com.RJComModalDialog;
import sanproject.client.com.RJComUty;
import sanproject.client.com.RJcAbsGuideConst;
import sanproject.client.com.RJcButton;
import sanproject.client.com.RJcConst;
import sanproject.client.com.RJcDlgMainTitlePanel;
import sanproject.client.com.RJcGuide;
import sanproject.client.com.RJcSouthPanel;
import sanproject.client.data.RJDataControl;
import sanproject.client.data.RJDataMsg;
import sanproject.client.spread.RJSPDFTCException;
import sanproject.client.spread.RJSPDFilterCompo;
import sanproject.client.spread.RJSPDGetData;
import sanproject.client.spread.RJSPDGuideDef;
import sanproject.client.spread.RJSPDLunmFilterCompo;
import sanproject.client.spread.RJSPDUvmFilterCompo;
import sanproject.client.spread.RJSPDVrFilterCompo;
import sanproject.serverux.data.FTFileData;

public class RJSPDFTCDialog
extends RJComModalDialog
implements RJSPDGuideDef {
    private String dialogName = null;
    public static final int RIGHT = 0;
    public static final int LEFT = 1;
    private Vector buttonVector = null;
    private int dummyPosition = 0;
    private Point dialogLocation = null;
    RJSPDFilterCompo filterPanel = null;
    private RJDataControl m_DataControl;
    private RJSPDGetData m_SPDGetData;
    protected int m_Kind;
    private JTextField m_FilePathText = null;
    private JButton m_ImpExpBtn = null;
    private JButton m_ExitBtn = null;
    protected int m_Function;
    public boolean bEndStatus = false;
    protected String m_strFilePath;
    protected static String m_stSettingFile = "";

    public RJSPDFTCDialog(Frame frame, RJDataControl rJDataControl, int n, int n2) {
        super(frame, true);
        this.m_DataControl = rJDataControl;
        this.m_Function = n2;
        this.m_Kind = n;
        try {
            this.m_SPDGetData = new RJSPDGetData(this.m_DataControl);
            this.initPPCompo(this.m_Function);
            this.initInstance();
            this.setResizable(false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void initPPCompo(int n) {
        switch (n) {
            case 0: {
                this.filterPanel = new RJSPDLunmFilterCompo(this.m_DataControl, this);
                break;
            }
            case 1: {
                this.filterPanel = new RJSPDUvmFilterCompo(this.m_DataControl, this);
                break;
            }
            case 2: {
                this.filterPanel = new RJSPDVrFilterCompo(this.m_DataControl, this);
                break;
            }
            default: {
                this.filterPanel = new RJSPDFilterCompo(this.m_DataControl, this);
            }
        }
        this.m_FilePathText = this.filterPanel.m_FilePathText;
    }

    protected JPanel createCenterComponent() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(RJcGuide.color("SPREAD/FilterBgClr"));
        jPanel.add((Component)this.filterPanel, "Center");
        return jPanel;
    }

    public void Show() {
        try {
            m_stSettingFile = System.getProperty("java.home") + "\\" + "FTClient.ftcset";
        }
        catch (AccessControlException accessControlException) {
            accessControlException.printStackTrace();
            System.out.println("[SPREAD]:AccessControlExceptionError:" + accessControlException.getMessage());
            return;
        }
        String string = RJSPDFTCDialog.LoadSettings();
        string = this.setDefaultFileName(string);
        this.m_FilePathText.setText(string);
        this.setBtnEnabled();
        this.setLocation(this.getDialogLocation());
        super.setVisible(true);
    }

    void OnExit(ActionEvent actionEvent) {
        this.dispose();
    }

    protected static String LoadSettings() {
        String string = "";
        String string2 = "";
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(m_stSettingFile));
            if (bufferedReader != null && bufferedReader.ready()) {
                while ((string2 = bufferedReader.readLine()) != null) {
                    string = string2;
                }
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            System.out.println("[SPREAD]:FilePath:" + m_stSettingFile);
            System.out.println("[SPREAD]:LoadSettings()ERROR:" + exception.getMessage());
        }
        return string;
    }

    public static void WriteSetting(String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(m_stSettingFile, false));
            bufferedWriter.write(string);
            bufferedWriter.newLine();
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (Exception exception) {
            System.out.println("[SPREAD]:FilePath:" + m_stSettingFile);
            System.out.println("[SPREAD]:WriteSetting()ERROR:" + exception.getMessage());
        }
    }

    protected void onExport(ActionEvent actionEvent) {
        short[] sArray = this.filterPanel.getFilter();
        int[] nArray = new int[]{0, 0};
        this.setCursor(new Cursor(3));
        this.setButton(false);
        if (this.chkMyLock() != 0) {
            this.setButton(true);
            this.setCursor(new Cursor(0));
            return;
        }
        try {
            this.ExportCheck(null);
        }
        catch (RJSPDFTCException rJSPDFTCException) {
            this.setButton(true);
            this.setCursor(new Cursor(0));
            return;
        }
        RJSPDFTCDialog rJSPDFTCDialog = this;
        rJSPDFTCDialog.m_SPDGetData.WaitControl();
        this.m_DataControl.getFTConfigureDownload(this.m_Function, sArray[0], sArray[1]);
        this.m_DataControl.waitDC();
        ArrayList arrayList = this.m_DataControl.getEndStatus();
        Integer n = (Integer)arrayList.get(0);
        nArray[0] = n;
        Integer n2 = (Integer)arrayList.get(1);
        nArray[1] = n2;
        if (nArray[0] == 0) {
            FTFileData fTFileData = this.m_DataControl.getFTConfigureDownloadData();
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.m_strFilePath));
                for (int i = 0; i < fTFileData.strData.length; ++i) {
                    bufferedWriter.write(fTFileData.strData[i]);
                    bufferedWriter.newLine();
                }
                bufferedWriter.flush();
                bufferedWriter.close();
                RJSPDFTCDialog.WriteSetting(this.m_FilePathText.getText());
                this.dispose();
                this.bEndStatus = true;
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
                RJDataMsg rJDataMsg = RJCom.getMsg(this.m_DataControl, 8110, 5634);
                Object[] objectArray = new Object[]{RJComUty.CAPTION_MSG_OK};
                RJComDialog.show(this, rJDataMsg, 0, objectArray, objectArray[0]);
                this.dispose();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                RJDataMsg rJDataMsg = RJCom.getMsg(this.m_DataControl, 8110, 5775);
                Object[] objectArray = new Object[]{RJComUty.CAPTION_MSG_OK};
                RJComDialog.show(this, rJDataMsg, 0, objectArray, objectArray[0]);
                this.setButton(true);
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
                RJDataMsg rJDataMsg = RJCom.getMsg(this.m_DataControl, 8110, 5634);
                Object[] objectArray = new Object[]{RJComUty.CAPTION_MSG_OK};
                RJComDialog.show(this, rJDataMsg, 0, objectArray, objectArray[0]);
                this.dispose();
            }
            catch (Exception exception) {}
        } else {
            RJDataMsg rJDataMsg = RJCom.getMsg(this.m_DataControl, nArray[0], nArray[1]);
            Object[] objectArray = new Object[]{RJComUty.CAPTION_MSG_OK};
            RJComDialog.show(this, rJDataMsg, 0, objectArray, objectArray[0]);
            this.dispose();
        }
        this.setButton(true);
        this.setCursor(new Cursor(0));
    }

    protected void onImport(ActionEvent actionEvent) {
        String string = "";
        int n = 0;
        int[] nArray = new int[]{0, 0};
        this.setCursor(new Cursor(3));
        this.setButton(false);
        if (this.chkMyLock() != 0) {
            this.setButton(true);
            this.setCursor(new Cursor(0));
            return;
        }
        try {
            this.ImportCheck(null);
        }
        catch (RJSPDFTCException rJSPDFTCException) {
            this.setButton(true);
            this.setCursor(new Cursor(0));
            return;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.m_strFilePath));
            if (bufferedReader != null && bufferedReader.ready()) {
                while ((string = bufferedReader.readLine()) != null) {
                    ++n;
                }
            }
            bufferedReader.close();
            FTFileData fTFileData = new FTFileData(n);
            bufferedReader = new BufferedReader(new FileReader(this.m_strFilePath));
            if (bufferedReader != null && bufferedReader.ready()) {
                int n2 = 0;
                while ((string = bufferedReader.readLine()) != null) {
                    fTFileData.strData[n2] = string;
                    ++n2;
                }
            }
            bufferedReader.close();
            RJSPDFTCDialog rJSPDFTCDialog = this;
            rJSPDFTCDialog.m_SPDGetData.WaitControl();
            this.m_DataControl.FTUpload(this.m_Function, fTFileData);
            this.m_DataControl.waitDC();
            ArrayList arrayList = this.m_DataControl.getEndStatus();
            Integer n3 = (Integer)arrayList.get(0);
            nArray[0] = n3;
            Integer n4 = (Integer)arrayList.get(1);
            nArray[1] = n4;
            if (nArray[0] != 0) {
                RJDataMsg rJDataMsg = RJCom.getMsg(this.m_DataControl, nArray[0], nArray[1]);
                Object[] objectArray = new Object[]{RJComUty.CAPTION_MSG_OK};
                RJComDialog.show(this, rJDataMsg, 0, objectArray, objectArray[0]);
                this.dispose();
            } else {
                this.setButton(true);
                this.setCursor(new Cursor(0));
                RJSPDFTCDialog.WriteSetting(this.m_FilePathText.getText());
                this.dispose();
                this.bEndStatus = true;
            }
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            RJDataMsg rJDataMsg = RJCom.getMsg(this.m_DataControl, 8110, 5634);
            Object[] objectArray = new Object[]{RJComUty.CAPTION_MSG_OK};
            RJComDialog.show(this, rJDataMsg, 0, objectArray, objectArray[0]);
            this.dispose();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            RJDataMsg rJDataMsg = RJCom.getMsg(this.m_DataControl, 8110, 5775);
            Object[] objectArray = new Object[]{RJComUty.CAPTION_MSG_OK};
            RJComDialog.show(this, rJDataMsg, 0, objectArray, objectArray[0]);
            this.setButton(true);
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            RJDataMsg rJDataMsg = RJCom.getMsg(this.m_DataControl, 8110, 5634);
            Object[] objectArray = new Object[]{RJComUty.CAPTION_MSG_OK};
            RJComDialog.show(this, rJDataMsg, 0, objectArray, objectArray[0]);
            this.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setCursor(new Cursor(0));
    }

    protected void ExportCheck(String string) throws RJSPDFTCException {
        Object object;
        boolean bl = true;
        boolean bl2 = false;
        int n = 0;
        String string2 = null;
        try {
            Object object2;
            string2 = string == null ? this.getClientFilePath() : string;
            this.m_strFilePath = string2.trim();
            int n2 = this.m_strFilePath.length();
            if (n2 >= 4) {
                if (!this.m_strFilePath.substring(n2 - 4, n2).equalsIgnoreCase(".spd")) {
                    this.m_strFilePath = this.m_strFilePath + ".spd";
                }
            } else {
                this.m_strFilePath = this.m_strFilePath + ".spd";
            }
            File file = new File(this.m_strFilePath);
            n2 = this.m_strFilePath.length();
            if (n2 > 255) {
                bl = false;
                n = 5633;
            } else {
                object = file.getName();
                n2 = ((String)object).length();
                if (n2 > 32) {
                    bl = false;
                    n = 5627;
                } else {
                    object2 = "";
                    File file2 = null;
                    int n3 = string2.lastIndexOf("\\");
                    if (n3 > 0 && !(file2 = new File((String)(object2 = string2.substring(0, n3)))).isDirectory()) {
                        if (string == null) {
                            bl = false;
                            n = 5773;
                        } else {
                            bl = false;
                            n = 5628;
                        }
                    }
                    if (bl && (n3 = string2.lastIndexOf("/")) > 0 && !(file2 = new File((String)(object2 = string2.substring(0, n3)))).isDirectory()) {
                        if (string == null) {
                            bl = false;
                            n = 5773;
                        } else {
                            bl = false;
                            n = 5628;
                        }
                    }
                    for (int i = 0; i < n2 && bl; ++i) {
                        char c = ((String)object).charAt(i);
                        if (c != '\"' && c != '\\' && c != '/' && c != ':' && c != ',' && c != ';' && c != '*' && c != '?' && c != '<' && c != '>' && c != '|' && c != ' ') continue;
                        bl = false;
                        n = 5628;
                        break;
                    }
                }
            }
            if (string == null && bl && file.exists()) {
                object = new Object[]{RJComUty.CAPTION_MSG_OK, RJComUty.CAPTION_MSG_CANCEL};
                object2 = RJCom.getMsg(this.m_DataControl, 8110, 59036);
                int n4 = RJComDialog.show(this, (RJDataMsg)object2, 0, (Object[])object, object[1]);
                if (n4 != 0) {
                    bl2 = true;
                } else if (!file.canWrite()) {
                    bl = false;
                    n = 5774;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("[SPREAD]:ExportCheck()ERROR:" + nullPointerException.getMessage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            RJDataMsg rJDataMsg = RJCom.getMsg(this.m_DataControl, 8110, n);
            object = new Object[]{RJComUty.CAPTION_MSG_OK};
            RJComDialog.show(this, rJDataMsg, 0, (Object[])object, object[0]);
            this.setButton(true);
            this.m_FilePathText.grabFocus();
            this.m_FilePathText.selectAll();
            throw new RJSPDFTCException();
        }
        if (bl2) {
            throw new RJSPDFTCException();
        }
    }

    protected void ImportCheck(String string) throws RJSPDFTCException {
        Object object;
        int n;
        boolean bl;
        block14: {
            bl = true;
            n = 0;
            String string2 = null;
            try {
                string2 = string == null ? this.getClientFilePath() : string;
                this.m_strFilePath = string2.trim();
                int n2 = this.m_strFilePath.length();
                if (n2 >= 4) {
                    if (!this.m_strFilePath.substring(n2 - 4, n2).equalsIgnoreCase(".spd")) {
                        bl = false;
                        n = 5776;
                    }
                } else {
                    bl = false;
                    n = 5776;
                }
                if (!bl) break block14;
                File file = new File(this.m_strFilePath);
                n2 = this.m_strFilePath.length();
                if (n2 > 255) {
                    bl = false;
                    n = 5633;
                    break block14;
                }
                if (file != null && !file.exists()) {
                    bl = false;
                    n = 5629;
                    break block14;
                }
                if (file != null && !file.canRead()) {
                    bl = false;
                    n = 5630;
                    break block14;
                }
                if (file != null && !file.isFile()) {
                    bl = false;
                    n = 5631;
                    break block14;
                }
                object = file.getName();
                n2 = ((String)object).length();
                if (n2 > 32) {
                    bl = false;
                    n = 5627;
                    break block14;
                }
                String string3 = "";
                File file2 = null;
                int n3 = string2.lastIndexOf("\\");
                if (n3 > 0 && !(file2 = new File(string3 = string2.substring(0, n3))).isDirectory() && string != null) {
                    bl = false;
                    n = 5628;
                }
                if (bl && (n3 = string2.lastIndexOf("/")) > 0 && !(file2 = new File(string3 = string2.substring(0, n3))).isDirectory() && string != null) {
                    bl = false;
                    n = 5628;
                }
                for (int i = 0; i < n2 && bl; ++i) {
                    char c = ((String)object).charAt(i);
                    if (c != '\"' && c != '\\' && c != '/' && c != ':' && c != ',' && c != ';' && c != '*' && c != '?' && c != '<' && c != '>' && c != '|' && c != ' ') continue;
                    bl = false;
                    n = 5628;
                    break;
                }
            }
            catch (Exception exception) {
                System.out.println("[SPREAD]:ImportCheck()ERROR:" + exception.getMessage());
            }
        }
        if (!bl) {
            RJDataMsg rJDataMsg = RJCom.getMsg(this.m_DataControl, 8110, n);
            object = new Object[]{RJComUty.CAPTION_MSG_OK};
            RJComDialog.show(this, rJDataMsg, 0, (Object[])object, object[0]);
            this.setButton(true);
            this.m_FilePathText.grabFocus();
            this.m_FilePathText.selectAll();
            throw new RJSPDFTCException();
        }
    }

    public String getClientFilePath() {
        return new String(this.m_FilePathText.getText());
    }

    public void setClientFilePath(String string) {
        this.m_FilePathText.setText(string);
    }

    public void setButton(boolean bl) {
        if (bl) {
            this.m_FilePathText.setEnabled(true);
            this.filterPanel.m_ReferenceBtn.setEnabled(true);
            this.m_ImpExpBtn.setEnabled(true);
            this.m_ExitBtn.setEnabled(true);
            System.gc();
        } else {
            this.m_FilePathText.setEnabled(false);
            this.filterPanel.m_ReferenceBtn.setEnabled(false);
            this.m_ImpExpBtn.setEnabled(false);
            this.m_ExitBtn.setEnabled(false);
        }
    }

    protected void setBtnEnabled() {
        String string = this.getClientFilePath();
        if (string == null || string.equals("")) {
            this.m_ImpExpBtn.setEnabled(false);
        } else {
            this.m_ImpExpBtn.setEnabled(true);
        }
    }

    private String setDefaultFileName(String string) {
        return this.filterPanel.setDefaultFileName(string);
    }

    public int chkMyLock() {
        boolean bl = false;
        int[] nArray = new int[]{0, 0};
        int n = 0;
        RJSPDFTCDialog rJSPDFTCDialog = this;
        rJSPDFTCDialog.m_SPDGetData.WaitControl();
        this.m_DataControl.getSetStatusEx();
        this.m_DataControl.waitDC();
        ArrayList arrayList = this.m_DataControl.getEndStatus();
        nArray[0] = (Integer)arrayList.get(0);
        nArray[1] = (Integer)arrayList.get(1);
        if (nArray[0] == 0) {
            bl = this.m_DataControl.IsMyLock();
            System.out.println("[SPREAD]:chkUserLock() IsMyLock call bLockUser:" + bl);
            if (!bl) {
                RJDataMsg rJDataMsg = RJCom.getMsg(this.m_DataControl, 8110, 5772);
                Object[] objectArray = new Object[]{RJComUty.CAPTION_MSG_OK};
                RJComDialog.show(this, rJDataMsg, 0, objectArray, objectArray[0]);
                n = rJDataMsg.getErrorLevel();
                this.dispose();
            }
        } else {
            RJDataMsg rJDataMsg = RJCom.getMsg(this.m_DataControl, nArray[0], nArray[1]);
            Object[] objectArray = new Object[]{RJComUty.CAPTION_MSG_OK};
            RJComDialog.show(this, rJDataMsg, 0, objectArray, objectArray[0]);
            n = rJDataMsg.getErrorLevel();
            this.dispose();
        }
        return n;
    }

    protected void initInstance() {
        JPanel jPanel;
        JPanel jPanel2;
        this.dialogName = this.getDialogName();
        if (this.dialogName != null) {
            this.setTitle(RJcGuide.text(this.dialogName + "DlgTitle"));
        }
        JPanel jPanel3 = new JPanel(new BorderLayout());
        Border border = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        jPanel3.setBackground(RJcGuide.color("SPREAD/FilterBgClr"));
        jPanel3.setBorder(border);
        JPanel jPanel4 = new JPanel(new BorderLayout(8, 4));
        Border border2 = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        jPanel4.setBorder(border2);
        jPanel4.setBackground(RJcGuide.color("SPREAD/FilterBgClr"));
        JPanel jPanel5 = this.createNorthComponent();
        if (jPanel5 != null) {
            jPanel4.add((Component)jPanel5, "North");
        }
        if ((jPanel2 = this.createCenterComponent()) != null) {
            jPanel4.add((Component)jPanel2, "Center");
        }
        if ((jPanel = this.createSouthComponent()) != null) {
            if (jPanel instanceof RJcSouthPanel) {
                ((RJcSouthPanel)jPanel).arrangeSouthPanel();
            }
            jPanel4.add((Component)jPanel, "South");
        }
        jPanel3.add((Component)jPanel4, "Center");
        this.getContentPane().add(jPanel3);
        this.setSize(this.filterPanel.getDimension());
    }

    protected JPanel createNorthComponent() {
        RJcDlgMainTitlePanel rJcDlgMainTitlePanel = new RJcDlgMainTitlePanel(null);
        rJcDlgMainTitlePanel.setMainTitle(this.getDialogName());
        rJcDlgMainTitlePanel.setBackground(RJcGuide.color("SPREAD/FilterBgClr"));
        return rJcDlgMainTitlePanel;
    }

    protected JPanel createSouthComponent() {
        RJcSouthPanel rJcSouthPanel = new RJcSouthPanel();
        rJcSouthPanel.setBackground(RJcGuide.color("SPREAD/FilterBgClr"));
        this.m_ExitBtn = this.newButton("SPREAD/ExitBtn");
        this.m_ExitBtn.setToolTipText(RJcGuide.text("SPREAD/ExitBtnTip"));
        this.m_ExitBtn.setBackground(this.getBackgroundColor());
        this.m_ExitBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RJSPDFTCDialog.this.OnExit(actionEvent);
            }
        });
        if (this.m_Kind == 2) {
            this.setTitle(RJcGuide.text("SPREAD/DlgTitleImport"));
            this.m_ImpExpBtn = this.newButton("SPREAD/ImportBtn");
            this.m_ImpExpBtn.setToolTipText(RJcGuide.text("SPREAD/ImportBtnTip"));
            this.m_ImpExpBtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    RJSPDFTCDialog.this.onImport(actionEvent);
                }
            });
        } else {
            this.setTitle(RJcGuide.text("SPREAD/DlgTitleExport"));
            this.m_ImpExpBtn = this.newButton("SPREAD/ExportBtn");
            this.m_ImpExpBtn.setToolTipText(RJcGuide.text("SPREAD/ExportBtnTip"));
            this.m_ImpExpBtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    RJSPDFTCDialog.this.onExport(actionEvent);
                }
            });
        }
        this.m_ImpExpBtn.setBackground(this.getBackgroundColor());
        rJcSouthPanel.addComponent(this.m_ImpExpBtn, 0);
        rJcSouthPanel.addComponent(this.m_ExitBtn, 0);
        return rJcSouthPanel;
    }

    public String getDialogName() {
        return this.filterPanel.getDialogName();
    }

    public Point getDialogLocation() {
        Point point = this.calcDialogLocation();
        return point;
    }

    protected Point calcDialogLocation() {
        Point point = null;
        Window window = this.getOwner();
        if (window != null) {
            Point point2 = window.getLocationOnScreen();
            Dimension dimension = window.getSize();
            Dimension dimension2 = this.getSize();
            point2.x += (dimension.width - dimension2.width) / 2;
            point2.y += (dimension.height - dimension2.height) / 2;
            point = new Point(point2);
        } else {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension3 = this.getSize();
            if (dimension3.height > dimension.height) {
                dimension3.height = dimension.height;
            }
            if (dimension3.width > dimension.width) {
                dimension3.width = dimension.width;
            }
            point = new Point((dimension.width - dimension3.width) / 2, (dimension.height - dimension3.height) / 2);
        }
        return point;
    }

    protected Color getBorderColor() {
        Color color = RJcAbsGuideConst.stdBgClr;
        return color;
    }

    protected Color getBackgroundColor() {
        Color color = RJcAbsGuideConst.stdBgClr;
        return color;
    }

    public JButton newButton(String string) {
        RJcButton rJcButton = new RJcButton(string);
        rJcButton.setFont(RJcConst.boldFont);
        rJcButton.setActionCommand(string);
        rJcButton.setName(string);
        Dimension dimension = rJcButton.getPreferredSize();
        dimension.height = 24;
        if (dimension.width < 80) {
            dimension.width = 80;
        }
        rJcButton.setPreferredSize(new Dimension(dimension.width, dimension.height));
        rJcButton.setMinimumSize(new Dimension(dimension.width, dimension.height));
        return rJcButton;
    }
}

