/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.sanproject.data;

import com.hitachi.sanproject.data.SanAttrs;
import com.hitachi.sanproject.data.SanClass;
import com.hitachi.sanproject.data.SanClassImpl;
import com.hitachi.sanproject.data.SanDataErrorCode;
import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanDataNode;
import com.hitachi.sanproject.data.SanObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class SanList
implements SanClass,
SanDataNode,
Iterable<SanObject>,
Serializable {
    private static final long serialVersionUID = 7163350371239564417L;
    protected SanClassImpl clazz;
    protected SanDataNode parentDataNode;
    protected ArrayList<SanObject> list;

    protected SanList() {
    }

    protected SanList(SanDataNode sanDataNode, SanClassImpl sanClassImpl) {
        this.clazz = sanClassImpl;
        this.parentDataNode = sanDataNode;
        this.list = new ArrayList();
    }

    protected SanList(SanDataNode sanDataNode, SanClassImpl sanClassImpl, int n) {
        this.clazz = sanClassImpl;
        this.parentDataNode = sanDataNode;
        this.list = new ArrayList(n);
    }

    protected SanList clone(SanDataNode sanDataNode) {
        SanList sanList = new SanList();
        sanList.clazz = this.clazz;
        sanList.parentDataNode = sanDataNode;
        sanList.list = new ArrayList(this.list.size());
        for (SanObject sanObject : this.list) {
            if (sanObject == null) {
                sanList.list.add(null);
                continue;
            }
            sanList.list.add(sanObject.clone(sanList));
        }
        return sanList;
    }

    @Override
    public int index() {
        return this.clazz.index();
    }

    @Override
    public String key() {
        return this.clazz.key();
    }

    @Override
    public String type() {
        return this.clazz.type();
    }

    @Override
    public SanAttrs attrs() {
        return this.clazz.attrs();
    }

    @Override
    public Object attr(String string) throws SanDataException {
        return this.clazz.attr(string);
    }

    @Override
    public SanClass parentClass() {
        return this.clazz.parentClass();
    }

    @Override
    public String path() {
        return this.clazz.path();
    }

    @Override
    public int memberIndex(String string) throws SanDataException {
        return this.clazz.memberIndex(string);
    }

    @Override
    public SanClass memberClass(int n) {
        return this.clazz.memberClass(n);
    }

    @Override
    public SanClass memberClass(String string) throws SanDataException {
        return this.clazz.memberClass(string);
    }

    @Override
    public int numberOfMembers() {
        return this.clazz.numberOfMembers();
    }

    @Override
    public List<String> memberKeyList() {
        return this.clazz.memberKeyList();
    }

    @Override
    public List<SanClass> memberClassList() {
        return this.clazz.memberClassList();
    }

    protected void optimizeMemoryUsage() {
        this.list.trimToSize();
        for (SanObject sanObject : this.list) {
            sanObject.optimizeMemoryUsage();
        }
    }

    public int hashCode() {
        return this.list.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SanList)) {
            return false;
        }
        SanList sanList = (SanList)object;
        return this.list.equals(sanList.list);
    }

    @Override
    public SanDataNode parentDataNode() {
        return this.parentDataNode;
    }

    protected void connectParentObjNode(ArrayList<String> arrayList) {
        SanDataNode sanDataNode = this.parentDataNode();
        if (sanDataNode instanceof SanObject) {
            ((SanObject)sanDataNode).connectParentObjNode(arrayList);
        } else if (sanDataNode instanceof SanList) {
            ((SanList)sanDataNode).connectParentObjNode(arrayList);
        }
    }

    @Override
    public String objPath() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.key());
        this.connectParentObjNode(arrayList);
        StringBuilder stringBuilder = null;
        ListIterator<String> listIterator = arrayList.listIterator(arrayList.size());
        while (listIterator.hasPrevious()) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(256);
            } else {
                stringBuilder.append(".");
            }
            String string = listIterator.previous();
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public SanObject getObj(int n) {
        return this.list.get(n);
    }

    public SanObject addObj() throws SanDataException {
        if (this.list.size() >= this.getMaxSize()) {
            throw SanDataErrorCode.newException(SanDataErrorCode.LIST_SIZE_OUT_OF_BOUNDS, String.format("addObj(){key=%s}", this.objPath()));
        }
        SanObject sanObject = new SanObject(this, this.clazz);
        this.list.add(sanObject);
        return sanObject;
    }

    public SanObject addObj(int n) throws SanDataException {
        if (this.list.size() >= this.getMaxSize()) {
            throw SanDataErrorCode.newException(SanDataErrorCode.LIST_SIZE_OUT_OF_BOUNDS, String.format("addObj(int index){key=%s}", this.objPath()));
        }
        SanObject sanObject = new SanObject(this, this.clazz);
        this.list.add(n, sanObject);
        return sanObject;
    }

    protected int getMaxSize() throws SanDataException {
        int n = Integer.MAX_VALUE;
        Integer n2 = (Integer)this.attrs().get(0);
        if (n2 != null) {
            n = n2;
        }
        return n;
    }

    public SanObject remove(int n) {
        return this.list.remove(n);
    }

    public boolean remove(SanObject sanObject) {
        return this.list.remove(sanObject);
    }

    public void clear() {
        this.list.clear();
    }

    public int indexOf(SanObject sanObject) {
        return this.list.indexOf(sanObject);
    }

    public int lastIndexOf(SanObject sanObject) {
        return this.list.lastIndexOf(sanObject);
    }

    public boolean contains(SanObject sanObject) {
        return this.list.contains(sanObject);
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public void ensureCapacity(int n) {
        this.list.ensureCapacity(n);
    }

    public SanObject removeAndAddObj(int n) {
        SanObject sanObject = new SanObject(this, this.clazz);
        this.list.set(n, sanObject);
        return sanObject;
    }

    public int size() {
        return this.list.size();
    }

    public void trimToSize() {
        this.list.trimToSize();
    }

    @Override
    public Iterator<SanObject> iterator() {
        return this.list.iterator();
    }

    public Iterator<SanObject> listiterator() {
        return this.list.listIterator();
    }

    public Iterator<SanObject> listiterator(int n) {
        return this.list.listIterator(n);
    }
}

