/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class RJDGDDeviceListTable
extends RJDGDBaseTable {
    private static final String CLASSNAME = "RJDGDDeviceListTable";
    private static String[] m_sarHeaderKeys = new String[]{"STRING_TAH_LDEV", "STRING_TAH_ATTRIBUTE", "STRING_TAH_TYPE", "STRING_TAH_CAPACITY", "STRING_TAH_VTOCAREA"};

    public static void main(String[] stringArray) {
        RJDGDDeviceListTable rJDGDDeviceListTable = new RJDGDDeviceListTable();
        RJDGDTableScrollPane rJDGDTableScrollPane = new RJDGDTableScrollPane(rJDGDDeviceListTable);
        rJDGDTableScrollPane.setPreferredSize(new Dimension(400, 300));
        RJDGDBasePanel rJDGDBasePanel = new RJDGDBasePanel();
        rJDGDBasePanel.setLayout(new BorderLayout());
        rJDGDBasePanel.add((Component)rJDGDTableScrollPane, "Center");
        JFrame jFrame = new JFrame("UnitTest Window(RJDGDDeviceListTable)");
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().add(rJDGDBasePanel);
        jFrame.pack();
        jFrame.show();
    }

    public RJDGDDeviceListTable() {
        this.initInstance();
    }

    public void setModel(TableModel tableModel) {
        this.setAutoCreateColumnsFromModel(true);
        super.setModel(tableModel);
        this.setAutoCreateColumnsFromModel(false);
    }

    public void refreshData(Object object, int n) throws RJDGDRefreshDataException {
        DeviceListTableModel deviceListTableModel = (DeviceListTableModel)this.getModel();
        deviceListTableModel.refreshData(object, n);
    }

    public int[] getSelectedLDEVNumbers() {
        int[] nArray = this.getSelectedRows();
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            RJDGDLDEVObject rJDGDLDEVObject = (RJDGDLDEVObject)this.getValueAt(n2, 0);
            RJDGDLdev rJDGDLdev = rJDGDLDEVObject.getLDEVInformation();
            nArray2[n] = rJDGDLdev.getLdev();
            ++n;
        }
        return nArray2;
    }

    public synchronized void setSelectionLDEVs(int[] nArray) {
        this.clearSelection();
        if (nArray != null) {
            HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>(350);
            int n = 0;
            while (n < nArray.length) {
                Integer n2 = new Integer(nArray[n]);
                hashMap.put(n2, n2);
                ++n;
            }
            int n3 = this.getRowCount();
            int n4 = 0;
            while (n4 < n3) {
                RJDGDLDEVObject rJDGDLDEVObject = (RJDGDLDEVObject)this.getValueAt(n4, 0);
                RJDGDLdev rJDGDLdev = rJDGDLDEVObject.getLDEVInformation();
                int n5 = rJDGDLdev.getLdev();
                if (hashMap.containsKey(new Integer(n5))) {
                    this.addRowSelectionInterval(n4, n4);
                }
                ++n4;
            }
        }
    }

    protected Object[] getColumnNames() {
        Object[] objectArray = new Object[m_sarHeaderKeys.length];
        int n = 0;
        while (n < m_sarHeaderKeys.length) {
            String string = m_sarHeaderKeys[n];
            objectArray[n] = RJDGDGuidanceManager.getString(string);
            ++n;
        }
        return objectArray;
    }

    protected Color[] getColumnHeaderColors() {
        Color[] colorArray = new Color[m_sarHeaderKeys.length];
        int n = 0;
        while (n < m_sarHeaderKeys.length) {
            String string = m_sarHeaderKeys[n];
            colorArray[n] = RJDGDGuidanceManager.getColor(string);
            ++n;
        }
        return colorArray;
    }

    protected int[] getColumnWidths() {
        return new int[]{70, 110, 100, 100, 210};
    }

    protected int[] getColumnHorizontalAlignments() {
        return new int[]{2, 0, 0, 4, 4};
    }

    protected TableModel getUsedTableModel() {
        Object[] objectArray = this.getColumnNames();
        return new DeviceListTableModel(objectArray);
    }

    protected TableCellRenderer getDefaultCellRenderer() {
        return new DeviceListTableCellRenderer();
    }

    protected void finalize() throws Throwable {
        RJDGDLogManager.putLog(1, this.getClass().getName() + ":" + CLASSNAME, "++++++++++++++++    finalize( )    ++++++++++++++++");
        super.finalize();
    }

    private void initInstance() {
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        int[] nArray = this.getColumnWidths();
        int n2 = 0;
        while (n2 < n && n2 < nArray.length) {
            TableColumn tableColumn = tableColumnModel.getColumn(n2);
            tableColumn.setPreferredWidth(nArray[n2]);
            tableColumn.setHeaderRenderer(new DeviceListTableHeaderRenderer());
            ++n2;
        }
    }

    protected class DeviceListTableHeaderRenderer
    implements TableCellRenderer {
        private static final String CLASSNAME = "RJDGDDeviceListTable.DeviceListTableHeaderRenderer";

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = new JLabel();
            if (object != null) {
                Serializable serializable;
                JTableHeader jTableHeader = jTable.getTableHeader();
                if (jTableHeader instanceof RJDGDBaseTableHeader) {
                    serializable = (RJDGDBaseTableHeader)jTableHeader;
                    TableCellRenderer tableCellRenderer = ((RJDGDBaseTableHeader)serializable).getDefaultHeaderRenderer();
                    jLabel = (JLabel)tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                } else {
                    jLabel = new JLabel(object.toString());
                    jLabel.setOpaque(true);
                    jLabel.setForeground(RJDGDGuidanceManager.DEFAULT_STRING_COLOR);
                    jLabel.setBackground(jTableHeader.getBackground());
                    jLabel.setFont(jTableHeader.getFont());
                    jLabel.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                    jLabel.setHorizontalAlignment(0);
                }
                Color[] colorArray = RJDGDDeviceListTable.this.getColumnHeaderColors();
                if (colorArray != null && colorArray.length >= n2) {
                    serializable = RJDGDGuidanceManager.DEFAULT_STRING_COLOR;
                    if (colorArray[n2].getRGB() != ((Color)serializable).getRGB()) {
                        jLabel.setForeground(colorArray[n2]);
                    }
                }
            }
            return jLabel;
        }
    }

    protected class DeviceListTableCellRenderer
    extends RJDGDDefaultTableCellRenderer {
        private static final String CLASSNAME = "RJDGDDeviceListTable.DeviceListTableCellRenderer";

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object != null) {
                Object object2;
                Object object3;
                if (object instanceof RJDGDLDEVObject) {
                    object3 = (RJDGDLDEVObject)object;
                    if (((RJDGDLDEVObject)object3).isModified()) {
                        jLabel.setFont(RJDGDDefine.FONT_CHANGE);
                        if (jTable.hasFocus() && bl) {
                            jLabel.setForeground(RJDGDBaseRenderer.m_clrSelectedText);
                        } else if (bl) {
                            jLabel.setForeground(RJDGDBaseRenderer.m_clrNoFocusPresetText);
                        } else {
                            jLabel.setForeground(RJDGDBaseRenderer.m_clrPresetText);
                        }
                    } else if (!bl) {
                        object2 = ((RJDGDLDEVObject)object3).getForeground();
                        Color color = RJDGDGuidanceManager.DEFAULT_STRING_COLOR;
                        if (((Color)object2).getRGB() != color.getRGB()) {
                            jLabel.setForeground((Color)object2);
                        }
                    }
                }
                if (n2 == 0) {
                    Icon icon;
                    if (object instanceof RJDGDLDEVObject) {
                        object3 = (RJDGDLDEVObject)object;
                        object2 = ((RJDGDLDEVObject)object3).getLDEVInformation();
                        icon = RJDGDUtilities.convertToIconAttribute(((RJDGDLdev)object2).getGuard());
                    } else {
                        object3 = "images/LDEVGuard_Dummy.gif";
                        icon = RJDGDIconManager.getIcon((String)object3);
                    }
                    jLabel.setIcon(icon);
                }
                object2 = "STRING_DAT_NODATA";
                object3 = RJDGDGuidanceManager.getString((String)object2);
                int[] nArray = RJDGDDeviceListTable.this.getColumnHorizontalAlignments();
                if (nArray != null && nArray.length >= n2) {
                    if (((String)object3).equals(object.toString())) {
                        jLabel.setHorizontalAlignment(0);
                    } else {
                        jLabel.setHorizontalAlignment(nArray[n2]);
                    }
                }
            }
            return jLabel;
        }
    }

    protected class DeviceListTableModel
    extends RJDGDBaseTableModel {
        private static final String CLASSNAME = "RJDGDDeviceListTable.DeviceListTableModel";
        private volatile int m_iSortMode;

        public DeviceListTableModel(Object[] objectArray) {
            super(objectArray);
        }

        public void refreshData() throws RJDGDRefreshDataException {
            Runnable runnable = new Runnable(this){
                private final /* synthetic */ DeviceListTableModel this$1;
                {
                    this.this$1 = deviceListTableModel;
                }

                public void run() {
                    this.this$1.removeAllRows();
                }
            };
            SwingUtilities.invokeLater(runnable);
        }

        public void refreshData(Object object, int n) throws RJDGDRefreshDataException {
            RJDGDLogManager.putLog(0, this.getClass().getName() + ":" + CLASSNAME, "Call refreshData( ) [" + object + ", " + n + "]");
            this.refreshData();
            if (object != null) {
                try {
                    RJDGDGuardPattern rJDGDGuardPattern;
                    RJDGDLdev[] rJDGDLdevArray;
                    if (object instanceof RJDGDGuardPattern && (rJDGDLdevArray = (rJDGDGuardPattern = (RJDGDGuardPattern)object).getLdevs(n)) != null) {
                        int n2 = 0;
                        while (n2 < rJDGDLdevArray.length) {
                            Object[] objectArray;
                            RJDGDLdev rJDGDLdev = rJDGDLdevArray[n2];
                            Object[] objectArray2 = objectArray = new Object[]{new RJDGDLDEVObject(rJDGDLdev, 0), new RJDGDLDEVObject(rJDGDLdev, 1), new RJDGDLDEVObject(rJDGDLdev, 2), new RJDGDLDEVObject(rJDGDLdev, 3), new RJDGDLDEVObject(rJDGDLdev, 4)};
                            Runnable runnable = new Runnable(this, objectArray2){
                                private final /* synthetic */ Object[] val$newRowData;
                                private final /* synthetic */ DeviceListTableModel this$1;
                                {
                                    this.this$1 = deviceListTableModel;
                                    this.val$newRowData = objectArray;
                                }

                                public void run() {
                                    this.this$1.addRow(this.val$newRowData);
                                }
                            };
                            SwingUtilities.invokeLater(runnable);
                            ++n2;
                        }
                    }
                }
                catch (RJDGDException rJDGDException) {
                    throw new RJDGDRefreshDataException(rJDGDException);
                }
                catch (Exception exception) {
                    throw new RJDGDRefreshDataException(exception.getMessage());
                }
            }
        }

        public boolean isNumericColumn(int n) {
            return false;
        }

        public synchronized void doSort(int n) {
            int[] nArray = RJDGDDeviceListTable.this.getSelectedLDEVNumbers();
            if (n != 3) {
                super.doSort(n);
                this.m_iSortMode = -1;
            } else {
                int n2;
                Object object;
                int n3;
                Object object2;
                Vector<Object> vector;
                RJDGDDataSorter rJDGDDataSorter = RJDGDUtilities.createDataSorter();
                Vector<Vector> vector2 = this.getDataVector();
                Iterator iterator = ((AbstractList)vector2).iterator();
                while (iterator.hasNext()) {
                    vector = (Vector<Object>)iterator.next();
                    Object e = vector.get(n);
                    if (e instanceof RJDGDLDEVObject) {
                        object2 = (RJDGDLDEVObject)e;
                        RJDGDLdev rJDGDLdev = ((RJDGDLDEVObject)object2).getLDEVInformation();
                        n3 = rJDGDLdev.getCapacity();
                        object = String.valueOf(n3);
                    } else {
                        object = e.toString();
                    }
                    rJDGDDataSorter.add(object, vector);
                }
                if (rJDGDDataSorter instanceof RJDGDDefaultDataSorter) {
                    object = (RJDGDDefaultDataSorter)rJDGDDataSorter;
                    boolean bl = true;
                    ((RJDGDDefaultDataSorter)object).setCompareType(bl);
                }
                n2 = (n2 = this.m_iSortMode) == 1 ? -1 : 1;
                this.m_iSortMode = n2;
                rJDGDDataSorter.setSortMode(n2);
                rJDGDDataSorter.executeSort();
                vector = new Vector<Object>(0);
                int n4 = rJDGDDataSorter.size();
                n3 = 0;
                while (n3 < n4) {
                    object2 = rJDGDDataSorter.get(n3);
                    vector.add(object2);
                    ++n3;
                }
                Vector<String> vector3 = new Vector<String>(0);
                n3 = this.getColumnCount();
                int n5 = 0;
                while (n5 < n3) {
                    vector3.add(this.getColumnName(n5));
                    ++n5;
                }
                this.setDataVector(vector, vector3);
            }
            RJDGDDeviceListTable.this.setSelectionLDEVs(nArray);
        }
    }

    public class RJDGDLDEVObject
    implements Serializable {
        private static final String CLASSNAME = "RJDGDDeviceListTable.RJDGDLDEVObject";
        public static final int VIEW_LDEV = 0;
        public static final int VIEW_ATTRIBUTE = 1;
        public static final int VIEW_TYPE = 2;
        public static final int VIEW_CAPACITY = 3;
        public static final int VIEW_VTOC = 4;
        private volatile int m_iViewIndex;
        private RJDGDLdev m_clsLDEV;
        private Color m_clrForeColor;

        public RJDGDLDEVObject(RJDGDLdev rJDGDLdev, int n) {
            this.m_clsLDEV = rJDGDLdev;
            this.m_iViewIndex = n;
        }

        public RJDGDLdev getLDEVInformation() {
            return this.m_clsLDEV;
        }

        public String toString() {
            String string = null;
            if (this.m_clsLDEV != null) {
                switch (this.m_iViewIndex) {
                    case 0: {
                        int n = this.m_clsLDEV.getLdev();
                        string = RJDGDUtilities.convertToHexString(n, 2);
                        break;
                    }
                    case 1: {
                        byte by = this.m_clsLDEV.getGuard();
                        string = RJDGDUtilities.convertToStringAttribute(by);
                        this.setForeground(RJDGDUtilities.convertToStringColorAttribute(by));
                        break;
                    }
                    case 2: {
                        Color color;
                        String string2 = "STRING_DAT_NODATA";
                        String string3 = RJDGDGuidanceManager.getString(string2);
                        string = this.m_clsLDEV.getEmulation();
                        if (!string.equals(string3) || (color = RJDGDGuidanceManager.getColor(string2)).getRGB() == RJDGDGuidanceManager.DEFAULT_STRING_COLOR.getRGB()) break;
                        this.setForeground(color);
                        break;
                    }
                    case 3: {
                        int n = this.m_clsLDEV.getCapacity();
                        if (n == -1) {
                            String string4 = "STRING_DAT_NODATA";
                            string = RJDGDGuidanceManager.getString(string4);
                            Color color = RJDGDGuidanceManager.getColor(string4);
                            if (color.getRGB() == RJDGDGuidanceManager.DEFAULT_STRING_COLOR.getRGB()) break;
                            this.setForeground(color);
                            break;
                        }
                        DecimalFormat decimalFormat = new DecimalFormat();
                        string = decimalFormat.format(n) + " Cyl";
                        break;
                    }
                    case 4: {
                        Color color;
                        Object object = "STRING_DAT_NODATA";
                        String string5 = RJDGDGuidanceManager.getString((String)object);
                        byte by = this.m_clsLDEV.getGuard();
                        if (by == -126) {
                            object = this.m_clsLDEV.getVtoc();
                            string = ((RJDGDVtocArea)object).toString();
                        } else {
                            string = string5;
                        }
                        if (!string.equals(string5) || (color = RJDGDGuidanceManager.getColor((String)(object = "STRING_DAT_NODATA"))).getRGB() == RJDGDGuidanceManager.DEFAULT_STRING_COLOR.getRGB()) break;
                        this.setForeground(color);
                        break;
                    }
                    default: {
                        string = super.toString();
                    }
                }
            }
            return string;
        }

        public void doChangeAttribute(byte by) {
            this.m_clsLDEV.setGuard(by);
        }

        public boolean canChangeAttribute() {
            return this.m_clsLDEV.canChgAttribute();
        }

        public boolean canEditVTOCArea() {
            return this.m_clsLDEV.canChgVtoc();
        }

        public boolean isModified() {
            return this.m_clsLDEV.isModify();
        }

        public void setForeground(Color color) {
            this.m_clrForeColor = color;
        }

        public Color getForeground() {
            Color color = null;
            color = this.m_clrForeColor == null ? RJDGDGuidanceManager.DEFAULT_STRING_COLOR : this.m_clrForeColor;
            return color;
        }
    }
}

