/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.cache;

import com.hitachi.smi.cache.AbstractVersionChecker;
import com.hitachi.smi.cache.CacheUpdater;
import com.hitachi.smi.common.DeviceNumberAOUProcessor;
import com.hitachi.smi.common.RMIObjectMapping;
import java.rmi.RemoteException;
import java.util.logging.Level;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_AOUVerAllLDEV;
import sanproject.common.Robj_interface_VerLeaf;
import sanproject.serverux.data.GetRmiException;
import sanproject.serverux.data.SANRmiException;

public class AOUVolInfoVersionChecker
extends AbstractVersionChecker {
    private Robj_interface_AOUVerAllLDEV prior;

    protected AOUVolInfoVersionChecker(String serialNum) {
        super(serialNum);
        CacheUpdater.registerVersionChecker(CacheUpdater.ConfVerID.THIN_PROVISION, this);
    }

    @Override
    public void checkVersionDetails(Robj_interface_VerLeaf[] currentChildren, Robj_interface_VerLeaf[] prevChildren) {
        boolean shouldUpdate = false;
        Robj_interface_AOUVerAllLDEV current = (Robj_interface_AOUVerAllLDEV)currentChildren[0];
        this.prior = (Robj_interface_AOUVerAllLDEV)prevChildren[0];
        if (current.getNVer() != this.prior.getNVer() || this.prior.getNSummaryVer() != current.getNSummaryVer()) {
            mLogger.info("Detected change in AOU Volume Info");
            shouldUpdate = true;
        }
        if (shouldUpdate) {
            try {
                DeviceNumberAOUProcessor.cache(RMIObjectMapping.getRMIObjectMapping(this.getSerialNumber()), true);
            }
            catch (RemoteException | WBEMException | GetRmiException | SANRmiException e) {
                mLogger.log(Level.SEVERE, "Error getting AOU Vol Info from " + this.getSerialNumber(), e);
            }
        }
    }
}

