/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.cache;

import com.hitachi.smi.cache.CachedObject;
import com.hitachi.smi.cache.HitachiCacheInterface;
import com.hitachi.smi.cache.TraceManager;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderProperties;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wbem.WBEMException;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;

class HitachiCache
implements HitachiCacheInterface {
    private static final String EHCACHE_XML = "ehcache.xml";
    private static final String EXCEPTION_TYPE = "Cached item was not of the expected type. Expected: %s got %s";
    private Cache theCache;
    private static final Logger mLogger = Logger.getLogger("com.hitachi.smis.logger.cache");
    private static CacheManager cacheManager = CacheManager.create((String)(ProviderConstants.getConfigDirectory() + "ehcache.xml"));
    private static Map<String, HitachiCache> theCaches = new Hashtable<String, HitachiCache>();

    protected static void dump() {
        String[] cacheNames;
        new TraceManager("CacheData", "CacheContents");
        Logger log = Logger.getLogger("CacheData");
        for (String name : cacheNames = cacheManager.getCacheNames()) {
            Cache cache = cacheManager.getCache(name);
            if (cache != null) {
                StringBuilder msg = new StringBuilder("\n");
                List keys = cache.getKeys();
                for (Object key : keys) {
                    if (key instanceof String) {
                        msg.append((String)key);
                    } else if (key instanceof Class) {
                        Class clz = (Class)key;
                        msg.append(clz.getSimpleName());
                    }
                    msg.append('\n');
                }
                log.severe(msg.toString());
                msg = null;
                msg = new StringBuilder("\n");
                for (Object key : keys) {
                    Object[] items = new Object[]{};
                    Element cachedItem = cache.get(key);
                    if (cachedItem != null) {
                        CachedObject data = (CachedObject)cachedItem.getObjectValue();
                        items = data.getData();
                    }
                    msg.append("Key: " + key + " has " + items.length + " elements\n");
                }
                log.severe(msg.toString());
                continue;
            }
            log.log(Level.SEVERE, "{0} was null", name);
        }
    }

    public static String getCacheStatistics() {
        String[] cacheNames = cacheManager.getCacheNames();
        StringBuilder ret = new StringBuilder(cacheNames.length + " caches.\n");
        for (String name : cacheNames) {
            Cache cache = cacheManager.getCache(name);
            ret = ret.append(System.lineSeparator());
            ret = ret.append(name);
            ret = ret.append(":" + System.lineSeparator());
            if (cache == null) continue;
            ret = ret.append(cache.getStatistics().toString());
            ret = ret.append(System.lineSeparator());
        }
        return ret.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static HitachiCache getHitachiCache(String serialNum) {
        HitachiCache theCache = theCaches.get(serialNum);
        if (null == theCache) {
            Map<String, HitachiCache> map = theCaches;
            synchronized (map) {
                theCache = theCaches.get(serialNum);
                if (null == theCache) {
                    theCache = new HitachiCache(serialNum);
                    theCaches.put(serialNum, theCache);
                }
            }
        }
        return theCache;
    }

    public static long getMemoryUsage() {
        String[] cacheNames;
        long ret = 0L;
        for (String name : cacheNames = cacheManager.getCacheNames()) {
            Cache cache = cacheManager.getCache(name);
            ret += cache.calculateInMemorySize();
        }
        return ret;
    }

    private HitachiCache(String serialNum) {
        cacheManager.addCache(serialNum);
        this.theCache = cacheManager.getCache(serialNum);
        CacheConfiguration config = this.theCache.getCacheConfiguration();
        try {
            if (ProviderProperties.getCacheCreation()) {
                config.setDiskPersistent(true);
            }
        }
        catch (WBEMException e) {
            mLogger.log(Level.WARNING, "Exception getting cache persitance, defaulting to false", e);
        }
    }

    @Override
    public <T extends Serializable> void addCacheObject(Class<T[]> clz, List<T> obj) throws WBEMException {
        this.addCacheObject(null, obj, clz);
    }

    @Override
    public <T extends Serializable> void addCacheObject(String key, List<T> addList, Class<T[]> clzType) throws WBEMException {
        Element el;
        if (key != null) {
            mLogger.finest("Looking up key: " + key + " in cache");
            el = this.theCache.get((Serializable)((Object)key));
        } else {
            mLogger.finest("Looking up class: " + clzType + " in cache");
            el = this.theCache.get(clzType);
        }
        if (el != null) {
            CachedObject item = (CachedObject)el.getObjectValue();
            item.addData(addList, clzType);
            mLogger.finest("Item was already in cache, appended item");
        } else {
            mLogger.finest("Item does not exist, adding");
            try {
                CachedObject<T> data = new CachedObject<T>(addList, clzType);
                Element newElement = new Element((Serializable)(key != null ? key : clzType), data);
                this.theCache.put(newElement);
                mLogger.finer("Added item to cache.");
            }
            catch (Throwable e) {
                mLogger.log(Level.SEVERE, "Exception from cache: " + e, e);
                throw new WBEMException(1, e.getLocalizedMessage(), null, e);
            }
        }
    }

    @Override
    public <T extends Serializable> T[] getCachedObject(Class<T[]> key) throws WBEMException {
        return this.getCachedObject(null, key);
    }

    @Override
    public <T extends Serializable> T[] getCachedObject(String key, Class<T[]> expectedType) throws WBEMException {
        Serializable[] ret = null;
        try {
            Element cachedItem;
            if (key != null) {
                mLogger.finer("Looking up string: " + key + " in cache");
                cachedItem = this.theCache.get((Serializable)((Object)key));
            } else {
                mLogger.finer("Looking up class: " + expectedType + " in cache");
                cachedItem = this.theCache.get(expectedType);
                key = expectedType.toString();
            }
            if (cachedItem != null) {
                CachedObject item = (CachedObject)cachedItem.getObjectValue();
                ret = item.getData();
                Class<T[]> clzKey = ret.getClass();
                if (!clzKey.isAssignableFrom(expectedType)) {
                    String gotClass = ret.getClass().getName();
                    ret = null;
                    String err = String.format(EXCEPTION_TYPE, expectedType.getName(), gotClass);
                    mLogger.finer("Cache Error: " + err);
                    throw new WBEMException(1, err);
                }
                mLogger.finer("Found " + key + " in cache");
            } else {
                mLogger.fine("Could not find " + key + " in cache");
            }
        }
        catch (Exception e) {
            throw new WBEMException(1, e.toString(), null, (Throwable)e);
        }
        return ret;
    }

    @Override
    public <T extends Serializable> boolean isCached(Class<T[]> key) {
        boolean ret = this.theCache.isKeyInCache(key);
        return ret;
    }

    @Override
    public boolean isCached(String key) {
        boolean ret = this.theCache.isKeyInCache((Object)key);
        return ret;
    }

    public <T extends Serializable> void removeCacheObject(String key, List<?> removedList, Class<?> clzType) throws WBEMException {
        if (!removedList.isEmpty()) {
            Element el;
            if (key != null) {
                mLogger.finer("removing items from key: " + key + " in cache");
                el = this.theCache.get((Serializable)((Object)key));
            } else {
                mLogger.finer("Removing items from class: " + clzType + " in cache");
                el = this.theCache.get(clzType);
            }
            if (el != null) {
                mLogger.finer("Item is cached, removing elements");
                CachedObject item = (CachedObject)el.getObjectValue();
                if (item.removeItems(removedList) <= 0) {
                    mLogger.finer(key + " is empty, removing from cache.");
                    this.theCache.remove((Serializable)((Object)key));
                }
            } else {
                mLogger.finer("Item does not exist, ignoring");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stop() {
        boolean ret = false;
        if (this.theCache != null) {
            String name = this.theCache.getName();
            try {
                Map<String, HitachiCache> map = theCaches;
                synchronized (map) {
                    this.theCache.flush();
                    mLogger.log(Level.INFO, "Stopping cache {0}", name);
                    theCaches.remove(name);
                    cacheManager.removeCache(name);
                    this.theCache = null;
                    ret = true;
                    mLogger.log(Level.INFO, "Cache {0} stopped", name);
                }
            }
            catch (Throwable thrown) {
                ret = false;
                mLogger.log(Level.SEVERE, "Unable to stop cache " + name, thrown);
            }
        }
        return ret;
    }
}

