/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.cache;

import com.hitachi.smi.cache.TraceManager;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.ProviderProperties;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.UserDefinedProperties;
import com.ws.wbem.CloseableAddableIterator;
import com.ws.wbem.jserver.JServerProperties;
import com.ws.wbem.jserver.JServerService;
import com.ws.wbem.jserver.JServerSettings;
import com.ws.wbem.jserver.WBEMServer;
import java.util.Calendar;
import java.util.Collection;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cim.CIMArgument;
import javax.cim.CIMDataType;
import javax.cim.CIMDateTime;
import javax.cim.CIMDateTimeAbsolute;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;
import javax.wbem.provider.ProviderHandle;
import net.sf.ehcache.Cache;

public class HitachiCacheMangerService
implements JServerService {
    private static final Logger mLogger = Logger.getLogger("com.hitachi.smis.logger.cache");
    private static WBEMServer mServer;
    private static ProviderHandle mWBEMClient;
    private static boolean shuttingDown;

    public static synchronized boolean isShuttingDown() {
        return shuttingDown;
    }

    private static synchronized void setShuttingDown(boolean shuttingDown) {
        HitachiCacheMangerService.shuttingDown = shuttingDown;
    }

    private static void startHTTPService(ProviderHandle cimom) {
        Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
        if (cimom != null) {
            String ns = ProviderLibs.getInteropNamespace();
            CIMObjectPath obj = new CIMObjectPath(null, null, null, ns, "CIM_TCPProtocolEndpoint", null);
            try {
                CloseableAddableIterator tcpEndPts = new CloseableAddableIterator();
                ProviderLibs.enumerateCIMOMInstances(obj, (CloseableAddableIterator<CIMInstance>)tcpEndPts, cimom);
                while (tcpEndPts.hasNext()) {
                    CIMInstance tcpEndPt = (CIMInstance)tcpEndPts.next();
                    UnsignedInteger16 ifType = (UnsignedInteger16)tcpEndPt.getPropertyValue("ProtocolIFType");
                    if (null == ifType || 4204 != ifType.intValue()) continue;
                    logger.fine("Found TCPProtocolEndpoint for HTTP");
                    CIMArgument enabledState = new CIMArgument("RequestedState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO);
                    cimom.invokeMethod(tcpEndPt.getObjectPath(), "RequestStateChange", new CIMArgument[]{enabledState}, new CIMArgument[0]);
                }
            }
            catch (WBEMException e) {
                logger.log(Level.SEVERE, "Exception trying to start CIM-XML adapter", e);
            }
        } else {
            logger.log(Level.SEVERE, "No handle to CIMOM!");
        }
    }

    public HitachiCacheMangerService() {
        new TraceManager("com.hitachi.smis.logger.cache", "CacheTrace");
        new TraceManager("com.hitachi.smis.logger.provider", "ProviderTrace");
        new TraceManager("com.hitachi.smis.logger.alert", "AlertManager");
        Logger t = Logger.getLogger(Cache.class.getName());
        Handler[] handlers = mLogger.getHandlers();
        Handler handler = handlers[0];
        t.addHandler(handler);
    }

    private void checkInstallDate() {
        String installDate = JServerProperties.getInstallDate();
        if (null == installDate || 0 <= installDate.length()) {
            try {
                UserDefinedProperties udp = UserDefinedProperties.getUserDefinedProperties();
                installDate = udp.getInstallDate();
                if (null == installDate || 0 <= installDate.length()) {
                    this.setInstallDate(udp, installDate);
                }
            }
            catch (WBEMException we) {
                mLogger.log(Level.WARNING, "Exception getting User defined properties.", we);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        mLogger.info("HitachiCacheMangerService.close() called.");
        HitachiCacheMangerService.setShuttingDown(true);
        try {
            Collection<RMIObjectMapping> devs = RMIObjectMapping.getAllRMIObjectMappings();
            for (RMIObjectMapping dev : devs) {
                try {
                    dev.getRMIObject().logOff();
                    mLogger.log(Level.INFO, "Disconnected from {0}", dev);
                }
                catch (Throwable e) {
                    mLogger.log(Level.WARNING, "Unable to disconnect from " + dev, e);
                }
            }
        }
        catch (Throwable e) {
            mLogger.log(Level.WARNING, "Unexpected error while disconnecting from managed devices", e);
        }
        finally {
            mLogger.info("HitachiCacheMangerService.close() complete.");
        }
    }

    public void initialize(WBEMServer server, ProviderHandle pch, Logger logger) {
        this.logStartup(pch);
        mServer = server;
        mWBEMClient = pch;
        HitachiCacheMangerService.setShuttingDown(false);
        this.checkInstallDate();
        if (ProviderProperties.start(mWBEMClient)) {
            mLogger.fine("provider.properties file read.");
        }
        try {
            RMIObjectMapping.initializeRMIMapping(pch);
        }
        catch (WBEMException e) {
            throw new RuntimeException(e);
        }
        try {
            if (ProviderProperties.isHttpEnabled()) {
                HitachiCacheMangerService.startHTTPService(mWBEMClient);
            }
        }
        catch (WBEMException we) {
            mLogger.log(Level.WARNING, "Caught exception determining if HttpEnabled property is set", we);
        }
        HitachiCacheMangerService.setShuttingDown(false);
        mLogger.fine("HitachiCacheMangerService initialized");
    }

    private void logStartup(ProviderHandle pch) {
        String providerVersion = null;
        String buildDate = null;
        try {
            CloseableAddableIterator tmpIter = new CloseableAddableIterator();
            ProviderLibs.enumerateCIMOMInstances(new CIMObjectPath(null, null, null, ProviderLibs.getInteropNamespace(), JServerSettings.replaceSchemaClassName((String)"WS_ObjectManager"), null), (CloseableAddableIterator<CIMInstance>)tmpIter, pch);
            if (tmpIter.hasNext()) {
                CIMInstance serverInst = (CIMInstance)tmpIter.next();
                providerVersion = (String)serverInst.getPropertyValue("Version");
                buildDate = (String)serverInst.getPropertyValue("Build");
            }
        }
        catch (WBEMException e1) {
            mLogger.log(Level.WARNING, "Error retrieving " + JServerSettings.replaceSchemaClassName((String)"WS_ObjectManager"), e1);
        }
        mLogger.log(Level.INFO, "HitachiCacheMangerService {0} initializing build {1}", new Object[]{providerVersion, buildDate});
    }

    public void reset() throws WBEMException {
        mLogger.log(Level.INFO, "{0} resetting.", this.getClass().getSimpleName());
        this.close();
        mLogger.log(Level.INFO, "{0} has been stopped, restarting.", this.getClass().getSimpleName());
        this.initialize(mServer, mWBEMClient, mLogger);
        mLogger.log(Level.INFO, "{0} has been restarted", this.getClass().getSimpleName());
    }

    private void setInstallDate(UserDefinedProperties udp, String installDate) {
        CIMDateTimeAbsolute dt;
        boolean setInstallDate;
        if (null == installDate) {
            setInstallDate = true;
            Calendar cal = Calendar.getInstance();
            dt = new CIMDateTimeAbsolute(cal);
            mLogger.log(Level.INFO, "installdate not found, defaulting: " + cal.toString());
        } else {
            setInstallDate = false;
            dt = new CIMDateTimeAbsolute(installDate);
        }
        JServerProperties.setInstallDate((String)dt.toString());
        if (setInstallDate) {
            udp.setInstallDate((CIMDateTime)dt);
        }
    }

    static {
        shuttingDown = false;
    }
}

