/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.cache;

import com.hitachi.smi.cache.AbstractVersionChecker;
import com.hitachi.smi.cache.CacheUpdateType;
import com.hitachi.smi.cache.CacheUpdater;
import com.hitachi.smi.common.ResourceGroupInfo;
import com.hitachi.smi.common.ResourceRestriction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import sanproject.common.Robj_interface_VerLeaf;

public class ResourceGroupInfoVersionChecker
extends AbstractVersionChecker {
    private static final Map<ResourceGroupInfo.SearchType, List<RSGUpdateCallback>> callbacks = new HashMap<ResourceGroupInfo.SearchType, List<RSGUpdateCallback>>();

    private static synchronized List<RSGUpdateCallback> getCallbackList(ResourceGroupInfo.SearchType type) {
        List<RSGUpdateCallback> theList = callbacks.get((Object)type);
        if (null == theList) {
            theList = new ArrayList<RSGUpdateCallback>();
            callbacks.put(type, theList);
        }
        return theList;
    }

    public static void registerForRSGUpdates(ResourceGroupInfo.SearchType type, RSGUpdateCallback callee) {
        List<RSGUpdateCallback> theList = ResourceGroupInfoVersionChecker.getCallbackList(type);
        if (!theList.contains(callee)) {
            theList.add(callee);
        }
    }

    protected ResourceGroupInfoVersionChecker(String serialNumber) {
        super(serialNumber);
        CacheUpdater.registerVersionChecker(CacheUpdater.ConfVerID.RESOURCEGRP, this);
    }

    @Override
    public void checkVersionDetails(Robj_interface_VerLeaf[] currentChildren, Robj_interface_VerLeaf[] prevChildren) {
        if (!ResourceRestriction.isUsingResourceRestriction(this.getSerialNumber())) {
            return;
        }
        try {
            mLogger.info("Checking ResourceGroupInfo version");
            ArrayList<ResourceGroupInfo> added = new ArrayList<ResourceGroupInfo>();
            ArrayList<ResourceGroupInfo> modified = new ArrayList<ResourceGroupInfo>();
            ArrayList<ResourceGroupInfo> removed = new ArrayList<ResourceGroupInfo>();
            HashMap<ResourceGroupInfo.SearchType, TreeSet<String>> addedElements = new HashMap<ResourceGroupInfo.SearchType, TreeSet<String>>();
            addedElements.put(ResourceGroupInfo.SearchType.DN, new TreeSet());
            addedElements.put(ResourceGroupInfo.SearchType.PG, new TreeSet());
            addedElements.put(ResourceGroupInfo.SearchType.PHGI, new TreeSet());
            addedElements.put(ResourceGroupInfo.SearchType.PORT, new TreeSet());
            HashMap<ResourceGroupInfo.SearchType, TreeSet<String>> removedElements = new HashMap<ResourceGroupInfo.SearchType, TreeSet<String>>();
            removedElements.put(ResourceGroupInfo.SearchType.DN, new TreeSet());
            removedElements.put(ResourceGroupInfo.SearchType.PG, new TreeSet());
            removedElements.put(ResourceGroupInfo.SearchType.PHGI, new TreeSet());
            removedElements.put(ResourceGroupInfo.SearchType.PORT, new TreeSet());
            ResourceGroupInfo.compareCachedResourceGroup2Backend(added, modified, removed, this.getSerialNumber(), addedElements, removedElements);
            this.processModifiedResourceGroups(addedElements, removedElements);
            if (!removed.isEmpty()) {
                CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.DELETE, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.RESOURCEGRP, (Serializable[])removed.toArray(new ResourceGroupInfo[removed.size()]));
            }
            if (!added.isEmpty()) {
                CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.ADD, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.RESOURCEGRP, (Serializable[])added.toArray(new ResourceGroupInfo[added.size()]));
            }
            if (!modified.isEmpty()) {
                CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.MODIFY, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.RESOURCEGRP, (Serializable[])modified.toArray(new ResourceGroupInfo[modified.size()]));
            }
        }
        catch (Throwable cce) {
            mLogger.log(Level.SEVERE, "Unexpected exception updating ResourceGroupInfo cache: " + cce, cce);
        }
    }

    private void processModifiedResourceGroups(final Map<ResourceGroupInfo.SearchType, TreeSet<String>> addedElements, final Map<ResourceGroupInfo.SearchType, TreeSet<String>> removedElements) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    for (ResourceGroupInfo.SearchType type : ResourceGroupInfo.SearchType.values()) {
                        if (ResourceGroupInfo.SearchType.NONE == type) continue;
                        TreeSet added = (TreeSet)addedElements.get((Object)type);
                        TreeSet removed = (TreeSet)removedElements.get((Object)type);
                        if (added.isEmpty() && removed.isEmpty()) continue;
                        ListIterator cb = ResourceGroupInfoVersionChecker.getCallbackList(type).listIterator();
                        while (cb.hasNext()) {
                            RSGUpdateCallback callee = (RSGUpdateCallback)cb.next();
                            try {
                                callee.RSGUpdated(type, added, removed);
                            }
                            catch (Throwable t) {
                                AbstractVersionChecker.mLogger.log(Level.SEVERE, "Unexpected exception from " + callee, t);
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    AbstractVersionChecker.mLogger.log(Level.SEVERE, "Unexpected exception processing RSG callbacks", t);
                }
            }
        });
        t.setName("RSG Callback");
        t.setDaemon(true);
        t.start();
    }

    public static interface RSGUpdateCallback {
        public void RSGUpdated(ResourceGroupInfo.SearchType var1, TreeSet<String> var2, TreeSet<String> var3);
    }
}

