/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.cache;

import com.hitachi.smi.cache.AbstractVersionChecker;
import com.hitachi.smi.cache.CacheUpdateNotifier;
import com.hitachi.smi.cache.CacheUpdateType;
import com.hitachi.smi.cache.CacheUpdater;
import com.hitachi.smi.common.VirtualLDEV;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import sanproject.common.Robj_interface_VerLeaf;

public class VirtualIDBranchChecker
extends AbstractVersionChecker {
    protected VirtualIDBranchChecker(String serialNumber) {
        super(serialNumber);
        CacheUpdater.registerVersionChecker(CacheUpdater.ConfVerID.VIRTUALID, this);
        CacheUpdater.registerUpdateCallback(CacheUpdater.CallBackType.LDEV, new LDEVUpdateListener(), serialNumber);
    }

    @Override
    public void checkVersionDetails(Robj_interface_VerLeaf[] currentChildren, Robj_interface_VerLeaf[] prevChildren) {
        try {
            mLogger.info("Checking VirtualID version");
            ArrayList<VirtualLDEV> added = new ArrayList<VirtualLDEV>();
            ArrayList<VirtualLDEV> modified = new ArrayList<VirtualLDEV>();
            ArrayList<VirtualLDEV> removed = new ArrayList<VirtualLDEV>();
            VirtualLDEV.compareCached2Backend(added, modified, removed, this.getSerialNumber());
            if (mLogger.isLoggable(Level.FINE)) {
                mLogger.log(Level.FINE, "Cache update for VirtualLDEV{0}\tAdded: {1}{0}\tRemoved: {2}{0}\tModified: {3}", new Object[]{System.lineSeparator(), ((Object)added).toString(), ((Object)removed).toString(), ((Object)modified).toString()});
            } else {
                mLogger.log(Level.INFO, "Cache update for VirtualLDEV, Added: {0}, Modified: {1}, Removed: {2}", new Object[]{added.size(), modified.size(), removed.size()});
            }
            CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.DELETE, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.VIRTUALID, (Serializable[])removed.toArray(new VirtualLDEV[removed.size()]));
            CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.ADD, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.VIRTUALID, (Serializable[])added.toArray(new VirtualLDEV[added.size()]));
            CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.MODIFY, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.VIRTUALID, (Serializable[])modified.toArray(new VirtualLDEV[modified.size()]));
        }
        catch (Throwable cce) {
            mLogger.log(Level.SEVERE, "Unexpected exception updating VirtualID cache: " + cce, cce);
        }
    }

    private class LDEVUpdateListener
    implements CacheUpdateNotifier {
        final AtomicBoolean checking = new AtomicBoolean(false);

        private LDEVUpdateListener() {
        }

        @Override
        public <T extends Serializable> void cacheItemAdded(T pObj) {
            if (this.checking.compareAndSet(false, true)) {
                AbstractVersionChecker.mLogger.info("LDEV added, forcing update of Virtual data");
                VirtualIDBranchChecker.this.checkVersionDetails(null, null);
                this.checking.set(false);
            }
        }

        @Override
        public <T extends Serializable> void cacheItemDeleted(T pObj) {
        }

        @Override
        public <T extends Serializable> void cacheItemModified(T pObj) {
        }
    }
}

