/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.client;

import com.hitachi.smi.cache.DeviceData;
import com.hitachi.smi.client.TCPPEFileFinder;
import com.hitachi.smi.common.ProviderStatusUtils;
import com.ws.utilities.Resources;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Principal;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.cim.CIMArgument;
import javax.cim.CIMObjectPath;
import javax.security.auth.Subject;
import javax.wbem.WBEMException;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;
import javax.wbem.client.WBEMClient;
import javax.wbem.client.WBEMClientFactory;
import sanproject.sn2.base.property.SJbaseSystemPropertiesManager;
import sanproject.sn2.com.utility.SJcEnvUty;

public class SetProviderStatus {
    private static final String CLASS_NAME = "HITACHI_ProviderStatusService";
    private static final String SUSPEND_METHOD_NAME = "SuspendService";
    private static final String CANCEL_METHOD_NAME = "CancelSuspendService";
    private static final String STOP_METHOD_NAME = "StopService";
    private static final String SHUTDOWN_METHOD_NAME = "ShutdownService";
    protected static Boolean DEBUG = Boolean.FALSE;
    private static Pattern regEx = Pattern.compile("com\\.ws\\.wbem\\.jserver\\.StartJWBEMServer");
    private final Map<String, String> cli;
    private final Resources resources = new Resources(SetProviderStatus.class.getCanonicalName());
    private String method;
    private String scheme;
    private String host;
    private String namespace;
    private String port;
    private final CIMObjectPath providerStatusOP;
    private boolean getState = false;
    private boolean validate = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int code = 1;
        try {
            String debugStr = System.getenv("DEBUG");
            Boolean bl = DEBUG = null == debugStr ? Boolean.FALSE : new Boolean(debugStr);
            if (DEBUG.booleanValue()) {
                System.err.println("Debug: " + DEBUG);
            }
            SetProviderStatus sps = new SetProviderStatus(args);
            code = sps.execOperation();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            if (DEBUG.booleanValue()) {
                System.err.println("execOperation returned: " + code);
            }
        }
        System.exit(code);
    }

    public static Map<String, String> parseCommandLine(String[] argv) {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        String lastArg = null;
        for (String arg : argv) {
            String option = null;
            String value = "";
            if (arg.startsWith("-")) {
                lastArg = option = arg.substring(1);
            } else {
                option = lastArg;
                value = arg;
            }
            if (null != option && null != value) {
                ht.put(option, value);
                continue;
            }
            System.out.print("invalid option or value ");
            System.out.println(option + " - " + value);
        }
        return ht;
    }

    public SetProviderStatus(String[] args) throws IOException {
        this.cli = SetProviderStatus.parseCommandLine(args);
        this.checkCmdLine();
        String urlStr = this.cli.get("url");
        if (null == urlStr) {
            this.scheme = "https";
            this.host = "127.0.0.1";
            this.namespace = "interop";
            this.port = this.cli.get("port");
        } else {
            URL url;
            try {
                url = new URL(urlStr);
            }
            catch (MalformedURLException e) {
                System.err.println("Specified URL is invalid: " + urlStr);
                throw e;
            }
            this.scheme = url.getProtocol();
            this.host = url.getHost();
            this.namespace = url.getPath();
            int urlPort = url.getPort();
            this.port = -1 == urlPort ? this.cli.get("port") : Integer.toString(urlPort);
        }
        this.providerStatusOP = new CIMObjectPath(this.scheme, this.host, this.port, this.namespace, CLASS_NAME, null);
    }

    private void checkCmdLine() {
        block23: {
            if (null != this.cli.get("m")) {
                switch (this.cli.get("m").toUpperCase()) {
                    case "SUSPEND": {
                        this.method = SUSPEND_METHOD_NAME;
                        break;
                    }
                    case "STOP": {
                        this.method = STOP_METHOD_NAME;
                        break;
                    }
                    case "CANCEL": {
                        this.method = CANCEL_METHOD_NAME;
                        break;
                    }
                    case "SHUTDOWN": {
                        this.method = SHUTDOWN_METHOD_NAME;
                        this.useJSanSN2Tools();
                        break;
                    }
                    case "GETSTATE": {
                        this.getState = true;
                        break;
                    }
                    case "VALIDATE": {
                        this.validate = true;
                        break;
                    }
                    default: {
                        this.usage();
                        break;
                    }
                }
            } else {
                this.usage();
            }
            if (null == this.cli.get("u")) {
                this.cli.put("u", "");
            }
            if (null == this.cli.get("p")) {
                this.cli.put("p", "");
            }
            if (null == this.cli.get("port")) {
                try {
                    this.cli.put("port", this.getPort());
                }
                catch (IOException e) {
                    this.cli.put("port", "5989");
                    if (!DEBUG.booleanValue()) break block23;
                    System.err.println("Unable to determine server port, using default");
                    e.printStackTrace();
                }
            }
        }
    }

    private WBEMClient connect() throws MalformedURLException {
        UserPrincipal userPr = new UserPrincipal(this.cli.get("u"));
        PasswordCredential pwCred = new PasswordCredential(this.cli.get("p"));
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)userPr);
        subject.getPrivateCredentials().add(pwCred);
        WBEMClient cc = null;
        try {
            String protocol = null == this.cli.get("ws") ? "CIM-XML" : this.cli.get("ws");
            cc = WBEMClientFactory.getClient((String)protocol);
            Locale[] l = new Locale[]{Locale.ENGLISH};
            cc.initialize(this.providerStatusOP, subject, l);
        }
        catch (WBEMException e) {
            e.printStackTrace();
            System.out.println("Received error when trying to retrieve client handle");
            System.exit(-1);
        }
        return cc;
    }

    private int execOperation() throws IOException {
        int ret = 1;
        if (this.validate || this.getState) {
            ret = this.validateRunning();
            if (0 == ret && this.getState) {
                ret = 2;
            } else if (1 == ret && this.getState) {
                ret = this.getStatusInfo();
            }
        } else {
            try (WBEMClient cc = this.connect();){
                CIMArgument[] inArgs = new CIMArgument[]{};
                CIMArgument[] outArgs = new CIMArgument[1];
                Object cvResult = cc.invokeMethod(this.providerStatusOP, this.method, inArgs, outArgs);
                if (null != cvResult && cvResult instanceof Number) {
                    ret = ((Number)cvResult).intValue();
                }
                System.out.println(this.providerStatusOP.getObjectName() + "." + this.method + " " + this.resources.loadString("RETURNED") + " " + cvResult);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    private String getPort() throws IOException {
        String ret;
        TCPPEFileFinder finder = new TCPPEFileFinder();
        Files.walkFileTree(Paths.get(".", new String[0]), finder);
        String tcpeFile = finder.getTcppeFile();
        if (null != tcpeFile) {
            Properties tcpe = new Properties();
            tcpe.load(new FileInputStream(tcpeFile));
            ret = tcpe.getProperty("cim-xml.https.portnumber", "5989");
        } else {
            ret = "5989";
        }
        return ret;
    }

    private int getStatusInfo() {
        int ret;
        File statusFile = new File("jserver.status");
        if (DEBUG.booleanValue()) {
            System.err.println("Examining " + statusFile.getAbsolutePath());
        }
        if (statusFile.exists()) {
            if (DEBUG.booleanValue()) {
                System.err.println("jserver.status exists");
            }
            String statusLine = null;
            try (BufferedReader in = new BufferedReader(new FileReader(statusFile));){
                if (DEBUG.booleanValue()) {
                    System.err.println("Reading status line");
                }
                statusLine = in.readLine();
                if (DEBUG.booleanValue()) {
                    System.err.println("Read in: " + statusLine);
                }
            }
            catch (IOException e) {
                System.err.printf(this.resources.loadString("FILE_EXCEPTION"), e);
                if (DEBUG.booleanValue()) {
                    e.printStackTrace();
                }
                int n = -1;
            }
            if (null != statusLine) {
                int parenIdx = statusLine.indexOf("(Detail Code ");
                if (parenIdx > 0) {
                    String status = statusLine.substring(0, parenIdx);
                    int spaceIdx = parenIdx + "(Detail Code ".length();
                    parenIdx = statusLine.indexOf(41);
                    if (spaceIdx > 0 && parenIdx > spaceIdx) {
                        String dcStr = statusLine.substring(spaceIdx, parenIdx);
                        ret = this.parseStatusValues(status, dcStr);
                    } else {
                        System.err.printf(this.resources.loadString("INVALID_DC_FORMAT"), statusLine);
                        ret = -1;
                    }
                } else {
                    System.err.printf(this.resources.loadString("INVALID_FORMAT"), statusLine);
                    ret = -1;
                }
            } else {
                System.err.printf(this.resources.loadString("INVALID_FORMAT"), statusLine);
                ret = -1;
            }
        } else {
            ret = -1;
        }
        return ret;
    }

    private int parseStatusValues(String status, String dcStr) {
        int ret;
        ProviderStatusUtils.ProviderStatus value;
        int x;
        if (DEBUG.booleanValue()) {
            System.err.println("ParseStatusValue: " + status + ", " + dcStr);
        }
        ProviderStatusUtils.ProviderStatus[] values = ProviderStatusUtils.ProviderStatus.values();
        for (x = 0; x < values.length && !(value = values[x]).name().equalsIgnoreCase(status); ++x) {
        }
        if (x >= 0) {
            StringBuilder statusStr = new StringBuilder(Integer.toString(x));
            if (values[x] != ProviderStatusUtils.ProviderStatus.Initializing) {
                statusStr.append(dcStr);
            }
            ret = Integer.parseInt(statusStr.toString());
        } else {
            ret = 0;
        }
        return ret;
    }

    private void usage() {
        System.out.println(this.resources.loadString("INVALID_CMD_LINE"));
        System.out.println(this.resources.loadString("OPTIONS"));
        System.out.println("\t-u " + this.resources.loadString("USER"));
        System.out.println("\t-p " + this.resources.loadString("PWD"));
        System.out.println("\t-m " + this.resources.loadString("MTHD"));
        System.out.println("\t-port " + this.resources.loadString("PORT"));
        System.out.println();
        System.out.println(this.resources.loadString("EXAMPLE2"));
        System.exit(-2);
    }

    private void useJSanSN2Tools() {
        block5: {
            try {
                block4: {
                    Path currentRelativePath = Paths.get("", new String[0]);
                    String currentDir = currentRelativePath.toAbsolutePath().toString();
                    DeviceData.setSystemProperties(currentDir);
                    SJbaseSystemPropertiesManager clsEnv = null;
                    try {
                        clsEnv = new SJbaseSystemPropertiesManager();
                        clsEnv.initialize(0);
                    }
                    catch (NoClassDefFoundError d) {
                        if (!DEBUG.booleanValue()) break block4;
                        System.err.println("Unable to get SN2 data. Maybe running remotely, skipping");
                    }
                }
                this.cli.put("u", SJcEnvUty.getManageUserName());
                this.cli.put("p", SJcEnvUty.getManagePassword());
            }
            catch (NoClassDefFoundError d) {
                if (!DEBUG.booleanValue()) break block5;
                d.printStackTrace();
            }
        }
    }

    private int validateRunning() throws IOException {
        int ret = 0;
        if (DEBUG.booleanValue()) {
            System.err.println("Validating if server is running via wmic.exe");
        }
        Process p = Runtime.getRuntime().exec("wmic process where (name=\"javaw.exe\") get commandline");
        try (BufferedReader bri = new BufferedReader(new InputStreamReader(p.getInputStream()));){
            String line;
            while (0 == ret && null != (line = bri.readLine())) {
                Matcher matcher = regEx.matcher(line);
                if (!matcher.find()) continue;
                if (DEBUG.booleanValue()) {
                    System.err.println("Found running javaw process: " + line);
                    System.err.println("Checking device dir" + System.lineSeparator() + "sdir: " + this.cli.get("sdir") + System.lineSeparator() + "ldir: " + this.cli.get("ldir"));
                }
                if (line.contains(this.cli.get("sdir")) || line.contains(this.cli.get("ldir"))) {
                    if (DEBUG.booleanValue()) {
                        System.err.println("javaw process matches this device");
                    }
                    ret = 1;
                    continue;
                }
                if (!DEBUG.booleanValue()) continue;
                System.err.println("javaw process does not match this device");
            }
        }
        if (DEBUG.booleanValue()) {
            System.err.println("Found " + (0 == ret ? "no " : "") + "running J Server for this device.");
        }
        return ret;
    }
}

