/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.smi.common.AbstractBaseCommonObject;
import com.hitachi.smi.common.ProviderLibs;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.wbem.WBEMException;
import sanproject.serverux.data.GetRmiException;

public class BaseDeviceNumber
extends AbstractBaseCommonObject
implements Comparable<BaseDeviceNumber> {
    private static final long HITACHI_BYTE = 1024L;
    private static final long NON_OPEN_V_MIN_SIZE = 36864000L;
    private static final String OPEN_3 = "OPEN-3";
    private static final long OPEN_3_MAX_KB = 2403360L;
    private static final String OPEN_8 = "OPEN-8";
    private static final long OPEN_8_MAX_KB = 7175520L;
    private static final String OPEN_9 = "OPEN-9";
    private static final long OPEN_9_MAX_KB = 7211520L;
    private static final String OPEN_E = "OPEN-E";
    private static final long OPEN_E_MAX_KB = 14226480L;
    private static final String OPEN_K = "OPEN-K";
    private static final long OPEN_K_MAX_KB = 1830960L;
    private static final String OPEN_V = "OPEN-V";
    private static final long OPEN_V_MAX_KB = 3221159680L;
    private static final long OPEN_V_MIN_SIZE = 0x2EE0000L;
    private static final long serialVersionUID = 1L;
    private short mCU;
    private long mDN;
    private String mEmulationType;
    private int mEmulationTypeVal;
    private short mLdev;
    private short mLdkc;
    private boolean mOpenVolume;

    public static short[] getDevIdStringValues(String deviceIDKeyVal) {
        short ldev = -1;
        short cu = -1;
        short dkc = -1;
        if (null != deviceIDKeyVal) {
            long devID = Long.parseLong(deviceIDKeyVal);
            if (devID < 65536L) {
                dkc = 0;
            } else {
                dkc = (short)(devID / 65536L);
                devID -= (long)(dkc * 65536);
            }
            if (devID < 256L) {
                cu = 0;
            } else {
                cu = (short)(devID / 256L);
                devID -= (long)(cu * 256);
            }
            if (devID > 32767L) {
                providerLogger.log(Level.SEVERE, deviceIDKeyVal + " is not a valid device ID");
            } else {
                ldev = (short)devID;
            }
        }
        short[] ret = new short[]{dkc, cu, ldev};
        return ret;
    }

    public static String getEmulationTypeStr(int emulationTypeVal) throws RemoteException, GetRmiException, WBEMException {
        Hashtable<Integer, String> emulationHash = ProviderLibs.getSupportedEmulation(false);
        String ret = emulationHash.get(emulationTypeVal);
        if (null == ret && null == (ret = (emulationHash = ProviderLibs.getSupportedEmulation(true)).get(emulationTypeVal))) {
            String msg = String.format("%s is an unknown emulation type, known values: %s", emulationTypeVal, emulationHash.toString());
            throw new WBEMException(msg);
        }
        return ret;
    }

    public static long getMaxPoolSize(String emulationType) {
        long ret = 0L;
        if (emulationType != null && emulationType.startsWith("OPEN")) {
            if (emulationType.equalsIgnoreCase(OPEN_3)) {
                ret = 2461040640L;
            } else if (emulationType.equalsIgnoreCase(OPEN_8)) {
                ret = 7347732480L;
            } else if (emulationType.equalsIgnoreCase(OPEN_9)) {
                ret = 7384596480L;
            } else if (emulationType.equalsIgnoreCase(OPEN_K)) {
                ret = 1874903040L;
            } else if (emulationType.equalsIgnoreCase(OPEN_E)) {
                ret = 14567915520L;
            } else if (emulationType.equalsIgnoreCase(OPEN_V)) {
                ret = 3298467512320L;
            } else {
                providerLogger.log(Level.WARNING, "The following is an unknown open type: " + emulationType);
            }
        } else {
            providerLogger.warning("The volume is not an OPEN volume: " + emulationType);
        }
        return ret;
    }

    public static long getMinPoolSize(String emulationType) {
        long ret = 0L;
        if (emulationType != null && emulationType.startsWith("OPEN")) {
            ret = emulationType.equalsIgnoreCase(OPEN_V) ? 0x2EE0000L : 36864000L;
        } else {
            providerLogger.warning("Not an OPEN volume: " + emulationType);
        }
        return ret;
    }

    public static long makeUniqueDN(short ldkc, short cu, short ldev) {
        long ret = ldkc * 256 * 256 + cu * 256 + ldev;
        return ret;
    }

    protected BaseDeviceNumber(String serialNum, short ldkc, short ldev, short cu, int iEmulationType) throws RemoteException, GetRmiException, WBEMException {
        super(serialNum);
        this.mLdev = ldev;
        this.mCU = cu;
        this.mLdkc = ldkc;
        this.mDN = BaseDeviceNumber.makeUniqueDN(ldkc, cu, ldev);
        this.mEmulationTypeVal = iEmulationType;
        this.mEmulationType = BaseDeviceNumber.getEmulationTypeStr(iEmulationType);
        if (this.mEmulationType.startsWith("OPEN")) {
            this.mOpenVolume = true;
        }
    }

    @Override
    public int compareTo(BaseDeviceNumber other) {
        long otherVal;
        long thisVal = this.getDn();
        return thisVal < (otherVal = other.getDn()) ? -1 : (thisVal == otherVal ? 0 : 1);
    }

    protected void copyBDN(BaseDeviceNumber newBDN) {
        this.setSerialNumber(newBDN.getSerialNumber());
        this.mDN = newBDN.mDN;
        this.mCU = newBDN.mCU;
        this.mEmulationType = new String(newBDN.mEmulationType);
        this.mEmulationTypeVal = newBDN.mEmulationTypeVal;
        this.mLdev = newBDN.mLdev;
        this.mLdkc = newBDN.mLdkc;
        this.mOpenVolume = newBDN.mOpenVolume;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseDeviceNumber other = (BaseDeviceNumber)obj;
        if (this.mCU != other.mCU) {
            return false;
        }
        if (this.mDN != other.mDN) {
            return false;
        }
        if (this.mEmulationType == null ? other.mEmulationType != null : !this.mEmulationType.equals(other.mEmulationType)) {
            return false;
        }
        if (this.mEmulationTypeVal != other.mEmulationTypeVal) {
            return false;
        }
        if (this.mLdev != other.mLdev) {
            return false;
        }
        if (this.mLdkc != other.mLdkc) {
            return false;
        }
        return this.mOpenVolume == other.mOpenVolume;
    }

    public short getCu() {
        return this.mCU;
    }

    public long getDn() {
        return this.mDN;
    }

    public String getDNAsString() {
        return String.valueOf(this.mDN);
    }

    public String getEmulationType() {
        return this.mEmulationType;
    }

    public int getEmulationTypeVal() {
        return this.mEmulationTypeVal;
    }

    public short getLdev() {
        return this.mLdev;
    }

    public String getLDEVIDString() {
        return String.format("%02x:%02x:%02x", this.mLdkc, this.mCU, this.mLdev);
    }

    public short getLdkc() {
        return this.mLdkc;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.mCU;
        result = 31 * result + (int)(this.mDN ^ this.mDN >>> 32);
        result = 31 * result + (this.mEmulationType == null ? 0 : this.mEmulationType.hashCode());
        result = 31 * result + this.mEmulationTypeVal;
        result = 31 * result + this.mLdev;
        result = 31 * result + this.mLdkc;
        result = 31 * result + (this.mOpenVolume ? 1231 : 1237);
        return result;
    }

    public boolean isOpenVolume() {
        return this.mOpenVolume;
    }

    boolean isSame(BaseDeviceNumber newDN) {
        return this.equals(newDN);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BaseDeviceNumber [serialNum=");
        builder.append(this.getSerialNumber());
        builder.append(", mCU=");
        builder.append(this.mCU);
        builder.append(", mDN=");
        builder.append(this.mDN);
        builder.append(", mEmulationType=");
        builder.append(this.mEmulationType);
        builder.append(", mEmulationTypeVal=");
        builder.append(this.mEmulationTypeVal);
        builder.append(", mLdev=");
        builder.append(this.mLdev);
        builder.append(", mLdkc=");
        builder.append(this.mLdkc);
        builder.append(", mOpenVolume=");
        builder.append(this.mOpenVolume);
        builder.append("]");
        return builder.toString();
    }
}

