/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.smi.common.IndicationHelper;
import com.hitachi.smi.common.PollingIndicationManager;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.provider.ProviderHandle;

public class IndicationPollingWorker
extends IndicationHelper
implements Runnable {
    private static final int WAIT_TIME = 30000;
    protected static final Logger mLogger = Logger.getLogger("com.hitachi.smis.logger.provider");
    Hashtable<CIMObjectPath, CIMInstance> mHashPreviousInstances = new Hashtable();
    boolean mIsRunning;
    boolean mKeepRunning;
    boolean mHaveBaseline;
    boolean mSkipWait = false;
    CIMObjectPath mOpClassname;
    boolean mIsListenCreation = false;
    boolean mIsListenDeletion = false;
    boolean mIsListenModification = false;

    public IndicationPollingWorker(ProviderHandle pHandle, CIMObjectPath classname) {
        super(pHandle);
        this.mOpClassname = classname;
        this.mHaveBaseline = false;
    }

    public boolean isListenCreation() {
        return this.mIsListenCreation;
    }

    public boolean isListenDeletion() {
        return this.mIsListenCreation;
    }

    public boolean isListening() {
        return this.mIsListenCreation || this.mIsListenDeletion || this.mIsListenModification;
    }

    public boolean isListenModification() {
        return this.mIsListenCreation;
    }

    public boolean isRunning() {
        return this.mIsRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread.currentThread().setName(this.mOpClassname.getObjectName() + " indication poller");
        this.mKeepRunning = true;
        this.mIsRunning = true;
        while (this.mKeepRunning) {
            this.mSkipWait = false;
            try {
                CloseableIterator newInstances = this.mHandle.enumerateInstances(this.mOpClassname, null);
                if (!this.mHaveBaseline) {
                    this.mHaveBaseline = true;
                    Hashtable<CIMObjectPath, CIMInstance> hashtable = this.mHashPreviousInstances;
                    synchronized (hashtable) {
                        while (newInstances.hasNext()) {
                            CIMInstance instance = (CIMInstance)newInstances.next();
                            CIMObjectPath op = instance.getObjectPath();
                            this.mHashPreviousInstances.put(op, instance);
                        }
                        continue;
                    }
                }
                if (!this.mKeepRunning) continue;
                HashSet<CIMObjectPath> foundInstances = new HashSet<CIMObjectPath>();
                ArrayList<CIMObjectPath> oldPrevKeys = new ArrayList<CIMObjectPath>();
                ArrayList<CIMInstance> listIndications = new ArrayList<CIMInstance>();
                Hashtable<CIMObjectPath, CIMInstance> hashtable = this.mHashPreviousInstances;
                synchronized (hashtable) {
                    CIMInstance instPrev;
                    Enumeration<CIMObjectPath> enumPrevKeys = this.mHashPreviousInstances.keys();
                    while (enumPrevKeys.hasMoreElements()) {
                        oldPrevKeys.add(enumPrevKeys.nextElement());
                    }
                    while (newInstances.hasNext()) {
                        CIMInstance instNew = (CIMInstance)newInstances.next();
                        CIMObjectPath opNew = instNew.getObjectPath();
                        instPrev = this.mHashPreviousInstances.get(opNew);
                        if (null != instPrev) {
                            foundInstances.add(opNew);
                            if (!this.mIsListenModification || instPrev.equals((Object)instNew)) continue;
                            listIndications.add(this.createInstModificationInstance(instNew, instPrev));
                            continue;
                        }
                        this.mHashPreviousInstances.put(opNew, instNew);
                        listIndications.add(this.createInstCreationInstance(instNew));
                    }
                    for (CIMObjectPath opPrev : oldPrevKeys) {
                        if (foundInstances.contains(opPrev)) continue;
                        instPrev = this.mHashPreviousInstances.remove(opPrev);
                        if (!this.mIsListenDeletion) continue;
                        listIndications.add(this.createInstDeletionInstance(instPrev));
                    }
                }
                if (this.mKeepRunning) {
                    for (CIMInstance indication : listIndications) {
                        this.mHandle.deliverEvent(indication, null);
                    }
                }
                for (int i = 0; i < 6 && this.mKeepRunning && !this.mSkipWait; ++i) {
                    try {
                        Thread.sleep(5000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
            catch (WBEMException e) {
                mLogger.log(Level.SEVERE, "Caught exception trying to enumerate instances of: " + this.mOpClassname, e);
            }
        }
        this.mIsRunning = false;
    }

    public void setIndicationType(PollingIndicationManager.Operation operation, boolean listen) {
        switch (operation) {
            case InstCreation: {
                this.mIsListenCreation = listen;
                break;
            }
            case InstDeletion: {
                this.mIsListenDeletion = listen;
                break;
            }
            case InstModification: {
                this.mIsListenModification = listen;
            }
        }
    }

    public void stop() {
        this.mKeepRunning = false;
    }

    public void updateEvent() {
        this.mSkipWait = true;
    }
}

