/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.smi.cache.CacheLib;
import com.hitachi.smi.cache.HitachiCacheInterface;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.AbstractBaseCommonObject;
import com.hitachi.smi.common.BaseDeviceNumber;
import com.hitachi.smi.common.ClosableAddableIteratorCB;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.IteratorCallback;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.paralleltasker.Task;
import com.hitachi.smi.paralleltasker.TaskProcessor;
import com.ws.wbem.CloseableAddableIterator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_RJiLDEVIndex;
import sanproject.common.Robj_interface_RJiLUSEInfoDetail;

public class LUSEInfo
extends AbstractBaseCommonObject {
    private static final long serialVersionUID = 1L;
    private static final Class<LUSEInfo[]> clz = LUSEInfo[].class;
    private final ArrayList<Long> mComponents = new ArrayList();

    private static void addLUSEInfoToMap(HashMap<String, List<LUSEInfo>> map, LUSEInfo luse) {
        String key = CacheLib.getLUSEDevNum(luse.getHeadLuse());
        CacheLib.addToMap(map, key, luse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cache(RMIObjectMapping mapping) throws WBEMException {
        RMIObjectCache rmiObj = mapping.getRMIObject();
        HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
        if (!cache.isCached(clz)) {
            Class<LUSEInfo> clazz = LUSEInfo.class;
            synchronized (LUSEInfo.class) {
                if (!cache.isCached(clz)) {
                    ClosableAddableIteratorCB<LUSEInfo> callback = new ClosableAddableIteratorCB<LUSEInfo>();
                    LUSEInfo.getUnCachedLUSEInfo(rmiObj, callback, (short)-1, (short)-1, (short)-1);
                    CloseableAddableIterator<LUSEInfo> cbIter = callback.getWrappedCloseableAddableIter();
                    ArrayList<LUSEInfo> luses = new ArrayList<LUSEInfo>();
                    HashMap<String, List<LUSEInfo>> map = new HashMap<String, List<LUSEInfo>>();
                    while (cbIter.hasNext()) {
                        LUSEInfo luse = (LUSEInfo)cbIter.next();
                        luses.add(luse);
                        LUSEInfo.addLUSEInfoToMap(map, luse);
                    }
                    CacheLib.addDataToCache(map, luses, clz, mapping.getSerialNumber());
                } else {
                    cacheLogger.log(Level.WARNING, "LUSEInfo was on {0}", mapping.getSerialNumber());
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        } else {
            cacheLogger.log(Level.WARNING, "LUSEInfo is already on {0}", mapping.getSerialNumber());
        }
    }

    private static void getLUSEInfo(IteratorCallback<LUSEInfo> callback, short pDKC, short pCU, short pLDEV) throws WBEMException {
        Collection<RMIObjectMapping> mappings = RMIObjectMapping.getAllRMIObjectMappings();
        for (RMIObjectMapping mapObj : mappings) {
            if (null != mapObj) {
                LUSEInfo.getLUSEInfo(mapObj.getRMIObject(), callback, pDKC, pCU, pLDEV);
                continue;
            }
            providerLogger.severe("One of the objects returned from getAllMappings is null");
        }
    }

    public static void getLUSEInfo(RMIObjectCache rmiObj, IteratorCallback<LUSEInfo> callback) throws WBEMException {
        LUSEInfo.getLUSEInfo(rmiObj, callback, (short)-1, (short)-1, (short)-1);
    }

    public static void getLUSEInfo(RMIObjectCache rmiObj, IteratorCallback<LUSEInfo> callback, short pDKC, short pCU, short pLDEV) throws WBEMException {
        if (null == rmiObj) {
            LUSEInfo.getLUSEInfo(callback, pDKC, pCU, pLDEV);
            return;
        }
        HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
        if (cache.isCached(clz)) {
            AbstractBaseCommonObject[] items;
            String key = null;
            if (pDKC != -1 && pCU != -1 && pLDEV != -1) {
                key = CacheLib.getLUSEDevNum(BaseDeviceNumber.makeUniqueDN(pDKC, pCU, pLDEV));
            }
            if ((items = (LUSEInfo[])cache.getCachedObject(key, clz)) != null) {
                callback.returnItems(items);
            } else {
                providerLogger.warning("Did not find any LUSEInfo in cache");
                callback.done();
            }
        } else {
            LogRecord record = new LogRecord(Level.WARNING, "LUSEInfo not cached on {0}, performance issue");
            record.setParameters(new Object[]{rmiObj.getSMISMappingContainer().getSerialNumber()});
            record.setThrown(new Exception(record.getMessage()));
            cacheLogger.log(record);
            LUSEInfo.getUnCachedLUSEInfo(rmiObj, callback, pDKC, pCU, pLDEV);
        }
    }

    private static void getUnCachedLUSEInfo(RMIObjectCache rmiObj, IteratorCallback<LUSEInfo> callback, short dkc, short cu, short ldev) {
        try {
            Robj_interface_RJiLUSEInfoDetail[] infoDetails;
            if (dkc != -1 && cu != -1 && ldev != -1) {
                Robj_interface_RJiLDEVIndex[] luseToGet = new Robj_interface_RJiLDEVIndex[]{(Robj_interface_RJiLDEVIndex)rmiObj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.RJILDEVINDEX)};
                luseToGet[0].setSCU(cu);
                luseToGet[0].setSLDEV(ldev);
                luseToGet[0].setSLDKC(dkc);
                infoDetails = rmiObj.getLUSEInfoDetail(luseToGet);
            } else {
                infoDetails = rmiObj.getLUSEInfoDetail();
            }
            if (infoDetails.length < 1) {
                callback.done();
                return;
            }
            String serialNum = rmiObj.getSMISMappingContainer().getSerialNumber();
            TaskProcessor task = new TaskProcessor("LUSEInfo - " + serialNum, infoDetails.length);
            for (Robj_interface_RJiLUSEInfoDetail infoDetail : infoDetails) {
                if (task.shouldStop()) {
                    callback.done();
                    break;
                }
                WorkerThread worker = new WorkerThread(serialNum, callback, infoDetail, task);
                task.addTask(worker);
            }
        }
        catch (Exception e) {
            WBEMException we = new WBEMException(1, e.toString(), null, (Throwable)e);
            callback.exceptionOccurred(we);
            callback.done();
        }
    }

    public static void modifyCachedLUSE(ArrayList<LUSEInfo> added, ArrayList<LUSEInfo> removed, String serialNum) throws WBEMException {
        try {
            RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(serialNum).getRMIObject();
            HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
            LUSEInfo[] cachedLUs = (LUSEInfo[])cache.getCachedObject(null, clz);
            cacheLogger.log(Level.INFO, "Found {0} cached LUSE on {1}", new Object[]{cachedLUs != null ? Integer.valueOf(cachedLUs.length) : "none", serialNum});
            CommonClassAsList<LUSEInfo> callback = new CommonClassAsList<LUSEInfo>();
            LUSEInfo.getUnCachedLUSEInfo(rmiObj, callback, (short)-1, (short)-1, (short)-1);
            LinkedList<LUSEInfo> newLUs = callback.getReturnValue();
            callback = null;
            cacheLogger.log(Level.INFO, "Found {0} LUSE on {1}", new Object[]{newLUs != null ? Integer.valueOf(newLUs.size()) : "none", serialNum});
            ArrayList cachedList = cachedLUs != null ? Arrays.asList(cachedLUs) : new ArrayList(0);
            ArrayList<LUSEInfo> newList = null != newLUs ? new ArrayList<LUSEInfo>(newLUs) : new ArrayList(0);
            added.addAll(newList);
            added.removeAll(cachedList);
            removed.clear();
            removed.addAll(cachedList);
            removed.removeAll(newList);
            cacheLogger.log(Level.INFO, "Found that {0} LUSE have been added to {1}", new Object[]{added.size(), serialNum});
            HashMap<String, List<LUSEInfo>> luMap = new HashMap<String, List<LUSEInfo>>();
            if (!added.isEmpty()) {
                for (LUSEInfo lu : added) {
                    LUSEInfo.addLUSEInfoToMap(luMap, lu);
                }
                CacheLib.addDataToCache(luMap, added, clz, serialNum);
            }
            cacheLogger.log(Level.INFO, "Found that {0} LUSE have been removed from {1}", new Object[]{removed.size(), serialNum});
            if (!removed.isEmpty()) {
                luMap.clear();
                LUSEInfo.removeItemsFromMap(luMap, removed, serialNum);
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable t) {
            throw new WBEMException(1, "Exception occurred trying to modify LUUSEInfo in " + serialNum, null, t);
        }
        cacheLogger.log(Level.INFO, "Done modifiying cached LUSE on {0}", serialNum);
    }

    public static boolean processInfoDetail(IteratorCallback<LUSEInfo> mCallback, Robj_interface_RJiLUSEInfoDetail mTheVal, String serialNumber) {
        Robj_interface_RJiLDEVIndex[] luses;
        boolean ret = true;
        LUSEInfo item = null;
        for (Robj_interface_RJiLDEVIndex luse : luses = mTheVal.getObjLUSEIndex()) {
            long devNum = BaseDeviceNumber.makeUniqueDN(luse.getSLDKC(), luse.getSCU(), luse.getSLDEV());
            if (item == null) {
                item = new LUSEInfo(serialNumber, devNum);
                continue;
            }
            super.addComponent(devNum);
        }
        ret = mCallback.returnItem(item);
        return ret;
    }

    private static void removeItemsFromMap(HashMap<String, List<LUSEInfo>> pathMap, List<LUSEInfo> theList, String serialNum) throws WBEMException {
        for (LUSEInfo path : theList) {
            LUSEInfo.addLUSEInfoToMap(pathMap, path);
        }
        CacheLib.removeDataFromCache(pathMap, (Serializable[])theList.toArray(new LUSEInfo[theList.size()]), clz, (String)serialNum);
    }

    private LUSEInfo(String serialNumber, long head) {
        super(serialNumber);
        this.addComponent(head);
    }

    private void addComponent(long dn) {
        this.mComponents.add(dn);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LUSEInfo other = (LUSEInfo)obj;
        return !(this.mComponents == null ? other.mComponents != null : !this.mComponents.equals(other.mComponents));
    }

    public Long findHeadLuse(String deviceIDKeyVal) {
        Long ret = -1L;
        try {
            Long LookingForDn = Long.valueOf(deviceIDKeyVal);
            if (this.mComponents.contains(LookingForDn)) {
                ret = this.mComponents.get(0);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return ret;
    }

    public Long[] getComponents() {
        return this.mComponents.toArray(new Long[this.mComponents.size()]);
    }

    private Long getHeadLuse() {
        return this.mComponents.get(0);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.mComponents == null ? 0 : this.mComponents.hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LUSEInfo [mComponents=");
        builder.append(this.mComponents);
        builder.append(", serialNumber=");
        builder.append(this.getSerialNumber());
        builder.append("]");
        return builder.toString();
    }

    private static class WorkerThread
    implements Task {
        private final IteratorCallback<LUSEInfo> mCallback;
        Robj_interface_RJiLUSEInfoDetail mTheVal;
        private final TaskProcessor mTheTask;
        private final String mSerialNumber;

        public WorkerThread(String serialNum, IteratorCallback<LUSEInfo> callback, Robj_interface_RJiLUSEInfoDetail val, TaskProcessor pTheTask) {
            this.mSerialNumber = serialNum;
            this.mCallback = callback;
            this.mTheVal = val;
            this.mTheTask = pTheTask;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doTask() {
            try {
                boolean ret;
                if (!this.mTheTask.shouldStop() && !(ret = LUSEInfo.processInfoDetail(this.mCallback, this.mTheVal, this.mSerialNumber))) {
                    this.mTheTask.setStop(true);
                }
            }
            catch (Throwable e) {
                WBEMException we = e.getClass().isInstance(WBEMException.class) ? (WBEMException)e : new WBEMException(1, "Exception while processing items", null, e);
                this.mCallback.exceptionOccurred(we);
                this.mTheTask.setStop(true);
            }
            finally {
                int counter = this.mTheTask.taskDone();
                if (counter < 1) {
                    this.mCallback.done();
                }
            }
        }
    }
}

