/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.BaseDeviceNumber;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.PairVolumeInfo;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.TargetVolumeInfo;
import com.hitachi.smi.paralleltasker.ProcessTask;
import com.hitachi.smi.paralleltasker.Task;
import com.hitachi.smi.paralleltasker.Wait4ProcessTasks;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_RJSetGettingParamLDEV;
import sanproject.common.Robj_interface_RJiLDEVIndex;
import sanproject.common.Robj_interface_RJiLDEVInfoDetail2;
import sanproject.common.Robj_interface_RJiSIPairParm;
import sanproject.common.Robj_interface_RJiSIgetPairInf;
import sanproject.common.Robj_interface_RJiSIgetPairLdev;
import sanproject.common.Robj_interface_RJiSIgetPairStatus;
import sanproject.common.Robj_interface_RJiSigetPairFilter;

public class PairInfo {
    private static Hashtable<String, ArrayList<TargetVolumeInfo>> mTargets = new Hashtable();
    private static Hashtable<String, String> mSourceLookup = new Hashtable();
    private static Hashtable<String, PairVolumeInfo> mPairVolumeInfo = new Hashtable();
    private static final byte SOURCE_VOLUME_ATTRIBUTE = 4;
    private static final byte TARGET_VOLUME_ATTRIBUTE = 2;

    public static void cache(RMIObjectMapping mapping) throws Exception {
        RMIObjectCache objCache = mapping.getRMIObject();
        Robj_interface_RJiLDEVIndex[] ldevIdxArray = objCache.getLDEVIndex();
        PairInfo.processLDEVIndexes(ldevIdxArray, objCache);
    }

    private static final String createHashKey(BaseDeviceNumber dn) {
        return PairInfo.createHashKey(dn.getSerialNumber(), dn.getDNAsString());
    }

    private static final String createHashKey(String serial, String deviceNimber) {
        String key = String.format("%s%s%s", serial, ".", deviceNimber);
        return key;
    }

    public static short getPairVolAttribute(DeviceNumber pDeviceNumber) {
        short ret = -1;
        if (null != pDeviceNumber) {
            String key = PairInfo.createHashKey(pDeviceNumber);
            PairVolumeInfo pvi = PairInfo.getPairVolumeInfo().get(key);
            if (null != pvi) {
                ret = pvi.getPairVolAttribute();
            }
        }
        return ret;
    }

    private static synchronized Hashtable<String, PairVolumeInfo> getPairVolumeInfo() {
        return mPairVolumeInfo;
    }

    public static String getSourceDeviceNumber(DeviceNumber pTargetDeviceNumber) {
        String ret = null;
        if (null != pTargetDeviceNumber) {
            String key = PairInfo.createHashKey(pTargetDeviceNumber);
            ret = PairInfo.getSourceLookup().get(key);
        }
        return ret;
    }

    private static synchronized Hashtable<String, String> getSourceLookup() {
        return mSourceLookup;
    }

    public static ArrayList<TargetVolumeInfo> getTargetInfo(DeviceNumber pSourceDeviceNumber) {
        ArrayList<Object> ret = null;
        if (null != pSourceDeviceNumber) {
            String key = PairInfo.createHashKey(pSourceDeviceNumber);
            ret = PairInfo.getTargets().get(key);
        }
        if (null == ret) {
            ret = new ArrayList();
        }
        return ret;
    }

    public static TargetVolumeInfo getTargetInfo(DeviceNumber pSourceDeviceNumber, DeviceNumber pTargetDeviceNumber) throws WBEMException {
        TargetVolumeInfo ret = null;
        if (null != pSourceDeviceNumber && null != pTargetDeviceNumber) {
            RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(pTargetDeviceNumber.getSerialNumber());
            RMIObjectCache rmiObject = device.getRMIObject();
            String key = PairInfo.createHashKey(device.getSerialNumber(), pSourceDeviceNumber.getDNAsString());
            ArrayList<TargetVolumeInfo> targetInfoList = PairInfo.getTargets().get(key);
            for (TargetVolumeInfo targetInfo : targetInfoList) {
                DeviceNumber targetDN = DeviceNumber.find(targetInfo.getDNString(), rmiObject);
                if (null != targetDN) {
                    if (!pTargetDeviceNumber.equals(targetDN)) continue;
                    ret = targetInfo;
                    break;
                }
                Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
                logger.log(Level.WARNING, "DN {0} is listed as part of a snap pair but the volume could not be found", targetInfo.getDNString());
            }
        }
        return ret;
    }

    private static synchronized Hashtable<String, ArrayList<TargetVolumeInfo>> getTargets() {
        return mTargets;
    }

    public static boolean isLocalReplica(DeviceNumber pDeviceNumber) {
        boolean ret = false;
        if (null != pDeviceNumber) {
            String key = PairInfo.createHashKey(pDeviceNumber);
            PairVolumeInfo pvi = PairInfo.getPairVolumeInfo().get(key);
            if (null != pvi) {
                boolean isTarget = pvi.isTargetCandidate();
                boolean isSource = pvi.isSourceCandidate();
                ret = isTarget || isSource;
            }
        }
        return ret;
    }

    public static Boolean isSourceCandidate(DeviceNumber pDeviceNumber) {
        Boolean ret = null;
        if (null != pDeviceNumber) {
            String key = PairInfo.createHashKey(pDeviceNumber);
            PairVolumeInfo pvi = PairInfo.getPairVolumeInfo().get(key);
            if (null != pvi) {
                ret = pvi.isSourceCandidate();
            }
        }
        return ret;
    }

    public static Boolean isTargetCandidate(DeviceNumber pDeviceNumber) {
        Boolean ret = null;
        if (null != pDeviceNumber) {
            String key = PairInfo.createHashKey(pDeviceNumber);
            PairVolumeInfo pvi = PairInfo.getPairVolumeInfo().get(key);
            if (null != pvi) {
                ret = pvi.isTargetCandidate();
            }
        }
        return ret;
    }

    public static void modifyCache(Robj_interface_RJiLDEVIndex[] ldevIdxArray, String serialNumber) throws Exception {
        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(serialNumber);
        RMIObjectCache rmiObj = device.getRMIObject();
        PairInfo.processLDEVIndexes(ldevIdxArray, rmiObj);
    }

    private static void processLDEVIndexes(Robj_interface_RJiLDEVIndex[] ldevIdxArray, RMIObjectCache rmiObj) throws Exception {
        int processed;
        if (null == ldevIdxArray) {
            throw new NullPointerException("ldevIdxArray can not be null");
        }
        if (null == rmiObj) {
            throw new NullPointerException("rmiObj can not be null");
        }
        if (ldevIdxArray.length < 1) {
            Logger logger = Logger.getLogger("com.hitachi.smis.logger.cache");
            logger.info("No LDEVs to process, skipping Pairinfo");
            return;
        }
        Hashtable<String, ArrayList<TargetVolumeInfo>> targets = new Hashtable<String, ArrayList<TargetVolumeInfo>>();
        Hashtable<String, String> sourceLookup = new Hashtable<String, String>();
        Hashtable<String, PairVolumeInfo> pairVolumeInfo = new Hashtable<String, PairVolumeInfo>();
        Robj_interface_RJSetGettingParamLDEV paramLDEV = (Robj_interface_RJSetGettingParamLDEV)rmiObj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.SetGettingLDEV);
        paramLDEV.setBAll(true);
        Robj_interface_RJiLDEVInfoDetail2[] infoDetails = rmiObj.getLDEVInfoDetail2(ldevIdxArray, paramLDEV);
        Wait4ProcessTasks task = new Wait4ProcessTasks(infoDetails.length);
        int arraySize = infoDetails.length > 2048 ? 2048 : infoDetails.length;
        int[] ldevIndexArray = new int[arraySize];
        int index = 0;
        for (int i = 0; i < infoDetails.length; ++i) {
            int intVal = 0;
            if (infoDetails[i].getSLDKC() == 0) {
                intVal = ProviderLibs.encodeCULDEVNumber(infoDetails[i].getSCU(), infoDetails[i].getSLDEV());
            }
            ldevIndexArray[index++] = intVal;
            if (index != 2048) continue;
            int retVal = PairInfo.processLDevs(rmiObj, ldevIndexArray, task, targets, sourceLookup, pairVolumeInfo);
            if (retVal > 961) {
                Logger logger = Logger.getLogger("com.hitachi.smis.logger.cache");
                logger.severe("An insufficent number of pairs were processed, exiting pairInfo processing");
                index = 0;
                task.setStop(true);
                break;
            }
            arraySize = infoDetails.length - ((i -= retVal) + 1) > 2048 ? 2048 : infoDetails.length - (i + 1);
            ldevIndexArray = new int[arraySize];
            index = 0;
        }
        if (index > 0 && (processed = PairInfo.processLDevs(rmiObj, ldevIndexArray, task, targets, sourceLookup, pairVolumeInfo)) == 0) {
            index = 0;
        }
        if (index == 0) {
            task.processingDone();
            PairInfo.setPairInfoHashes(targets, sourceLookup, pairVolumeInfo);
        } else {
            task.setStop(true);
            Logger logger = Logger.getLogger("com.hitachi.smis.logger.cache");
            logger.severe("Failed to process all SI Pairs. non-fatal but cache may not reflect back end properly");
        }
    }

    private static synchronized int processLDevs(RMIObjectCache pObjCache, int[] ldevIndexes, Wait4ProcessTasks pTask, Hashtable<String, ArrayList<TargetVolumeInfo>> pTargets, Hashtable<String, String> pSourceLookup, Hashtable<String, PairVolumeInfo> pPairVolumeInfo) throws Exception {
        Logger logger = Logger.getLogger("com.hitachi.smis.logger.cache");
        int count = ldevIndexes.length;
        String serial = pObjCache.getSMISMappingContainer().getSerialNumber();
        Robj_interface_RJiSigetPairFilter pairFilter = (Robj_interface_RJiSigetPairFilter)pObjCache.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.RJISIGETPAIRFILTER);
        pairFilter.setLDEVIndex(ldevIndexes);
        Robj_interface_RJiSIPairParm pairPrm = (Robj_interface_RJiSIPairParm)pObjCache.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.RJISIPAIRPARM);
        pairPrm.setSTgtPp((short)10);
        pairPrm.setSiFlt(pairFilter);
        logger.log(Level.INFO, "Calling getSIPairVolInf with {0} elements for {1}", new Object[]{ldevIndexes.length, serial});
        Robj_interface_RJiSIgetPairStatus siPairStatus = pObjCache.getSIPairVolInf(pairPrm);
        Robj_interface_RJiSIgetPairLdev[] siPairLdevs = siPairStatus.getPairLdev();
        logger.log(Level.INFO, "getSIPairVolInf returned: {0} elements for {1}", new Object[]{null == siPairLdevs ? -1 : siPairLdevs.length, serial});
        if (null != siPairLdevs && siPairLdevs.length > 0) {
            for (Robj_interface_RJiSIgetPairLdev siPairLdev : siPairLdevs) {
                --count;
                SIPairWorkerThread worker = new SIPairWorkerThread(serial, pTask, siPairLdev, pTargets, pSourceLookup, pPairVolumeInfo);
                ProcessTask.addTask(worker);
            }
        }
        logger.info("PairInfo::Process return " + count);
        return count;
    }

    private static synchronized void setPairInfoHashes(Hashtable<String, ArrayList<TargetVolumeInfo>> pTargets, Hashtable<String, String> pSourceLookup, Hashtable<String, PairVolumeInfo> pPairVolumeInfo) {
        mTargets.putAll(pTargets);
        mSourceLookup.putAll(pSourceLookup);
        mPairVolumeInfo.putAll(pPairVolumeInfo);
    }

    private static class SIPairWorkerThread
    implements Task {
        private static final short KIND_SHADOWIMAGE = 1;
        Robj_interface_RJiSIgetPairLdev siPairLdev;
        private final Wait4ProcessTasks mTask;
        private final Hashtable<String, ArrayList<TargetVolumeInfo>> workerTargets;
        private final Hashtable<String, String> workerSourceLookup;
        private final Hashtable<String, PairVolumeInfo> workerPairVolInf;
        private final String mSerialNum;

        public SIPairWorkerThread(String serialNum, Wait4ProcessTasks task, Robj_interface_RJiSIgetPairLdev pInfo, Hashtable<String, ArrayList<TargetVolumeInfo>> pTargets, Hashtable<String, String> pSourceLookup, Hashtable<String, PairVolumeInfo> pPairVolumeInfo) {
            this.mSerialNum = serialNum;
            this.mTask = task;
            this.siPairLdev = pInfo;
            this.workerTargets = pTargets;
            this.workerSourceLookup = pSourceLookup;
            this.workerPairVolInf = pPairVolumeInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doTask() {
            block13: {
                try {
                    String sourceDNString = String.valueOf(BaseDeviceNumber.makeUniqueDN(this.siPairLdev.getSLDKC(), this.siPairLdev.getSCU(), this.siPairLdev.getSLDEV()));
                    short pairVolAttribute = this.siPairLdev.getVolAtrb();
                    boolean sourceCandidate = (pairVolAttribute & 4) == 4;
                    boolean targetCandidate = (pairVolAttribute & 2) == 2;
                    Robj_interface_RJiSIgetPairInf[] pairInfs = this.siPairLdev.getPairInf();
                    ArrayList<TargetVolumeInfo> targetList = new ArrayList<TargetVolumeInfo>(pairInfs.length);
                    boolean isShadowImage = false;
                    for (Robj_interface_RJiSIgetPairInf pairInf : pairInfs) {
                        String targetDNString = String.valueOf(BaseDeviceNumber.makeUniqueDN(pairInf.getSLDKC(), pairInf.getSCU(), pairInf.getSLDEV()));
                        short status = pairInf.getPairStatus();
                        short kind = pairInf.getKind();
                        if (kind != 1) continue;
                        isShadowImage = true;
                        targetList.add(new TargetVolumeInfo(this.mSerialNum, targetDNString, status, kind));
                        String key = PairInfo.createHashKey(this.mSerialNum, targetDNString);
                        Hashtable<String, String> hashtable = this.workerSourceLookup;
                        synchronized (hashtable) {
                            this.workerSourceLookup.put(key, sourceDNString);
                        }
                    }
                    if (!isShadowImage) break block13;
                    String key = PairInfo.createHashKey(this.mSerialNum, sourceDNString);
                    Hashtable<String, Object> hashtable = this.workerPairVolInf;
                    synchronized (hashtable) {
                        this.workerPairVolInf.put(key, new PairVolumeInfo(this.mSerialNum, sourceDNString, pairVolAttribute, sourceCandidate, targetCandidate));
                    }
                    if (null == targetList) break block13;
                    hashtable = this.workerTargets;
                    synchronized (hashtable) {
                        this.workerTargets.put(key, targetList);
                    }
                }
                finally {
                    this.mTask.taskProcessed();
                }
            }
        }
    }
}

