/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.ChassisArrayGroup;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.ThinPool;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;

public class StorageCapabilitiesIMPL
implements Serializable {
    private static final StorageCapabilitiesIMPL mImportedPrimodialCaps = new StorageCapabilitiesIMPL(-1, -1, false, ProviderConstants.UINT16_ONE, ProviderConstants.UINT16_ONE, ProviderConstants.UINT16_ONE, ProviderConstants.UINT16_ZED, ProviderConstants.UINT16_ZED, ProviderConstants.UINT16_ZED, null, null, null, null, true, true);
    private static final StorageCapabilitiesIMPL mPrimordialCaps = new StorageCapabilitiesIMPL(-1, -1, true, ProviderConstants.UINT16_TWO, ProviderConstants.UINT16_ONE, ProviderConstants.UINT16_ONE, ProviderConstants.UINT16_TWO, ProviderConstants.UINT16_ZED, ProviderConstants.UINT16_ONE, ProviderConstants.UINT16_FOUR, ProviderConstants.UINT16_TWO, null, null, false, true);
    private static final long serialVersionUID = 1L;
    protected int mArrayGroup;
    protected int mChassis;
    protected UnsignedInteger16 mDataRedun;
    protected UnsignedInteger16 mDataRedunMax;
    protected UnsignedInteger16 mDataRedunMin;
    protected UnsignedInteger16 mDeltaRes;
    protected UnsignedInteger16 mDeltaResMax;
    protected UnsignedInteger16 mDeltaResMin;
    protected UnsignedInteger16 mExtentStripLength;
    protected boolean mNoSinglePointOfFailure;
    protected UnsignedInteger16 mParityLayout;
    protected UnsignedInteger16 mPkgRedun;
    protected UnsignedInteger16 mPkgRedunMax;
    protected UnsignedInteger16 mPkgRedunMin;
    protected boolean mPrimordial;
    protected boolean mThin;
    protected String mRaidLevel;
    protected boolean mImported;
    protected String mSystemName;
    protected boolean mOpenVolume;
    protected boolean mAOUPool;

    public static final StorageCapabilitiesIMPL findCapabilities(int chassis, int arrayGroup, RMIObjectCache pRMIObj) throws WBEMException {
        StorageCapabilitiesIMPL ret = null;
        boolean getObjOnly = false;
        ChassisArrayGroup data = ChassisArrayGroup.find(pRMIObj, null, chassis, arrayGroup, false);
        if (data != null) {
            try {
                ret = new StorageCapabilitiesIMPL(data, pRMIObj.getSMISMappingContainer().getStorageSystemName());
            }
            catch (Exception e) {
                throw new WBEMException(1, "Exception while finding capabilities: " + e, null, (Throwable)e);
            }
        }
        return ret;
    }

    public static StorageCapabilitiesIMPL findThinPoolCapability(short thinPoolID, RMIObjectCache rmiObj) throws WBEMException {
        StorageCapabilitiesIMPL ret = null;
        try {
            ThinPool tp = ThinPool.find(rmiObj, thinPoolID, ThinPool.ThinPoolType.AOU);
            if (tp != null) {
                ret = new StorageCapabilitiesIMPL(tp, rmiObj.getSMISMappingContainer().getStorageSystemName());
            }
        }
        catch (Exception e) {
            throw new WBEMException(1, "Exception while finding capabilities: " + e, null, (Throwable)e);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final StorageCapabilitiesIMPL getImportedPrimordialCaps(String pSysName) throws WBEMException {
        StorageCapabilitiesIMPL newImportedPrimodialCaps;
        if (StorageCapabilitiesIMPL.mImportedPrimodialCaps.mSystemName == null && pSysName != null) {
            StorageCapabilitiesIMPL storageCapabilitiesIMPL = mImportedPrimodialCaps;
            synchronized (storageCapabilitiesIMPL) {
                StorageCapabilitiesIMPL.mImportedPrimodialCaps.mSystemName = pSysName;
                try {
                    newImportedPrimodialCaps = (StorageCapabilitiesIMPL)mImportedPrimodialCaps.clone();
                }
                catch (CloneNotSupportedException e) {
                    throw new NullPointerException("Clone not supported");
                }
                StorageCapabilitiesIMPL.mImportedPrimodialCaps.mSystemName = null;
            }
        }
        throw new WBEMException("System name must be provided");
        return newImportedPrimodialCaps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final StorageCapabilitiesIMPL getPrimordialCaps(String pSysName) throws WBEMException {
        StorageCapabilitiesIMPL newPrimodialCaps;
        if (StorageCapabilitiesIMPL.mPrimordialCaps.mSystemName == null && pSysName != null) {
            StorageCapabilitiesIMPL storageCapabilitiesIMPL = mPrimordialCaps;
            synchronized (storageCapabilitiesIMPL) {
                StorageCapabilitiesIMPL.mPrimordialCaps.mSystemName = pSysName;
                try {
                    newPrimodialCaps = (StorageCapabilitiesIMPL)mPrimordialCaps.clone();
                }
                catch (CloneNotSupportedException e) {
                    throw new NullPointerException("Clone not supported");
                }
                StorageCapabilitiesIMPL.mPrimordialCaps.mSystemName = null;
            }
        }
        throw new WBEMException("System name must be provided");
        return newPrimodialCaps;
    }

    protected static final String getSystemNameFromInstID(String instID) {
        String ret = null;
        int firstDot = 0;
        int secondDot = -1;
        firstDot = instID.indexOf(".");
        secondDot = instID.substring(firstDot).indexOf(".");
        ret = instID.substring(0, firstDot + secondDot);
        return ret;
    }

    protected StorageCapabilitiesIMPL() {
        this.mDeltaResMax = this.mDeltaRes = new UnsignedInteger16(100);
        this.mDeltaResMin = this.mDeltaRes;
        this.mThin = false;
        this.mChassis = -1;
        this.mArrayGroup = -1;
        this.mImported = false;
    }

    public StorageCapabilitiesIMPL(ChassisArrayGroup cag, String systemName) throws WBEMException {
        this();
        UnsignedInteger16 pkg;
        UnsignedInteger16 data;
        boolean raid1Plus = true;
        if (cag.getRaidLevel().compareTo("UNKNOWN") == 0 || cag.getRaidLevel().equalsIgnoreCase("RAID0")) {
            raid1Plus = false;
        }
        String rl = cag.getRaidLevel();
        this.mNoSinglePointOfFailure = raid1Plus;
        this.mChassis = cag.getChassis();
        this.mArrayGroup = cag.getArrayGroup();
        this.mImported = cag.isExternalVol();
        this.mSystemName = systemName;
        this.mDataRedunMax = data = new UnsignedInteger16(ProviderLibs.getDataRedudancy(rl));
        this.mDataRedunMin = data;
        this.mDataRedun = data;
        this.mPkgRedunMax = pkg = new UnsignedInteger16(ProviderLibs.getPackageRedudancy(rl));
        this.mPkgRedunMin = pkg;
        this.mPkgRedun = pkg;
        this.mExtentStripLength = new UnsignedInteger16(ProviderLibs.getExtentStripeLen(rl));
        this.mParityLayout = ProviderLibs.getParityLayout(rl);
        this.mOpenVolume = cag.isContainedDNsOpenVolume();
        this.mRaidLevel = this.mImported ? "UNKNOWN" : this.getRaidLevel();
    }

    protected StorageCapabilitiesIMPL(int pChassis, int pArrayGroup, boolean pNoSinglePointOfFailure, UnsignedInteger16 pDataRedunMax, UnsignedInteger16 pDataRedunMin, UnsignedInteger16 pDataRedunDefault, UnsignedInteger16 pPkgRedunMax, UnsignedInteger16 pPkgRedunMin, UnsignedInteger16 pPkgRedunDefault, UnsignedInteger16 pExtentStripLength, UnsignedInteger16 pParityLayout, String pRaidLevel, String pSystemName, boolean pImported, boolean pPrimordial) {
        this();
        this.mPrimordial = pPrimordial;
        if (!this.mPrimordial) {
            this.mChassis = pChassis;
            this.mArrayGroup = pArrayGroup;
        }
        this.mImported = pImported;
        this.mSystemName = pSystemName;
        this.mNoSinglePointOfFailure = pNoSinglePointOfFailure;
        this.mDataRedunMax = pDataRedunMax;
        this.mDataRedunMin = pDataRedunMin;
        this.mDataRedun = pDataRedunDefault;
        this.mPkgRedunMax = pPkgRedunMax;
        this.mPkgRedunMin = pPkgRedunMin;
        this.mPkgRedun = pPkgRedunDefault;
        this.mExtentStripLength = pExtentStripLength;
        this.mParityLayout = pParityLayout;
        this.mRaidLevel = pRaidLevel;
        this.mOpenVolume = true;
    }

    public StorageCapabilitiesIMPL(ThinPool tp, String systemName) {
        this();
        UnsignedInteger16 data;
        this.mThin = true;
        this.mAOUPool = tp.isAOUPool();
        this.mRaidLevel = tp.getRAIDLevel();
        this.mNoSinglePointOfFailure = this.mRaidLevel.startsWith("RAID");
        this.mChassis = -1;
        this.mArrayGroup = tp.getPoolID();
        this.mSystemName = systemName;
        this.mDataRedunMax = data = new UnsignedInteger16(ProviderLibs.getDataRedudancy(this.mRaidLevel));
        this.mDataRedunMin = data;
        this.mDataRedun = data;
        this.mPkgRedunMax = data = new UnsignedInteger16(ProviderLibs.getPackageRedudancy(this.mRaidLevel));
        this.mPkgRedunMin = data;
        this.mPkgRedun = data;
        int extStripeLen = ProviderLibs.getNumDisksInRaid(this.mRaidLevel);
        this.mExtentStripLength = 0 == extStripeLen ? null : new UnsignedInteger16(extStripeLen);
        this.mParityLayout = null;
        this.mOpenVolume = this.mAOUPool ? true : true;
    }

    protected Object clone() throws CloneNotSupportedException {
        StorageCapabilitiesIMPL clone = new StorageCapabilitiesIMPL();
        clone.mAOUPool = this.mAOUPool;
        clone.mArrayGroup = this.mArrayGroup;
        clone.mChassis = this.mChassis;
        clone.mDataRedun = new UnsignedInteger16(this.mDataRedun.intValue());
        clone.mDataRedunMax = new UnsignedInteger16(this.mDataRedunMax.intValue());
        clone.mDataRedunMin = new UnsignedInteger16(this.mDataRedunMin.intValue());
        clone.mDeltaRes = new UnsignedInteger16(this.mDeltaRes.intValue());
        clone.mDeltaResMax = new UnsignedInteger16(this.mDeltaResMax.intValue());
        clone.mDeltaResMin = new UnsignedInteger16(this.mDeltaResMin.intValue());
        clone.mExtentStripLength = null == this.mExtentStripLength ? null : new UnsignedInteger16(this.mExtentStripLength.intValue());
        clone.mImported = this.mImported;
        clone.mNoSinglePointOfFailure = this.mNoSinglePointOfFailure;
        clone.mOpenVolume = this.mOpenVolume;
        clone.mParityLayout = null == this.mParityLayout ? null : new UnsignedInteger16(this.mParityLayout.intValue());
        clone.mPkgRedun = new UnsignedInteger16(this.mPkgRedun.intValue());
        clone.mPkgRedunMax = new UnsignedInteger16(this.mPkgRedunMax.intValue());
        clone.mPkgRedunMin = new UnsignedInteger16(this.mPkgRedunMin.intValue());
        clone.mPrimordial = this.mPrimordial;
        clone.mRaidLevel = null == this.mRaidLevel ? null : new String(this.mRaidLevel);
        clone.mSystemName = null == this.mSystemName ? null : new String(this.mSystemName);
        clone.mThin = this.mThin;
        return clone;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().isAssignableFrom(this.getClass())) {
            return false;
        }
        StorageCapabilitiesIMPL other = (StorageCapabilitiesIMPL)obj;
        if (this.mAOUPool != other.mAOUPool) {
            return false;
        }
        if (this.mArrayGroup != other.mArrayGroup) {
            return false;
        }
        if (this.mChassis != other.mChassis) {
            return false;
        }
        if (this.mDataRedun == null ? other.mDataRedun != null : !this.mDataRedun.equals((Object)other.mDataRedun)) {
            return false;
        }
        if (this.mDataRedunMax == null ? other.mDataRedunMax != null : !this.mDataRedunMax.equals((Object)other.mDataRedunMax)) {
            return false;
        }
        if (this.mDataRedunMin == null ? other.mDataRedunMin != null : !this.mDataRedunMin.equals((Object)other.mDataRedunMin)) {
            return false;
        }
        if (this.mDeltaRes == null ? other.mDeltaRes != null : !this.mDeltaRes.equals((Object)other.mDeltaRes)) {
            return false;
        }
        if (this.mDeltaResMax == null ? other.mDeltaResMax != null : !this.mDeltaResMax.equals((Object)other.mDeltaResMax)) {
            return false;
        }
        if (this.mDeltaResMin == null ? other.mDeltaResMin != null : !this.mDeltaResMin.equals((Object)other.mDeltaResMin)) {
            return false;
        }
        if (this.mExtentStripLength == null ? other.mExtentStripLength != null : !this.mExtentStripLength.equals((Object)other.mExtentStripLength)) {
            return false;
        }
        if (this.mImported != other.mImported) {
            return false;
        }
        if (this.mNoSinglePointOfFailure != other.mNoSinglePointOfFailure) {
            return false;
        }
        if (this.mOpenVolume != other.mOpenVolume) {
            return false;
        }
        if (this.mParityLayout == null ? other.mParityLayout != null : !this.mParityLayout.equals((Object)other.mParityLayout)) {
            return false;
        }
        if (this.mPkgRedun == null ? other.mPkgRedun != null : !this.mPkgRedun.equals((Object)other.mPkgRedun)) {
            return false;
        }
        if (this.mPkgRedunMax == null ? other.mPkgRedunMax != null : !this.mPkgRedunMax.equals((Object)other.mPkgRedunMax)) {
            return false;
        }
        if (this.mPkgRedunMin == null ? other.mPkgRedunMin != null : !this.mPkgRedunMin.equals((Object)other.mPkgRedunMin)) {
            return false;
        }
        if (this.mPrimordial != other.mPrimordial) {
            return false;
        }
        if (this.mRaidLevel == null) {
            if (other.mRaidLevel != null) {
                return false;
            }
        } else {
            try {
                if (!this.mRaidLevel.equals(other.getRaidLevel())) {
                    return false;
                }
            }
            catch (WBEMException e) {
                Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
                logger.log(Level.SEVERE, "exception getting raid level from " + other, e);
                return false;
            }
        }
        if (this.mSystemName == null ? other.mSystemName != null : !this.mSystemName.equals(other.mSystemName)) {
            return false;
        }
        return this.mThin == other.mThin;
    }

    public final int getArrayGroup() {
        return this.mArrayGroup;
    }

    public final int getChassis() {
        return this.mChassis;
    }

    public final UnsignedInteger16 getDataRedun() {
        return this.mDataRedun;
    }

    public final UnsignedInteger16 getDataRedunMax() {
        return this.mDataRedunMax;
    }

    public final UnsignedInteger16 getDataRedunMin() {
        return this.mDataRedunMin;
    }

    public final UnsignedInteger16 getDeltaReservation() {
        return this.mDeltaRes;
    }

    public final UnsignedInteger16 getDeltaReservationMax() {
        return this.mDeltaResMax;
    }

    public final UnsignedInteger16 getDeltaReservationMin() {
        return this.mDeltaResMin;
    }

    public final UnsignedInteger16 getElementType() {
        return ProviderConstants.UINT16_FIVE;
    }

    public final UnsignedInteger16 getExtentStripLength() {
        return this.mExtentStripLength;
    }

    public String getInstanceID() {
        if (null == this.mSystemName) {
            throw new NullPointerException("System name can not be null");
        }
        StringBuffer ret = new StringBuffer(this.mSystemName);
        ret.append(".");
        if (!this.mPrimordial) {
            if (!this.mThin) {
                ret.append(this.mChassis);
                ret.append(".");
            }
            ret.append(this.mArrayGroup);
        } else {
            if (this.mImported) {
                ret.append("Imported");
            }
            ret.append("Primordial");
        }
        return ret.toString();
    }

    public final UnsignedInteger16 getParityLayout() {
        return this.mParityLayout;
    }

    public final UnsignedInteger16 getPkgRedun() {
        return this.mPkgRedun;
    }

    public final UnsignedInteger16 getPkgRedunMax() {
        return this.mPkgRedunMax;
    }

    public final UnsignedInteger16 getPkgRedunMin() {
        return this.mPkgRedunMin;
    }

    public final String getRaidLevel() throws WBEMException {
        String ret;
        Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
        if (null != this.mRaidLevel && this.mRaidLevel.startsWith("RAID")) {
            ret = this.mRaidLevel;
        } else if (ProviderConstants.UINT16_TWO.equals((Object)this.getDataRedun())) {
            ret = "RAID 1(2D+2P)";
        } else if (ProviderConstants.UINT16_ONE.equals((Object)this.getPkgRedun())) {
            switch (this.getExtentStripLength().intValue()) {
                case 4: {
                    ret = "RAID5(3D+1P)";
                    break;
                }
                case 5: {
                    ret = "RAID5(4D+1P)";
                    break;
                }
                case 7: {
                    ret = "RAID5(6D+1P)";
                    break;
                }
                case 8: {
                    ret = "RAID5(7D+1P)";
                    break;
                }
                default: {
                    logger.log(Level.SEVERE, "{0} is not supported for ExtentStripLength, defaulting to RAID5(3D+1P)", this.getExtentStripLength());
                    this.mExtentStripLength = ProviderConstants.UINT16_EIGHT;
                    ret = "RAID5(3D+1P)";
                    break;
                }
            }
        } else if (ProviderConstants.UINT16_TWO.equals((Object)this.getPkgRedun())) {
            switch (this.getExtentStripLength().intValue()) {
                case 8: {
                    ret = "RAID6(6D+2P)";
                    break;
                }
                case 14: {
                    ret = "RAID6(12D+2P)";
                    break;
                }
                case 16: {
                    ret = "RAID6(14D+2P)";
                    break;
                }
                default: {
                    logger.log(Level.SEVERE, "{0} is not supported for ExtentStripLength, defaulting to RAID5(6D+2P)", this.getExtentStripLength());
                    this.mExtentStripLength = ProviderConstants.UINT16_EIGHT;
                    ret = "RAID6(6D+2P)";
                    break;
                }
            }
        } else {
            LogRecord record = new LogRecord(Level.WARNING, "Unknown RAID level for:{1}{2}");
            record.setParameters(new Object[]{System.lineSeparator(), this});
            if (logger.isLoggable(Level.FINE)) {
                record.setThrown(new WBEMException("used for stack trace only"));
            }
            logger.log(record);
            ret = "UNKNOWN";
        }
        return ret;
    }

    public final String getSerialNumber() {
        return ProviderLibs.getSerialFromString(this.mSystemName);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mAOUPool ? 1231 : 1237);
        result = 31 * result + this.mArrayGroup;
        result = 31 * result + this.mChassis;
        result = 31 * result + (this.mDataRedun == null ? 0 : this.mDataRedun.hashCode());
        result = 31 * result + (this.mDataRedunMax == null ? 0 : this.mDataRedunMax.hashCode());
        result = 31 * result + (this.mDataRedunMin == null ? 0 : this.mDataRedunMin.hashCode());
        result = 31 * result + (this.mDeltaRes == null ? 0 : this.mDeltaRes.hashCode());
        result = 31 * result + (this.mDeltaResMax == null ? 0 : this.mDeltaResMax.hashCode());
        result = 31 * result + (this.mDeltaResMin == null ? 0 : this.mDeltaResMin.hashCode());
        result = 31 * result + (this.mExtentStripLength == null ? 0 : this.mExtentStripLength.hashCode());
        result = 31 * result + (this.mImported ? 1231 : 1237);
        result = 31 * result + (this.mNoSinglePointOfFailure ? 1231 : 1237);
        result = 31 * result + (this.mOpenVolume ? 1231 : 1237);
        result = 31 * result + (this.mParityLayout == null ? 0 : this.mParityLayout.hashCode());
        result = 31 * result + (this.mPkgRedun == null ? 0 : this.mPkgRedun.hashCode());
        result = 31 * result + (this.mPkgRedunMax == null ? 0 : this.mPkgRedunMax.hashCode());
        result = 31 * result + (this.mPkgRedunMin == null ? 0 : this.mPkgRedunMin.hashCode());
        result = 31 * result + (this.mPrimordial ? 1231 : 1237);
        result = 31 * result + (this.mRaidLevel == null ? 0 : this.mRaidLevel.hashCode());
        result = 31 * result + (this.mSystemName == null ? 0 : this.mSystemName.hashCode());
        result = 31 * result + (this.mThin ? 1231 : 1237);
        return result;
    }

    public final boolean isNoSinglePointOfFailure() {
        return this.mNoSinglePointOfFailure;
    }

    public final boolean isOpenVolume() {
        return this.mOpenVolume;
    }

    public final String toString() {
        return this.getInstanceID();
    }
}

