/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderDataProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cim.CIMDateTime;
import javax.wbem.WBEMException;

public class UserDefinedProperties {
    private static volatile UserDefinedProperties singleton = null;
    private static final Logger mLogger = Logger.getLogger("com.hitachi.smis.logger.provider");
    public static final String USERDEFINED_PROPERTIES = "user-defined.properties";
    private static final String USERDEF_INSTALLDATE = "InstallDate";
    private final Properties mProps;

    public static String getResourceRestriction() throws WBEMException {
        return UserDefinedProperties.getUserDefinedProperties().getProperty("ResourceGroup", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UserDefinedProperties getUserDefinedProperties() throws WBEMException {
        UserDefinedProperties t = singleton;
        if (null != t) return t;
        Class<UserDefinedProperties> clazz = UserDefinedProperties.class;
        synchronized (UserDefinedProperties.class) {
            t = singleton;
            if (null != t) return t;
            singleton = new UserDefinedProperties();
            return singleton;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop() {
        Class<UserDefinedProperties> clazz = UserDefinedProperties.class;
        synchronized (UserDefinedProperties.class) {
            singleton = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private UserDefinedProperties() throws WBEMException {
        block20: {
            this.mProps = new Properties();
            File udFile = null;
            StringBuilder propFile = new StringBuilder(ProviderConstants.getConfigDirectory());
            propFile.append(USERDEFINED_PROPERTIES);
            udFile = new File(propFile.toString());
            try {
                if (!udFile.exists()) break block20;
                try (FileInputStream in = new FileInputStream(udFile);){
                    mLogger.info("user-defined.properties loading data");
                    this.mProps.load(in);
                }
            }
            catch (FileNotFoundException fnf) {
                mLogger.log(Level.WARNING, "user-defined.properties could not be found", fnf);
            }
            catch (IOException ioe) {
                throw new WBEMException(1, "Error getting data from user-defined.properties", null, (Throwable)ioe);
            }
            finally {
                if (null != udFile && !udFile.delete()) {
                    mLogger.log(Level.WARNING, "Unable to delete user-defined.properties");
                }
                mLogger.info("user-defined.properties data loaded.");
            }
        }
    }

    public String getInstallDate() {
        String ret = null;
        try {
            ProviderDataProperties pdp = ProviderDataProperties.getProviderData();
            ret = pdp.getProperty(USERDEF_INSTALLDATE, null);
        }
        catch (WBEMException we) {
            mLogger.log(Level.SEVERE, "Failure getting InstallDate", we);
        }
        return ret;
    }

    private String getProperty(String propName, String defaultValue) {
        return this.mProps.getProperty(propName, defaultValue);
    }

    public void setInstallDate(CIMDateTime installDate) {
        if (null != installDate) {
            try {
                ProviderDataProperties pdp = ProviderDataProperties.getProviderData();
                pdp.addOrUpdateProperty(USERDEF_INSTALLDATE, installDate.toString());
                pdp.saveProperties();
            }
            catch (WBEMException we) {
                mLogger.log(Level.SEVERE, "Failure updating InstallDate", we);
            }
        }
    }
}

