/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.ThinPool;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public final class AssociatedThinProvisioningPoolComponentCompositeLDEVExtentInstrumentation
extends BaseAssocInstrumentation {
    private static final String CCN_HITACHI_ASSOCIATEDTHINPROVISIONINGPOOLCOMPONENTCOMPOSITELDEVEXTENT = "HITACHI_AssociatedThinProvisioningPoolComponentCompositeLDEVExtent";
    private static final String CCN_GROUPCOMPONENT = "HITACHI_ThinProvisioningPool";
    private static final String CPN_GROUPCOMPONENT = "GroupComponent";
    private static final String CCN_PARTCOMPONENT = "HITACHI_CompositeLDEVExtent";
    private static final String CPN_PARTCOMPONENT = "PartComponent";

    protected AssociatedThinProvisioningPoolComponentCompositeLDEVExtentInstrumentation() {
        super(CCN_HITACHI_ASSOCIATEDTHINPROVISIONINGPOOLCOMPONENTCOMPOSITELDEVEXTENT, CCN_GROUPCOMPONENT, CPN_GROUPCOMPONENT, BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.ThinProvisioningPoolInstrumentation"), CCN_PARTCOMPONENT, CPN_PARTCOMPONENT, BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.CompositeLDEVExtentInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, boolean shouldTestInst) throws WBEMException {
        try {
            boolean needToCloseIter = true;
            if (null != assocName && CCN_HITACHI_ASSOCIATEDTHINPROVISIONINGPOOLCOMPONENTCOMPOSITELDEVEXTENT.equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference2PropertyName()))) {
                    if (!shouldTestInst || this.getReference1Instrumentation().instanceExists(objectName)) {
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "InstanceID");
                        CIMProperty cpPoolID = objectName.getKey("InstanceID");
                        String strPoolID = (String)cpPoolID.getValue();
                        short poolID = Short.parseShort(ProviderLibs.getEndString(strPoolID, ProviderConstants.ID_SEPERATOR_AS_CHAR));
                        this.getCompositeLDEVsFromThinPool(device.getRMIObject(), iter, objectName, propertyList, isObjectPath, poolID, true);
                    }
                } else if (!(!objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) || null != role && !role.equalsIgnoreCase(this.getReference2PropertyName()) || null != resultRole && !resultRole.equalsIgnoreCase(this.getReference1PropertyName()) || shouldTestInst && !this.getReference2Instrumentation().instanceExists(objectName))) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    CIMProperty cpDevID = objectName.getKey("DeviceID");
                    String strDevID = (String)cpDevID.getValue();
                    ThinPool tp = ThinPool.find(device.getRMIObject(), Long.valueOf(strDevID), ThinPool.ThinPoolType.AOU);
                    if (tp != null) {
                        if (isObjectPath) {
                            CIMObjectPath retOP = this.getReference1Instrumentation().generateObjectPath(objectName, tp);
                            if (retOP != null) {
                                iter.add(retOP);
                            }
                        } else {
                            CIMInstance ret = this.getReference1Instrumentation().generateInstance(objectName, propertyList, tp);
                            if (ret != null) {
                                iter.add(ret);
                            }
                        }
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        block6: {
            Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
            try {
                for (RMIObjectMapping device : devices) {
                    this.getCompositeLDEVsFromThinPool(device.getRMIObject(), iter, op, propertyList, isObjectPath, (short)-1, false);
                }
            }
            catch (WBEMException we) {
                if (null != iter) {
                    iter.setException(we);
                    iter.close();
                }
                throw we;
            }
            catch (Throwable th) {
                if (null == iter) break block6;
                WBEMException we = new WBEMException(1, th.toString(), null, th);
                iter.setException(we);
                iter.close();
                throw we;
            }
        }
        if (null != iter) {
            iter.done();
        }
    }

    private void getCompositeLDEVsFromThinPool(RMIObjectCache objCache, CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, boolean isObjectPath, short tPoolID, boolean isAssocCall) throws Exception {
        CommonClassAsList<ThinPool> callback = new CommonClassAsList<ThinPool>();
        ThinPool.getThinPools(objCache, callback, tPoolID, true);
        LinkedList<ThinPool> tPools = callback.getReturnValue();
        callback = null;
        ThinPool tp = tPools.poll();
        while (tp != null) {
            CIMObjectPath antObj = this.getReference1Instrumentation().generateObjectPath(op, tp);
            Set<String> containedDNs = tp.getContainingLDEVs();
            for (String DN : containedDNs) {
                DeviceNumber data = DeviceNumber.find(DN, true, objCache);
                if (data == null) continue;
                CIMObjectPath depObj = this.getReference2Instrumentation().generateObjectPath(op, data);
                if (isObjectPath) {
                    CIMObjectPath retOP = !isAssocCall ? this.generateObjectPath(op, antObj, depObj) : depObj;
                    if (retOP == null) continue;
                    iter.add(retOP);
                    continue;
                }
                CIMInstance ret = !isAssocCall ? this.generateInstance(op, propertyList, antObj, depObj) : this.getReference2Instrumentation().generateInstance(op, propertyList, data);
                if (ret == null) continue;
                iter.add(ret);
            }
            tp = tPools.poll();
        }
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            boolean needToCloseIter = true;
            if (null != assocName && CCN_HITACHI_ASSOCIATEDTHINPROVISIONINGPOOLCOMPONENTCOMPOSITELDEVEXTENT.equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName()))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "InstanceID");
                        CIMProperty cpPoolID = objectName.getKey("InstanceID");
                        String strPoolID = (String)cpPoolID.getValue();
                        short poolID = Short.parseShort(ProviderLibs.getEndString(strPoolID, ProviderConstants.ID_SEPERATOR_AS_CHAR));
                        this.getCompositeLDEVsFromThinPool(device.getRMIObject(), iter, objectName, propertyList, isObjectPath, poolID, false);
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    CIMProperty cpDevID = objectName.getKey("DeviceID");
                    String strDevID = (String)cpDevID.getValue();
                    ThinPool tp = ThinPool.find(device.getRMIObject(), Long.valueOf(strDevID), ThinPool.ThinPoolType.AOU);
                    if (tp != null) {
                        CIMObjectPath opGroup = this.getReference1Instrumentation().generateObjectPath(objectName, tp);
                        CIMObjectPath opPart = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), objectName.getObjectName(), objectName.getKeys(), objectName.getXmlSchemaName());
                        if (isObjectPath) {
                            CIMObjectPath retOP = this.generateObjectPath(objectName, opGroup, opPart);
                            if (retOP != null) {
                                iter.add(retOP);
                            }
                        } else {
                            CIMInstance ret = this.generateInstance(objectName, propertyList, opGroup, opPart);
                            if (ret != null) {
                                iter.add(ret);
                            }
                        }
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we1 = new WBEMException(1, th.toString(), null, th);
            mLogger.log(Level.SEVERE, th.getLocalizedMessage(), th);
            if (null != iter) {
                iter.setException(we1);
                iter.close();
            }
            throw we1;
        }
    }
}

