/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.AbstractBaseCommonObject;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.IteratorCallbackIMPL;
import com.hitachi.smi.common.PDEVInfoEntry;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;

public class DiskInStorageProductInstrumentation
extends BaseAssocInstrumentation {
    protected DiskInStorageProductInstrumentation() {
        super("HITACHI_DiskInStorageProduct", "HITACHI_StorageProduct", "Parent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageProductInstrumentation"), "HITACHI_DiskProduct", "Child", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.DiskProductInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            boolean needToCloseIter = true;
            if (null != assocName && "HITACHI_DiskInStorageProduct".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase("Parent")) && (null == resultRole || resultRole.equalsIgnoreCase("Child"))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "IdentifyingNumber", ".", 0);
                        Hashtable<String, Object> depSearchProps = new Hashtable<String, Object>();
                        depSearchProps.put("Name", device.getStorageSystemName());
                        this.getReference2Instrumentation().enumerate(iter, objectName, propertyList, filterQueryLanguage, filterQuery, continueOnError, isObjectPath, depSearchProps, null);
                        needToCloseIter = false;
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference1PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Name");
                    if (isObjectPath) {
                        iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, device.getModel(), device.getSerialNumber(), device.getVendor()));
                    } else {
                        iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, device.getModel(), device.getSerialNumber(), device.getVendor()));
                    }
                }
            }
            if (null != iter && needToCloseIter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devs = RMIObjectMapping.getAllRMIObjectMappings();
        ArrayList<RMIObjectMapping> devices = new ArrayList<RMIObjectMapping>(devs);
        ArrayList iterList = new ArrayList(devices.size());
        try {
            for (RMIObjectMapping rMIObjectMapping : devices) {
                CustomCloseableIterator threadIter = isObjectPath ? new CustomCloseableIterator() : new CustomCloseableIterator();
                iterList.add(threadIter);
                CallbackIMPL<PDEVInfoEntry> callback = new CallbackIMPL<PDEVInfoEntry>(threadIter, isObjectPath, refInfo, op, propertyList);
                PDEVInfoEntry.getPDEVInfoEntry(rMIObjectMapping.getRMIObject(), callback);
            }
            for (CustomCloseableIterator customCloseableIterator : iterList) {
                while (customCloseableIterator.hasNext()) {
                    if (isObjectPath) {
                        iter.add((CIMObjectPath)customCloseableIterator.next());
                        continue;
                    }
                    iter.add((CIMInstance)customCloseableIterator.next());
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException wBEMException = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(wBEMException);
                iter.close();
            }
            throw wBEMException;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            CIMObjectPath opDiskProduct;
            String pnStorageProduct = this.getReference1PropertyName();
            CIMObjectPath opStorageProduct = op.getKey(pnStorageProduct) != null ? (CIMObjectPath)op.getKey(pnStorageProduct).getValue() : null;
            String pnDiskProduct = this.getReference2PropertyName();
            CIMObjectPath cIMObjectPath = opDiskProduct = op.getKey(pnDiskProduct) != null ? (CIMObjectPath)op.getKey(pnDiskProduct).getValue() : null;
            if (null != opStorageProduct && null != opDiskProduct) {
                CIMInstance instStorageProduct = this.getReference1Instrumentation().getInstance(opStorageProduct, null);
                CIMInstance instDiskProduct = this.getReference2Instrumentation().getInstance(opDiskProduct, null);
                if (null != instStorageProduct && null != instDiskProduct) {
                    return this.generateInstance(op, propertyList, instStorageProduct.getObjectPath(), instDiskProduct.getObjectPath());
                }
            }
            throw new WBEMException(6, op.toString());
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            boolean needToCloseIter = true;
            if (null != assocName && "HITACHI_DiskInStorageProduct".equalsIgnoreCase(assocName.getObjectName())) {
                String cnStorageProduct = this.getReference1ClassName();
                String cnDiskProduct = this.getReference2ClassName();
                String pnStorageProduct = this.getReference1PropertyName();
                String pnDiskProduct = this.getReference2PropertyName();
                if (objectName.getObjectName().equalsIgnoreCase(cnStorageProduct) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName()))) {
                    CIMInstance instStorageProduct = null;
                    try {
                        instStorageProduct = this.getReference1Instrumentation().getInstance(objectName, null);
                    }
                    catch (WBEMException we) {
                        // empty catch block
                    }
                    if (null != instStorageProduct) {
                        CIMObjectPath opDiskProduct = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), this.getReference2ClassName(), null, objectName.getXmlSchemaName());
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "IdentifyingNumber", ".", 0);
                        Hashtable<String, Object> depSearchProps = new Hashtable<String, Object>();
                        depSearchProps.put("Name", device.getStorageSystemName());
                        ReferenceInfo refInfo = new ReferenceInfo(instStorageProduct.getObjectPath(), null, pnStorageProduct, pnDiskProduct, propertyList, isObjectPath, this);
                        this.getReference2Instrumentation().enumerate(iter, opDiskProduct, new String[0], null, null, continueOnError, true, depSearchProps, refInfo);
                        needToCloseIter = false;
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(cnDiskProduct) && (null == role || role.equalsIgnoreCase(pnDiskProduct))) {
                    CIMInstance instDiskProduct = null;
                    try {
                        instDiskProduct = this.getReference2Instrumentation().getInstance(objectName, null);
                    }
                    catch (WBEMException we) {
                        // empty catch block
                    }
                    if (null != instDiskProduct) {
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Name");
                        CIMObjectPath opStorageProduct = this.getReference1Instrumentation().generateObjectPath(objectName, device.getModel(), device.getSerialNumber(), device.getVendor());
                        if (isObjectPath) {
                            iter.add(this.generateObjectPath(objectName, opStorageProduct, instDiskProduct.getObjectPath()));
                        } else {
                            iter.add(this.generateInstance(objectName, propertyList, opStorageProduct, instDiskProduct.getObjectPath()));
                        }
                    }
                }
            }
            if (null != iter && needToCloseIter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    public class CallbackIMPL<E extends PDEVInfoEntry>
    extends IteratorCallbackIMPL<E> {
        public CallbackIMPL(CustomCloseableIterator<?> iter, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList) {
            super(iter, isObjectPath, refInfo, op, propertyList);
        }

        @Override
        public boolean returnItem(E item) {
            boolean ret;
            block5: {
                ret = true;
                if (!this.mIter.isClosed()) {
                    try {
                        E entry = item;
                        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(((AbstractBaseCommonObject)entry).getSerialNumber());
                        CIMObjectPath opStorageProduct = DiskInStorageProductInstrumentation.this.getReference1Instrumentation().generateObjectPath(this.mOP, device.getModel(), device.getSerialNumber(), device.getVendor());
                        CIMObjectPath opDiskProduct = DiskInStorageProductInstrumentation.this.getReference2Instrumentation().generateObjectPath(this.mOP, entry);
                        CIMInstance instAssoc = DiskInStorageProductInstrumentation.this.generateInstance(this.mOP, this.mPropertyList, opStorageProduct, opDiskProduct);
                        if (this.mIsObjectPath) {
                            this.mIter.add(instAssoc.getObjectPath());
                            break block5;
                        }
                        this.mIter.add(instAssoc.filterProperties(this.mPropertyList));
                    }
                    catch (Throwable thrown) {
                        WBEMException we = new WBEMException(1, thrown.toString(), null, thrown);
                        this.mIter.setException(we);
                        this.mIter.close();
                        ret = false;
                    }
                } else {
                    ret = false;
                }
            }
            return ret;
        }
    }
}

