/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.FCPort;
import com.hitachi.smi.common.FCPortCallbackHandler;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;

public class FCPortForSCSIProtocolEndpointImplementationInstrumentation
extends BaseAssocInstrumentation {
    protected FCPortForSCSIProtocolEndpointImplementationInstrumentation() {
        super("HITACHI_FCPortForSCSIProtocolEndpointImplementation", "HITACHI_FCPort", "Antecedent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.FCPortInstrumentation"), "HITACHI_SCSIProtocolEndpoint", "Dependent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.SCSIProtocolEndpointInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, boolean shouldTestInst) throws WBEMException {
        block19: {
            try {
                if (null != assocName && "HITACHI_FCPortForSCSIProtocolEndpointImplementation".equalsIgnoreCase(assocName.getObjectName())) {
                    String assocClassName = null;
                    String portWWNVal = null;
                    String sysNameVal = null;
                    if (objectName.getObjectName().equalsIgnoreCase("HITACHI_FCPort") && (null == role || role.equalsIgnoreCase("Antecedent")) && (null == resultRole || resultRole.equalsIgnoreCase("Dependent"))) {
                        assocClassName = "HITACHI_SCSIProtocolEndpoint";
                        portWWNVal = objectName.getKey("DeviceID") != null ? (String)objectName.getKey("DeviceID").getValue() : null;
                        sysNameVal = objectName.getKey("SystemName") != null ? (String)objectName.getKey("SystemName").getValue() : null;
                    } else if (objectName.getObjectName().equalsIgnoreCase("HITACHI_SCSIProtocolEndpoint") && (null == role || role.equalsIgnoreCase("Dependent")) && (null == resultRole || resultRole.equalsIgnoreCase("Antecedent"))) {
                        assocClassName = "HITACHI_FCPort";
                        portWWNVal = objectName.getKey("Name") != null ? (String)objectName.getKey("Name").getValue() : null;
                        String string = sysNameVal = objectName.getKey("SystemName") != null ? (String)objectName.getKey("SystemName").getValue() : null;
                    }
                    if (null != assocClassName && null != portWWNVal && null != sysNameVal) {
                        String sysName;
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                        FCPort port = FCPort.find(portWWNVal, FCPort.PortTypeRequested.OPEN, device.getRMIObject());
                        if (iter.isClosed()) {
                            return;
                        }
                        if (port != null && sysNameVal.equals(sysName = device.getStorageSystemName() + "." + port.getControlID())) {
                            if (assocClassName.equalsIgnoreCase("HITACHI_FCPort")) {
                                if (isObjectPath) {
                                    iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, port));
                                } else {
                                    iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, port, null));
                                }
                            } else if (isObjectPath) {
                                iter.add(this.getReference2Instrumentation().generateObjectPath(objectName, port));
                            } else {
                                iter.add(this.getReference2Instrumentation().generateInstance(objectName, propertyList, port, null));
                            }
                        }
                    }
                }
            }
            catch (WBEMException we) {
                if (we.getID() != 6) {
                    if (null != iter) {
                        iter.setException(we);
                        iter.close();
                    }
                    throw we;
                }
            }
            catch (Throwable th) {
                if (null == iter) break block19;
                WBEMException we = new WBEMException(1, th.toString(), null, th);
                iter.setException(we);
                iter.close();
                throw we;
            }
        }
        if (null != iter) {
            iter.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        PassthruIterator deviceIter = new PassthruIterator(iter);
        try {
            for (RMIObjectMapping device : devices) {
                FCPortCallbackHandler<FCPort> callback = new FCPortCallbackHandler<FCPort>(deviceIter, isObjectPath, refInfo, op, propertyList, FCPort.PortTypeRequested.OPEN, this);
                FCPort.getFCPorts(device.getRMIObject(), callback, isObjectPath, propertyList != null && propertyList.length != 0, null, null);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            if (null != iter) {
                WBEMException we = new WBEMException(1, th.toString(), null, th);
                iter.setException(we);
                iter.close();
                throw we;
            }
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            CIMObjectPath opSCSIPE;
            CIMObjectPath opFCPort = op.getKey("Antecedent") != null ? (CIMObjectPath)op.getKey("Antecedent").getValue() : null;
            CIMObjectPath cIMObjectPath = opSCSIPE = op.getKey("Dependent") != null ? (CIMObjectPath)op.getKey("Dependent").getValue() : null;
            if (null != opFCPort && null != opSCSIPE) {
                FCPort port;
                String scsiPEPortSysName;
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(opFCPort, "SystemName");
                String fcPortWWN = null != opFCPort.getKey("DeviceID") && null != opFCPort.getKey("DeviceID").getValue() ? (String)opFCPort.getKey("DeviceID").getValue() : null;
                String fcPortSysName = null != opFCPort.getKey("SystemName") && null != opFCPort.getKey("SystemName").getValue() ? (String)opFCPort.getKey("SystemName").getValue() : null;
                String scsiPEPortWWN = null != opSCSIPE.getKey("Name") && null != opSCSIPE.getKey("Name").getValue() ? (String)opSCSIPE.getKey("Name").getValue() : null;
                String string = scsiPEPortSysName = null != opSCSIPE.getKey("SystemName") && null != opSCSIPE.getKey("SystemName").getValue() ? (String)opSCSIPE.getKey("SystemName").getValue() : null;
                if (null != fcPortWWN && fcPortWWN.equals(scsiPEPortWWN) && null != fcPortSysName && fcPortSysName.equals(scsiPEPortSysName) && (port = FCPort.find(fcPortWWN, FCPort.PortTypeRequested.OPEN, device.getRMIObject())) != null) {
                    String sysName;
                    String string2 = sysName = opSCSIPE.getKey("SystemName") != null ? (String)opSCSIPE.getKey("SystemName").getValue() : null;
                    if (fcPortSysName.equals(sysName)) {
                        opFCPort = this.getReference1Instrumentation().generateObjectPath(op, port);
                        opSCSIPE = this.getReference2Instrumentation().generateObjectPath(op, port);
                        return this.generateInstance(op, propertyList, opFCPort, opSCSIPE);
                    }
                }
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        block14: {
            try {
                if (null != assocName && "HITACHI_FCPortForSCSIProtocolEndpointImplementation".equalsIgnoreCase(assocName.getObjectName())) {
                    String sysNameVal;
                    String portWWNVal = null;
                    String string = sysNameVal = objectName.getKey("SystemName") != null ? (String)objectName.getKey("SystemName").getValue() : null;
                    if (objectName.getObjectName().equalsIgnoreCase("HITACHI_FCPort") && (null == role || role.equalsIgnoreCase("Antecedent"))) {
                        portWWNVal = objectName.getKey("DeviceID") != null ? (String)objectName.getKey("DeviceID").getValue() : null;
                    } else if (objectName.getObjectName().equalsIgnoreCase("HITACHI_SCSIProtocolEndpoint")) {
                        String string2 = portWWNVal = objectName.getKey("Name") != null ? (String)objectName.getKey("Name").getValue() : null;
                    }
                    if (null != portWWNVal && null != sysNameVal) {
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                        FCPort port = FCPort.find(portWWNVal, FCPort.PortTypeRequested.OPEN, device.getRMIObject());
                        if (iter.isClosed()) {
                            return;
                        }
                        short ctrlID = port.getControlID();
                        String sysName = device.getStorageSystemName() + "." + ctrlID;
                        if (sysNameVal.equals(sysName)) {
                            CIMObjectPath opFCPort = this.getReference1Instrumentation().generateObjectPath(objectName, port);
                            CIMObjectPath opSCSIPE = this.getReference2Instrumentation().generateObjectPath(objectName, port);
                            if (isObjectPath) {
                                iter.add(this.generateObjectPath(objectName, opFCPort, opSCSIPE));
                            } else {
                                iter.add(this.generateInstance(objectName, propertyList, opFCPort, opSCSIPE));
                            }
                        }
                    }
                }
            }
            catch (WBEMException we) {
                if (null != iter) {
                    iter.setException(we);
                    iter.close();
                }
                throw we;
            }
            catch (Throwable th) {
                if (null == iter) break block14;
                WBEMException we = new WBEMException(1, th.toString(), null, th);
                iter.setException(we);
                iter.close();
                throw we;
            }
        }
        if (null != iter) {
            iter.done();
        }
    }
}

