/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;

public class HostedLunMaskPrivilegeServiceInstrumentation
extends BaseAssocInstrumentation {
    protected HostedLunMaskPrivilegeServiceInstrumentation() {
        super("HITACHI_HostedLunMaskPrivilegeService", "HITACHI_StorageSystem", "Antecedent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageSystemInstrumentation"), "HITACHI_LunMaskPrivilegeService", "Dependent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.LunMaskPrivilegeServiceInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_HostedLunMaskPrivilegeService".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference2PropertyName())) && this.getReference1Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Name");
                    if (isObjectPath) {
                        iter.add(this.getReference2Instrumentation().generateObjectPath(objectName, device.getRMIObject()));
                    } else {
                        iter.add(this.getReference2Instrumentation().generateInstance(objectName, propertyList, device.getRMIObject()));
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference1PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    if (isObjectPath) {
                        iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject()));
                    } else {
                        iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, device.getRMIObject()));
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
            for (RMIObjectMapping device : devices) {
                CIMObjectPath ssOP = this.getReference1Instrumentation().generateObjectPath(op, device.getRMIObject());
                CIMObjectPath lmpsOP = this.getReference2Instrumentation().generateObjectPath(op, device.getRMIObject());
                if (isObjectPath) {
                    iter.add(this.generateObjectPath(op, ssOP, lmpsOP));
                    continue;
                }
                iter.add(this.generateInstance(op, propertyList, ssOP, lmpsOP));
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            CIMObjectPath lmpsOP;
            String ssPropName = this.getReference1PropertyName();
            CIMObjectPath ssOP = op.getKey(ssPropName) != null ? (CIMObjectPath)op.getKey(ssPropName).getValue() : null;
            String lmpsPropName = this.getReference2PropertyName();
            CIMObjectPath cIMObjectPath = lmpsOP = op.getKey(lmpsPropName) != null ? (CIMObjectPath)op.getKey(lmpsPropName).getValue() : null;
            if (null != lmpsOP && null != ssOP) {
                String lmpsSysName;
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(ssOP, "Name");
                String ssName = ssOP.getKey("Name") != null && ssOP.getKey("Name").getValue() != null ? (String)ssOP.getKey("Name").getValue() : null;
                String string = lmpsSysName = lmpsOP.getKey("SystemName") != null && lmpsOP.getKey("SystemName").getValue() != null ? (String)lmpsOP.getKey("SystemName").getValue() : null;
                if (null != ssName && null != lmpsSysName && ssName.equals(lmpsSysName) && ssName.equals(device.getStorageSystemName())) {
                    ssOP = this.getReference1Instrumentation().generateObjectPath(op, device.getRMIObject());
                    lmpsOP = this.getReference2Instrumentation().generateObjectPath(op, device.getRMIObject());
                    return this.generateInstance(op, propertyList, ssOP, lmpsOP);
                }
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            boolean isObjectNameRef1;
            if (null != assocName && "HITACHI_HostedLunMaskPrivilegeService".equalsIgnoreCase(assocName.getObjectName()) && ((isObjectNameRef1 = objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName())) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName())) && this.getReference1Instrumentation().instanceExists(objectName) || objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName))) {
                String prop2Examine = isObjectNameRef1 ? "Name" : "SystemName";
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, prop2Examine);
                CIMObjectPath ssOP = this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject());
                CIMObjectPath lmpsOP = this.getReference2Instrumentation().generateObjectPath(objectName, device.getRMIObject());
                if (isObjectPath) {
                    iter.add(this.generateObjectPath(objectName, ssOP, lmpsOP));
                } else {
                    iter.add(this.generateInstance(objectName, propertyList, ssOP, lmpsOP));
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }
}

