/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;

public class HostedStorageProtectionServiceInstrumentation
extends BaseAssocInstrumentation {
    protected HostedStorageProtectionServiceInstrumentation() {
        super("HITACHI_HostedStorageProtectionService", "HITACHI_StorageSystem", "Antecedent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageSystemInstrumentation"), "HITACHI_StorageProtectionService", "Dependent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageProtectionServiceInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_HostedStorageProtectionService".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference2PropertyName())) && this.getReference1Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Name");
                    if (isObjectPath) {
                        iter.add(this.getReference2Instrumentation().generateObjectPath(objectName, device.getRMIObject()));
                    } else {
                        iter.add(this.getReference2Instrumentation().generateInstance(objectName, propertyList, device.getRMIObject()));
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference1PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    if (isObjectPath) {
                        iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject()));
                    } else {
                        iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, device.getRMIObject()));
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        try {
            for (RMIObjectMapping device : devices) {
                CIMObjectPath opStorageSystem = this.getReference1Instrumentation().generateObjectPath(op, device.getRMIObject());
                CIMObjectPath opStorageProtectionService = this.getReference2Instrumentation().generateObjectPath(op, device.getRMIObject());
                if (isObjectPath) {
                    iter.add(this.generateObjectPath(op, opStorageSystem, opStorageProtectionService));
                    continue;
                }
                CIMInstance instAssoc = this.generateInstance(op, propertyList, opStorageSystem, opStorageProtectionService);
                iter.add(instAssoc.filterProperties(propertyList));
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            CIMObjectPath opStorageProtectionService;
            String ssPropName = this.getReference1PropertyName();
            CIMObjectPath opStorageSystem = op.getKey(ssPropName) != null ? (CIMObjectPath)op.getKey(ssPropName).getValue() : null;
            String cpnStorageProtectionService = this.getReference2PropertyName();
            CIMObjectPath cIMObjectPath = opStorageProtectionService = op.getKey(cpnStorageProtectionService) != null ? (CIMObjectPath)op.getKey(cpnStorageProtectionService).getValue() : null;
            if (null != opStorageProtectionService && null != opStorageSystem) {
                String sysNameStorageProtectionService;
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(opStorageSystem, "Name");
                String ssName = opStorageSystem.getKey("Name") != null && opStorageSystem.getKey("Name").getValue() != null ? (String)opStorageSystem.getKey("Name").getValue() : null;
                String string = sysNameStorageProtectionService = opStorageProtectionService.getKey("SystemName") != null && opStorageProtectionService.getKey("SystemName").getValue() != null ? (String)opStorageProtectionService.getKey("SystemName").getValue() : null;
                if (null != ssName && null != sysNameStorageProtectionService && ssName.equals(sysNameStorageProtectionService) && ssName.equals(device.getStorageSystemName())) {
                    opStorageSystem = this.getReference1Instrumentation().generateObjectPath(op, device.getRMIObject());
                    opStorageProtectionService = this.getReference2Instrumentation().generateObjectPath(op, device.getRMIObject());
                    CIMInstance ci = this.generateInstance(op, propertyList, opStorageSystem, opStorageProtectionService);
                    return ci.filterProperties(propertyList);
                }
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            boolean isObjectNameRef1;
            if (null != assocName && "HITACHI_HostedStorageProtectionService".equalsIgnoreCase(assocName.getObjectName()) && ((isObjectNameRef1 = objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName())) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName())) && this.getReference1Instrumentation().instanceExists(objectName) || objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName))) {
                String prop2Examine = isObjectNameRef1 ? "Name" : "SystemName";
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, prop2Examine);
                CIMObjectPath opStorageSystem = this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject());
                CIMObjectPath opStorageProtectionService = this.getReference2Instrumentation().generateObjectPath(objectName, device.getRMIObject());
                if (isObjectPath) {
                    iter.add(this.generateObjectPath(objectName, opStorageSystem, opStorageProtectionService));
                } else {
                    CIMInstance instAssoc = this.generateInstance(objectName, propertyList, opStorageSystem, opStorageProtectionService);
                    iter.add(instAssoc.filterProperties(propertyList));
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }
}

