/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.jserver.soma.HitachiAuthService;
import com.hitachi.smi.cache.CacheLib;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.ProviderStatusUtils;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.hitachi.smi.jobs.JobQueue;
import com.ws.wbem.CloseableAddableIterator;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMArgument;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger32;
import javax.wbem.WBEMException;
import javax.wbem.WBEMOperation;
import javax.wbem.WBEMOperationErrors;

public class ProviderStatusServiceInstrumentation
extends BaseInstrumentation {
    private static final String CPN_STATUS = "Status";
    private static final String CPN_SYSTEMNAME = "SystemName";
    public static final String CCN_CLASSNAME = "HITACHI_ProviderStatusService";
    private static final String CMN_SUSPENDSERVICE = "SuspendService";
    private static final String CMN_CANCELSUSPENDSERVICE = "CancelSuspendService";
    private static final String CMN_STOPSERVICE = "StopService";
    private static final String CMN_SHUTDOWNSERVICE = "ShutdownService";
    private static final String CMP_PREVSTATUS = "previousStatus";
    private static final String CMN_GETCACHESTATS = "getCacheStatistics";
    private static final String CMN_GETCACHEMEMORY = "getCacheMemoryUsage";
    private static final String CMP_CACHEDATA = "cacheData";

    private UnsignedInteger32 cancelSuspend(CIMObjectPath pOp, CIMArgument<?>[] pOutArgs) throws WBEMException {
        UnsignedInteger32 ret;
        mLogger.fine("CancelSuspend called, checking status");
        ProviderStatusUtils.ProviderStatus status = ProviderStatusUtils.getCurrentStatusEnum();
        if (ProviderStatusUtils.ProviderStatus.Suspended == status) {
            mLogger.log(Level.INFO, "Provider suspended, enable provider");
            HitachiAuthService.suspend(false);
            ret = ProviderConstants.UINT32_ZED;
        } else {
            mLogger.log(Level.WARNING, "CancelSuspend failed since providers are not suspended");
            ret = ProviderConstants.UINT32_ONE;
        }
        if (null != pOutArgs && pOutArgs.length > 0) {
            pOutArgs[0] = new CIMArgument(CMP_PREVSTATUS, CIMDataType.STRING_T, (Object)status.toString());
        } else {
            mLogger.log(Level.WARNING, "Out arguments is null or empty: {0}", null == pOutArgs ? "null" : Integer.valueOf(pOutArgs.length));
        }
        mLogger.log(Level.FINE, "CancelSuspend returning {0} with out arguments {1}", new Object[]{ret, Arrays.toString(pOutArgs)});
        return ret;
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devices = ProviderLibs.getManagedDevicesFromObjectPath(op, CPN_SYSTEMNAME);
        try {
            for (RMIObjectMapping device : devices) {
                iter.add(this.generateInstance(op, propertyList, device.getRMIObject()));
            }
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        return new CIMInstance(retOP, retOP.getKeys()).filterProperties(propList);
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{RMIObjectCache.class}, o, CCN_CLASSNAME);
        RMIObjectCache rmiObj = (RMIObjectCache)o[0];
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty(CPN_STATUS, CIMDataType.STRING_T, (Object)ProviderStatusUtils.getCurrentStatus(), true), new CIMProperty(CPN_SYSTEMNAME, CIMDataType.STRING_T, (Object)rmiObj.getSMISMappingContainer().getStorageSystemName(), true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), CCN_CLASSNAME, keys, op.getXmlSchemaName());
    }

    private Object getCacheMemoryUsage(CIMObjectPath pOp) {
        UnsignedInteger32 ret = new UnsignedInteger32(CacheLib.getCacheMemoryUsage().longValue());
        return ret;
    }

    private UnsignedInteger32 getCacheStats(CIMObjectPath pOp, CIMArgument<?>[] pOutArgs) {
        UnsignedInteger32 ret;
        if (null != pOutArgs && pOutArgs.length > 0) {
            String statStr = CacheLib.getCacheStatistics();
            pOutArgs[0] = new CIMArgument(CMP_CACHEDATA, CIMDataType.STRING_T, (Object)statStr);
            ret = ProviderConstants.UINT32_ZED;
        } else {
            ret = ProviderConstants.UINT32_ONE;
        }
        return ret;
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, CPN_SYSTEMNAME, ".", 1);
        if (null == device) {
            throw new WBEMException(6, "Could not find managed device information: " + op);
        }
        try {
            if (op.equalsModelPath(this.generateObjectPath(op, device.getRMIObject()))) {
                return this.generateInstance(op, propertyList, device.getRMIObject());
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    public Object invokeMethod(CIMObjectPath pOp, String pMethodName, CIMArgument<?>[] pInArgs, CIMArgument<?>[] pOutArgs) throws WBEMException {
        if (pMethodName.equalsIgnoreCase(CMN_SUSPENDSERVICE)) {
            return this.suspendService(pOp, pOutArgs);
        }
        if (pMethodName.equalsIgnoreCase(CMN_CANCELSUSPENDSERVICE)) {
            return this.cancelSuspend(pOp, pOutArgs);
        }
        if (pMethodName.equalsIgnoreCase(CMN_STOPSERVICE)) {
            return this.stopService(pOp, pOutArgs);
        }
        if (pMethodName.equalsIgnoreCase(CMN_SHUTDOWNSERVICE)) {
            return this.shutdownService(pOp, pOutArgs, true);
        }
        if (pMethodName.equalsIgnoreCase(CMN_GETCACHESTATS)) {
            return this.getCacheStats(pOp, pOutArgs);
        }
        if (pMethodName.equalsIgnoreCase(CMN_GETCACHEMEMORY)) {
            return this.getCacheMemoryUsage(pOp);
        }
        throw WBEMOperationErrors.getMethodNotSupportedException((CIMObjectPath)pOp, (String)pMethodName, (WBEMOperation)WBEMOperation.INVOKEMETHOD);
    }

    private UnsignedInteger32 shutdownService(CIMObjectPath pOp, CIMArgument<?>[] pOutArgs, boolean fromStopFunc) throws WBEMException {
        UnsignedInteger32 ret;
        mLogger.fine("Shutdown called, getting Server object");
        CloseableAddableIterator retIter = new CloseableAddableIterator();
        ProviderLibs.enumerateCIMOMInstances(new CIMObjectPath(pOp.getScheme(), pOp.getHost(), pOp.getPort(), ProviderLibs.getInteropNamespace(), "CIM_ObjectManager", null, pOp.getXmlSchemaName()), (CloseableAddableIterator<CIMInstance>)retIter, mHandle);
        if (retIter.hasNext()) {
            mLogger.log(Level.FINE, "Found server, calling shutdown");
            CIMInstance objMgr = (CIMInstance)retIter.next();
            Object funcRet = mHandle.invokeMethod(objMgr.getObjectPath(), CMN_STOPSERVICE, new CIMArgument[0], new CIMArgument[0]);
            if (funcRet instanceof UnsignedInteger32) {
                ret = (UnsignedInteger32)funcRet;
            } else {
                try {
                    String t = funcRet.toString();
                    ret = new UnsignedInteger32(t);
                }
                catch (Throwable t) {
                    mLogger.log(Level.WARNING, "Error converting StopServer return value", t);
                    ret = ProviderConstants.UINT32_ZED;
                }
            }
        } else {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)pOp, (String)"Could not find CIM_ObjectManager instance", (WBEMOperation)WBEMOperation.INVOKEMETHOD, (String)(!fromStopFunc ? "shutdownService" : "stopService"));
        }
        mLogger.log(Level.FINE, "Shutdown returning {0} with out arguments {1}", new Object[]{ret, Arrays.toString(pOutArgs)});
        return ret;
    }

    private UnsignedInteger32 stopService(CIMObjectPath pOp, CIMArgument<?>[] pOutArgs) throws WBEMException {
        UnsignedInteger32 ret;
        mLogger.fine("stopservice called, checking status");
        ProviderStatusUtils.ProviderStatus status = ProviderStatusUtils.getCurrentStatusEnum();
        if (ProviderStatusUtils.ProviderStatus.Suspended == status) {
            mLogger.info("Providers are suspended, attempting to shutdown");
            ret = this.shutdownService(pOp, pOutArgs, false);
        } else {
            mLogger.log(Level.WARNING, "stopService failed since providers are not suspended", "");
            ret = ProviderConstants.UINT32_ONE;
        }
        if (null != pOutArgs && pOutArgs.length > 0) {
            pOutArgs[0] = new CIMArgument(CMP_PREVSTATUS, CIMDataType.STRING_T, (Object)status.toString());
        } else {
            mLogger.log(Level.WARNING, "Out arguments is null or empty: {0}", null == pOutArgs ? "null" : Integer.valueOf(pOutArgs.length));
        }
        mLogger.log(Level.FINE, "Stopservice returning {0} with out arguments {1}", new Object[]{ret, Arrays.toString(pOutArgs)});
        return ret;
    }

    private UnsignedInteger32 suspendService(CIMObjectPath pOp, CIMArgument<?>[] pOutArgs) {
        UnsignedInteger32 ret;
        String status;
        mLogger.fine("suspend called, check status");
        try {
            status = ProviderStatusUtils.getCurrentStatus();
        }
        catch (WBEMException e) {
            mLogger.log(Level.SEVERE, "Unable to get current status", e);
            status = null;
        }
        if (!ProviderStatusUtils.ProviderStatus.Suspended.name().equalsIgnoreCase(status)) {
            mLogger.log(Level.INFO, "Attempting to suspend provider");
            JobQueue jq = JobQueue.getJobQ();
            if (!jq.isJobRunning() && !jq.isJobWaiting()) {
                mLogger.log(Level.INFO, "Job service reports no jobs executing or pending");
                HitachiAuthService.suspend(true);
                ret = ProviderConstants.UINT32_ZED;
            } else {
                mLogger.log(Level.INFO, "Job service reports job executing or pending");
                ProviderStatusUtils.setProviderStatus(ProviderStatusUtils.ProviderStatus.Warning, ProviderStatusUtils.ProviderStatusDetailCode.JOBSRUNNING);
                ret = ProviderConstants.UINT32_ONE;
            }
        } else {
            mLogger.log(Level.INFO, "Providers already suspended");
            ret = ProviderConstants.UINT32_ZED;
        }
        if (null != pOutArgs && pOutArgs.length > 0) {
            pOutArgs[0] = new CIMArgument(CMP_PREVSTATUS, CIMDataType.STRING_T, (Object)status);
        } else {
            mLogger.log(Level.WARNING, "Out arguments is null or empty: {0}", null == pOutArgs ? "null" : "empty");
        }
        mLogger.log(Level.FINE, "Suspend returning {0} with out arguments {1}", new Object[]{ret, Arrays.toString(pOutArgs)});
        return ret;
    }
}

