/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.CacheUpdateNotifier;
import com.hitachi.smi.cache.CacheUpdater;
import com.hitachi.smi.common.AbstractBaseCommonObject;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.FCPort;
import com.hitachi.smi.common.ISCSITargetPort;
import com.hitachi.smi.common.IndicationHelper;
import com.hitachi.smi.common.IteratorCallbackIMPL;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.PortandHostGroupInfo;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.hitachi.smi.jobs.ModifyPortLabel;
import com.ws.wbem.jserver.JServerProperties;
import com.ws.wbem.provider.jobservice.CIM_ConcreteJob;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.wbem.WBEMException;
import javax.wbem.WBEMOperation;
import javax.wbem.WBEMOperationErrors;

public class SCSIProtocolControllerInstrumentation
extends BaseInstrumentation
implements CacheUpdateNotifier {
    private static final int UNITS_CONTROLLED = 126;

    protected static String createDeviceID(String port, String hostgroup) {
        String ret = port + "." + hostgroup;
        return ret;
    }

    protected static String createSystemName(String ctrID, String serialNum) throws Exception {
        String ret = RMIObjectMapping.getRMIObjectMapping(serialNum).getStorageSystemName() + "." + ctrID;
        return ret;
    }

    @Override
    public <T extends Serializable> void cacheItemAdded(T pObj) {
        if (this.isListening()) {
            CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_SCSIProtocolController", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
            IndicationHelper helper = new IndicationHelper(mHandle);
            try {
                this.process4Indication(op, helper, (AbstractBaseCommonObject)pObj, null, true);
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_SCSIProtocolController added indication instance", t);
            }
        }
    }

    @Override
    public <T extends Serializable> void cacheItemDeleted(T pObj) {
        if (this.isListening()) {
            CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_SCSIProtocolController", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
            IndicationHelper helper = new IndicationHelper(mHandle);
            try {
                this.process4Indication(op, helper, (AbstractBaseCommonObject)pObj, null, false);
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_SCSIProtocolController deleted indication instance", t);
            }
        }
    }

    @Override
    public <T extends Serializable> void cacheItemModified(T pObj) {
        if (this.isListening()) {
            CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_SCSIProtocolController", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
            IndicationHelper helper = new IndicationHelper(mHandle);
            try {
                if (pObj instanceof PortandHostGroupInfo) {
                    PortandHostGroupInfo port = (PortandHostGroupInfo)pObj;
                    PortandHostGroupInfo newInst = PortandHostGroupInfo.find(port.getSerialNumber(), port.getSystemName(), String.valueOf(port.getCtrlID()), String.valueOf(port.getPortID()), String.valueOf(port.getHostgroupID()), null, false, null);
                    if (newInst != null) {
                        this.process4Indication(op, helper, port, newInst, true);
                    } else {
                        mLogger.severe("Unable to find a port that that matches: " + port.toString());
                    }
                } else if (pObj instanceof ISCSITargetPort) {
                    this.processiSCSIPortModified(op, helper, (ISCSITargetPort)pObj);
                } else {
                    mLogger.log(Level.SEVERE, "Unexpected object passed to function: {0}", pObj);
                }
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_SCSIProtocolController modified indication instance for " + pObj, t);
            }
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, final CIMObjectPath op, final String[] propertyList, String filterQueryLanguage, String filterQuery, final boolean continueOnError, final boolean isObjectPath, Hashtable<String, Object> expectedValues, final ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "SystemName", expectedValues, new String[]{"SystemName", "ElementName"});
        try {
            String expDomainID;
            String expPortID;
            String expClientType;
            String expCtrID;
            if (null != expectedValues) {
                if (1 != devices.size()) {
                    throw new WBEMException("HITACHI_SCSIProtocolController.enumerate called for association but found insf. managed devices. Found devices: " + devices.size() + ", expectedValues: " + expectedValues);
                }
                String expSysName = (String)expectedValues.get("SystemName");
                expCtrID = null != expSysName ? ProviderLibs.getEndString(expSysName, ProviderConstants.ID_SEPERATOR_AS_CHAR) : null;
                expClientType = (String)expectedValues.get("InstanceID");
                String expDeviceID = (String)expectedValues.get("DeviceID");
                if (null != expDeviceID) {
                    expPortID = ProviderLibs.getAllButEndString(expDeviceID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                    expDomainID = ProviderLibs.getEndString(expDeviceID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                } else {
                    String strPortID = (String)expectedValues.get("PortID");
                    expPortID = null != strPortID ? strPortID : null;
                    String strDomainID = (String)expectedValues.get("DomainID");
                    expDomainID = null != strDomainID ? strDomainID : null;
                }
            } else {
                expPortID = null;
                expCtrID = null;
                expDomainID = null;
                expClientType = null;
            }
            final PassthruIterator deviceIter = new PassthruIterator(iter);
            for (final RMIObjectMapping device : devices) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        SCSIProtocolControllerInstrumentation.this.getPortandHostGroups(device, op, propertyList, deviceIter, isObjectPath, refInfo, expCtrID, expPortID, expDomainID, expClientType, continueOnError);
                    }
                };
                if (null != expPortID) {
                    FCPort fcPort = FCPort.find(Short.valueOf(expPortID), FCPort.PortTypeRequested.ALL, device.getRMIObject());
                    if (null != fcPort) {
                        if (!fcPort.isRequestedType(FCPort.PortTypeRequested.iSCSI)) {
                            r.run();
                            continue;
                        }
                        this.getISCSITargets(device, op, propertyList, deviceIter, isObjectPath, refInfo, expCtrID, expPortID, expDomainID, expClientType, continueOnError);
                        continue;
                    }
                    mLogger.log(Level.SEVERE, "Unable to find required FCPort with id {0}", expPortID);
                    continue;
                }
                Thread t = new Thread(r);
                t.setDaemon(true);
                t.setName("HostGroup SCSIController");
                t.start();
                this.getISCSITargets(device, op, propertyList, deviceIter, isObjectPath, refInfo, expCtrID, expPortID, expDomainID, expClientType, continueOnError);
                try {
                    t.join(0L);
                }
                catch (InterruptedException ie) {
                    mLogger.log(Level.SEVERE, "Failed to wait for HostGroup thread", ie);
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        boolean isFC;
        String iSCSIName;
        String elementName;
        UnsignedInteger16 hostMode;
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        if (o[0] instanceof PortandHostGroupInfo) {
            PortandHostGroupInfo phgi = (PortandHostGroupInfo)o[0];
            hostMode = phgi.getHostMode();
            elementName = phgi.getHostGroupNickName();
            iSCSIName = null;
            isFC = true;
        } else {
            ISCSITargetPort.ISCSITarget target = (ISCSITargetPort.ISCSITarget)o[0];
            hostMode = new UnsignedInteger16(target.getHostModeID());
            elementName = target.getAlias();
            iSCSIName = target.getName();
            isFC = false;
        }
        CIMInstance ret = null;
        try {
            CIMProperty[] keys = retOP.getKeys();
            String spcDeviceID = (String)keys[1].getValue();
            ArrayList<CIMProperty> props = new ArrayList<CIMProperty>();
            props.add(keys[0]);
            props.add(keys[1]);
            props.add(keys[2]);
            props.add(keys[3]);
            props.add(new CIMProperty("HostMode", CIMDataType.UINT16_T, (Object)hostMode, false));
            props.add(new CIMProperty("MaxUnitsControlled", CIMDataType.UINT32_T, (Object)new UnsignedInteger32(126L), false));
            props.add(new CIMProperty("EnabledState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FIVE, false));
            props.add(new CIMProperty("RequestedState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWELVE, false));
            props.add(new CIMProperty("EnabledDefault", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false));
            props.add(new CIMProperty("OperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_TWO}, false));
            props.add(new CIMProperty("StatusDescriptions", CIMDataType.STRING_ARRAY_T, (Object)ProviderConstants.getOpStatusDescriptions(new UnsignedInteger16[]{ProviderConstants.UINT16_TWO}), false));
            props.add(new CIMProperty("HealthState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FIVE, false));
            props.add(new CIMProperty("Caption", CIMDataType.STRING_T, (Object)spcDeviceID, false));
            props.add(new CIMProperty("Description", CIMDataType.STRING_T, (Object)spcDeviceID, false));
            if (null == elementName || elementName.length() == 0) {
                elementName = spcDeviceID;
            }
            props.add(new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)elementName, false));
            props.add(new CIMProperty("Name", CIMDataType.STRING_T, (Object)(isFC ? spcDeviceID : iSCSIName), false));
            props.add(new CIMProperty("NameFormat", CIMDataType.UINT16_T, (Object)(isFC ? ProviderConstants.UINT16_TWO : ProviderConstants.UINT16_THREE), false));
            CIMProperty[] propArray = props.toArray(new CIMProperty[props.size()]);
            ret = new CIMInstance(retOP, propArray).filterProperties(propList);
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        return ret;
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        String serialNumber;
        String ctrID;
        String hostgroup;
        String port;
        try {
            ProviderLibs.validateVARArgs(new Class[]{PortandHostGroupInfo.class}, o, "HITACHI_SCSIProtocolController");
            PortandHostGroupInfo phgi = (PortandHostGroupInfo)o[0];
            port = String.valueOf(phgi.getPortID());
            hostgroup = String.valueOf(phgi.getHostgroupID());
            ctrID = String.valueOf(phgi.getCtrlID());
            serialNumber = phgi.getSerialNumber();
        }
        catch (IllegalArgumentException iae) {
            ProviderLibs.validateVARArgs(new Class[]{ISCSITargetPort.ISCSITarget.class}, o, "HITACHI_SCSIProtocolController");
            ISCSITargetPort.ISCSITarget target = (ISCSITargetPort.ISCSITarget)o[0];
            port = String.valueOf(target.getPortID());
            hostgroup = String.valueOf(target.getId());
            serialNumber = target.getSerialNumber();
            short tCTRId = PortandHostGroupInfo.getCtrIDUsingPortID((short)target.getPortID(), serialNumber);
            ctrID = String.valueOf(tCTRId);
        }
        CIMObjectPath ret = null;
        try {
            String systemName = SCSIProtocolControllerInstrumentation.createSystemName(ctrID, serialNumber);
            String deviceID = SCSIProtocolControllerInstrumentation.createDeviceID(port, hostgroup);
            CIMProperty[] keys = new CIMProperty[]{new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_SCSIProtocolController", true), new CIMProperty("DeviceID", CIMDataType.STRING_T, (Object)deviceID, true), new CIMProperty("SystemCreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_StorageProcessorSystem", true), new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)systemName, true)};
            ret = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_SCSIProtocolController", keys, op.getXmlSchemaName());
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        return ret;
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "SystemName");
        try {
            String ssVal;
            String sysNameKeyVal;
            String ccName = null != op.getKey("CreationClassName") ? (String)op.getKey("CreationClassName").getValue() : null;
            String sccName = null != op.getKey("SystemCreationClassName") ? (String)op.getKey("SystemCreationClassName").getValue() : null;
            String deviceIDKeyVal = null != op.getKey("DeviceID") ? (String)op.getKey("DeviceID").getValue() : null;
            String string = sysNameKeyVal = null != op.getKey("SystemName") ? (String)op.getKey("SystemName").getValue() : null;
            if (null != deviceIDKeyVal && null != sysNameKeyVal && null != ccName && null != sccName && ccName.equals("HITACHI_SCSIProtocolController") && sccName.equals("HITACHI_StorageProcessorSystem") && null != (ssVal = ProviderLibs.getAllButEndString(sysNameKeyVal, ProviderConstants.ID_SEPERATOR_AS_CHAR)) && ssVal.equals(device.getStorageSystemName())) {
                String ctrID = ProviderLibs.getEndString(sysNameKeyVal, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                String portID = ProviderLibs.getAllButEndString(deviceIDKeyVal, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                String domainID = ProviderLibs.getEndString(deviceIDKeyVal, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                FCPort fcPort = FCPort.find(Short.valueOf(portID), FCPort.PortTypeRequested.ALL, device.getRMIObject());
                if (null != fcPort) {
                    CIMInstance ret = !fcPort.isRequestedType(FCPort.PortTypeRequested.iSCSI) ? this.getPortHostGroupInstance(op, device, ssVal, ctrID, portID, domainID, propertyList) : this.getISCSITarget(op, device, ssVal, ctrID, portID, domainID, propertyList);
                    if (null != ret) {
                        return ret;
                    }
                } else {
                    mLogger.log(Level.SEVERE, "Unable to find required FCPort with id {0}", portID);
                }
            }
            throw new WBEMException(6, op.toString());
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    private CIMInstance getISCSITarget(CIMObjectPath op, RMIObjectMapping device, String ssVal, String ctrID, String portID, String domainID, String[] propertyList) throws Exception {
        try {
            ISCSITargetPort port = ISCSITargetPort.find(device.getRMIObject(), Integer.parseInt(portID));
            if (null != port) {
                ISCSITargetPort.ISCSITarget target = port.getTarget(Short.parseShort(domainID));
                if (null != target) {
                    return this.generateInstance(op, propertyList, target);
                }
                mLogger.log(Level.SEVERE, "No domianID {0} in target port {1}", new Object[]{domainID, port.getPortId()});
            }
        }
        catch (WBEMException we) {
            // empty catch block
        }
        throw new WBEMException(6, op.toString());
    }

    private void getISCSITargets(RMIObjectMapping device, CIMObjectPath op, String[] propertyList, PassthruIterator<?> deviceIter, boolean isObjectPath, ReferenceInfo refInfo, String expCtrID, String expPortID, String expDomainID, String expClientType, boolean continueOnError) throws WBEMException {
        iSCSICallbackHandler<ISCSITargetPort> iSCSIcb = new iSCSICallbackHandler<ISCSITargetPort>(deviceIter, isObjectPath, refInfo, op, propertyList, expClientType, expCtrID, expDomainID);
        ISCSITargetPort.getISCSIPorts(device.getRMIObject(), iSCSIcb, null == expPortID ? -1 : Integer.parseInt(expPortID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getPortandHostGroups(RMIObjectMapping device, CIMObjectPath op, String[] propertyList, CustomCloseableIterator<?> deviceIter, boolean isObjectPath, ReferenceInfo refInfo, String expCtrID, String expPortID, String expDomainID, String expClientType, boolean continueOnError) {
        mLogger.info("Entering Host group controller thread.");
        try {
            HostGrpCallbackHandler<PortandHostGroupInfo> fcHostGrpCB = new HostGrpCallbackHandler<PortandHostGroupInfo>(deviceIter, isObjectPath, refInfo, op, propertyList);
            PortandHostGroupInfo.getPortandHostGroupInfo(device.getRMIObject(), fcHostGrpCB, null, expCtrID, expPortID, expDomainID, null, false, expClientType, continueOnError);
        }
        catch (WBEMException we) {
            deviceIter.setException(we);
        }
        catch (Throwable t) {
            deviceIter.setException(new WBEMException(1, "Error in Host group controller thread", null, t));
        }
        finally {
            mLogger.info("Host group controller thread exiting");
        }
    }

    private CIMInstance getPortHostGroupInstance(CIMObjectPath op, RMIObjectMapping device, String ssVal, String ctrID, String portID, String domainID, String[] propertyList) throws Exception {
        try {
            PortandHostGroupInfo phgi = PortandHostGroupInfo.find(device.getSerialNumber(), ssVal, ctrID, portID, domainID, null, false, null);
            if (null != phgi) {
                CIMInstance ci = this.generateInstance(op, propertyList, phgi);
                return ci.filterProperties(propertyList);
            }
        }
        catch (WBEMException we) {
            // empty catch block
        }
        throw new WBEMException(6, op.toString());
    }

    @Override
    public void modifyInstance(CIMInstance modifiedInst, String[] propertyList) throws WBEMException {
        CIMObjectPath objectPath = modifiedInst.getObjectPath();
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectPath, "SystemName");
        CIMInstance currentInst = this.getInstance(objectPath, null);
        if (null != propertyList) {
            for (String name : propertyList) {
                if (name.equalsIgnoreCase("ElementName")) continue;
                throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)objectPath, (String)("Can only modify ElementName but '" + Arrays.toString(propertyList) + "' was specified"), (WBEMOperation)WBEMOperation.MODIFYINSTANCE, (String)"ModifyInstance");
            }
        }
        ProviderLibs.CheckModifiedProperties(currentInst, modifiedInst, null, new String[]{"ElementName"}, null);
        String deviceIDKeyVal = (String)objectPath.getKeyValue("DeviceID");
        String sysNameKeyVal = (String)objectPath.getKeyValue("SystemName");
        if (null == deviceIDKeyVal || null == sysNameKeyVal) {
            throw new WBEMException("Unable to get DeviceID or SystemName from path: " + objectPath);
        }
        String newElementName = (String)modifiedInst.getPropertyValue("ElementName");
        if (null == newElementName) {
            newElementName = "";
        } else if (!ProviderLibs.isElementNameValid(newElementName, 64)) {
            throw WBEMOperationErrors.getOtherFailureException((CIMObjectPath)objectPath, (String)("Invalid ElementName: \"" + newElementName + "\""), (WBEMOperation)WBEMOperation.MODIFYINSTANCE, (String)"ModifyInstance");
        }
        String ctrID = ProviderLibs.getEndString(sysNameKeyVal, ProviderConstants.ID_SEPERATOR_AS_CHAR);
        String portID = ProviderLibs.getAllButEndString(deviceIDKeyVal, ProviderConstants.ID_SEPERATOR_AS_CHAR);
        String domainID = ProviderLibs.getEndString(deviceIDKeyVal, ProviderConstants.ID_SEPERATOR_AS_CHAR);
        FCPort fcPort = FCPort.find(Short.valueOf(portID), FCPort.PortTypeRequested.ALL, device.getRMIObject());
        if (null == fcPort) {
            throw new WBEMException("ModifyInstance unable to find required FCPort with id " + portID + " passed in instance " + modifiedInst);
        }
        ModifyPortLabel mpl = new ModifyPortLabel(mHandle.getProperty("javax.wbem.provider.Principal"), objectPath.getHost(), objectPath, newElementName, objectPath, fcPort, ctrID, domainID);
        CIM_ConcreteJob job = mpl.submitJob(false);
        job.setDescription("Modify ElementName for " + objectPath);
        ProviderLibs.waitForJob(job);
    }

    private void process4Indication(CIMObjectPath op, IndicationHelper helper, AbstractBaseCommonObject prevObj, AbstractBaseCommonObject newObj, boolean isCreate) throws Exception {
        CIMInstance indication;
        CIMInstance sourceInstance = this.generateInstance(op, null, prevObj);
        if (null != newObj) {
            CIMInstance newInstance = this.generateInstance(op, null, newObj);
            indication = helper.createInstModificationInstance(newInstance, sourceInstance);
        } else {
            indication = isCreate ? helper.createInstCreationInstance(sourceInstance) : helper.createInstDeletionInstance(sourceInstance);
        }
        mHandle.deliverEvent(indication, null);
    }

    @Override
    public void processIndicationFilter(String query, boolean startListening) {
        boolean oldListenState = this.isListening();
        if ("SELECT * FROM CIM_InstCreation WHERE SourceInstance ISA CIM_ProtocolController".equalsIgnoreCase(query)) {
            this.setListen4InstMod(startListening);
        } else if ("SELECT * FROM CIM_InstDeletion WHERE SourceInstance ISA CIM_ProtocolController".equalsIgnoreCase(query)) {
            this.setListen4InstMod(startListening);
        } else if ("SELECT * FROM CIM_InstCreation WHERE SourceInstance ISA CIM_SCSIProtocolController".equalsIgnoreCase(query)) {
            this.setListen4InstMod(startListening);
        } else if ("SELECT * FROM CIM_InstDeletion WHERE SourceInstance ISA CIM_SCSIProtocolController".equalsIgnoreCase(query)) {
            this.setListen4InstMod(startListening);
        } else if ("SELECT * FROM HITACHI_InstCreation WHERE SourceInstance ISA HITACHI_SCSIProtocolController".equalsIgnoreCase(query)) {
            this.setListen4InstMod(startListening);
        } else if ("SELECT * FROM HITACHI_InstDeletion WHERE SourceInstance ISA HITACHI_SCSIProtocolController".equalsIgnoreCase(query)) {
            this.setListen4InstMod(startListening);
        } else if ("SELECT * FROM HITACHI_InstModification WHERE SourceInstance ISA HITACHI_SCSIProtocolController".equalsIgnoreCase(query)) {
            this.setListen4InstMod(startListening);
        }
        if (!oldListenState && this.isListening()) {
            CacheUpdater.registerUpdateCallback(CacheUpdater.CallBackType.PORTHOSTGROUP, this, null);
        } else if (oldListenState && !this.isListening()) {
            CacheUpdater.unregisterUpdateCallback(CacheUpdater.CallBackType.PORTHOSTGROUP, this, null);
        }
    }

    private void processiSCSIPortModified(CIMObjectPath op, IndicationHelper helper, ISCSITargetPort oldPort) throws WBEMException {
        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(oldPort.getSerialNumber());
        ISCSITargetPort newPort = ISCSITargetPort.find(device.getRMIObject(), oldPort.getPortId());
        List<ISCSITargetPort.ISCSITarget> newTargets = newPort.getTargets();
        ISCSITargetPort.ISCSITargetComparator iSCSITargetComparator = new ISCSITargetPort.ISCSITargetComparator();
        Collections.sort(newTargets, iSCSITargetComparator);
        for (ISCSITargetPort.ISCSITarget oldTarget : oldPort.getTargets()) {
            CIMInstance indication = null;
            try {
                CIMInstance prevInstance = this.generateInstance(op, null, oldTarget);
                int idx = Collections.binarySearch(newTargets, oldTarget, iSCSITargetComparator);
                if (idx >= 0) {
                    ISCSITargetPort.ISCSITarget newTarget = newTargets.remove(idx);
                    if (!oldTarget.equals(newTarget)) {
                        CIMInstance newInstance = this.generateInstance(op, null, newTarget);
                        indication = helper.createInstModificationInstance(newInstance, prevInstance);
                    }
                } else {
                    indication = helper.createInstDeletionInstance(prevInstance);
                }
                if (null == indication) continue;
                mHandle.deliverEvent(indication, null);
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_SCSIProtocolController indication for prev target: " + oldTarget, t);
            }
        }
        for (ISCSITargetPort.ISCSITarget newTarget : newTargets) {
            try {
                this.process4Indication(op, helper, newTarget, null, true);
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_SCSIProtocolController InstCreation indication for target: " + newTarget, t);
            }
        }
    }

    private class iSCSICallbackHandler<E extends ISCSITargetPort>
    extends IteratorCallbackIMPL<E> {
        private final short expCtrID;
        private final String expClientType;
        private final short expDomainID;

        protected iSCSICallbackHandler(CustomCloseableIterator<?> iter, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList, String expClientType, String expCtrID, String expDomainID) {
            super(iter, isObjectPath, refInfo, op, propertyList);
            this.expCtrID = (short)(null == expCtrID ? -1 : (int)Short.parseShort(expCtrID));
            this.expClientType = expClientType;
            this.expDomainID = (short)(null == expDomainID ? -1 : (int)Short.parseShort(expDomainID));
        }

        @Override
        public boolean returnItem(E item) {
            boolean ret = true;
            if (!this.mIter.isDone()) {
                try {
                    E port = item;
                    List<ISCSITargetPort.ISCSITarget> targets = ((ISCSITargetPort)port).getTargets();
                    for (ISCSITargetPort.ISCSITarget target : targets) {
                        byte client = new Integer(target.getHostModeID()).byteValue();
                        if (-1 != this.expDomainID && -2 != this.expDomainID && target.getId() != this.expDomainID || -1 != this.expCtrID && this.expCtrID != FCPort.getCtrlID((short)((ISCSITargetPort)port).getPortId(), target.getSerialNumber()) || null != this.expClientType && !this.expClientType.equals(PortandHostGroupInfo.setClientType(client))) continue;
                        if (null != this.mRefInfo) {
                            this.mRefInfo.addReference(this.mIter, SCSIProtocolControllerInstrumentation.this.generateObjectPath(this.mOP, target));
                            continue;
                        }
                        if (this.mIsObjectPath) {
                            this.mIter.add(SCSIProtocolControllerInstrumentation.this.generateObjectPath(this.mOP, target));
                            continue;
                        }
                        CIMInstance ci = SCSIProtocolControllerInstrumentation.this.generateInstance(this.mOP, this.mPropertyList, target);
                        this.mIter.add(ci.filterProperties(this.mPropertyList));
                    }
                }
                catch (Throwable thrown) {
                    WBEMException we = new WBEMException(1, thrown.toString(), null, thrown);
                    this.mIter.setException(we);
                    this.mIter.close();
                }
            } else {
                ret = false;
            }
            return ret;
        }
    }

    private class HostGrpCallbackHandler<E extends PortandHostGroupInfo>
    extends IteratorCallbackIMPL<E> {
        protected HostGrpCallbackHandler(CustomCloseableIterator<?> iter, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList) {
            super(iter, isObjectPath, refInfo, op, propertyList);
        }

        @Override
        public boolean returnItem(E item) {
            boolean ret;
            block6: {
                ret = true;
                if (!this.mIter.isDone()) {
                    try {
                        E phgi = item;
                        if (null != this.mRefInfo) {
                            this.mRefInfo.addReference(this.mIter, SCSIProtocolControllerInstrumentation.this.generateObjectPath(this.mOP, phgi));
                            break block6;
                        }
                        if (this.mIsObjectPath) {
                            this.mIter.add(SCSIProtocolControllerInstrumentation.this.generateObjectPath(this.mOP, phgi));
                            break block6;
                        }
                        CIMInstance ci = SCSIProtocolControllerInstrumentation.this.generateInstance(this.mOP, this.mPropertyList, phgi);
                        this.mIter.add(ci);
                    }
                    catch (Throwable thrown) {
                        WBEMException we = new WBEMException(1, thrown.toString(), null, thrown);
                        this.mIter.setException(we);
                        this.mIter.close();
                    }
                } else {
                    ret = false;
                }
            }
            return ret;
        }
    }
}

