/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.CacheUpdateNotifier;
import com.hitachi.smi.cache.CacheUpdater;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.FCPort;
import com.hitachi.smi.common.IndicationHelper;
import com.hitachi.smi.common.PortandHostGroupInfo;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.ws.wbem.jserver.JServerProperties;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;

public class SCSIProtocolEndpointAvailableForProtocolControllerInstrumentation
extends BaseAssocInstrumentation
implements CacheUpdateNotifier {
    protected SCSIProtocolEndpointAvailableForProtocolControllerInstrumentation() {
        super("HITACHI_SCSIProtocolEndpointAvailableForProtocolController", "HITACHI_SCSIProtocolEndpoint", "AvailableSAP", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.SCSIProtocolEndpointInstrumentation"), "HITACHI_SCSIProtocolController", "ManagedElement", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.SCSIProtocolControllerInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, boolean shouldTestInst) throws WBEMException {
        try {
            boolean needToCloseIter = true;
            if (null != assocName && "HITACHI_SCSIProtocolEndpointAvailableForProtocolController".equalsIgnoreCase(assocName.getObjectName())) {
                if (!(!objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) || null != role && !role.equalsIgnoreCase(this.getReference1PropertyName()) || null != resultRole && !resultRole.equalsIgnoreCase(this.getReference2PropertyName()) || shouldTestInst && !this.getReference1Instrumentation().instanceExists(objectName))) {
                    needToCloseIter = false;
                    this.getSCSIPCForSCSIEndPt(iter, objectName, propertyList);
                } else if (!(!objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) || null != role && !role.equalsIgnoreCase(this.getReference2PropertyName()) || null != resultRole && !resultRole.equalsIgnoreCase(this.getReference1PropertyName()) || shouldTestInst && !this.getReference2Instrumentation().instanceExists(objectName))) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    String strDevID = (String)objectName.getKeyValue("DeviceID");
                    String portID = ProviderLibs.getAllButEndString(strDevID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                    FCPort fcPort = FCPort.find(Short.parseShort(portID), FCPort.PortTypeRequested.OPEN, device.getRMIObject());
                    if (null != fcPort) {
                        Hashtable<String, Object> ref1SearchProps = new Hashtable<String, Object>();
                        ref1SearchProps.put("Name", fcPort.getPortWWN());
                        ref1SearchProps.put("ElementName", device.getStorageSystemName());
                        CIMObjectPath opReference2 = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), this.getReference2ClassName(), null);
                        this.getReference1Instrumentation().enumerate(iter, opReference2, propertyList, filterQueryLanguage, filterQuery, continueOnError, isObjectPath, ref1SearchProps, null);
                        needToCloseIter = false;
                    } else {
                        mLogger.log(Level.WARNING, "{0} does not have a matching FCPort", objectName);
                    }
                }
            }
            if (null != iter && needToCloseIter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public <T extends Serializable> void cacheItemAdded(T pObj) {
        if (this.isListening()) {
            try {
                this.handleCacheModifyEvent(pObj, true);
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_SCSIProtocolEndpointAvailableForProtocolController added indication instance", t);
            }
        }
    }

    @Override
    public <T extends Serializable> void cacheItemDeleted(T pObj) {
        if (this.isListening()) {
            try {
                this.handleCacheModifyEvent(pObj, false);
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_SCSIProtocolEndpointAvailableForProtocolController deleted indication instance", t);
            }
        }
    }

    @Override
    public <T extends Serializable> void cacheItemModified(T pObj) {
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath objectName, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            final CIMObjectPath opReference1 = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), this.getReference1ClassName(), null);
            final CustomCloseableIterator scsiEndPtiter = new CustomCloseableIterator();
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        BaseInstrumentation.mLogger.log(Level.FINE, "Starting {0} thread", "HITACHI_SCSIProtocolEndpointAvailableForProtocolController");
                        SCSIProtocolEndpointAvailableForProtocolControllerInstrumentation.this.getReference1Instrumentation().enumerate(scsiEndPtiter, opReference1, null, null, null, false, false, null, null);
                    }
                    catch (Throwable t) {
                        WBEMException we = t instanceof WBEMException ? (WBEMException)t : new WBEMException(1, "Unexpected error in thread: " + t, null, t);
                        scsiEndPtiter.setException(we);
                    }
                    finally {
                        BaseInstrumentation.mLogger.log(Level.FINE, "Exiting {0} thread", "HITACHI_SCSIProtocolEndpointAvailableForProtocolController");
                    }
                }
            };
            Thread t = new Thread(r, "HITACHI_SCSIProtocolEndpointAvailableForProtocolController");
            t.setDaemon(true);
            t.start();
            while (scsiEndPtiter.hasNext()) {
                CIMInstance scsiendPt = (CIMInstance)scsiEndPtiter.next();
                CustomCloseableIterator scPCIter = new CustomCloseableIterator();
                this.getSCSIPCForSCSIEndPt(scPCIter, scsiendPt.getObjectPath(), null);
                while (scPCIter.hasNext()) {
                    CIMInstance scsiPC = (CIMInstance)scPCIter.next();
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(objectName, scsiendPt.getObjectPath(), scsiPC.getObjectPath()));
                        continue;
                    }
                    iter.add(this.generateInstance(objectName, propertyList, scsiendPt.getObjectPath(), scsiPC.getObjectPath()));
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter) {
                iter.done();
            }
        }
    }

    private void enumOtherEndpt(CustomCloseableIterator<CIMInstance> iter, boolean isFCPort, CIMObjectPath objectName, BaseInstrumentation inst) throws WBEMException {
        CIMObjectPath opReference;
        Hashtable<String, Object> refSearchProps;
        if (isFCPort) {
            refSearchProps = this.getReference2SearchProperties(objectName);
            opReference = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), this.getReference2ClassName(), null);
        } else {
            refSearchProps = this.getReference1SearchProperties(objectName);
            opReference = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), this.getReference2ClassName(), null);
        }
        CIMObjectPath opObjectName = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), objectName.getObjectName(), objectName.getKeys(), objectName.getXmlSchemaName());
        ReferenceInfo refInfo = new ReferenceInfo((CIMObjectPath)(isFCPort ? opObjectName : null), (CIMObjectPath)(!isFCPort ? opObjectName : null), this.getReference1PropertyName(), this.getReference2PropertyName(), null, false, this);
        inst.enumerate(iter, opReference, new String[0], null, null, true, true, refSearchProps, refInfo);
    }

    private void getSCSIPCForSCSIEndPt(CustomCloseableIterator<?> iter, CIMObjectPath scsiEndPtOP, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(scsiEndPtOP, "SystemName");
        String wwn = (String)scsiEndPtOP.getKeyValue("Name");
        FCPort fcPort = FCPort.find(wwn, FCPort.PortTypeRequested.OPEN, device.getRMIObject());
        if (null != fcPort) {
            Hashtable<String, Object> ref2SearchProps = new Hashtable<String, Object>();
            ref2SearchProps.put("PortID", String.valueOf(fcPort.getPort()));
            ref2SearchProps.put("ElementName", device.getStorageSystemName());
            CIMObjectPath opReference2 = new CIMObjectPath(scsiEndPtOP.getScheme(), scsiEndPtOP.getHost(), scsiEndPtOP.getPort(), scsiEndPtOP.getNamespace(), this.getReference2ClassName(), null);
            this.getReference2Instrumentation().enumerate(iter, opReference2, propertyList, null, null, false, false, ref2SearchProps, null);
        } else {
            mLogger.log(Level.WARNING, "{0} does not have a WWN that matches a FCPort", scsiEndPtOP);
        }
    }

    private <T extends Serializable> void handleCacheModifyEvent(T pObj, boolean isCreateInst) throws Exception {
        BaseInstrumentation otherInstrumentation;
        boolean isFCPort;
        CIMObjectPath objectName;
        CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_SCSIProtocolEndpointAvailableForProtocolController", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
        CIMInstance instSCSIProtocolEndPt = null;
        CIMInstance instSCSIProtocolController = null;
        if (pObj instanceof FCPort) {
            instSCSIProtocolEndPt = this.getReference1Instrumentation().generateInstance(op, null, pObj);
            objectName = instSCSIProtocolEndPt.getObjectPath();
            isFCPort = true;
            otherInstrumentation = this.getReference2Instrumentation();
        } else if (pObj instanceof PortandHostGroupInfo) {
            instSCSIProtocolController = this.getReference2Instrumentation().generateInstance(op, null, pObj);
            objectName = instSCSIProtocolController.getObjectPath();
            isFCPort = false;
            otherInstrumentation = this.getReference1Instrumentation();
        } else {
            mLogger.log(Level.FINE, "Unknown object passed in for cache update: {0}", pObj);
            return;
        }
        CustomCloseableIterator<CIMInstance> iter = new CustomCloseableIterator<CIMInstance>();
        this.enumOtherEndpt(iter, isFCPort, objectName, otherInstrumentation);
        while (iter.hasNext()) {
            CIMInstance sourceInstance = (CIMInstance)iter.next();
            IndicationHelper helper = new IndicationHelper(mHandle);
            CIMInstance indication = isCreateInst ? helper.createInstCreationInstance(sourceInstance) : helper.createInstDeletionInstance(sourceInstance);
            mHandle.deliverEvent(indication, null);
        }
    }

    @Override
    public void processIndicationFilter(String query, boolean startListening) {
        boolean oldListenState = this.isListening();
        if ("SELECT * FROM CIM_InstCreation WHERE SourceInstance ISA CIM_SAPAvailableForElement".equalsIgnoreCase(query)) {
            this.setListen4InstAdd(startListening);
        } else if ("SELECT * FROM CIM_InstDeletion WHERE SourceInstance ISA CIM_SAPAvailableForElement".equalsIgnoreCase(query)) {
            this.setListen4InstDel(startListening);
        } else if ("SELECT * FROM CIM_InstCreation WHERE SourceInstance ISA CIM_ProtocolController".equalsIgnoreCase(query)) {
            this.setListen4InstMod(startListening);
        } else if ("SELECT * FROM CIM_InstDeletion WHERE SourceInstance ISA CIM_ProtocolController".equalsIgnoreCase(query)) {
            this.setListen4InstMod(startListening);
        } else if ("SELECT * FROM HITACHI_InstCreation WHERE SourceInstance ISA HITACHI_SCSIProtocolController".equalsIgnoreCase(query)) {
            this.setListen4InstMod(startListening);
        } else if ("SELECT * FROM HITACHI_InstDeletion WHERE SourceInstance ISA HITACHI_SCSIProtocolController".equalsIgnoreCase(query)) {
            this.setListen4InstMod(startListening);
        } else if ("SELECT * FROM HITACHI_InstModification WHERE SourceInstance ISA HITACHI_SCSIProtocolController".equalsIgnoreCase(query)) {
            this.setListen4InstMod(startListening);
        }
        if (!oldListenState && this.isListening()) {
            CacheUpdater.registerUpdateCallback(CacheUpdater.CallBackType.PORT, this, null);
            CacheUpdater.registerUpdateCallback(CacheUpdater.CallBackType.PORTHOSTGROUP, this, null);
        } else if (oldListenState && !this.isListening()) {
            CacheUpdater.unregisterUpdateCallback(CacheUpdater.CallBackType.PORT, this, null);
            CacheUpdater.unregisterUpdateCallback(CacheUpdater.CallBackType.PORTHOSTGROUP, this, null);
        }
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        boolean needToCloseIter = true;
        try {
            if (null != assocName && "HITACHI_SCSIProtocolEndpointAvailableForProtocolController".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName()))) {
                    CIMInstance endPt = this.getReference1Instrumentation().getInstance(objectName, null);
                    if (null != endPt) {
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                        String wwn = (String)objectName.getKeyValue("Name");
                        FCPort fcPort = FCPort.find(wwn, FCPort.PortTypeRequested.OPEN, device.getRMIObject());
                        if (null != fcPort) {
                            Hashtable<String, Object> ref2SearchProps = new Hashtable<String, Object>();
                            ref2SearchProps.put("PortID", String.valueOf(fcPort.getPort()));
                            ref2SearchProps.put("ElementName", device.getStorageSystemName());
                            CIMObjectPath opReference2 = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), this.getReference2ClassName(), null);
                            ReferenceInfo refInfo = new ReferenceInfo(endPt.getObjectPath(), null, this.getReference1PropertyName(), this.getReference2PropertyName(), propertyList, isObjectPath, this);
                            this.getReference2Instrumentation().enumerate(iter, opReference2, new String[0], null, null, continueOnError, true, ref2SearchProps, refInfo);
                            needToCloseIter = false;
                        } else {
                            mLogger.log(Level.WARNING, "{0} does not have a WWN that matches a FCPort", objectName);
                        }
                    } else {
                        mLogger.log(Level.WARNING, "{0} could not be found", objectName);
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName()))) {
                    CIMInstance scsiPC = this.getReference2Instrumentation().getInstance(objectName, null);
                    if (null != scsiPC) {
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                        String strDevID = (String)objectName.getKeyValue("DeviceID");
                        String portID = ProviderLibs.getAllButEndString(strDevID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                        FCPort fcPort = FCPort.find(Short.parseShort(portID), FCPort.PortTypeRequested.OPEN, device.getRMIObject());
                        if (null != fcPort) {
                            Hashtable<String, Object> ref1SearchProps = new Hashtable<String, Object>();
                            ref1SearchProps.put("Name", fcPort.getPortWWN());
                            ref1SearchProps.put("ElementName", device.getStorageSystemName());
                            CIMObjectPath opReference1 = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), this.getReference1ClassName(), null);
                            ReferenceInfo refInfo = new ReferenceInfo(null, scsiPC.getObjectPath(), this.getReference1PropertyName(), this.getReference2PropertyName(), propertyList, isObjectPath, this);
                            this.getReference1Instrumentation().enumerate(iter, opReference1, new String[0], null, null, continueOnError, true, ref1SearchProps, refInfo);
                            needToCloseIter = false;
                        } else {
                            mLogger.log(Level.WARNING, "Port with ID {0} could not be found", portID);
                        }
                    } else {
                        mLogger.log(Level.WARNING, "{0} could not be found", objectName);
                    }
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we1 = new WBEMException(1, th.toString(), null, th);
            mLogger.log(Level.SEVERE, th.getLocalizedMessage(), th);
            if (null != iter) {
                iter.setException(we1);
                iter.close();
            }
            throw we1;
        }
        finally {
            if (null != iter && needToCloseIter) {
                iter.done();
            }
        }
    }
}

