/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.ChassisArrayGroup;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.StorageCapabilitiesIMPL;
import com.hitachi.smi.instrumentation.StorageCapabilitiesInstrumentation;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import javax.cim.CIMArgument;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.wbem.WBEMException;

public class StorageCapabilitiesOfPrimordialPoolInstrumentation
extends StorageCapabilitiesInstrumentation {
    private static final String CV_STORAGECAPABILITIESOFPRIMORDIALPOOL = "StorageCapabilitiesOfPrimordialPool";

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "InstanceID", expectedValues);
        try {
            for (RMIObjectMapping device : devices) {
                if (null != refInfo) {
                    refInfo.addReference(iter, this.generateObjectPath(op, device.getRMIObject()));
                    continue;
                }
                if (isObjectPath) {
                    iter.add(this.generateObjectPath(op, device.getRMIObject()));
                    continue;
                }
                iter.add(this.generateInstance(op, propertyList, device.getRMIObject()));
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws WBEMException {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        CIMProperty[] keys = retOP.getKeys();
        ProviderLibs.validateVARArgs(new Class[]{RMIObjectCache.class}, o, "HITACHI_StorageCapabilitiesOfPrimordialPool");
        RMIObjectCache rmiObj = (RMIObjectCache)o[0];
        String name = null;
        try {
            name = rmiObj.getSMISMappingContainer().getStorageSystemName();
        }
        catch (Exception e) {
            if (WBEMException.class.isInstance(e)) {
                throw (WBEMException)((Object)e);
            }
            throw new WBEMException(1, "Unable to get storage system name: " + e, null, (Throwable)e);
        }
        StorageCapabilitiesIMPL cap = StorageCapabilitiesIMPL.getPrimordialCaps(name);
        CIMProperty[] props = new CIMProperty[]{keys[0], new CIMProperty("ElementType", CIMDataType.UINT16_T, (Object)cap.getElementType(), false), new CIMProperty("NoSinglePointOfFailure", CIMDataType.BOOLEAN_T, (Object)cap.isNoSinglePointOfFailure(), false), new CIMProperty("NoSinglePointOfFailureDefault", CIMDataType.BOOLEAN_T, (Object)cap.isNoSinglePointOfFailure(), false), new CIMProperty("DataRedundancyMax", CIMDataType.UINT16_T, (Object)cap.getDataRedunMax(), false), new CIMProperty("DataRedundancyMin", CIMDataType.UINT16_T, (Object)cap.getDataRedunMin(), false), new CIMProperty("DataRedundancyDefault", CIMDataType.UINT16_T, (Object)cap.getDataRedun(), false), new CIMProperty("PackageRedundancyMax", CIMDataType.UINT16_T, (Object)cap.getPkgRedunMax(), false), new CIMProperty("PackageRedundancyMin", CIMDataType.UINT16_T, (Object)cap.getPkgRedunMin(), false), new CIMProperty("PackageRedundancyDefault", CIMDataType.UINT16_T, (Object)cap.getPkgRedun(), false), new CIMProperty("DeltaReservationMax", CIMDataType.UINT16_T, (Object)cap.getDeltaReservationMax(), false), new CIMProperty("DeltaReservationMin", CIMDataType.UINT16_T, (Object)cap.getDeltaReservationMin(), false), new CIMProperty("DeltaReservationDefault", CIMDataType.UINT16_T, (Object)cap.getDeltaReservation(), false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)CV_STORAGECAPABILITIESOFPRIMORDIALPOOL, false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)CV_STORAGECAPABILITIESOFPRIMORDIALPOOL, false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)CV_STORAGECAPABILITIESOFPRIMORDIALPOOL, false), new CIMProperty("SupportedDataOrganizations", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_TWO}, false), new CIMProperty("SupportedExtentTypes", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_TWO}, false)};
        return new CIMInstance(retOP, props).filterProperties(propList);
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws WBEMException {
        ProviderLibs.validateVARArgs(new Class[]{RMIObjectCache.class}, o, "HITACHI_StorageCapabilitiesOfPrimordialPool");
        RMIObjectCache rmiObj = (RMIObjectCache)o[0];
        String name = null;
        try {
            name = rmiObj.getSMISMappingContainer().getStorageSystemName();
        }
        catch (Exception e) {
            // empty catch block
        }
        StorageCapabilitiesIMPL cap = StorageCapabilitiesIMPL.getPrimordialCaps(name);
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)cap.getInstanceID(), true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_StorageCapabilitiesOfPrimordialPool", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "InstanceID");
        try {
            String instID;
            String string = instID = null != op.getKey("InstanceID") ? (String)op.getKey("InstanceID").getValue() : null;
            if (null == instID) {
                throw new WBEMException(6, op.toString());
            }
            StorageCapabilitiesIMPL cap = StorageCapabilitiesIMPL.getPrimordialCaps(device.getStorageSystemName());
            if (instID.equals(cap.getInstanceID())) {
                return this.generateInstance(op, propertyList, device.getRMIObject());
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    @Override
    protected Object GetSupportedParityLengthsHelper(CIMObjectPath op, CIMArgument<?>[] outArgs, boolean doParity) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "InstanceID");
        UnsignedInteger32 ret = ProviderConstants.UINT32_ZED;
        CommonClassAsList<ChassisArrayGroup> callback = new CommonClassAsList<ChassisArrayGroup>();
        ChassisArrayGroup.getChassisArrayGroup(device.getRMIObject(), callback, false);
        LinkedList<ChassisArrayGroup> cags = callback.getReturnValue();
        callback = null;
        TreeSet<UnsignedInteger16> retLengths = new TreeSet<UnsignedInteger16>();
        ChassisArrayGroup cag = cags.poll();
        while (cag != null) {
            String rl = cag.getRaidLevel();
            if (doParity) {
                UnsignedInteger16 value;
                if (!(cag.isAouVol() || cag.isExternalVol() || cag.isFICONDMVol() || (value = ProviderLibs.getParityLayout(rl)) == null)) {
                    if (value.intValue() == 2) {
                        value = ProviderConstants.UINT16_THREE;
                    }
                    retLengths.add(value);
                }
            } else {
                int length = ProviderLibs.getExtentStripeLen(rl);
                retLengths.add(new UnsignedInteger16(length));
            }
            cag = cags.poll();
        }
        outArgs[0] = new CIMArgument(doParity ? "ParityLayout" : "StripeLengths", CIMDataType.UINT16_ARRAY_T, (Object)retLengths.toArray(new UnsignedInteger16[retLengths.size()]));
        return ret;
    }
}

